LICENSE = "BSD-3-Clause"
LIC_FILES_CHKSUM = "file://COPYING.txt;md5=e8f6789acdcda76d02ed9203fc2e603d"

COMPATIBLE_MACHINE = "tci6614-evm|keystone"
PACKAGE_ARCH = "${MACHINE_ARCH}"

TRACEFRAMEWORK_GIT_URI = "git://git.ti.com/keystone-rtos/traceframework.git"
TRACEFRAMEWORK_GIT_PROTOCOL = "git"
TRACEFRAMEWORK_GIT_BRANCH = "master"
TRACEFRAMEWORK_GIT_DESTSUFFIX = "git/ti/instrumentation/traceframework"

# Below commit ID corresponds to "DEV.TFWK-01.01.01.08B"
TRACEFRAMEWORK_SRCREV = "e7a60a71a385337425547e3cac6716998c6a3528"

BRANCH = "${TRACEFRAMEWORK_GIT_BRANCH}"
SRC_URI = "${TRACEFRAMEWORK_GIT_URI};destsuffix=${TRACEFRAMEWORK_GIT_DESTSUFFIX};protocol=${TRACEFRAMEWORK_GIT_PROTOCOL};branch=${BRANCH}"

SRCREV = "${TRACEFRAMEWORK_SRCREV}"
PV = "01.01.01.08"
INC_PR = "r1"

DEVICELIST = "k2k k2h k2e k2l"
DEVICELIST_tci6614-evm = "c6614"
DEVICELIST_k2hk-evm    = "k2k k2h"
DEVICELIST_k2e-evm     = "k2e"
DEVICELIST_k2l-evm     = "k2l"

S = "${WORKDIR}/${TRACEFRAMEWORK_GIT_DESTSUFFIX}"
