SUMMARY = "cve-check-tool"
DESCRIPTION = "cve-check-tool is a tool for checking known (public) CVEs.\
The tool will identify potentially vunlnerable software packages within Linux distributions through version matching."
HOMEPAGE = "https://github.com/ikeydoherty/cve-check-tool"
SECTION = "Development/Tools"
LICENSE = "GPL-2.0"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e8c1458438ead3c34974bc0be3a03ed6"

SRC_URI = "https://github.com/ikeydoherty/${BPN}/releases/download/v${PV}/${BP}.tar.xz \
    file://curl-allow-overriding-default-CA-certificate-file.patch \
    file://0001-Check-for-malloc_trim-before-using-it.patch \
"

SRC_URI[md5sum] = "c5f4247140fc9be3bf41491d31a34155"
SRC_URI[sha256sum] = "b8f283be718af8d31232ac1bfc10a0378fb958aaaa49af39168f8acf501e6a5b"

DEPENDS = "libcheck glib-2.0 json-glib curl libxml2 sqlite3 openssl ca-certificates"

inherit pkgconfig autotools

EXTRA_OECONF = "--disable-static --enable-relative-plugins"
CFLAGS += "-Wno-error=pedantic"

BBCLASSEXTEND = "native nativesdk"
