
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was AudioManagerConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/audiomanager/cmake" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(AudioManager_INCLUDE_DIRS ${PACKAGE_PREFIX_DIR}/include/audiomanager)

set(DAEMONVERSION "7.4.12")
set(TEST_EXECUTABLE_INSTALL_PATH "/usr/bin")
set(AM_SHARE_FOLDER "/usr/share/audiomanager")
set(CONTROLLER_PLUGIN "")
set(LIB_INSTALL_SUFFIX "audiomanager")
set(LIB_CONTROL_INTERFACE_VERSION "5.0")
set(LIB_ROUTING_INTERFACE_VERSION "5.0")
set(LIB_COMMAND_INTERFACE_VERSION "4.0")
set(DEFAULT_PLUGIN_COMMAND_DIR "/usr/lib/audiomanager/command")
set(DEFAULT_PLUGIN_ROUTING_DIR "/usr/lib/audiomanager/routing")
set(CONTROLLER_PLUGIN_DIR  "/usr/lib/audiomanager/control")
set(AUDIOMANAGER_CMAKE_CXX_FLAGS "-std=gnu++11 -pedantic -rdynamic -Wno-variadic-macros")
set(WITH_CAPI_WRAPPER "OFF")
set(WITH_DBUS_WRAPPER "ON")
set(WITH_SHARED_UTILITIES "ON")
set(WITH_SHARED_CORE "ON")

check_required_components(AudioManagerDaemon)
if (WITH_SHARED_UTILITIES)
	check_required_components(AudioManagerUtilities)
endif (WITH_SHARED_UTILITIES)
if (WITH_SHARED_CORE)    
	check_required_components(AudioManagerCore)
endif(WITH_SHARED_CORE)





