
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was AudioManagerUtilitiesConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/audiomanager/cmake" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(AudioManagerUtilities_INCLUDE_DIRS ${PACKAGE_PREFIX_DIR}/include/audiomanager/AudioManagerUtilities)
find_library(AudioManagerUtilities_LIBRARY NAMES AudioManagerUtilities HINTS ${PACKAGE_PREFIX_DIR}/lib}) 

set(WITH_CAPI_WRAPPER "OFF")
set(WITH_DBUS_WRAPPER "ON")
set(WITH_SYSTEMD_WATCHDOG "ON")
set(WITH_DLT "ON")


if(WITH_SYSTEMD_WATCHDOG)
	pkg_check_modules(SYSTEMD REQUIRED "libsystemd >= 44")

    set(AUDIOMANAGER_UTILITIES_EXTERNAL_INCLUDE
		${AUDIOMANAGER_UTILITIES_EXTERNAL_INCLUDE}
		${SYSTEMD_INCLUDEDIR})

endif(WITH_SYSTEMD_WATCHDOG)	

IF (WITH_DBUS_WRAPPER)
	pkg_check_modules (DBUS REQUIRED "dbus-1 >= 1.4")
	
	set(AUDIOMANAGER_UTILITIES_EXTERNAL_INCLUDE
		${AUDIOMANAGER_UTILITIES_EXTERNAL_INCLUDE}
		${DBUS_INCLUDE_DIRS})
ENDIF (WITH_DBUS_WRAPPER)

IF (WITH_CAPI_WRAPPER)
        pkg_check_modules(COMMONAPI REQUIRED "CommonAPI >= 3.1.5")

    	set(AUDIOMANAGER_UTILITIES_EXTERNAL_INCLUDE
		    ${AUDIOMANAGER_UTILITIES_EXTERNAL_INCLUDE}
	        ${COMMONAPI_INCLUDE_DIRS})
ENDIF (WITH_CAPI_WRAPPER)

if(WITH_DLT)    
    pkg_check_modules(DLT REQUIRED "automotive-dlt >= 2.2.0")
    	  	
    	SET(AUDIOMANAGER_UTILITIES_EXTERNAL_INCLUDE
			${AUDIOMANAGER_UTILITIES_EXTERNAL_INCLUDE}
	        ${DLT_LIBRARY_DIRS})
endif(WITH_DLT)

set(AudioManagerUtilities_INCLUDE_DIRS ${AudioManagerUtilities_INCLUDE_DIRS} ${AUDIOMANAGER_UTILITIES_EXTERNAL_INCLUDE})
set(AudioManagerUtilities_LIBRARIES dl;systemd;dbus-1;dlt;rt;pthread;z ${AudioManagerUtilities_LIBRARY})
set(DAEMONVERSION "7.4.12")
set(AUDIOMANAGER_CMAKE_CXX_FLAGS "-std=gnu++11 -pedantic -rdynamic -Wno-variadic-macros")
set(WITH_SHARED_UTILITIES "ON")




