SUMMARY = "Phoronix Test Suite"
DESCRIPTION = "The Phoronix Test Suite is designed to carry out both qualitative \
and quantitative benchmarks in a clean, reproducible, and easy-to-use manner."
LICENSE = "GPLv3"
LIC_FILES_CHKSUM = "file://COPYING;md5=d32239bcb673463ab874e80d47fae504"
SECTION = "console/tests"

SRC_URI = "http://www.phoronix-test-suite.com/releases/${BP}.tar.gz"
SRC_URI[md5sum] = "5bcac5896a4a34fc6ae4ae94991e1637"
SRC_URI[sha256sum] = "631ceb808d8bd6cebe69c8b711d55090d6880e906a65837f18fa8200fe7d2c4d"

S = "${WORKDIR}/phoronix-test-suite"

inherit systemd allarch

do_install() {
    DESTDIR=${D} ./install-sh ${exec_prefix}

    if [ "${systemd_unitdir}" != "/usr/lib/systemd" ]; then
        install -d ${D}/${systemd_unitdir}/system/
        mv ${D}/usr/lib/systemd/system/* ${D}/${systemd_unitdir}/system/
        rm -rf ${D}/usr/lib/
    fi
}

SYSTEMD_SERVICE_${PN} = "phoromatic-client.service phoromatic-server.service"
RDEPENDS_${PN} += "bash python php-cli"

FILES_${PN} += " \
    ${datadir}/phoronix-test-suite \
    ${datadir}/appdata/phoronix-test-suite.appdata.xml \
    ${datadir}/icons/hicolor/48x48/apps/phoronix-test-suite.png \
    ${datadir}/icons/hicolor/64x64/mimetypes/application-x-openbenchmarking.png \
    ${datadir}/mime/packages/openbenchmarking-mime.xml \
    ${systemd_unitdir}/* \
"

PNBLACKLIST[phoronix-test-suite] ?= "Runtime depends on blacklisted php-cli - the recipe will be removed on 2017-09-01 unless the issue is fixed"
