SUMMARY = "cve-check-tool"
DESCRIPTION = "cve-check-tool is a tool for checking known (public) CVEs.\
The tool will identify potentially vunlnerable software packages within Linux distributions through version matching."
HOMEPAGE = "https://github.com/ikeydoherty/cve-check-tool"
SECTION = "Development/Tools"
LICENSE = "GPL-2.0+"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e8c1458438ead3c34974bc0be3a03ed6"

SRC_URI = "https://github.com/ikeydoherty/${BPN}/releases/download/v${PV}/${BP}.tar.xz \
           file://check-for-malloc_trim-before-using-it.patch \
           file://0001-print-progress-in-percent-when-downloading-CVE-db.patch \
           file://0001-curl-allow-overriding-default-CA-certificate-file.patch \
           file://0001-update-Compare-computed-vs-expected-sha256-digit-str.patch \
          "

SRC_URI[md5sum] = "c5f4247140fc9be3bf41491d31a34155"
SRC_URI[sha256sum] = "b8f283be718af8d31232ac1bfc10a0378fb958aaaa49af39168f8acf501e6a5b"

UPSTREAM_CHECK_URI = "https://github.com/ikeydoherty/cve-check-tool/releases"

DEPENDS = "libcheck glib-2.0 json-glib curl libxml2 sqlite3 openssl ca-certificates"

RDEPENDS_${PN} = "ca-certificates"

inherit pkgconfig autotools

EXTRA_OECONF = "--disable-coverage --enable-relative-plugins"
CFLAGS_append = " -Wno-error=pedantic"

do_populate_cve_db() {
    if [ "${BB_NO_NETWORK}" = "1" ] ; then
        bberror "BB_NO_NETWORK is set; Can't update cve-check-tool database, CVEs won't be checked"
        return
    fi

    # In case we don't inherit cve-check class, use default values defined in the class.
    cve_dir="${CVE_CHECK_DB_DIR}"
    cve_file="${CVE_CHECK_TMP_FILE}"

    [ -z "${cve_dir}" ] && cve_dir="${DL_DIR}/CVE_CHECK"
    [ -z "${cve_file}" ] && cve_file="${TMPDIR}/cve_check"

    bbdebug 2 "Updating cve-check-tool database located in $cve_dir"
    # --cacert works around curl-native not finding the CA bundle
    if cve-check-update --cacert ${sysconfdir}/ssl/certs/ca-certificates.crt -d "$cve_dir" ; then
        printf "CVE database was updated on %s UTC\n\n" "$(LANG=C date --utc +'%F %T')" > "$cve_file"
    else
        bbwarn "Error in executing cve-check-update"
        if [ "${@'1' if bb.data.inherits_class('cve-check', d) else '0'}" -ne 0 ] ; then
            bbwarn "Failed to update cve-check-tool database, CVEs won't be checked"
        fi
    fi
}

addtask populate_cve_db after do_populate_sysroot
do_populate_cve_db[depends] = "cve-check-tool-native:do_populate_sysroot"
do_populate_cve_db[nostamp] = "1"
do_populate_cve_db[progress] = "percent"

BBCLASSEXTEND = "native nativesdk"
