#!/bin/sh

MOSTCORE=/sys/devices/virtual/most/mostcore

DEV0=${MOSTCORE}/devices/mdev0
echo control > ${DEV0}/ca2/set_datatype
echo dir_rx  > ${DEV0}/ca2/set_direction
echo 32       > ${DEV0}/ca2/set_number_of_buffers
echo 128     > ${DEV0}/ca2/set_buffer_size

echo control > ${DEV0}/ca4/set_datatype
echo dir_tx  > ${DEV0}/ca4/set_direction
echo 32       > ${DEV0}/ca4/set_number_of_buffers
echo 128     > ${DEV0}/ca4/set_buffer_size

echo "--Setting up RX channel with MLB addr 0x03 (0x06)--"
echo 128    > ${DEV0}/ca6/set_packets_per_xact
echo 4      > ${DEV0}/ca6/set_subbuffer_size
echo sync   > ${DEV0}/ca6/set_datatype
echo dir_rx > ${DEV0}/ca6/set_direction
echo 32     > ${DEV0}/ca6/set_number_of_buffers
echo 8192   > ${DEV0}/ca6/set_buffer_size

echo "--Setting up TX channel with MLB addr 0x04 (0x08)--"
echo 128    > ${DEV0}/ca8/set_packets_per_xact
echo 4      > ${DEV0}/ca8/set_subbuffer_size
echo sync   > ${DEV0}/ca8/set_datatype
echo dir_tx > ${DEV0}/ca8/set_direction
echo 32     > ${DEV0}/ca8/set_number_of_buffers
echo 8192   > ${DEV0}/ca8/set_buffer_size

echo "--Setting up TX channel with MLB addr 0x06 (0x0C)--"
echo 128    > ${DEV0}/ca10/set_packets_per_xact
echo 4      > ${DEV0}/ca10/set_subbuffer_size
echo sync   > ${DEV0}/ca10/set_datatype
echo dir_tx > ${DEV0}/ca10/set_direction
echo 32     > ${DEV0}/ca10/set_number_of_buffers
echo 8192   > ${DEV0}/ca10/set_buffer_size

echo "--Creating char devices--"
CDEV=${MOSTCORE}/aims/cdev
echo mdev0:ca2:most_ctrl_rx > ${CDEV}/add_link
echo mdev0:ca4:most_ctrl_tx > ${CDEV}/add_link

echo "--Creating ALSA devices--"
AUDIODEV=${MOSTCORE}/aims/sound/
echo mdev0:ca6:rx0.2x16 > ${AUDIODEV}/add_link
echo mdev0:ca8:tx0.2x16 > ${AUDIODEV}/add_link
echo mdev0:ca10:tx1.2x16 > ${AUDIODEV}/add_link
