
SUMMARY = "Kexec fast reboot tools"
DESCRIPTION = "Kexec is a fast reboot feature that lets you reboot to a new Linux kernel"
AUTHOR = "Eric Biederman"
HOMEPAGE = "http://kernel.org/pub/linux/utils/kernel/kexec/"
SECTION = "kernel/userland"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://COPYING;md5=ea5bed2f60d357618ca161ad539f7c0a \
                    file://kexec/kexec.c;beginline=1;endline=20;md5=af10f6ae4a8715965e648aa687ad3e09"
DEPENDS = "zlib xz"

SRC_URI = "${KERNELORG_MIRROR}/linux/utils/kernel/kexec/kexec-tools-${PV}.tar.gz \
           file://kdump \
           file://kdump.conf \
           file://kdump.service \
           file://0002-powerpc-change-the-memory-size-limit.patch \
           file://0001-purgatory-Pass-r-directly-to-linker.patch \
           file://0010-kexec-ARM-Fix-add_buffer_phys_virt-align-issue.patch \
           file://kexec-x32.patch \
           file://0001-Disable-PIE-during-link.patch \
           file://0001-kexec-fix-for-Unhandled-rela-relocation-R_X86_64_PLT.patch \
           "

SRC_URI[md5sum] = "8e071ca473694a71e4ae60ed7ef6f377"
SRC_URI[sha256sum] = "450c87ba048641eb05f9717f5567aca57f063c266149ae663b58a34e5852deaf"

inherit autotools update-rc.d systemd

export LDFLAGS = "-L${STAGING_LIBDIR}"
EXTRA_OECONF = " --with-zlib=yes"

do_compile_prepend() {
    # Remove the prepackaged config.h from the source tree as it overrides
    # the same file generated by configure and placed in the build tree
    rm -f ${S}/include/config.h

    # Remove the '*.d' file to make sure the recompile is OK
    for dep in `find ${B} -type f -name '*.d'`; do
        dep_no_d="`echo $dep | sed 's#.d$##'`"
        # Remove file.d when there is a file.o
        if [ -f "$dep_no_d.o" ]; then
            rm -f $dep
        fi
    done
}

do_install_append () {
        install -d ${D}${sysconfdir}/sysconfig
        install -m 0644 ${WORKDIR}/kdump.conf ${D}${sysconfdir}/sysconfig

        if ${@bb.utils.contains('DISTRO_FEATURES', 'sysvinit', 'true', 'false', d)}; then
                install -D -m 0755 ${WORKDIR}/kdump ${D}${sysconfdir}/init.d/kdump
        fi

        if ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'true', 'false', d)}; then
                install -D -m 0755 ${WORKDIR}/kdump ${D}${libexecdir}/kdump-helper
                install -D -m 0644 ${WORKDIR}/kdump.service ${D}${systemd_unitdir}/system/kdump.service
                sed -i -e 's,@LIBEXECDIR@,${libexecdir},g' ${D}${systemd_unitdir}/system/kdump.service
        fi
}

PACKAGES =+ "kexec kdump vmcore-dmesg"

ALLOW_EMPTY_${PN} = "1"
RRECOMMENDS_${PN} = "kexec kdump vmcore-dmesg"

FILES_kexec = "${sbindir}/kexec"
FILES_kdump = "${sbindir}/kdump \
               ${sysconfdir}/sysconfig/kdump.conf \
               ${sysconfdir}/init.d/kdump \
               ${libexecdir}/kdump-helper \
               ${systemd_unitdir}/system/kdump.service \
"

FILES_vmcore-dmesg = "${sbindir}/vmcore-dmesg"

INITSCRIPT_PACKAGES = "kdump"
INITSCRIPT_NAME_kdump = "kdump"
INITSCRIPT_PARAMS_kdump = "start 56 2 3 4 5 . stop 56 0 1 6 ."

SYSTEMD_PACKAGES = "kdump"
SYSTEMD_SERVICE_kdump = "kdump.service"

SECURITY_PIE_CFLAGS_remove = "-fPIE -pie"

COMPATIBLE_HOST = '(x86_64.*|i.86.*|arm.*|aarch64.*|powerpc.*|mips.*)-(linux|freebsd.*)'

INSANE_SKIP_${PN} = "arch"
