/*
 * Copyright 2017-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *     http://aws.amazon.com/apache2.0/
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazon.aace.storage.config;

import com.amazon.aace.core.config.EngineConfiguration;

/**
 * The @c StorageConfiguration class is a factory interface for creating Storage service configuration objects.
 */
public class StorageConfiguration
{
    private static final String TAG = "StorageConfiguration";

    /**
     * Factory method used to programmatically generate storage configuration data.
     * The data generated by this method is equivalent to providing the following JSON
     * values in a configuration file:
     *
     * @code{.json}
     * {
     *   "aace.storage": {
     *     "localStoragePath": "<LOCAL_STORAGE_FILE_PATH>"
     *   }
     * }
     * @endcode
     *
     * @param [in] localStoragePath The file path to the local storage data file
     *
     * The database will be created on initialization if it does not already exist.
     */
    public static EngineConfiguration createLocalStorageConfig( final String localStoragePath )
    {
        return new EngineConfiguration() {
            @Override
            protected long createNativeRef() {
                return createLocalStorageConfigBinder( localStoragePath );
            }
        };
    }

    // Native Engine JNI methods
    static private native long createLocalStorageConfigBinder( String localStoragePath );
}
