# Android toolchain directory
# Needs to be setup via "setup-android-toolchain.sh" script
ANDROID_TOOLCHAIN ?= "${HOME}/android-toolchain"

# NDK Version
NDK_PACKAGE ?= "android-ndk-r20"

# API Level
ANDROID_API_LEVEL ?= "22"
ANDROID_PLATFORM = "android-${ANDROID_API_LEVEL}"

# NDK
ANDROID_NDK_HOME = "${ANDROID_TOOLCHAIN}/ndk/ndk-bundle/${NDK_PACKAGE}"

# Prebuilt Toolchain path
TOOLCHAIN = "${ANDROID_NDK_HOME}/toolchains/llvm/prebuilt/linux-x86_64"

TCLIBC = "android"
TCMODE = "external"

TARGET_VENDOR = ""

TARGET_SYSROOT = "${TOOLCHAIN}/sysroot"
ANDROID_PLATFORM_LIBDIR = "${TARGET_SYSROOT}/${libdir_native}/${TARGET_SYS}/${ANDROID_API_LEVEL}"

# CMake: https://developer.android.com/ndk/guides/cmake
#
# Note: CMake built-in NDK support is strongly discouraged by Google
#       thus we use toolchain file provided by NDK.
#
# Note: Specifying CMAKE_TOOLCHAIN_FILE in EXTRA_OECMAKE will override
#       existing variable, so it won't use a toolchain file that is
#       generated by OE-Core.
EXTRA_OECMAKE += "\
  -DANDROID_ABI="${ANDROID_ABI}" \
  -DANDROID_PLATFORM="${ANDROID_PLATFORM}" \
  -DANDROID_STL="c++_shared" \
  -DCMAKE_TOOLCHAIN_FILE="${ANDROID_NDK_HOME}/build/cmake/android.toolchain.cmake" \
  -DCMAKE_FIND_ROOT_PATH="${STAGING_DIR_HOST}" \
"

# No toolchain options
TOOLCHAIN_OPTIONS = ""

# Use Clang/LLVM
export CC = "${TARGET_SYS}${ANDROID_API_LEVEL}-clang"
export CXX = "${TARGET_SYS}${ANDROID_API_LEVEL}-clang++"
export CPP = "${CC} -E"

# Add toolchain path
PATH_prepend = "${TOOLCHAIN}/bin:"
EXTERNAL_TOOLCHAIN = "${TOOLCHAIN}"

# Tell configure what flags Android requires.
TARGET_CFLAGS = "-fPIE -fPIC"
TARGET_LDFLAGS = "-pie"

# Workaround
MODIFYTOS = "0"

# Android doesn't support versioning in SONAME
FILES_SOLIBSDEV = ""
SOLIBS = ".so"

# Use ABI/API name for image archive
ANDROID_MACHINE = "${ANDROID_ABI}-${ANDROID_PLATFORM}"
IMAGE_NAME = "${IMAGE_BASENAME}-${ANDROID_MACHINE}-${DATETIME}"
IMAGE_LINK_NAME = "${IMAGE_BASENAME}-${ANDROID_MACHINE}"

# Nothing are provided from host
AAC_ASSUME_PROVIDED = ""
AAC_PKG_CONFIG_PROVIDED = ""

##################################################################
# OE extra functions
##################################################################

def android_siteinfo_setfunc(archinfo, osinfo, targetinfo, d):
    osinfo['linux-android'] = "common-android"
    targetinfo['x86_64-linux-android'] = "bit-64"
    return archinfo, osinfo, targetinfo

SITEINFO_EXTRA_DATAFUNCS = "android_siteinfo_setfunc"

def android_get_machine_dict(machdata, d):
    machdata["linux-android"] = {
        "x86_64": (62,  0, 0, True, 64),
        "i686":   (3,   0, 0, True, 32),
        "aarch64":(183, 0, 0, True, 64),
    }
    machdata["linux-androideabi"] = {
        "arm" : (40, 0, 0, True, 32),
    }
    return machdata

PACKAGEQA_EXTRA_MACHDEFFUNCS = "android_get_machine_dict"