/*
 * Copyright 2019-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *     http://aws.amazon.com/apache2.0/
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazon.aace.carControl;

public class CarControlAssets {
    private CarControlAssets() {}

    public class Device {
        public static final String AIR_CONDITIONER = "Alexa.Automotive.DeviceName.AirConditioner";
        public static final String AMBIENT_LIGHT = "Alexa.Automotive.DeviceName.AmbientLight";
        public static final String AVM_CAMERA = "Alexa.Automotive.DeviceName.AVMCamera";
        public static final String ARMREST = "Alexa.Automotive.DeviceName.Armrest";
        public static final String CABIN_LIGHT = "Alexa.Automotive.DeviceName.CabinLight";
        public static final String CAMERA_360 = "Alexa.Automotive.DeviceName.360Camera";
        public static final String CAR = "Alexa.Automotive.DeviceName.Car";
        public static final String CHARGE_DOOR = "Alexa.Automotive.DeviceName.ChargeDoor";
        public static final String CLIMATE_CONTROL = "Alexa.Automotive.DeviceName.ClimateControl";
        public static final String COOLER = "Alexa.Automotive.DeviceName.Cooler";
        public static final String CUP_HOLDER = "Alexa.Automotive.DeviceName.CupHolder";
        public static final String DISPLAY = "Alexa.Automotive.DeviceName.Display";
        public static final String DISPLAY_SCREEN = "Alexa.Automotive.DeviceName.DisplayScreen";
        public static final String DOME_LIGHT = "Alexa.Automotive.DeviceName.DomeLight";
        public static final String DRIVER_SEAT = "Alexa.Automotive.DeviceName.DriverSeat";
        public static final String FAN = "Alexa.Automotive.DeviceName.Fan";
        public static final String FOG_LIGHT = "Alexa.Automotive.DeviceName.FogLight";
        public static final String GAS_DOOR = "Alexa.Automotive.DeviceName.GasDoor";
        public static final String HAZARD_LIGHTS = "Alexa.Automotive.DeviceName.HazardLights";
        public static final String HEADLIGHT = "Alexa.Automotive.DeviceName.Headlight";
        public static final String HEATER = "Alexa.Automotive.DeviceName.Heater";
        public static final String HIGH_BEAM = "Alexa.Automotive.DeviceName.HighBeam";
        public static final String HOOD = "Alexa.Automotive.DeviceName.Hood";
        public static final String HUD = "Alexa.Automotive.DeviceName.HUD";
        public static final String INFO_SCREEN = "Alexa.Automotive.DeviceName.InfoScreen";
        public static final String LEFT_SEAT = "Alexa.Automotive.DeviceName.LeftSeat";
        public static final String LIGHT = "Alexa.Automotive.DeviceName.Light";
        public static final String MOONROOF = "Alexa.Automotive.DeviceName.Moonroof";
        public static final String PARKING_LIGHTS = "Alexa.Automotive.DeviceName.ParkingLights";
        public static final String PASSENGER_SEAT = "Alexa.Automotive.DeviceName.PassengerSeat";
        public static final String READING_LIGHT = "Alexa.Automotive.DeviceName.ReadingLight";
        public static final String RIGHT_SEAT = "Alexa.Automotive.DeviceName.RightSeat";
        public static final String SEAT = "Alexa.Automotive.DeviceName.Seat";
        public static final String SEAT_HEATER = "Alexa.Automotive.DeviceName.SeatHeater";
        public static final String STEERING_WHEEL = "Alexa.Automotive.DeviceName.SteeringWheel";
        public static final String SUNROOF = "Alexa.Automotive.DeviceName.Sunroof";
        public static final String SUNSHADE = "Alexa.Automotive.DeviceName.Sunshade";
        public static final String TAILGATE = "Alexa.Automotive.DeviceName.Tailgate";
        public static final String TRUNK = "Alexa.Automotive.DeviceName.Trunk";
        public static final String TRUNK_LIGHT = "Alexa.Automotive.DeviceName.TrunkLight";
        public static final String VENT = "Alexa.Automotive.DeviceName.Vent";
        public static final String WINDOW = "Alexa.Automotive.DeviceName.Window";
        public static final String WINDSHIELD = "Alexa.Automotive.DeviceName.Windshield";
        public static final String WINDSHIELD_WIPERS = "Alexa.Automotive.DeviceName.WindshieldWipers";
    };

    public class Location {
        public static final String ALL = "Alexa.Automotive.Location.All";
        public static final String DRIVER = "Alexa.Automotive.Location.Driver";
        public static final String DRIVER_ROW = "Alexa.Automotive.Location.DriverRow";
        public static final String FIRST_ROW = "Alexa.Automotive.Location.FirstRow";
        public static final String FOURTH_ROW = "Alexa.Automotive.Location.FourthRow";
        public static final String FRONT = "Alexa.Automotive.Location.Front";
        public static final String FRONT_LEFT = "Alexa.Automotive.Location.FrontLeft";
        public static final String FRONT_RIGHT = "Alexa.Automotive.Location.FrontRight";
        public static final String LEFT = "Alexa.Automotive.Location.Left";
        public static final String PASSENGER = "Alexa.Automotive.Location.Passenger";
        public static final String PASSENGER_ROW = "Alexa.Automotive.Location.PassengerRow";
        public static final String REAR = "Alexa.Automotive.Location.Rear";
        public static final String REAR_LEFT = "Alexa.Automotive.Location.RearLeft";
        public static final String REAR_RIGHT = "Alexa.Automotive.Location.RearRight";
        public static final String REAR_DRIVER = "Alexa.Automotive.Location.RearDriver";
        public static final String REAR_PASSENGER = "Alexa.Automotive.Location.RearPassenger";
        public static final String RIGHT = "Alexa.Automotive.Location.Right";
        public static final String SECOND_ROW = "Alexa.Automotive.Location.SecondRow";
        public static final String THIRD_ROW = "Alexa.Automotive.Location.ThirdRow";
    };

    public class Setting {
        public static final String AIR_RECIRCULATION = "Alexa.Automotive.Setting.AirRecirculation";
        public static final String AUTO = "Alexa.Automotive.Setting.Auto";
        public static final String AUTO_BRAKE_HOLD = "Alexa.Automotive.Setting.AutoBrakeHold";
        public static final String BLUETOOTH_PAGE = "Alexa.Automotive.Setting.BluetoothPage";
        public static final String BODY_VENTS = "Alexa.Automotive.Setting.BodyVents";
        public static final String BRIGHTNESS = "Alexa.Automotive.Setting.Brightness";
        public static final String CHILD_DOOR_LOCK = "Alexa.Automotive.Setting.ChildDoorLock";
        public static final String CLIMATE_SYNC = "Alexa.Automotive.Setting.ClimateSync";
        public static final String COLOR = "Alexa.Automotive.Setting.Color";
        public static final String COOLING = "Alexa.Automotive.Setting.Cooling";
        public static final String CRUISE_CONTROL = "Alexa.Automotive.Setting.CruiseControl";
        public static final String DEFOG = "Alexa.Automotive.Setting.Defog";
        public static final String DEFROST = "Alexa.Automotive.Setting.Defrost";
        public static final String DIRECTION = "Alexa.Automotive.Setting.Direction";
        public static final String DRIVE_MODE = "Alexa.Automotive.Setting.DriveMode";
        public static final String ECONOMY = "Alexa.Automotive.Setting.Economy";
        public static final String FAN_SPEED = "Alexa.Automotive.Setting.FanSpeed";
        public static final String FLOOR_VENTS = "Alexa.Automotive.Setting.FloorVents";
        public static final String HEAT = "Alexa.Automotive.Setting.Heat";
        public static final String HEIGHT = "Alexa.Automotive.Setting.Height";
        public static final String HILL_ASSIST = "Alexa.Automotive.Setting.HillAssist";
        public static final String INFO_PAGE = "Alexa.Automotive.Setting.InfoPage";
        public static final String INTENSITY = "Alexa.Automotive.Setting.Intensity";
        public static final String LANE_ASSIST = "Alexa.Automotive.Setting.LaneAssist";
        public static final String MANUAL = "Alexa.Automotive.Setting.Manual";
        public static final String MAX_AIR_CONDITIONING = "Alexa.Automotive.Setting.MaxAirConditioning";
        public static final String MIX_VENTS = "Alexa.Automotive.Setting.MixVents";
        public static final String MODE = "Alexa.Automotive.Setting.Mode";
        public static final String NAVIGATION_PAGE = "Alexa.Automotive.Setting.NavigationPage";
        public static final String OPENNESS = "Alexa.Automotive.Setting.Openness";
        public static final String PARKING_BRAKE = "Alexa.Automotive.Setting.ParkingBrake";
        public static final String POSITION = "Alexa.Automotive.Setting.Position";
        public static final String PRE_COLLISION_BRAKE = "Alexa.Automotive.Setting.PreCollisionBrake";
        public static final String RADIO_PAGE = "Alexa.Automotive.Setting.RadioPage";
        public static final String SATELLITE_RADIO_PAGE = "Alexa.Automotive.Setting.SatelliteRadioPage";
        public static final String SERVICE_PAGE = "Alexa.Automotive.Setting.ServicePage";
        public static final String SETTINGS_PAGE = "Alexa.Automotive.Setting.SettingsPage";
        public static final String SPEED = "Alexa.Automotive.Setting.Speed";
        public static final String STORED_POSITION = "Alexa.Automotive.Setting.StoredPosition";
        public static final String SWAY_WARNING = "Alexa.Automotive.Setting.SwayWarning";
        public static final String TEMPERATURE = "Alexa.Automotive.Setting.Temperature";
        public static final String TOWING_MODE = "Alexa.Automotive.Setting.TowingMode";
        public static final String TRACTION_CONTROL = "Alexa.Automotive.Setting.TractionControl";
        public static final String WINDOW_LOCK = "Alexa.Automotive.Setting.WindowLock";
        public static final String WINDSHIELD_VENTS = "Alexa.Automotive.Setting.WindshieldVents";
    };

    public class Unit {
        public static final String CELSIUS = "Alexa.Unit.Temperature.Celsius";
        public static final String FAHRENHEIT = "Alexa.Unit.Temperature.Fahrenheit";
        public static final String PERCENT = "Alexa.Unit.Percent";
    };

    public class Color {
        public static final String BLUE = "Alexa.Automotive.Value.Blue";
        public static final String GREEN = "Alexa.Automotive.Value.Green";
        public static final String INDIGO = "Alexa.Automotive.Value.Indigo";
        public static final String ORANGE = "Alexa.Automotive.Value.Orange";
        public static final String RED = "Alexa.Automotive.Value.Red";
        public static final String VIOLET = "Alexa.Automotive.Value.Violet";
        public static final String WHITE = "Alexa.Automotive.Value.White";
        public static final String YELLOW = "Alexa.Automotive.Value.Yellow";
    };

    public class Value {
        public static final String ALERTS_PAGE = "Alexa.Automotive.Value.AlertsPage";
        public static final String BLUETOOTH_PAGE = "Alexa.Automotive.Value.BluetoothPage";
        public static final String CLOSED = "Alexa.Automotive.Value.Closed";
        public static final String COMFORT = "Alexa.Automotive.Value.Comfort";
        public static final String CONTACTS_PAGE = "Alexa.Automotive.Value.ContactsPage";
        public static final String CONTROLS_PAGE = "Alexa.Automotive.Value.ControlsPage";
        public static final String DRIVER_VIEW = "Alexa.Automotive.Value.DriverView";
        public static final String DYNAMIC_COORDINATOR_PAGE = "Alexa.Automotive.Value.DynamicCoordinatorPage";
        public static final String FOUR_WD_AUTO = "Alexa.Automotive.Value.4WDAuto";
        public static final String FOUR_WD_HIGH = "Alexa.Automotive.Value.4WDHigh";
        public static final String FOUR_WD_LOW = "Alexa.Automotive.Value.4WDLow";
        public static final String FRONT_VIEW = "Alexa.Automotive.Value.FrontView";
        public static final String FULL = "Alexa.Automotive.Value.Full";
        public static final String GPS_PAGE = "Alexa.Automotive.Value.GPSPage";
        public static final String HALF = "Alexa.Automotive.Value.Half";
        public static final String HIGH = "Alexa.Automotive.Value.High";
        public static final String HOME_PAGE = "Alexa.Automotive.Value.HomePage";
        public static final String INFORMATION_PAGE = "Alexa.Automotive.Value.InformationPage";
        public static final String INSIDE_AIR = "Alexa.Automotive.Value.InsideAir";
        public static final String INTERMITTENT = "Alexa.Automotive.Value.Intermittent";
        public static final String LOW = "Alexa.Automotive.Value.Low";
        public static final String MAXIMUM = "Alexa.Automotive.Value.Maximum";
        public static final String MEDIUM = "Alexa.Automotive.Value.Medium";
        public static final String MINIMUM = "Alexa.Automotive.Value.Minimum";
        public static final String MULTIMEDIA_PAGE = "Alexa.Automotive.Value.MultimediaPage";
        public static final String MUSIC_PAGE = "Alexa.Automotive.Value.MusicPage";
        public static final String NAVIGATION_PAGE = "Alexa.Automotive.Value.NavigationPage";
        public static final String NORMAL = "Alexa.Automotive.Value.Normal";
        public static final String NOTIFICATIONS_PAGE = "Alexa.Automotive.Value.NotificationsPage";
        public static final String OPEN = "Alexa.Automotive.Value.Open";
        public static final String OPTIMAL = "Alexa.Automotive.Value.Optimal";
        public static final String OUTSIDE_AIR = "Alexa.Automotive.Value.OutsideAir";
        public static final String PASSENGER_VIEW = "Alexa.Automotive.Value.PassengerView";
        public static final String PERFORMANCE_PAGE = "Alexa.Automotive.Value.PerformancePage";
        public static final String POSITION_ONE = "Alexa.Automotive.Value.PositionOne";
        public static final String POSITION_THREE = "Alexa.Automotive.Value.PositionThree";
        public static final String POSITION_TWO = "Alexa.Automotive.Value.PositionTwo";
        public static final String RADIO_PAGE = "Alexa.Automotive.Value.RadioPage";
        public static final String REAR_VIEW = "Alexa.Automotive.Value.RearView";
        public static final String SATELLITE_RADIO_PAGE = "Alexa.Automotive.Value.SatelliteRadioPage";
        public static final String SERVICE_PAGE = "Alexa.Automotive.Value.ServicePage";
        public static final String SETTINGS_PAGE = "Alexa.Automotive.Value.SettingsPage";
        public static final String SPORT = "Alexa.Automotive.Value.Sport";
        public static final String SPORT_PLUS = "Alexa.Automotive.Value.SportPlus";
        public static final String TELEPHONE_PAGE = "Alexa.Automotive.Value.TelephonePage";
        public static final String VEHICLE_STATUS_PAGE = "Alexa.Automotive.Value.VehicleStatusPage";
    };
}