# This file contains a list of CVE's where resolution has proven to be impractical
# or there is no reasonable action the Yocto Project can take to resolve the issue.
# It contains all the information we are aware of about an issue and analysis about
# why we believe it can't be fixed/handled. Additional information is welcome through
# patches to the file.
#
# Include this file in your local.conf or distro.conf to exclude these CVE's
# from the cve-check results or add to the bitbake command with:
#     -R conf/distro/include/cve-extra-exclusions.inc
#
# The file is not included by default since users should review this data to ensure
# it matches their expectations and usage of the project.
#
# We may also include "in-flight" information about current/ongoing CVE work with
# the aim of sharing that work and ensuring we don't duplicate it.
#


# strace https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2000-0006
# CVE is more than 20 years old with no resolution evident
# broken links in CVE database references make resolution impractical
CVE_CHECK_WHITELIST += "CVE-2000-0006"

# epiphany https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2005-0238
# The issue here is spoofing of domain names using characters from other character sets.
# There has been much discussion amongst the epiphany and webkit developers and
# whilst there are improvements about how domains are handled and displayed to the user
# there is unlikely ever to be a single fix to webkit or epiphany which addresses this
# problem. Whitelisted as there isn't any mitigation or fix or way to progress this further
# we can seem to take.
CVE_CHECK_WHITELIST += "CVE-2005-0238"

# glibc https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2010-4756
# Issue is memory exhaustion via glob() calls, e.g. from within an ftp server
# Best discussion in https://bugzilla.redhat.com/show_bug.cgi?id=681681
# Upstream don't see it as a security issue, ftp servers shouldn't be passing
# this to libc glob. Exclude as upstream have no plans to add BSD's GLOB_LIMIT or similar
CVE_CHECK_WHITELIST += "CVE-2010-4756"

# go https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2020-29509
# go https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2020-29511
# The encoding/xml package in go can potentially be used for security exploits if not used correctly
# CVE applies to a netapp product as well as flagging a general issue. We don't ship anything
# exposing this interface in an exploitable way
CVE_CHECK_WHITELIST += "CVE-2020-29509 CVE-2020-29511"

# db
# Since Oracle relicensed bdb, the open source community is slowly but surely replacing bdb with
# supported and open source friendly alternatives. As a result these CVEs are unlikely to ever be fixed.
CVE_CHECK_WHITELIST += "CVE-2015-2583 CVE-2015-2624 CVE-2015-2626 CVE-2015-2640 CVE-2015-2654 \
CVE-2015-2656 CVE-2015-4754 CVE-2015-4764 CVE-2015-4774 CVE-2015-4775 CVE-2015-4776 CVE-2015-4777 \
CVE-2015-4778 CVE-2015-4779 CVE-2015-4780 CVE-2015-4781 CVE-2015-4782 CVE-2015-4783 CVE-2015-4784 \
CVE-2015-4785 CVE-2015-4786 CVE-2015-4787 CVE-2015-4788 CVE-2015-4789 CVE-2015-4790 CVE-2016-0682 \
CVE-2016-0689 CVE-2016-0692 CVE-2016-0694 CVE-2016-3418 CVE-2020-2981"

# qemu:qemu-native:qemu-system-native https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2021-20255
# There was a proposed patch https://lists.gnu.org/archive/html/qemu-devel/2021-02/msg06098.html
# qemu maintainers say the patch is incorrect and should not be applied
# Ignore from OE's perspectivee as the issue is of low impact, at worst sitting in an infinite loop rather than exploitable
CVE_CHECK_WHITELIST += "CVE-2021-20255"

# qemu:qemu-native:qemu-system-native https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2019-12067
# There was a proposed patch but rejected by upstream qemu. It is unclear if the issue can
# still be reproduced or where exactly any bug is.
# Ignore from OE's perspective as we'll pick up any fix when upstream accepts one.
CVE_CHECK_WHITELIST += "CVE-2019-12067"

# nasm:nasm-native https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2020-18974
# It is a fuzzing related buffer overflow. It is of low impact since most devices
# wouldn't expose an assembler. The upstream is inactive and there is little to be
# done about the bug, ignore from an OE perspective.
CVE_CHECK_WHITELIST += "CVE-2020-18974"



