
SUMMARY = "An abstract syntax tree for Python with inference support."
DESCRIPTION = "The aim of this module is to provide a common base \
representation of python source code. It is currently the library powering \
pylint’s capabilities.\
\
It provides a compatible representation which comes from the _ast module. It \
rebuilds the tree generated by the builtin _ast module by recursively walking \
down the AST and building an extended ast. The new node classes have \
additional methods and attributes for different usages. They include some \
support for static inference and local name scopes. Furthermore, astroid can \
also build partial trees by inspecting living objects."
HOMEPAGE = "https://pypi.python.org/pypi/astroid"
SECTION = "devel/python"

LICENSE = "LGPL-2.1"
LIC_FILES_CHKSUM = "file://COPYING;md5=751419260aa954499f7abaabaa882bbe"

SRC_URI[md5sum] = "5f3d73d82d1753b59bb49a6bc6046dee"
SRC_URI[sha256sum] = "71ea07f44df9568a75d0f354c49143a4575d90645e9fead6dfb52c26a85ed13a"

DEPENDS += "${PYTHON_PN}-pytest-runner-native"

PACKAGES =+ "${PN}-tests"

inherit pypi setuptools

FILES_${PN}-tests += " \
    ${PYTHON_SITEPACKAGES_DIR}/astroid/test* \
    ${PYTHON_SITEPACKAGES_DIR}/astroid/__pycache__/test* \
"

RDEPENDS_${PN}_class-target += "\
    ${PYTHON_PN}-backports-functools-lru-cache \
    ${PYTHON_PN}-distutils \
    ${PYTHON_PN}-enum34 \
    ${PYTHON_PN}-lazy-object-proxy \
    ${PYTHON_PN}-logging \
    ${PYTHON_PN}-re \
    ${PYTHON_PN}-setuptools \
    ${PYTHON_PN}-singledispatch \
    ${PYTHON_PN}-six \
    ${PYTHON_PN}-subprocess \
    ${PYTHON_PN}-wrapt \
"

RDEPENDS_${PN}-tests_class-target += "\
    ${PYTHON_PN}-unittest \
    ${PYTHON_PN}-xml \
"
