# Blacklist all failing task for CI jobs to easily compare
# if "bitbake world" is getting better or worse

# LICENSE_FLAGS_WHITELIST restrictions

# faad PACKAGECONFIG in meta-raspberrypi/recipes-multimedia/gstreamer/gstreamer1.0-plugins-bad_%.bbappend
# now respects commercial in LICENSE_FLAGS_WHITELIST, we don't need to add it to SKIP_GROUPS by default with dunfell
# ROS_WORLD_SKIP_GROUPS += "world-license-faad"
PNBLACKLIST[gstreamer1.0-plugins-bad] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[gstd] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on gstreamer1.0-plugins-bad which depends on faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[gst-shark] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on gstreamer1.0-plugins-bad which depends on faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[packagegroup-meta-multimedia] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'rdepends on gstd, gst-shark which depend on gstreamer1.0-plugins-bad which depends on faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
# this is new since meta-qt5/dunfell, because gstreamer PACKAGECONFIG wasn't used to be enabled by default in qtmultimedia
PNBLACKLIST[qtmultimedia] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'with default gstreamer PACKAGECONFIG it depends on gstreamer1.0-plugins-bad which depends on faad2 (for rpi) which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[qtvirtualkeyboard] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on qtmultimedia which with default gstreamer PACKAGECONFIG it depends on gstreamer1.0-plugins-bad which depends on faad2 (for rpi) which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[qtcharts] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on qtmultimedia which with default gstreamer PACKAGECONFIG it depends on gstreamer1.0-plugins-bad which depends on faad2 (for rpi) which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[python3-pyqtchart] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on qtcharts which depends on qtmultimedia which with default gstreamer PACKAGECONFIG it depends on gstreamer1.0-plugins-bad which depends on faad2 (for rpi) which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[qtwebkit] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['world-license-faad', 'qt5-widgets'], 'world-license-faad: depends on qtmultimedia which with default gstreamer PACKAGECONFIG it depends on gstreamer1.0-plugins-bad which depends on faad2 (for rpi) which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST; qt5-widgets: needs widgets enabled in qtbase PACKAGECONFIG', '', d)}"
PNBLACKLIST[qt5everywheredemo] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on qtmultimedia which with default gstreamer PACKAGECONFIG it depends on gstreamer1.0-plugins-bad which depends on faad2 (for rpi) which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[qtdatavis3d] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on qtmultimedia which with default gstreamer PACKAGECONFIG it depends on gstreamer1.0-plugins-bad which depends on faad2 (for rpi) which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[packagegroup-qt5-toolchain-target] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'rdepends on qtmultimedia which with default gstreamer PACKAGECONFIG it depends on gstreamer1.0-plugins-bad which depends on faad2 (for rpi) which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[qt5-creator] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['world-license-faad', 'qt5-widgets'], 'world-license-faad: rdepends on packagegroup-qt5-toolchain-target which rdepends on qtmultimedia which with default gstreamer PACKAGECONFIG it depends on gstreamer1.0-plugins-bad which depends on faad2 (for rpi) which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST; qt5-widgets: depends on qtwebkit which needs widgets enabled in qtbase PACKAGECONFIG', '', d)}"
PNBLACKLIST[gstreamer1.0-vaapi] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on gstreamer1.0-plugins-bad->faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[webkitgtk] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on gstreamer1.0-plugins-bad->faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[surf] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on webkitgtk which depends on gstreamer1.0-plugins-bad->faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[epiphany] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on webkitgtk->gstreamer1.0-plugins-bad->faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[packagegroup-self-hosted] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on epiphany->webkitgtk->gstreamer1.0-plugins-bad->faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[clutter-gst-3.0] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on gstreamer1.0-plugins-bad->faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[packagegroup-core-clutter] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on clutter-gst-3.0->gstreamer1.0-plugins-bad->faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[gst-examples] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on gstreamer1.0-plugins-bad which depends on faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[packagegroup-core-x11-sato] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license-faad', 'depends on gst-examples which depends on gstreamer1.0-plugins-bad which depends on faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"
PNBLACKLIST[packagegroup-core-tools-testapps] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['world-license-faad'], 'world-license: depends on gst-examples which depends on gstreamer1.0-plugins-bad which depends on faad2 which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"

ROS_WORLD_SKIP_GROUPS += "world-license"
PNBLACKLIST[omxplayer] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-license', 'depends on libav, libomxil which has a restricted license not whitelisted in LICENSE_FLAGS_WHITELIST', '', d)}"

# Other issues:
ROS_WORLD_SKIP_GROUPS += "world-issues"
PNBLACKLIST[wiringpi] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-issues', 'Fails to fetch: git.drogon.net[0: 188.246.205.22]: errno=Connection refused', '', d)}"
PNBLACKLIST[packagegroup-rpi-test] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['world-issues'], 'world-issues: Depends on blacklisted packages like wiringpi and recipes from meta-multimedia we do not depend on: bigbuckbunny-480p, bigbuckbunny-720p, bigbuckbunny-1080p and wireless-regdb from meta-networking', '', d)}"
PNBLACKLIST[kernel-selftest] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-issues', 'Fails to build with linux-yocto kernel: WARNING: clang >= 6.0  with bpf support is needed with kernel 4.18+ so either install it and add it to HOSTTOOLS, or add clang-native from meta-clang to dependency and then /bin/sh: 1: llc: not found + /bin/sh: 1: clang: not found + /bin/sh: 1: llvm-readelf: not found', '', d)}"
PNBLACKLIST[vboxguestdrivers] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-issues', 'Fails to build with linux-yocto kernel: vboxguestdrivers/5.2.22-r0/vbox_module/vboxguest/r0drv/linux/time-r0drv-linux.c:175:5: error: implicit declaration of function ktime_get_real_ts; did you mean ktime_get_real_ns? [-Werror=implicit-function-declaration]', '', d)}"
PNBLACKLIST[renderdoc] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-issues', 'Depends on mesa-gl without setting correct REQUIRED_DISTRO_FEATURES to match it: mesa-gl PROVIDES virtual/libgl but was skipped: one of vulkan opengl needs to be in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[python-ldap] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-issues', 'Depends on cyrus-sasl from meta-networking, skipped since http://lists.openembedded.org/pipermail/openembedded-devel/2020-February/205123.html', '', d)}"
PNBLACKLIST[python-networkmanager] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'world-issues', 'Depends on networkmanager, skipped since http://lists.openembedded.org/pipermail/openembedded-devel/2020-February/205124.html', '', d)}"

PNBLACKLIST[packagegroup-meta-oe] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['world-issues'], 'world-issues: Depends on blacklisted packages like libvncserver,x11vnc', '', d)}"

PNBLACKLIST[userland] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'opengl', 'depends on libegl-mesa from mesa-gl which is not available without opengl in DISTRO_FEATURES', '', d)}"
