# galactic/ros-distro-recipe-blacklist.inc
#
# Copyright (c) 2020-2021 LG Electronics, Inc.

PNBLACKLIST[ament-clang-format-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on clang-format', '', d)}"
PNBLACKLIST[ament-clang-format] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on clang-format', '', d)}"
PNBLACKLIST[ament-clang-tidy-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on clang-tidy', '', d)}"
PNBLACKLIST[ament-clang-tidy] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on clang-tidy', '', d)}"
PNBLACKLIST[ament-cmake-clang-format] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on ament-clang-format-native->clang-format', '', d)}"
PNBLACKLIST[ament-cmake-clang-tidy] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on ament-clang-tidy-native->clang-tidy', '', d)}"
PNBLACKLIST[connext-cmake-module-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds-native which is not available', '', d)}"
PNBLACKLIST[connext-cmake-module] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
PNBLACKLIST[control-box-rst] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'Depends on unavailable ROS_UNRESOLVED_DEP-coinor-libipopt-dev', '', d)}"
PNBLACKLIST[desktop] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5', 'opengl', 'x11'], 'qt5: rdepends on rviz2, rviz-default-plugins, rqt-common-plugins which rdepends on rqt-image-view which depends on qt-gui-cpp, rqt-gui, rqt-gui-cpp which depend on qtbase; pyqt5: rdepends on rqt-common-plugins which rdepends on rqt-image-view which depends on qt-gui-cpp, rqt-gui, rqt-gui-cpp which depend on python3-pyqt5 which requires pyqt5; opengl: rdepends on rviz2, rviz-default-plugins which depend on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on rviz2, rviz-default-plugins which depend on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[gazebo-plugins] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-rosdev->gazebo which is not available', '', d)}"
PNBLACKLIST[gazebo-ros-pkgs] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-rosdev->gazebo which is not available', '', d)}"
PNBLACKLIST[gazebo-ros] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-rosdev->gazebo which is not available', '', d)}"
PNBLACKLIST[gazebo-rosdev] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo which is not available', '', d)}"
PNBLACKLIST[gurumdds-cmake-module] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gurumdds', 'gurumdds: depends on gurumdds-2.6 which is not available', '', d)}"
PNBLACKLIST[ign-rviz-common] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'ignition', 'ignition: depends on unavailable ROS_UNRESOLVED_DEP-ignition-math6, ROS_UNRESOLVED_DEP-ignition-gui5', '', d)}"
PNBLACKLIST[ign-rviz-plugins] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'ignition', 'ignition: depends on unavailable ROS_UNRESOLVED_DEP-ignition-math6, ROS_UNRESOLVED_DEP-ignition-rendering5, ROS_UNRESOLVED_DEP-ignition-common4, ROS_UNRESOLVED_DEP-ignition-gui5', '', d)}"
PNBLACKLIST[ign-rviz] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'ignition', 'ignition: depends on unavailable ROS_UNRESOLVED_DEP-ignition-math6, ROS_UNRESOLVED_DEP-ignition-common4, ROS_UNRESOLVED_DEP-ignition-gui5', '', d)}"
PNBLACKLIST[joint-state-publisher-gui] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-binding which depends on qtbase; pyqt5: depends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[launch-testing-ament-cmake] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'launch', 'launch: depends on launch-testing-native->launch-native', '', d)}"
PNBLACKLIST[launch-testing-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'launch', 'launch: depends on launch-native', '', d)}"
PNBLACKLIST[libg2o] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'x11'], 'opengl: depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on libglu which requires x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[librealsense2] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'glfw'], 'opengl: depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; glfw: depends on librealsense2 which depends on glfw which is available only in dunfell and requires x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[moveit-planners-ompl] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', ['libomp'], 'libomp: depends on ROS_UNRESOLVED_DEP-libomp-dev which can be provided by meta-clang, but not yet tested with meta-ros', '', d)}"
PNBLACKLIST[moveit-planners] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', ['libomp'], 'libomp: rdepends on moveit-planners-ompl which depends on ROS_UNRESOLVED_DEP-libomp-dev which can be provided by meta-clang, but not yet tested with meta-ros', '', d)}"
PNBLACKLIST[moveit-resources-panda-moveit-config] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on joint-state-publisher-gui which depends on python-qt-binding which depends on qtbase; pyqt5: rdepends on joint-state-publisher-gui which depends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[moveit-resources] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on moveit-resources-panda-moveit-config which rdepends on joint-state-publisher-gui which depends on python-qt-binding which depends on qtbase; pyqt5: rdepends on moveit-resources-panda-moveit-config which rdepends on joint-state-publisher-gui which depends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[moveit-ros-perception] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'x11'], 'Depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES and freeglut which requires x11', '', d)}"
PNBLACKLIST[moveit-ros-visualization] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on rviz2 which depends on qtbase; opengl: depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[moveit-ros] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: rdepends on moveit-ros-visualization which depends on rviz2 which depends on qtbase; opengl: rdepends on moveit-ros-visualization which depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on moveit-ros-visualization which depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[moveit-runtime] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'libomp'], 'qt5: rdepends on moveit-ros which rdepends on moveit-ros-visualization which depends on rviz2 which depends on qtbase; opengl: rdepends on moveit-ros rdepends on moveit-ros-visualization which depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on moveit-ros rdepends on moveit-ros-visualization which depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; libomp: rdepends on moveit-planners which rdepends on moveit-planners-ompl which depends on ROS_UNRESOLVED_DEP-libomp-dev which can be provided by meta-clang, but not yet tested with meta-ros', '', d)}"
PNBLACKLIST[moveit] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'libomp'], 'qt5: rdepends on moveit-ros which rdepends on moveit-ros-visualization which depends on rviz2 which depends on qtbase; opengl: rdepends on moveit-ros rdepends on moveit-ros-visualization which depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on moveit-ros rdepends on moveit-ros-visualization which depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; libomp: rdepends on moveit-planners which rdepends on moveit-planners-ompl which depends on ROS_UNRESOLVED_DEP-libomp-dev which can be provided by meta-clang, but not yet tested with meta-ros', '', d)}"
PNBLACKLIST[mrpt2] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['ffmpeg', 'x264', 'x11'], 'ffmpeg: Depends on ffmpeg which requires commercial license; x264: Depends on ffmpeg which depends on x264 which requires commercial license; x11: Depends on libxxf86vm, freeglut, libxrandr, wxwidgets, glfw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[nav2-bringup] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on slam-toolbox which depends on qtbase; x11: depends on slam-toolbox which depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[nav2-rviz-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on qtbase; x11: depends on rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[nav2-system-tests] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on nav2-bringup which depends on slam-toolbox which depends on qtbase; x11: depends on nav2-bringup which depends on slam-toolbox which depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[navigation2] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: rdepends on nav2-rviz-plugins which depends on qtbase; x11: rdepends on nav2-rviz-plugins which depends on rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[octovis] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'libqglviewer'], 'qt5: depends on qtbase which requires meta-qt5 to be included; libqglviewer: depends on libqglviewer2-qt5 which is not available', '', d)}"
PNBLACKLIST[openvslam] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'x11'], 'opengl: depends on libg2o which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on libg2o which depends on libglu which requires x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[packagegroup-ros-turtlebot3-core] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'turtlebot3', 'turtlebot3: rdepends on turtlebot3-bringup,hls-lfcd-lds-driver,turtlebot3-msgs,ros-base which were not ported to foxy yet', '', d)}"
PNBLACKLIST[packagegroup-ros-turtlebot3-extended] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'turtlebot3', 'turtlebot3: rdepends on slam-karto, compressed-image-transport, depthimage-to-laserscan turtlebot3-applications-msgs, turtlebot3-autorace, cartographer-ros, turtlebot3, turtlebot3-applications which were not ported to foxy yet', '', d)}"
PNBLACKLIST[plansys2-bringup] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on plansys2-executor which depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
PNBLACKLIST[plansys2-bt-actions] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on plansys2-executor which depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
PNBLACKLIST[plansys2-domain-expert] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on plansys2-popf-plan-solver which depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
PNBLACKLIST[plansys2-executor] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
PNBLACKLIST[plansys2-planner] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on plansys2-popf-plan-solver which depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
PNBLACKLIST[plansys2-popf-plan-solver] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
PNBLACKLIST[plansys2-problem-expert] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on plansys2-domain-expert which depends on plansys2-popf-plan-solver which depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
PNBLACKLIST[plansys2-terminal] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on plansys2-executor which depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
PNBLACKLIST[plotjuggler-ros] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'qt5-widgets', 'opengl'], 'qt5: Requires qtsvg, qtwebsockets, qtbase which require meta-qt5 to be included; qt5-widgets: depends on plotjuggler which needs widgets enabled in qtbase PACKAGECONFIG; opengl: depends on plotjuggler which requires opengl to be enabled in qtbase', '', d)}"
PNBLACKLIST[plotjuggler] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'qt5-widgets', 'opengl'], 'qt5: Requires qtbase which requires meta-qt5 to be included; qt5-widgets: needs widgets enabled in qtbase PACKAGECONFIG; opengl: requires opengl to be enabled in qtbase', '', d)}"
PNBLACKLIST[popf] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'Depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
PNBLACKLIST[python-qt-binding] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qtbase; pyqt5: depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[qt-dotgraph] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on python-qt-binding which depends on qtbase which requires meta-qt5 to be included; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[qt-gui-app] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on qt-gui which depends on qtbase which requires meta-qt5 to be included; pyqt5: rdepends on qt-gui which depends on python-qt-binding which requires pyqt5', '', d)}"
PNBLACKLIST[qt-gui-core] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5', 'qt-gui-cpp'], 'qt5: depends on qt-gui which depends on qtbase which requires meta-qt5 to be included; pyqt5: depends on python-qt-binding which requires pyqt5; qt-gui-cpp: depends on qt-gui-cpp which fails to compile', '', d)}"
PNBLACKLIST[qt-gui-cpp] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5', 'qt-gui-cpp'], 'qt5: depends on qtbase which requires meta-qt5 to be included; pyqt5: depends on python-qt-binding which requires pyqt5; qt-gui-cpp: pyqt5; qt-gui-cpp: do_compile task fails: requires pyqt5-native for sip', '', d)}"
PNBLACKLIST[qt-gui-py-common] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on python-qt-binding which depends on qtbase which requires meta-qt5 to be included; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[qt-gui] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qtbase; pyqt5: depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[realsense-examples] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'glfw'], 'opengl: depends on librealsense2 which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; glfw: depends on librealsense2 which depends on glfw which is available only in dunfell and requires x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[realsense-node] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'glfw'], 'opengl: rdepends on realsense-ros which depends on librealsense2 which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; glfw: depends on librealsense2 which depends on glfw which is available only in dunfell and requires x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[realsense-ros] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'glfw'], 'opengl: depends on librealsense2 which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; glfw: depends on librealsense2 which depends on glfw which is available only in dunfell and requires x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[realsense2-camera] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'glfw'], 'opengl: depends on librealsense2->mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; glfw: Depends on librealsense2->glfw which is not available in zeus and older', '', d)}"
PNBLACKLIST[rmw-connext-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
PNBLACKLIST[rmw-connext-shared-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
PNBLACKLIST[rmw-connextdds-common] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
PNBLACKLIST[rmw-connextdds] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
PNBLACKLIST[rmw-gurumdds-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gurumdds', 'gurumdds: depends on gurumdds-2.6 which is not available', '', d)}"
PNBLACKLIST[rmw-gurumdds-shared-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gurumdds', 'gurumdds: depends on gurumdds-2.6 which is not available', '', d)}"
PNBLACKLIST[ros-ign-bridge] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'ignition', 'ignition: depends on unavailable ROS_UNRESOLVED_DEP-ignition-msgs7, ROS_UNRESOLVED_DEP-ignition-transport10', '', d)}"
PNBLACKLIST[ros-ign-gazebo-demos] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'ignition', 'ignition: depends on unavailable ROS_UNRESOLVED_DEP-ignition-gazebo5', '', d)}"
PNBLACKLIST[ros-ign-gazebo] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'ignition', 'ignition: depends on unavailable ROS_UNRESOLVED_DEP-ignition-gazebo5, ROS_UNRESOLVED_DEP-ignition-math6', '', d)}"
PNBLACKLIST[ros-ign-image] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'ignition', 'ignition: depends on unavailable ROS_UNRESOLVED_DEP-ignition-msgs7, ROS_UNRESOLVED_DEP-ignition-transport10', '', d)}"
PNBLACKLIST[ros-ign] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'ignition', 'ignition: rdepends on ros-ign-image, ros-ign-bridge, ros-ign-gazebo which depend on unavailable ROS_UNRESOLVED_DEP-ignition-gazebo5, ROS_UNRESOLVED_DEP-ignition-math6, ROS_UNRESOLVED_DEP-ignition-msgs7, ROS_UNRESOLVED_DEP-ignition-transport10', '', d)}"
PNBLACKLIST[ros-image-turtlebot3-all] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'turtlebot3', 'turtlebot3: Rdepends on packagegroup-ros-turtlebot3-core, packagegroup-ros-turtlebot3-extended which rdepend turtlebot3-bringup,hls-lfcd-lds-driver,turtlebot3-msgs,ros-base,slam-karto, compressed-image-transport, depthimage-to-laserscan turtlebot3-applications-msgs, turtlebot3-autorace, cartographer-ros, turtlebot3, turtlebot3-applications which were not ported to foxy yet', '', d)}"
PNBLACKLIST[ros-image-turtlebot3-core] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'turtlebot3', 'turtlebot3: Rdepends on packagegroup-ros-turtlebot3-core, packagegroup-ros-turtlebot3-extended which rdepend turtlebot3-bringup,hls-lfcd-lds-driver,turtlebot3-msgs,ros-base,slam-karto, compressed-image-transport, depthimage-to-laserscan turtlebot3-applications-msgs, turtlebot3-autorace, cartographer-ros, turtlebot3, turtlebot3-applications which were not ported to foxy yet', '', d)}"
PNBLACKLIST[ros-testing] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'launch', 'launch: depends on launch-testing-ament-cmake->launch-testing-native->launch-native', '', d)}"
PNBLACKLIST[ros2test-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'launch', 'launch: depends on launch-testing-ros-native->launch-testing-native->osrf-pycommon-native->launch-native', '', d)}"
PNBLACKLIST[ros2trace-analysis] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'babeltrace-python', 'babeltrace-python: depends on tracetools-analysis which rdepends on tracetools-read which rdepends on ROS_UNRESOLVED_DEP-python3-babeltrace and python bindings in babeltrace are not enabled as shown in log.do_configure - configure: You may configure with --enable-python-bindings if you want Python bindings.', '', d)}"
PNBLACKLIST[rosbag2-bag-v2-plugins] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'ros1', 'ros1: since https://github.com/ros2/rosbag2_bag_v2/commit/ef48a3ef8a8753b3005862a7c437ff19d70e1745 requires roscpp ROS1 package to be available during do_configure', '', d)}"
PNBLACKLIST[rosidl-typesupport-connext-c] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on (rosidl-typesupport-connext-cpp-native,connext-cmake-module-native)->rti-connext-dds-native which is not available', '', d)}"
PNBLACKLIST[rosidl-typesupport-connext-cpp-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds-native which is not available', '', d)}"
PNBLACKLIST[rosidl-typesupport-connext-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds-native which is not available', '', d)}"
PNBLACKLIST[rqt-action] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui-py which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-bag-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-bag] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-common-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-image-view which depends on qt-gui-cpp, rqt-gui, rqt-gui-cpp which depend on qtbase; pyqt5: rdepends on rqt-image-view which depends on qt-gui-cpp, rqt-gui, rqt-gui-cpp which depend on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-console] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-graph] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-gui-cpp] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5', 'qt-gui-cpp'], 'qt5: depends on qt-gui-cpp and qtbase itself which requires meta-qt5 to be included; pyqt5: depends on qt-gui-cpp which depends python-qt-binding which requires pyqt5; qt-gui-cpp: pyqt5; qt-gui-cpp: depends on qt-gui-cpp which fails to compile', '', d)}"
PNBLACKLIST[rqt-gui-py] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qt-gui which depends on qtbase; pyqt5: depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-gui] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qt-gui which depends on qtbase; pyqt5: depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-image-view] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qt-gui-cpp, rqt-gui, rqt-gui-cpp which depend on qtbase; pyqt5: depends on qt-gui-cpp, rqt-gui, rqt-gui-cpp which depend on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-moveit] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-msg] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-plot] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-publisher] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-py-common] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-py-console] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-reconfigure] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding and rqt-gui-py which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-robot-dashboard] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui-py which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-robot-monitor] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui,rqt-gui-py,qt-gui-py-common which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui,rqt-gui-py,qt-gui-py-common which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-robot-steering] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-service-caller] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui-py which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-shell] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on qt-gui and rqt-gui-py which depends on qtbase which requires meta-qt5 to be included; pyqt5: rdepends on qt-gui which depends on python-qt-binding which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-srv] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-msg which rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-top] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-topic] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding and rqt-gui-py which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5', 'qt-gui-cpp'], 'qt5: depends on qt-gui which depends on qtbase which requires meta-qt5 to be included; pyqt5: depends on rqt-gui-cpp which depends on qt-gui-cpp which depends python-qt-binding which requires pyqt5; qt-gui-cpp: pyqt5; qt-gui-cpp: depends on rqt-gui-cpp which depends depends on qt-gui-cpp which fails to compile', '', d)}"
PNBLACKLIST[rti-connext-dds-cmake-module] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
PNBLACKLIST[run-ompl-constrained-planning] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['mongodb', 'mongodb-legacy-cxx-driver'], 'mongodb: rdepends on warehouse-ros-mongo which requires mongodb; mongodb-legacy-cxx-driver: rdepends on warehouse-ros-mongo which requires unavailable mongo-cxx-driver-legacy', '', d)}"
PNBLACKLIST[rviz-common] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[rviz-default-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[rviz-ogre-vendor] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'x11'], 'opengl: depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[rviz-rendering-tests] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[rviz-rendering] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[rviz-visual-testing-framework] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[rviz2] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[sdformat-urdf] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'sdformat', 'sdformat: depends on unavailable sdformat"
PNBLACKLIST[slam-toolbox] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on qtbase; x11: depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[spacenav] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'libspnav', 'Depends on unavailable ROS_UNRESOLVED_DEP-libspnav-dev', '', d)}"
PNBLACKLIST[tracetools-analysis] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'babeltrace-python', 'babeltrace-python: rdepends on tracetools-read which rdepends on ROS_UNRESOLVED_DEP-python3-babeltrace and python bindings in babeltrace are not enabled as shown in log.do_configure - configure: You may configure with --enable-python-bindings if you want Python bindings.', '', d)}"
PNBLACKLIST[tracetools-read] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'babeltrace-python', 'babeltrace-python: rdepends on ROS_UNRESOLVED_DEP-python3-babeltrace and python bindings in babeltrace are not enabled as shown in log.do_configure - configure: You may configure with --enable-python-bindings if you want Python bindings.', '', d)}"
PNBLACKLIST[turtlebot3-gazebo] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'gazebo'], 'qt5: depends on turtlebot3 which depends on turtlebot3-bringup, turtlebot3-navigation2 which depend on rviz2 which depends on qtbase; opengl: depends on turtlebot3 which depends on turtlebot3-bringup which depends on rviz2 which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on turtlebot3 which depends on turtlebot3-bringup, turtlebot3-navigation2 which depend on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; gazebo: depends on gazebo-ros-pkgs->gazebo-rosdev->gazebo which is not available', '', d)}"
PNBLACKLIST[turtlebot3-simulations] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'gazebo'], 'qt5: depends on turtlebot3-gazebo which depends on turtlebot3 which depends on turtlebot3-bringup, turtlebot3-navigation2 which depend on rviz2 which depends on qtbase; opengl: depends on turtlebot3-gazebo which depends on turtlebot3 which depends on turtlebot3-bringup which depends on rviz2 which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on turtlebot3-gazebo which depends on turtlebot3 which depends on turtlebot3-bringup, turtlebot3-navigation2 which depend on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; gazebo: depends on turtlebot3-gazebo which depends on gazebo-ros-pkgs->gazebo-rosdev->gazebo which is not available', '', d)}"
PNBLACKLIST[turtlesim] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'qt5-widgets'], 'qt5: depends on qtbase; qt5-widgets: needs widgets enabled in qtbase PACKAGECONFIG', '', d)}"
PNBLACKLIST[warehouse-ros-mongo] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['mongodb', 'mongodb-legacy-cxx-driver'], 'Requires mongodb; mongodb-legacy-cxx-driver: requires unavailable mongo-cxx-driver-legacy', '', d)}"
PNBLACKLIST[webots-ros2-abb] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
PNBLACKLIST[webots-ros2-core] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: requires python-transforms3d-pip which is not available in OE yet', '', d)}"
PNBLACKLIST[webots-ros2-demos] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'webots-python-modules'], 'qt5: rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on qtbase; opengl: rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
PNBLACKLIST[webots-ros2-desktop] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'webots-python-modules'], 'qt5: rdepends on webots-ros2 which rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on qtbase; opengl: rdepends on webots-ros2 which rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on webots-ros2 which rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; webots-python-modules: rdepends on webots-ros2 which rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet and webots-ros2-importer which requires python3-collada-pip, urdf2webots-pip which are not available in OE yet', '', d)}"
PNBLACKLIST[webots-ros2-epuck] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: rdepends on rviz2 which depends on qtbase; opengl: rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[webots-ros2-examples] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
PNBLACKLIST[webots-ros2-importer] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: requires python3-collada-pip, urdf2webots-pip which are not available in OE yet', '', d)}"
PNBLACKLIST[webots-ros2-tesla] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
PNBLACKLIST[webots-ros2-tiago] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: rdepends on rviz2 which depends on qtbase; opengl: rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[webots-ros2-turtlebot] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
PNBLACKLIST[webots-ros2-tutorials] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
PNBLACKLIST[webots-ros2-universal-robot] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: rdepends on rviz2 which depends on qtbase; opengl: rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[webots-ros2] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'webots-python-modules'], 'qt5: rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on qtbase; opengl: rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet and webots-ros2-importer which requires python3-collada-pip, urdf2webots-pip which are not available in OE yet', '', d)}"
PNBLACKLIST[wiimote] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'cwiid', 'Depends on unavailable ROS_UNRESOLVED_DEP-cwiid-dev', '', d)}"
