// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import 'src/google_fonts_base.dart';
import 'src/google_fonts_descriptor.dart';
import 'src/google_fonts_variant.dart';

/// A collection of properties used to specify custom behavior of the
/// GoogleFonts library.
class _Config {
  /// Whether or not the GoogleFonts library can make requests to
  /// [fonts.google.com](https://fonts.google.com/) to retrieve font files.
  var allowRuntimeFetching = true;
}

class GoogleFonts {
  /// Configuration for the [GoogleFonts] library.
  ///
  /// Use this to define custom behavior of the GoogleFonts library in your app.
  /// For example, if you do not want the GoogleFonts library to make any http
  /// requests for fonts, add the following snippet to your app's `main` method.
  ///
  /// ```dart
  /// GoogleFonts.config.allowRuntimeFetching = false;
  /// ```
  static final config = _Config();

  /// Get a map of all available fonts.
  ///
  /// Returns a map where the key is the name of the font family and the value
  /// is the corresponding [GoogleFonts] method.
  static Map<
      String,
      TextStyle Function({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  })> asMap() => const {
        'ABeeZee': GoogleFonts.aBeeZee,
        'Abel': GoogleFonts.abel,
        'Abhaya Libre': GoogleFonts.abhayaLibre,
        'Abril Fatface': GoogleFonts.abrilFatface,
        'Aclonica': GoogleFonts.aclonica,
        'Acme': GoogleFonts.acme,
        'Actor': GoogleFonts.actor,
        'Adamina': GoogleFonts.adamina,
        'Advent Pro': GoogleFonts.adventPro,
        'Aguafina Script': GoogleFonts.aguafinaScript,
        'Akaya Telivigala': GoogleFonts.akayaTelivigala,
        'Akronim': GoogleFonts.akronim,
        'Aladin': GoogleFonts.aladin,
        'Alata': GoogleFonts.alata,
        'Alatsi': GoogleFonts.alatsi,
        'Aldrich': GoogleFonts.aldrich,
        'Alef': GoogleFonts.alef,
        'Alegreya': GoogleFonts.alegreya,
        'Alegreya SC': GoogleFonts.alegreyaSc,
        'Alegreya Sans': GoogleFonts.alegreyaSans,
        'Alegreya Sans SC': GoogleFonts.alegreyaSansSc,
        'Aleo': GoogleFonts.aleo,
        'Alex Brush': GoogleFonts.alexBrush,
        'Alfa Slab One': GoogleFonts.alfaSlabOne,
        'Alice': GoogleFonts.alice,
        'Alike': GoogleFonts.alike,
        'Alike Angular': GoogleFonts.alikeAngular,
        'Allan': GoogleFonts.allan,
        'Allerta': GoogleFonts.allerta,
        'Allerta Stencil': GoogleFonts.allertaStencil,
        'Allison': GoogleFonts.allison,
        'Allura': GoogleFonts.allura,
        'Almarai': GoogleFonts.almarai,
        'Almendra': GoogleFonts.almendra,
        'Almendra Display': GoogleFonts.almendraDisplay,
        'Almendra SC': GoogleFonts.almendraSc,
        'Alumni Sans': GoogleFonts.alumniSans,
        'Amarante': GoogleFonts.amarante,
        'Amaranth': GoogleFonts.amaranth,
        'Amatic SC': GoogleFonts.amaticSc,
        'Amatica SC': GoogleFonts.amaticaSc,
        'Amethysta': GoogleFonts.amethysta,
        'Amiko': GoogleFonts.amiko,
        'Amiri': GoogleFonts.amiri,
        'Amita': GoogleFonts.amita,
        'Anaheim': GoogleFonts.anaheim,
        'Andada': GoogleFonts.andada,
        'Andada Pro': GoogleFonts.andadaPro,
        'Andika': GoogleFonts.andika,
        'Andika New Basic': GoogleFonts.andikaNewBasic,
        'Annie Use Your Telescope': GoogleFonts.annieUseYourTelescope,
        'Anonymous Pro': GoogleFonts.anonymousPro,
        'Antic': GoogleFonts.antic,
        'Antic Didone': GoogleFonts.anticDidone,
        'Antic Slab': GoogleFonts.anticSlab,
        'Anton': GoogleFonts.anton,
        'Arapey': GoogleFonts.arapey,
        'Arbutus': GoogleFonts.arbutus,
        'Arbutus Slab': GoogleFonts.arbutusSlab,
        'Architects Daughter': GoogleFonts.architectsDaughter,
        'Archivo': GoogleFonts.archivo,
        'Archivo Black': GoogleFonts.archivoBlack,
        'Archivo Narrow': GoogleFonts.archivoNarrow,
        'Are You Serious': GoogleFonts.areYouSerious,
        'Aref Ruqaa': GoogleFonts.arefRuqaa,
        'Arima Madurai': GoogleFonts.arimaMadurai,
        'Arimo': GoogleFonts.arimo,
        'Arizonia': GoogleFonts.arizonia,
        'Armata': GoogleFonts.armata,
        'Arsenal': GoogleFonts.arsenal,
        'Artifika': GoogleFonts.artifika,
        'Arvo': GoogleFonts.arvo,
        'Arya': GoogleFonts.arya,
        'Asap': GoogleFonts.asap,
        'Asar': GoogleFonts.asar,
        'Asset': GoogleFonts.asset,
        'Assistant': GoogleFonts.assistant,
        'Astloch': GoogleFonts.astloch,
        'Asul': GoogleFonts.asul,
        'Athiti': GoogleFonts.athiti,
        'Atkinson Hyperlegible': GoogleFonts.atkinsonHyperlegible,
        'Atma': GoogleFonts.atma,
        'Atomic Age': GoogleFonts.atomicAge,
        'Aubrey': GoogleFonts.aubrey,
        'Audiowide': GoogleFonts.audiowide,
        'Autour One': GoogleFonts.autourOne,
        'Average': GoogleFonts.average,
        'Average Sans': GoogleFonts.averageSans,
        'Averia Gruesa Libre': GoogleFonts.averiaGruesaLibre,
        'Averia Libre': GoogleFonts.averiaLibre,
        'Averia Sans Libre': GoogleFonts.averiaSansLibre,
        'Averia Serif Libre': GoogleFonts.averiaSerifLibre,
        'Azeret Mono': GoogleFonts.azeretMono,
        'B612': GoogleFonts.b612,
        'B612 Mono': GoogleFonts.b612Mono,
        'Bad Script': GoogleFonts.badScript,
        'Bahiana': GoogleFonts.bahiana,
        'Bahianita': GoogleFonts.bahianita,
        'Bai Jamjuree': GoogleFonts.baiJamjuree,
        'Bakbak One': GoogleFonts.bakbakOne,
        'Baloo': GoogleFonts.baloo,
        'Baloo 2': GoogleFonts.baloo2,
        'Baloo Bhai': GoogleFonts.balooBhai,
        'Baloo Bhai 2': GoogleFonts.balooBhai2,
        'Baloo Bhaijaan': GoogleFonts.balooBhaijaan,
        'Baloo Bhaijaan 2': GoogleFonts.balooBhaijaan2,
        'Baloo Bhaina': GoogleFonts.balooBhaina,
        'Baloo Bhaina 2': GoogleFonts.balooBhaina2,
        'Baloo Chettan': GoogleFonts.balooChettan,
        'Baloo Chettan 2': GoogleFonts.balooChettan2,
        'Baloo Da': GoogleFonts.balooDa,
        'Baloo Da 2': GoogleFonts.balooDa2,
        'Baloo Paaji': GoogleFonts.balooPaaji,
        'Baloo Paaji 2': GoogleFonts.balooPaaji2,
        'Baloo Tamma': GoogleFonts.balooTamma,
        'Baloo Tamma 2': GoogleFonts.balooTamma2,
        'Baloo Tammudu': GoogleFonts.balooTammudu,
        'Baloo Tammudu 2': GoogleFonts.balooTammudu2,
        'Baloo Thambi': GoogleFonts.balooThambi,
        'Baloo Thambi 2': GoogleFonts.balooThambi2,
        'Balsamiq Sans': GoogleFonts.balsamiqSans,
        'Balthazar': GoogleFonts.balthazar,
        'Bangers': GoogleFonts.bangers,
        'Barlow': GoogleFonts.barlow,
        'Barlow Condensed': GoogleFonts.barlowCondensed,
        'Barlow Semi Condensed': GoogleFonts.barlowSemiCondensed,
        'Barriecito': GoogleFonts.barriecito,
        'Barrio': GoogleFonts.barrio,
        'Basic': GoogleFonts.basic,
        'Baskervville': GoogleFonts.baskervville,
        'Baumans': GoogleFonts.baumans,
        'Be Vietnam': GoogleFonts.beVietnam,
        'Be Vietnam Pro': GoogleFonts.beVietnamPro,
        'Bebas Neue': GoogleFonts.bebasNeue,
        'Belgrano': GoogleFonts.belgrano,
        'Bellefair': GoogleFonts.bellefair,
        'Belleza': GoogleFonts.belleza,
        'Bellota': GoogleFonts.bellota,
        'Bellota Text': GoogleFonts.bellotaText,
        'BenchNine': GoogleFonts.benchNine,
        'Bentham': GoogleFonts.bentham,
        'Berkshire Swash': GoogleFonts.berkshireSwash,
        'Besley': GoogleFonts.besley,
        'Beth Ellen': GoogleFonts.bethEllen,
        'Bevan': GoogleFonts.bevan,
        'Big Shoulders Display': GoogleFonts.bigShouldersDisplay,
        'Big Shoulders Inline Display': GoogleFonts.bigShouldersInlineDisplay,
        'Big Shoulders Inline Text': GoogleFonts.bigShouldersInlineText,
        'Big Shoulders Stencil Display': GoogleFonts.bigShouldersStencilDisplay,
        'Big Shoulders Stencil Text': GoogleFonts.bigShouldersStencilText,
        'Big Shoulders Text': GoogleFonts.bigShouldersText,
        'Bigelow Rules': GoogleFonts.bigelowRules,
        'Bigshot One': GoogleFonts.bigshotOne,
        'Bilbo': GoogleFonts.bilbo,
        'Bilbo Swash Caps': GoogleFonts.bilboSwashCaps,
        'BioRhyme': GoogleFonts.bioRhyme,
        'BioRhyme Expanded': GoogleFonts.bioRhymeExpanded,
        'Birthstone': GoogleFonts.birthstone,
        'Birthstone Bounce': GoogleFonts.birthstoneBounce,
        'Biryani': GoogleFonts.biryani,
        'Bitter': GoogleFonts.bitter,
        'Black And White Picture': GoogleFonts.blackAndWhitePicture,
        'Black Han Sans': GoogleFonts.blackHanSans,
        'Black Ops One': GoogleFonts.blackOpsOne,
        'Blinker': GoogleFonts.blinker,
        'Bona Nova': GoogleFonts.bonaNova,
        'Bonbon': GoogleFonts.bonbon,
        'Bonheur Royale': GoogleFonts.bonheurRoyale,
        'Boogaloo': GoogleFonts.boogaloo,
        'Bowlby One': GoogleFonts.bowlbyOne,
        'Bowlby One SC': GoogleFonts.bowlbyOneSc,
        'Brawler': GoogleFonts.brawler,
        'Bree Serif': GoogleFonts.breeSerif,
        'Brygada 1918': GoogleFonts.brygada1918,
        'Bubblegum Sans': GoogleFonts.bubblegumSans,
        'Bubbler One': GoogleFonts.bubblerOne,
        'Buda': GoogleFonts.buda,
        'Buenard': GoogleFonts.buenard,
        'Bungee': GoogleFonts.bungee,
        'Bungee Hairline': GoogleFonts.bungeeHairline,
        'Bungee Inline': GoogleFonts.bungeeInline,
        'Bungee Outline': GoogleFonts.bungeeOutline,
        'Bungee Shade': GoogleFonts.bungeeShade,
        'Butcherman': GoogleFonts.butcherman,
        'Butterfly Kids': GoogleFonts.butterflyKids,
        'Cabin': GoogleFonts.cabin,
        'Cabin Condensed': GoogleFonts.cabinCondensed,
        'Cabin Sketch': GoogleFonts.cabinSketch,
        'Caesar Dressing': GoogleFonts.caesarDressing,
        'Cagliostro': GoogleFonts.cagliostro,
        'Cairo': GoogleFonts.cairo,
        'Caladea': GoogleFonts.caladea,
        'Calistoga': GoogleFonts.calistoga,
        'Calligraffitti': GoogleFonts.calligraffitti,
        'Cambay': GoogleFonts.cambay,
        'Cambo': GoogleFonts.cambo,
        'Candal': GoogleFonts.candal,
        'Cantarell': GoogleFonts.cantarell,
        'Cantata One': GoogleFonts.cantataOne,
        'Cantora One': GoogleFonts.cantoraOne,
        'Capriola': GoogleFonts.capriola,
        'Caramel': GoogleFonts.caramel,
        'Carattere': GoogleFonts.carattere,
        'Cardo': GoogleFonts.cardo,
        'Carme': GoogleFonts.carme,
        'Carrois Gothic': GoogleFonts.carroisGothic,
        'Carrois Gothic SC': GoogleFonts.carroisGothicSc,
        'Carter One': GoogleFonts.carterOne,
        'Castoro': GoogleFonts.castoro,
        'Catamaran': GoogleFonts.catamaran,
        'Caudex': GoogleFonts.caudex,
        'Caveat': GoogleFonts.caveat,
        'Caveat Brush': GoogleFonts.caveatBrush,
        'Cedarville Cursive': GoogleFonts.cedarvilleCursive,
        'Ceviche One': GoogleFonts.cevicheOne,
        'Chakra Petch': GoogleFonts.chakraPetch,
        'Changa': GoogleFonts.changa,
        'Changa One': GoogleFonts.changaOne,
        'Chango': GoogleFonts.chango,
        'Charm': GoogleFonts.charm,
        'Charmonman': GoogleFonts.charmonman,
        'Chathura': GoogleFonts.chathura,
        'Chau Philomene One': GoogleFonts.chauPhilomeneOne,
        'Chela One': GoogleFonts.chelaOne,
        'Chelsea Market': GoogleFonts.chelseaMarket,
        'Cherish': GoogleFonts.cherish,
        'Cherry Cream Soda': GoogleFonts.cherryCreamSoda,
        'Cherry Swash': GoogleFonts.cherrySwash,
        'Chewy': GoogleFonts.chewy,
        'Chicle': GoogleFonts.chicle,
        'Chilanka': GoogleFonts.chilanka,
        'Chivo': GoogleFonts.chivo,
        'Chonburi': GoogleFonts.chonburi,
        'Cinzel': GoogleFonts.cinzel,
        'Cinzel Decorative': GoogleFonts.cinzelDecorative,
        'Clicker Script': GoogleFonts.clickerScript,
        'Coda': GoogleFonts.coda,
        'Coda Caption': GoogleFonts.codaCaption,
        'Codystar': GoogleFonts.codystar,
        'Coiny': GoogleFonts.coiny,
        'Combo': GoogleFonts.combo,
        'Comfortaa': GoogleFonts.comfortaa,
        'Comforter': GoogleFonts.comforter,
        'Comforter Brush': GoogleFonts.comforterBrush,
        'Comic Neue': GoogleFonts.comicNeue,
        'Coming Soon': GoogleFonts.comingSoon,
        'Commissioner': GoogleFonts.commissioner,
        'Concert One': GoogleFonts.concertOne,
        'Condiment': GoogleFonts.condiment,
        'Contrail One': GoogleFonts.contrailOne,
        'Convergence': GoogleFonts.convergence,
        'Cookie': GoogleFonts.cookie,
        'Copse': GoogleFonts.copse,
        'Corben': GoogleFonts.corben,
        'Corinthia': GoogleFonts.corinthia,
        'Cormorant': GoogleFonts.cormorant,
        'Cormorant Garamond': GoogleFonts.cormorantGaramond,
        'Cormorant Infant': GoogleFonts.cormorantInfant,
        'Cormorant SC': GoogleFonts.cormorantSc,
        'Cormorant Unicase': GoogleFonts.cormorantUnicase,
        'Cormorant Upright': GoogleFonts.cormorantUpright,
        'Courgette': GoogleFonts.courgette,
        'Courier Prime': GoogleFonts.courierPrime,
        'Cousine': GoogleFonts.cousine,
        'Coustard': GoogleFonts.coustard,
        'Covered By Your Grace': GoogleFonts.coveredByYourGrace,
        'Crafty Girls': GoogleFonts.craftyGirls,
        'Creepster': GoogleFonts.creepster,
        'Crete Round': GoogleFonts.creteRound,
        'Crimson Pro': GoogleFonts.crimsonPro,
        'Crimson Text': GoogleFonts.crimsonText,
        'Croissant One': GoogleFonts.croissantOne,
        'Crushed': GoogleFonts.crushed,
        'Cuprum': GoogleFonts.cuprum,
        'Cute Font': GoogleFonts.cuteFont,
        'Cutive': GoogleFonts.cutive,
        'Cutive Mono': GoogleFonts.cutiveMono,
        'DM Mono': GoogleFonts.dmMono,
        'DM Sans': GoogleFonts.dmSans,
        'DM Serif Display': GoogleFonts.dmSerifDisplay,
        'DM Serif Text': GoogleFonts.dmSerifText,
        'Damion': GoogleFonts.damion,
        'Dancing Script': GoogleFonts.dancingScript,
        'Darker Grotesque': GoogleFonts.darkerGrotesque,
        'David Libre': GoogleFonts.davidLibre,
        'Dawning of a New Day': GoogleFonts.dawningOfANewDay,
        'Days One': GoogleFonts.daysOne,
        'Dekko': GoogleFonts.dekko,
        'Dela Gothic One': GoogleFonts.delaGothicOne,
        'Delius': GoogleFonts.delius,
        'Delius Swash Caps': GoogleFonts.deliusSwashCaps,
        'Delius Unicase': GoogleFonts.deliusUnicase,
        'Della Respira': GoogleFonts.dellaRespira,
        'Denk One': GoogleFonts.denkOne,
        'Devonshire': GoogleFonts.devonshire,
        'Dhurjati': GoogleFonts.dhurjati,
        'Didact Gothic': GoogleFonts.didactGothic,
        'Diplomata': GoogleFonts.diplomata,
        'Diplomata SC': GoogleFonts.diplomataSc,
        'Do Hyeon': GoogleFonts.doHyeon,
        'Dokdo': GoogleFonts.dokdo,
        'Domine': GoogleFonts.domine,
        'Donegal One': GoogleFonts.donegalOne,
        'Dongle': GoogleFonts.dongle,
        'Doppio One': GoogleFonts.doppioOne,
        'Dorsa': GoogleFonts.dorsa,
        'Dosis': GoogleFonts.dosis,
        'DotGothic16': GoogleFonts.dotGothic16,
        'Dr Sugiyama': GoogleFonts.drSugiyama,
        'Droid Sans': GoogleFonts.droidSans,
        'Droid Sans Mono': GoogleFonts.droidSansMono,
        'Droid Serif': GoogleFonts.droidSerif,
        'Duru Sans': GoogleFonts.duruSans,
        'Dynalight': GoogleFonts.dynalight,
        'EB Garamond': GoogleFonts.ebGaramond,
        'Eagle Lake': GoogleFonts.eagleLake,
        'East Sea Dokdo': GoogleFonts.eastSeaDokdo,
        'Eater': GoogleFonts.eater,
        'Economica': GoogleFonts.economica,
        'Eczar': GoogleFonts.eczar,
        'El Messiri': GoogleFonts.elMessiri,
        'Electrolize': GoogleFonts.electrolize,
        'Elsie': GoogleFonts.elsie,
        'Elsie Swash Caps': GoogleFonts.elsieSwashCaps,
        'Emblema One': GoogleFonts.emblemaOne,
        'Emilys Candy': GoogleFonts.emilysCandy,
        'Encode Sans': GoogleFonts.encodeSans,
        'Encode Sans Condensed': GoogleFonts.encodeSansCondensed,
        'Encode Sans Expanded': GoogleFonts.encodeSansExpanded,
        'Encode Sans SC': GoogleFonts.encodeSansSc,
        'Encode Sans Semi Condensed': GoogleFonts.encodeSansSemiCondensed,
        'Encode Sans Semi Expanded': GoogleFonts.encodeSansSemiExpanded,
        'Engagement': GoogleFonts.engagement,
        'Englebert': GoogleFonts.englebert,
        'Enriqueta': GoogleFonts.enriqueta,
        'Ephesis': GoogleFonts.ephesis,
        'Epilogue': GoogleFonts.epilogue,
        'Erica One': GoogleFonts.ericaOne,
        'Esteban': GoogleFonts.esteban,
        'Estonia': GoogleFonts.estonia,
        'Euphoria Script': GoogleFonts.euphoriaScript,
        'Ewert': GoogleFonts.ewert,
        'Exo': GoogleFonts.exo,
        'Exo 2': GoogleFonts.exo2,
        'Expletus Sans': GoogleFonts.expletusSans,
        'Explora': GoogleFonts.explora,
        'Fahkwang': GoogleFonts.fahkwang,
        'Fanwood Text': GoogleFonts.fanwoodText,
        'Farro': GoogleFonts.farro,
        'Farsan': GoogleFonts.farsan,
        'Fascinate': GoogleFonts.fascinate,
        'Fascinate Inline': GoogleFonts.fascinateInline,
        'Faster One': GoogleFonts.fasterOne,
        'Fauna One': GoogleFonts.faunaOne,
        'Faustina': GoogleFonts.faustina,
        'Federant': GoogleFonts.federant,
        'Federo': GoogleFonts.federo,
        'Felipa': GoogleFonts.felipa,
        'Fenix': GoogleFonts.fenix,
        'Festive': GoogleFonts.festive,
        'Finger Paint': GoogleFonts.fingerPaint,
        'Fira Code': GoogleFonts.firaCode,
        'Fira Mono': GoogleFonts.firaMono,
        'Fira Sans': GoogleFonts.firaSans,
        'Fira Sans Condensed': GoogleFonts.firaSansCondensed,
        'Fira Sans Extra Condensed': GoogleFonts.firaSansExtraCondensed,
        'Fjalla One': GoogleFonts.fjallaOne,
        'Fjord One': GoogleFonts.fjordOne,
        'Flamenco': GoogleFonts.flamenco,
        'Flavors': GoogleFonts.flavors,
        'Fleur De Leah': GoogleFonts.fleurDeLeah,
        'Flow Block': GoogleFonts.flowBlock,
        'Flow Circular': GoogleFonts.flowCircular,
        'Flow Rounded': GoogleFonts.flowRounded,
        'Fondamento': GoogleFonts.fondamento,
        'Fontdiner Swanky': GoogleFonts.fontdinerSwanky,
        'Forum': GoogleFonts.forum,
        'Francois One': GoogleFonts.francoisOne,
        'Frank Ruhl Libre': GoogleFonts.frankRuhlLibre,
        'Fraunces': GoogleFonts.fraunces,
        'Freckle Face': GoogleFonts.freckleFace,
        'Fredericka the Great': GoogleFonts.frederickaTheGreat,
        'Fredoka One': GoogleFonts.fredokaOne,
        'Fresca': GoogleFonts.fresca,
        'Frijole': GoogleFonts.frijole,
        'Fruktur': GoogleFonts.fruktur,
        'Fugaz One': GoogleFonts.fugazOne,
        'Fuggles': GoogleFonts.fuggles,
        'Fuzzy Bubbles': GoogleFonts.fuzzyBubbles,
        'GFS Didot': GoogleFonts.gfsDidot,
        'GFS Neohellenic': GoogleFonts.gfsNeohellenic,
        'Gabriela': GoogleFonts.gabriela,
        'Gaegu': GoogleFonts.gaegu,
        'Gafata': GoogleFonts.gafata,
        'Galada': GoogleFonts.galada,
        'Galdeano': GoogleFonts.galdeano,
        'Galindo': GoogleFonts.galindo,
        'Gamja Flower': GoogleFonts.gamjaFlower,
        'Gayathri': GoogleFonts.gayathri,
        'Gelasio': GoogleFonts.gelasio,
        'Gemunu Libre': GoogleFonts.gemunuLibre,
        'Genos': GoogleFonts.genos,
        'Gentium Basic': GoogleFonts.gentiumBasic,
        'Gentium Book Basic': GoogleFonts.gentiumBookBasic,
        'Geo': GoogleFonts.geo,
        'Georama': GoogleFonts.georama,
        'Geostar': GoogleFonts.geostar,
        'Geostar Fill': GoogleFonts.geostarFill,
        'Germania One': GoogleFonts.germaniaOne,
        'Gideon Roman': GoogleFonts.gideonRoman,
        'Gidugu': GoogleFonts.gidugu,
        'Gilda Display': GoogleFonts.gildaDisplay,
        'Girassol': GoogleFonts.girassol,
        'Give You Glory': GoogleFonts.giveYouGlory,
        'Glass Antiqua': GoogleFonts.glassAntiqua,
        'Glegoo': GoogleFonts.glegoo,
        'Gloria Hallelujah': GoogleFonts.gloriaHallelujah,
        'Glory': GoogleFonts.glory,
        'Gluten': GoogleFonts.gluten,
        'Goblin One': GoogleFonts.goblinOne,
        'Gochi Hand': GoogleFonts.gochiHand,
        'Goldman': GoogleFonts.goldman,
        'Gorditas': GoogleFonts.gorditas,
        'Gothic A1': GoogleFonts.gothicA1,
        'Gotu': GoogleFonts.gotu,
        'Goudy Bookletter 1911': GoogleFonts.goudyBookletter1911,
        'Gowun Batang': GoogleFonts.gowunBatang,
        'Gowun Dodum': GoogleFonts.gowunDodum,
        'Graduate': GoogleFonts.graduate,
        'Grand Hotel': GoogleFonts.grandHotel,
        'Grandstander': GoogleFonts.grandstander,
        'Gravitas One': GoogleFonts.gravitasOne,
        'Great Vibes': GoogleFonts.greatVibes,
        'Grechen Fuemen': GoogleFonts.grechenFuemen,
        'Grenze': GoogleFonts.grenze,
        'Grenze Gotisch': GoogleFonts.grenzeGotisch,
        'Grey Qo': GoogleFonts.greyQo,
        'Griffy': GoogleFonts.griffy,
        'Gruppo': GoogleFonts.gruppo,
        'Gudea': GoogleFonts.gudea,
        'Gugi': GoogleFonts.gugi,
        'Gupter': GoogleFonts.gupter,
        'Gurajada': GoogleFonts.gurajada,
        'Gwendolyn': GoogleFonts.gwendolyn,
        'Habibi': GoogleFonts.habibi,
        'Hachi Maru Pop': GoogleFonts.hachiMaruPop,
        'Hahmlet': GoogleFonts.hahmlet,
        'Halant': GoogleFonts.halant,
        'Hammersmith One': GoogleFonts.hammersmithOne,
        'Hanalei': GoogleFonts.hanalei,
        'Hanalei Fill': GoogleFonts.hanaleiFill,
        'Handlee': GoogleFonts.handlee,
        'Happy Monkey': GoogleFonts.happyMonkey,
        'Harmattan': GoogleFonts.harmattan,
        'Headland One': GoogleFonts.headlandOne,
        'Heebo': GoogleFonts.heebo,
        'Henny Penny': GoogleFonts.hennyPenny,
        'Hepta Slab': GoogleFonts.heptaSlab,
        'Herr Von Muellerhoff': GoogleFonts.herrVonMuellerhoff,
        'Hi Melody': GoogleFonts.hiMelody,
        'Hina Mincho': GoogleFonts.hinaMincho,
        'Hind': GoogleFonts.hind,
        'Hind Guntur': GoogleFonts.hindGuntur,
        'Hind Madurai': GoogleFonts.hindMadurai,
        'Hind Siliguri': GoogleFonts.hindSiliguri,
        'Hind Vadodara': GoogleFonts.hindVadodara,
        'Holtwood One SC': GoogleFonts.holtwoodOneSc,
        'Homemade Apple': GoogleFonts.homemadeApple,
        'Homenaje': GoogleFonts.homenaje,
        'Hurricane': GoogleFonts.hurricane,
        'IBM Plex Mono': GoogleFonts.ibmPlexMono,
        'IBM Plex Sans': GoogleFonts.ibmPlexSans,
        'IBM Plex Sans Arabic': GoogleFonts.ibmPlexSansArabic,
        'IBM Plex Sans Condensed': GoogleFonts.ibmPlexSansCondensed,
        'IBM Plex Sans Devanagari': GoogleFonts.ibmPlexSansDevanagari,
        'IBM Plex Sans Hebrew': GoogleFonts.ibmPlexSansHebrew,
        'IBM Plex Sans KR': GoogleFonts.ibmPlexSansKr,
        'IBM Plex Sans Thai': GoogleFonts.ibmPlexSansThai,
        'IBM Plex Sans Thai Looped': GoogleFonts.ibmPlexSansThaiLooped,
        'IBM Plex Serif': GoogleFonts.ibmPlexSerif,
        'IM Fell DW Pica': GoogleFonts.imFellDwPica,
        'IM Fell DW Pica SC': GoogleFonts.imFellDwPicaSc,
        'IM Fell Double Pica': GoogleFonts.imFellDoublePica,
        'IM Fell Double Pica SC': GoogleFonts.imFellDoublePicaSc,
        'IM Fell English': GoogleFonts.imFellEnglish,
        'IM Fell English SC': GoogleFonts.imFellEnglishSc,
        'IM Fell French Canon': GoogleFonts.imFellFrenchCanon,
        'IM Fell French Canon SC': GoogleFonts.imFellFrenchCanonSc,
        'IM Fell Great Primer': GoogleFonts.imFellGreatPrimer,
        'IM Fell Great Primer SC': GoogleFonts.imFellGreatPrimerSc,
        'Ibarra Real Nova': GoogleFonts.ibarraRealNova,
        'Iceberg': GoogleFonts.iceberg,
        'Iceland': GoogleFonts.iceland,
        'Imprima': GoogleFonts.imprima,
        'Inconsolata': GoogleFonts.inconsolata,
        'Inder': GoogleFonts.inder,
        'Indie Flower': GoogleFonts.indieFlower,
        'Inika': GoogleFonts.inika,
        'Inknut Antiqua': GoogleFonts.inknutAntiqua,
        'Inria Sans': GoogleFonts.inriaSans,
        'Inria Serif': GoogleFonts.inriaSerif,
        'Inter': GoogleFonts.inter,
        'Irish Grover': GoogleFonts.irishGrover,
        'Istok Web': GoogleFonts.istokWeb,
        'Italiana': GoogleFonts.italiana,
        'Italianno': GoogleFonts.italianno,
        'Itim': GoogleFonts.itim,
        'Jacques Francois': GoogleFonts.jacquesFrancois,
        'Jacques Francois Shadow': GoogleFonts.jacquesFrancoisShadow,
        'Jaldi': GoogleFonts.jaldi,
        'JetBrains Mono': GoogleFonts.jetBrainsMono,
        'Jim Nightshade': GoogleFonts.jimNightshade,
        'Jockey One': GoogleFonts.jockeyOne,
        'Jolly Lodger': GoogleFonts.jollyLodger,
        'Jomhuria': GoogleFonts.jomhuria,
        'Jomolhari': GoogleFonts.jomolhari,
        'Josefin Sans': GoogleFonts.josefinSans,
        'Josefin Slab': GoogleFonts.josefinSlab,
        'Jost': GoogleFonts.jost,
        'Joti One': GoogleFonts.jotiOne,
        'Jua': GoogleFonts.jua,
        'Judson': GoogleFonts.judson,
        'Julee': GoogleFonts.julee,
        'Julius Sans One': GoogleFonts.juliusSansOne,
        'Junge': GoogleFonts.junge,
        'Jura': GoogleFonts.jura,
        'Just Another Hand': GoogleFonts.justAnotherHand,
        'Just Me Again Down Here': GoogleFonts.justMeAgainDownHere,
        'K2D': GoogleFonts.k2d,
        'Kadwa': GoogleFonts.kadwa,
        'Kaisei Decol': GoogleFonts.kaiseiDecol,
        'Kaisei HarunoUmi': GoogleFonts.kaiseiHarunoUmi,
        'Kaisei Opti': GoogleFonts.kaiseiOpti,
        'Kaisei Tokumin': GoogleFonts.kaiseiTokumin,
        'Kalam': GoogleFonts.kalam,
        'Kameron': GoogleFonts.kameron,
        'Kanit': GoogleFonts.kanit,
        'Kantumruy': GoogleFonts.kantumruy,
        'Karla': GoogleFonts.karla,
        'Karma': GoogleFonts.karma,
        'Katibeh': GoogleFonts.katibeh,
        'Kaushan Script': GoogleFonts.kaushanScript,
        'Kavivanar': GoogleFonts.kavivanar,
        'Kavoon': GoogleFonts.kavoon,
        'Kdam Thmor': GoogleFonts.kdamThmor,
        'Keania One': GoogleFonts.keaniaOne,
        'Kelly Slab': GoogleFonts.kellySlab,
        'Kenia': GoogleFonts.kenia,
        'Khand': GoogleFonts.khand,
        'Khula': GoogleFonts.khula,
        'Kings': GoogleFonts.kings,
        'Kirang Haerang': GoogleFonts.kirangHaerang,
        'Kite One': GoogleFonts.kiteOne,
        'Klee One': GoogleFonts.kleeOne,
        'Knewave': GoogleFonts.knewave,
        'KoHo': GoogleFonts.koHo,
        'Kodchasan': GoogleFonts.kodchasan,
        'Koh Santepheap': GoogleFonts.kohSantepheap,
        'Kosugi': GoogleFonts.kosugi,
        'Kosugi Maru': GoogleFonts.kosugiMaru,
        'Kotta One': GoogleFonts.kottaOne,
        'Kranky': GoogleFonts.kranky,
        'Kreon': GoogleFonts.kreon,
        'Kristi': GoogleFonts.kristi,
        'Krona One': GoogleFonts.kronaOne,
        'Krub': GoogleFonts.krub,
        'Kufam': GoogleFonts.kufam,
        'Kulim Park': GoogleFonts.kulimPark,
        'Kumar One': GoogleFonts.kumarOne,
        'Kumar One Outline': GoogleFonts.kumarOneOutline,
        'Kumbh Sans': GoogleFonts.kumbhSans,
        'Kurale': GoogleFonts.kurale,
        'La Belle Aurore': GoogleFonts.laBelleAurore,
        'Lacquer': GoogleFonts.lacquer,
        'Laila': GoogleFonts.laila,
        'Lakki Reddy': GoogleFonts.lakkiReddy,
        'Lalezar': GoogleFonts.lalezar,
        'Lancelot': GoogleFonts.lancelot,
        'Langar': GoogleFonts.langar,
        'Lateef': GoogleFonts.lateef,
        'Lato': GoogleFonts.lato,
        'League Script': GoogleFonts.leagueScript,
        'Leckerli One': GoogleFonts.leckerliOne,
        'Ledger': GoogleFonts.ledger,
        'Lekton': GoogleFonts.lekton,
        'Lemon': GoogleFonts.lemon,
        'Lemonada': GoogleFonts.lemonada,
        'Lexend': GoogleFonts.lexend,
        'Lexend Deca': GoogleFonts.lexendDeca,
        'Lexend Exa': GoogleFonts.lexendExa,
        'Lexend Giga': GoogleFonts.lexendGiga,
        'Lexend Mega': GoogleFonts.lexendMega,
        'Lexend Peta': GoogleFonts.lexendPeta,
        'Lexend Tera': GoogleFonts.lexendTera,
        'Lexend Zetta': GoogleFonts.lexendZetta,
        'Libre Barcode 128': GoogleFonts.libreBarcode128,
        'Libre Barcode 128 Text': GoogleFonts.libreBarcode128Text,
        'Libre Barcode 39': GoogleFonts.libreBarcode39,
        'Libre Barcode 39 Extended': GoogleFonts.libreBarcode39Extended,
        'Libre Barcode 39 Extended Text':
            GoogleFonts.libreBarcode39ExtendedText,
        'Libre Barcode 39 Text': GoogleFonts.libreBarcode39Text,
        'Libre Baskerville': GoogleFonts.libreBaskerville,
        'Libre Caslon Display': GoogleFonts.libreCaslonDisplay,
        'Libre Caslon Text': GoogleFonts.libreCaslonText,
        'Libre Franklin': GoogleFonts.libreFranklin,
        'Life Savers': GoogleFonts.lifeSavers,
        'Lilita One': GoogleFonts.lilitaOne,
        'Lily Script One': GoogleFonts.lilyScriptOne,
        'Limelight': GoogleFonts.limelight,
        'Linden Hill': GoogleFonts.lindenHill,
        'Literata': GoogleFonts.literata,
        'Liu Jian Mao Cao': GoogleFonts.liuJianMaoCao,
        'Livvic': GoogleFonts.livvic,
        'Lobster': GoogleFonts.lobster,
        'Lobster Two': GoogleFonts.lobsterTwo,
        'Londrina Outline': GoogleFonts.londrinaOutline,
        'Londrina Shadow': GoogleFonts.londrinaShadow,
        'Londrina Sketch': GoogleFonts.londrinaSketch,
        'Londrina Solid': GoogleFonts.londrinaSolid,
        'Long Cang': GoogleFonts.longCang,
        'Lora': GoogleFonts.lora,
        'Love Ya Like A Sister': GoogleFonts.loveYaLikeASister,
        'Loved by the King': GoogleFonts.lovedByTheKing,
        'Lovers Quarrel': GoogleFonts.loversQuarrel,
        'Luckiest Guy': GoogleFonts.luckiestGuy,
        'Lusitana': GoogleFonts.lusitana,
        'Lustria': GoogleFonts.lustria,
        'Luxurious Script': GoogleFonts.luxuriousScript,
        'M PLUS 1': GoogleFonts.mPlus1,
        'M PLUS 1 Code': GoogleFonts.mPlus1Code,
        'M PLUS 1p': GoogleFonts.mPlus1p,
        'M PLUS 2': GoogleFonts.mPlus2,
        'M PLUS Code Latin': GoogleFonts.mPlusCodeLatin,
        'M PLUS Rounded 1c': GoogleFonts.mPlusRounded1c,
        'Ma Shan Zheng': GoogleFonts.maShanZheng,
        'Macondo': GoogleFonts.macondo,
        'Macondo Swash Caps': GoogleFonts.macondoSwashCaps,
        'Mada': GoogleFonts.mada,
        'Magra': GoogleFonts.magra,
        'Maiden Orange': GoogleFonts.maidenOrange,
        'Maitree': GoogleFonts.maitree,
        'Major Mono Display': GoogleFonts.majorMonoDisplay,
        'Mako': GoogleFonts.mako,
        'Mali': GoogleFonts.mali,
        'Mallanna': GoogleFonts.mallanna,
        'Mandali': GoogleFonts.mandali,
        'Manjari': GoogleFonts.manjari,
        'Manrope': GoogleFonts.manrope,
        'Mansalva': GoogleFonts.mansalva,
        'Manuale': GoogleFonts.manuale,
        'Marcellus': GoogleFonts.marcellus,
        'Marcellus SC': GoogleFonts.marcellusSc,
        'Marck Script': GoogleFonts.marckScript,
        'Margarine': GoogleFonts.margarine,
        'Markazi Text': GoogleFonts.markaziText,
        'Marko One': GoogleFonts.markoOne,
        'Marmelad': GoogleFonts.marmelad,
        'Martel': GoogleFonts.martel,
        'Martel Sans': GoogleFonts.martelSans,
        'Marvel': GoogleFonts.marvel,
        'Mate': GoogleFonts.mate,
        'Mate SC': GoogleFonts.mateSc,
        'Maven Pro': GoogleFonts.mavenPro,
        'McLaren': GoogleFonts.mcLaren,
        'Meddon': GoogleFonts.meddon,
        'MedievalSharp': GoogleFonts.medievalSharp,
        'Medula One': GoogleFonts.medulaOne,
        'Meera Inimai': GoogleFonts.meeraInimai,
        'Megrim': GoogleFonts.megrim,
        'Meie Script': GoogleFonts.meieScript,
        'Meow Script': GoogleFonts.meowScript,
        'Merienda': GoogleFonts.merienda,
        'Merienda One': GoogleFonts.meriendaOne,
        'Merriweather': GoogleFonts.merriweather,
        'Merriweather Sans': GoogleFonts.merriweatherSans,
        'Metal Mania': GoogleFonts.metalMania,
        'Metamorphous': GoogleFonts.metamorphous,
        'Metrophobic': GoogleFonts.metrophobic,
        'Michroma': GoogleFonts.michroma,
        'Milonga': GoogleFonts.milonga,
        'Miltonian': GoogleFonts.miltonian,
        'Miltonian Tattoo': GoogleFonts.miltonianTattoo,
        'Mina': GoogleFonts.mina,
        'Miniver': GoogleFonts.miniver,
        'Miriam Libre': GoogleFonts.miriamLibre,
        'Mirza': GoogleFonts.mirza,
        'Miss Fajardose': GoogleFonts.missFajardose,
        'Mitr': GoogleFonts.mitr,
        'Mochiy Pop One': GoogleFonts.mochiyPopOne,
        'Mochiy Pop P One': GoogleFonts.mochiyPopPOne,
        'Modak': GoogleFonts.modak,
        'Modern Antiqua': GoogleFonts.modernAntiqua,
        'Mogra': GoogleFonts.mogra,
        'Mohave': GoogleFonts.mohave,
        'Molengo': GoogleFonts.molengo,
        'Molle': GoogleFonts.molle,
        'Monda': GoogleFonts.monda,
        'Monofett': GoogleFonts.monofett,
        'Monoton': GoogleFonts.monoton,
        'Monsieur La Doulaise': GoogleFonts.monsieurLaDoulaise,
        'Montaga': GoogleFonts.montaga,
        'Montagu Slab': GoogleFonts.montaguSlab,
        'MonteCarlo': GoogleFonts.monteCarlo,
        'Montez': GoogleFonts.montez,
        'Montserrat': GoogleFonts.montserrat,
        'Montserrat Alternates': GoogleFonts.montserratAlternates,
        'Montserrat Subrayada': GoogleFonts.montserratSubrayada,
        'Mountains of Christmas': GoogleFonts.mountainsOfChristmas,
        'Mouse Memoirs': GoogleFonts.mouseMemoirs,
        'Mr Bedfort': GoogleFonts.mrBedfort,
        'Mr Dafoe': GoogleFonts.mrDafoe,
        'Mr De Haviland': GoogleFonts.mrDeHaviland,
        'Mrs Saint Delafield': GoogleFonts.mrsSaintDelafield,
        'Mrs Sheppards': GoogleFonts.mrsSheppards,
        'Mukta': GoogleFonts.mukta,
        'Mukta Mahee': GoogleFonts.muktaMahee,
        'Mukta Malar': GoogleFonts.muktaMalar,
        'Mukta Vaani': GoogleFonts.muktaVaani,
        'Muli': GoogleFonts.muli,
        'Mulish': GoogleFonts.mulish,
        'Murecho': GoogleFonts.murecho,
        'MuseoModerno': GoogleFonts.museoModerno,
        'Mystery Quest': GoogleFonts.mysteryQuest,
        'NTR': GoogleFonts.ntr,
        'Nanum Brush Script': GoogleFonts.nanumBrushScript,
        'Nanum Gothic': GoogleFonts.nanumGothic,
        'Nanum Gothic Coding': GoogleFonts.nanumGothicCoding,
        'Nanum Myeongjo': GoogleFonts.nanumMyeongjo,
        'Nanum Pen Script': GoogleFonts.nanumPenScript,
        'Nerko One': GoogleFonts.nerkoOne,
        'Neucha': GoogleFonts.neucha,
        'Neuton': GoogleFonts.neuton,
        'New Rocker': GoogleFonts.newRocker,
        'New Tegomin': GoogleFonts.newTegomin,
        'News Cycle': GoogleFonts.newsCycle,
        'Niconne': GoogleFonts.niconne,
        'Niramit': GoogleFonts.niramit,
        'Nixie One': GoogleFonts.nixieOne,
        'Nobile': GoogleFonts.nobile,
        'Norican': GoogleFonts.norican,
        'Nosifer': GoogleFonts.nosifer,
        'Notable': GoogleFonts.notable,
        'Nothing You Could Do': GoogleFonts.nothingYouCouldDo,
        'Noticia Text': GoogleFonts.noticiaText,
        'Noto Color Emoji Compat': GoogleFonts.notoColorEmojiCompat,
        'Noto Kufi Arabic': GoogleFonts.notoKufiArabic,
        'Noto Music': GoogleFonts.notoMusic,
        'Noto Naskh Arabic': GoogleFonts.notoNaskhArabic,
        'Noto Nastaliq Urdu': GoogleFonts.notoNastaliqUrdu,
        'Noto Rashi Hebrew': GoogleFonts.notoRashiHebrew,
        'Noto Sans': GoogleFonts.notoSans,
        'Noto Sans Adlam': GoogleFonts.notoSansAdlam,
        'Noto Sans Adlam Unjoined': GoogleFonts.notoSansAdlamUnjoined,
        'Noto Sans Anatolian Hieroglyphs':
            GoogleFonts.notoSansAnatolianHieroglyphs,
        'Noto Sans Arabic': GoogleFonts.notoSansArabic,
        'Noto Sans Armenian': GoogleFonts.notoSansArmenian,
        'Noto Sans Avestan': GoogleFonts.notoSansAvestan,
        'Noto Sans Balinese': GoogleFonts.notoSansBalinese,
        'Noto Sans Bamum': GoogleFonts.notoSansBamum,
        'Noto Sans Bassa Vah': GoogleFonts.notoSansBassaVah,
        'Noto Sans Batak': GoogleFonts.notoSansBatak,
        'Noto Sans Bengali': GoogleFonts.notoSansBengali,
        'Noto Sans Bhaiksuki': GoogleFonts.notoSansBhaiksuki,
        'Noto Sans Brahmi': GoogleFonts.notoSansBrahmi,
        'Noto Sans Buginese': GoogleFonts.notoSansBuginese,
        'Noto Sans Buhid': GoogleFonts.notoSansBuhid,
        'Noto Sans Canadian Aboriginal': GoogleFonts.notoSansCanadianAboriginal,
        'Noto Sans Carian': GoogleFonts.notoSansCarian,
        'Noto Sans Caucasian Albanian': GoogleFonts.notoSansCaucasianAlbanian,
        'Noto Sans Chakma': GoogleFonts.notoSansChakma,
        'Noto Sans Cham': GoogleFonts.notoSansCham,
        'Noto Sans Cherokee': GoogleFonts.notoSansCherokee,
        'Noto Sans Coptic': GoogleFonts.notoSansCoptic,
        'Noto Sans Cuneiform': GoogleFonts.notoSansCuneiform,
        'Noto Sans Cypriot': GoogleFonts.notoSansCypriot,
        'Noto Sans Deseret': GoogleFonts.notoSansDeseret,
        'Noto Sans Devanagari': GoogleFonts.notoSansDevanagari,
        'Noto Sans Display': GoogleFonts.notoSansDisplay,
        'Noto Sans Duployan': GoogleFonts.notoSansDuployan,
        'Noto Sans Egyptian Hieroglyphs':
            GoogleFonts.notoSansEgyptianHieroglyphs,
        'Noto Sans Elbasan': GoogleFonts.notoSansElbasan,
        'Noto Sans Elymaic': GoogleFonts.notoSansElymaic,
        'Noto Sans Georgian': GoogleFonts.notoSansGeorgian,
        'Noto Sans Glagolitic': GoogleFonts.notoSansGlagolitic,
        'Noto Sans Gothic': GoogleFonts.notoSansGothic,
        'Noto Sans Grantha': GoogleFonts.notoSansGrantha,
        'Noto Sans Gujarati': GoogleFonts.notoSansGujarati,
        'Noto Sans Gunjala Gondi': GoogleFonts.notoSansGunjalaGondi,
        'Noto Sans Gurmukhi': GoogleFonts.notoSansGurmukhi,
        'Noto Sans Hanifi Rohingya': GoogleFonts.notoSansHanifiRohingya,
        'Noto Sans Hanunoo': GoogleFonts.notoSansHanunoo,
        'Noto Sans Hatran': GoogleFonts.notoSansHatran,
        'Noto Sans Hebrew': GoogleFonts.notoSansHebrew,
        'Noto Sans Imperial Aramaic': GoogleFonts.notoSansImperialAramaic,
        'Noto Sans Indic Siyaq Numbers': GoogleFonts.notoSansIndicSiyaqNumbers,
        'Noto Sans Inscriptional Pahlavi':
            GoogleFonts.notoSansInscriptionalPahlavi,
        'Noto Sans Inscriptional Parthian':
            GoogleFonts.notoSansInscriptionalParthian,
        'Noto Sans Javanese': GoogleFonts.notoSansJavanese,
        'Noto Sans Kaithi': GoogleFonts.notoSansKaithi,
        'Noto Sans Kannada': GoogleFonts.notoSansKannada,
        'Noto Sans Kayah Li': GoogleFonts.notoSansKayahLi,
        'Noto Sans Kharoshthi': GoogleFonts.notoSansKharoshthi,
        'Noto Sans Khmer': GoogleFonts.notoSansKhmer,
        'Noto Sans Khojki': GoogleFonts.notoSansKhojki,
        'Noto Sans Khudawadi': GoogleFonts.notoSansKhudawadi,
        'Noto Sans Lao': GoogleFonts.notoSansLao,
        'Noto Sans Lepcha': GoogleFonts.notoSansLepcha,
        'Noto Sans Limbu': GoogleFonts.notoSansLimbu,
        'Noto Sans Linear A': GoogleFonts.notoSansLinearA,
        'Noto Sans Linear B': GoogleFonts.notoSansLinearB,
        'Noto Sans Lisu': GoogleFonts.notoSansLisu,
        'Noto Sans Lycian': GoogleFonts.notoSansLycian,
        'Noto Sans Lydian': GoogleFonts.notoSansLydian,
        'Noto Sans Mahajani': GoogleFonts.notoSansMahajani,
        'Noto Sans Malayalam': GoogleFonts.notoSansMalayalam,
        'Noto Sans Mandaic': GoogleFonts.notoSansMandaic,
        'Noto Sans Manichaean': GoogleFonts.notoSansManichaean,
        'Noto Sans Marchen': GoogleFonts.notoSansMarchen,
        'Noto Sans Masaram Gondi': GoogleFonts.notoSansMasaramGondi,
        'Noto Sans Math': GoogleFonts.notoSansMath,
        'Noto Sans Mayan Numerals': GoogleFonts.notoSansMayanNumerals,
        'Noto Sans Medefaidrin': GoogleFonts.notoSansMedefaidrin,
        'Noto Sans Meetei Mayek': GoogleFonts.notoSansMeeteiMayek,
        'Noto Sans Meroitic': GoogleFonts.notoSansMeroitic,
        'Noto Sans Miao': GoogleFonts.notoSansMiao,
        'Noto Sans Modi': GoogleFonts.notoSansModi,
        'Noto Sans Mongolian': GoogleFonts.notoSansMongolian,
        'Noto Sans Mono': GoogleFonts.notoSansMono,
        'Noto Sans Mro': GoogleFonts.notoSansMro,
        'Noto Sans Multani': GoogleFonts.notoSansMultani,
        'Noto Sans Myanmar': GoogleFonts.notoSansMyanmar,
        'Noto Sans N Ko': GoogleFonts.notoSansNKo,
        'Noto Sans Nabataean': GoogleFonts.notoSansNabataean,
        'Noto Sans New Tai Lue': GoogleFonts.notoSansNewTaiLue,
        'Noto Sans Newa': GoogleFonts.notoSansNewa,
        'Noto Sans Nushu': GoogleFonts.notoSansNushu,
        'Noto Sans Ogham': GoogleFonts.notoSansOgham,
        'Noto Sans Ol Chiki': GoogleFonts.notoSansOlChiki,
        'Noto Sans Old Hungarian': GoogleFonts.notoSansOldHungarian,
        'Noto Sans Old Italic': GoogleFonts.notoSansOldItalic,
        'Noto Sans Old North Arabian': GoogleFonts.notoSansOldNorthArabian,
        'Noto Sans Old Permic': GoogleFonts.notoSansOldPermic,
        'Noto Sans Old Persian': GoogleFonts.notoSansOldPersian,
        'Noto Sans Old Sogdian': GoogleFonts.notoSansOldSogdian,
        'Noto Sans Old South Arabian': GoogleFonts.notoSansOldSouthArabian,
        'Noto Sans Old Turkic': GoogleFonts.notoSansOldTurkic,
        'Noto Sans Oriya': GoogleFonts.notoSansOriya,
        'Noto Sans Osage': GoogleFonts.notoSansOsage,
        'Noto Sans Osmanya': GoogleFonts.notoSansOsmanya,
        'Noto Sans Pahawh Hmong': GoogleFonts.notoSansPahawhHmong,
        'Noto Sans Palmyrene': GoogleFonts.notoSansPalmyrene,
        'Noto Sans Pau Cin Hau': GoogleFonts.notoSansPauCinHau,
        'Noto Sans Phags Pa': GoogleFonts.notoSansPhagsPa,
        'Noto Sans Phoenician': GoogleFonts.notoSansPhoenician,
        'Noto Sans Psalter Pahlavi': GoogleFonts.notoSansPsalterPahlavi,
        'Noto Sans Rejang': GoogleFonts.notoSansRejang,
        'Noto Sans Runic': GoogleFonts.notoSansRunic,
        'Noto Sans Samaritan': GoogleFonts.notoSansSamaritan,
        'Noto Sans Saurashtra': GoogleFonts.notoSansSaurashtra,
        'Noto Sans Sharada': GoogleFonts.notoSansSharada,
        'Noto Sans Shavian': GoogleFonts.notoSansShavian,
        'Noto Sans Siddham': GoogleFonts.notoSansSiddham,
        'Noto Sans Sinhala': GoogleFonts.notoSansSinhala,
        'Noto Sans Sogdian': GoogleFonts.notoSansSogdian,
        'Noto Sans Sora Sompeng': GoogleFonts.notoSansSoraSompeng,
        'Noto Sans Soyombo': GoogleFonts.notoSansSoyombo,
        'Noto Sans Sundanese': GoogleFonts.notoSansSundanese,
        'Noto Sans Syloti Nagri': GoogleFonts.notoSansSylotiNagri,
        'Noto Sans Symbols': GoogleFonts.notoSansSymbols,
        'Noto Sans Symbols 2': GoogleFonts.notoSansSymbols2,
        'Noto Sans Syriac': GoogleFonts.notoSansSyriac,
        'Noto Sans Tagalog': GoogleFonts.notoSansTagalog,
        'Noto Sans Tagbanwa': GoogleFonts.notoSansTagbanwa,
        'Noto Sans Tai Le': GoogleFonts.notoSansTaiLe,
        'Noto Sans Tai Tham': GoogleFonts.notoSansTaiTham,
        'Noto Sans Tai Viet': GoogleFonts.notoSansTaiViet,
        'Noto Sans Takri': GoogleFonts.notoSansTakri,
        'Noto Sans Tamil': GoogleFonts.notoSansTamil,
        'Noto Sans Tamil Supplement': GoogleFonts.notoSansTamilSupplement,
        'Noto Sans Telugu': GoogleFonts.notoSansTelugu,
        'Noto Sans Thaana': GoogleFonts.notoSansThaana,
        'Noto Sans Thai': GoogleFonts.notoSansThai,
        'Noto Sans Thai Looped': GoogleFonts.notoSansThaiLooped,
        'Noto Sans Tifinagh': GoogleFonts.notoSansTifinagh,
        'Noto Sans Tirhuta': GoogleFonts.notoSansTirhuta,
        'Noto Sans Ugaritic': GoogleFonts.notoSansUgaritic,
        'Noto Sans Vai': GoogleFonts.notoSansVai,
        'Noto Sans Wancho': GoogleFonts.notoSansWancho,
        'Noto Sans Warang Citi': GoogleFonts.notoSansWarangCiti,
        'Noto Sans Yi': GoogleFonts.notoSansYi,
        'Noto Sans Zanabazar Square': GoogleFonts.notoSansZanabazarSquare,
        'Noto Serif': GoogleFonts.notoSerif,
        'Noto Serif Ahom': GoogleFonts.notoSerifAhom,
        'Noto Serif Armenian': GoogleFonts.notoSerifArmenian,
        'Noto Serif Balinese': GoogleFonts.notoSerifBalinese,
        'Noto Serif Bengali': GoogleFonts.notoSerifBengali,
        'Noto Serif Devanagari': GoogleFonts.notoSerifDevanagari,
        'Noto Serif Display': GoogleFonts.notoSerifDisplay,
        'Noto Serif Dogra': GoogleFonts.notoSerifDogra,
        'Noto Serif Ethiopic': GoogleFonts.notoSerifEthiopic,
        'Noto Serif Georgian': GoogleFonts.notoSerifGeorgian,
        'Noto Serif Grantha': GoogleFonts.notoSerifGrantha,
        'Noto Serif Gujarati': GoogleFonts.notoSerifGujarati,
        'Noto Serif Gurmukhi': GoogleFonts.notoSerifGurmukhi,
        'Noto Serif Hebrew': GoogleFonts.notoSerifHebrew,
        'Noto Serif Kannada': GoogleFonts.notoSerifKannada,
        'Noto Serif Khmer': GoogleFonts.notoSerifKhmer,
        'Noto Serif Lao': GoogleFonts.notoSerifLao,
        'Noto Serif Malayalam': GoogleFonts.notoSerifMalayalam,
        'Noto Serif Myanmar': GoogleFonts.notoSerifMyanmar,
        'Noto Serif Nyiakeng Puachue Hmong':
            GoogleFonts.notoSerifNyiakengPuachueHmong,
        'Noto Serif Sinhala': GoogleFonts.notoSerifSinhala,
        'Noto Serif Tamil': GoogleFonts.notoSerifTamil,
        'Noto Serif Tangut': GoogleFonts.notoSerifTangut,
        'Noto Serif Telugu': GoogleFonts.notoSerifTelugu,
        'Noto Serif Thai': GoogleFonts.notoSerifThai,
        'Noto Serif Tibetan': GoogleFonts.notoSerifTibetan,
        'Noto Serif Yezidi': GoogleFonts.notoSerifYezidi,
        'Noto Traditional Nushu': GoogleFonts.notoTraditionalNushu,
        'Nova Cut': GoogleFonts.novaCut,
        'Nova Flat': GoogleFonts.novaFlat,
        'Nova Mono': GoogleFonts.novaMono,
        'Nova Oval': GoogleFonts.novaOval,
        'Nova Round': GoogleFonts.novaRound,
        'Nova Script': GoogleFonts.novaScript,
        'Nova Slim': GoogleFonts.novaSlim,
        'Nova Square': GoogleFonts.novaSquare,
        'Numans': GoogleFonts.numans,
        'Nunito': GoogleFonts.nunito,
        'Nunito Sans': GoogleFonts.nunitoSans,
        'Odibee Sans': GoogleFonts.odibeeSans,
        'Odor Mean Chey': GoogleFonts.odorMeanChey,
        'Offside': GoogleFonts.offside,
        'Oi': GoogleFonts.oi,
        'Old Standard TT': GoogleFonts.oldStandardTt,
        'Oldenburg': GoogleFonts.oldenburg,
        'Oleo Script': GoogleFonts.oleoScript,
        'Oleo Script Swash Caps': GoogleFonts.oleoScriptSwashCaps,
        'Open Sans': GoogleFonts.openSans,
        'Open Sans Condensed': GoogleFonts.openSansCondensed,
        'Oranienbaum': GoogleFonts.oranienbaum,
        'Orbitron': GoogleFonts.orbitron,
        'Oregano': GoogleFonts.oregano,
        'Orienta': GoogleFonts.orienta,
        'Original Surfer': GoogleFonts.originalSurfer,
        'Oswald': GoogleFonts.oswald,
        'Otomanopee One': GoogleFonts.otomanopeeOne,
        'Outfit': GoogleFonts.outfit,
        'Over the Rainbow': GoogleFonts.overTheRainbow,
        'Overlock': GoogleFonts.overlock,
        'Overlock SC': GoogleFonts.overlockSc,
        'Overpass': GoogleFonts.overpass,
        'Overpass Mono': GoogleFonts.overpassMono,
        'Ovo': GoogleFonts.ovo,
        'Oxanium': GoogleFonts.oxanium,
        'Oxygen': GoogleFonts.oxygen,
        'Oxygen Mono': GoogleFonts.oxygenMono,
        'PT Mono': GoogleFonts.ptMono,
        'PT Sans': GoogleFonts.ptSans,
        'PT Sans Caption': GoogleFonts.ptSansCaption,
        'PT Sans Narrow': GoogleFonts.ptSansNarrow,
        'PT Serif': GoogleFonts.ptSerif,
        'PT Serif Caption': GoogleFonts.ptSerifCaption,
        'Pacifico': GoogleFonts.pacifico,
        'Padauk': GoogleFonts.padauk,
        'Palanquin': GoogleFonts.palanquin,
        'Palanquin Dark': GoogleFonts.palanquinDark,
        'Palette Mosaic': GoogleFonts.paletteMosaic,
        'Pangolin': GoogleFonts.pangolin,
        'Paprika': GoogleFonts.paprika,
        'Parisienne': GoogleFonts.parisienne,
        'Passero One': GoogleFonts.passeroOne,
        'Passion One': GoogleFonts.passionOne,
        'Passions Conflict': GoogleFonts.passionsConflict,
        'Pathway Gothic One': GoogleFonts.pathwayGothicOne,
        'Patrick Hand': GoogleFonts.patrickHand,
        'Patrick Hand SC': GoogleFonts.patrickHandSc,
        'Pattaya': GoogleFonts.pattaya,
        'Patua One': GoogleFonts.patuaOne,
        'Pavanam': GoogleFonts.pavanam,
        'Paytone One': GoogleFonts.paytoneOne,
        'Peddana': GoogleFonts.peddana,
        'Peralta': GoogleFonts.peralta,
        'Permanent Marker': GoogleFonts.permanentMarker,
        'Petemoss': GoogleFonts.petemoss,
        'Petit Formal Script': GoogleFonts.petitFormalScript,
        'Petrona': GoogleFonts.petrona,
        'Philosopher': GoogleFonts.philosopher,
        'Piazzolla': GoogleFonts.piazzolla,
        'Piedra': GoogleFonts.piedra,
        'Pinyon Script': GoogleFonts.pinyonScript,
        'Pirata One': GoogleFonts.pirataOne,
        'Plaster': GoogleFonts.plaster,
        'Play': GoogleFonts.play,
        'Playball': GoogleFonts.playball,
        'Playfair Display': GoogleFonts.playfairDisplay,
        'Playfair Display SC': GoogleFonts.playfairDisplaySc,
        'Podkova': GoogleFonts.podkova,
        'Poiret One': GoogleFonts.poiretOne,
        'Poller One': GoogleFonts.pollerOne,
        'Poly': GoogleFonts.poly,
        'Pompiere': GoogleFonts.pompiere,
        'Pontano Sans': GoogleFonts.pontanoSans,
        'Poor Story': GoogleFonts.poorStory,
        'Poppins': GoogleFonts.poppins,
        'Port Lligat Sans': GoogleFonts.portLligatSans,
        'Port Lligat Slab': GoogleFonts.portLligatSlab,
        'Potta One': GoogleFonts.pottaOne,
        'Pragati Narrow': GoogleFonts.pragatiNarrow,
        'Praise': GoogleFonts.praise,
        'Prata': GoogleFonts.prata,
        'Press Start 2P': GoogleFonts.pressStart2p,
        'Pridi': GoogleFonts.pridi,
        'Princess Sofia': GoogleFonts.princessSofia,
        'Prociono': GoogleFonts.prociono,
        'Prompt': GoogleFonts.prompt,
        'Prosto One': GoogleFonts.prostoOne,
        'Proza Libre': GoogleFonts.prozaLibre,
        'Public Sans': GoogleFonts.publicSans,
        'Puppies Play': GoogleFonts.puppiesPlay,
        'Puritan': GoogleFonts.puritan,
        'Purple Purse': GoogleFonts.purplePurse,
        'Pushster': GoogleFonts.pushster,
        'Qahiri': GoogleFonts.qahiri,
        'Quando': GoogleFonts.quando,
        'Quantico': GoogleFonts.quantico,
        'Quattrocento': GoogleFonts.quattrocento,
        'Quattrocento Sans': GoogleFonts.quattrocentoSans,
        'Questrial': GoogleFonts.questrial,
        'Quicksand': GoogleFonts.quicksand,
        'Quintessential': GoogleFonts.quintessential,
        'Qwigley': GoogleFonts.qwigley,
        'Racing Sans One': GoogleFonts.racingSansOne,
        'Radley': GoogleFonts.radley,
        'Rajdhani': GoogleFonts.rajdhani,
        'Rakkas': GoogleFonts.rakkas,
        'Raleway': GoogleFonts.raleway,
        'Raleway Dots': GoogleFonts.ralewayDots,
        'Ramabhadra': GoogleFonts.ramabhadra,
        'Ramaraja': GoogleFonts.ramaraja,
        'Rambla': GoogleFonts.rambla,
        'Rammetto One': GoogleFonts.rammettoOne,
        'Rampart One': GoogleFonts.rampartOne,
        'Ranchers': GoogleFonts.ranchers,
        'Rancho': GoogleFonts.rancho,
        'Ranga': GoogleFonts.ranga,
        'Rasa': GoogleFonts.rasa,
        'Rationale': GoogleFonts.rationale,
        'Ravi Prakash': GoogleFonts.raviPrakash,
        'Readex Pro': GoogleFonts.readexPro,
        'Recursive': GoogleFonts.recursive,
        'Red Hat Display': GoogleFonts.redHatDisplay,
        'Red Hat Mono': GoogleFonts.redHatMono,
        'Red Hat Text': GoogleFonts.redHatText,
        'Red Rose': GoogleFonts.redRose,
        'Redacted': GoogleFonts.redacted,
        'Redacted Script': GoogleFonts.redactedScript,
        'Redressed': GoogleFonts.redressed,
        'Reem Kufi': GoogleFonts.reemKufi,
        'Reenie Beanie': GoogleFonts.reenieBeanie,
        'Reggae One': GoogleFonts.reggaeOne,
        'Revalia': GoogleFonts.revalia,
        'Rhodium Libre': GoogleFonts.rhodiumLibre,
        'Ribeye': GoogleFonts.ribeye,
        'Ribeye Marrow': GoogleFonts.ribeyeMarrow,
        'Righteous': GoogleFonts.righteous,
        'Risque': GoogleFonts.risque,
        'Road Rage': GoogleFonts.roadRage,
        'Roboto': GoogleFonts.roboto,
        'Roboto Condensed': GoogleFonts.robotoCondensed,
        'Roboto Mono': GoogleFonts.robotoMono,
        'Roboto Slab': GoogleFonts.robotoSlab,
        'Rochester': GoogleFonts.rochester,
        'Rock 3D': GoogleFonts.rock3d,
        'Rock Salt': GoogleFonts.rockSalt,
        'RocknRoll One': GoogleFonts.rocknRollOne,
        'Rokkitt': GoogleFonts.rokkitt,
        'Romanesco': GoogleFonts.romanesco,
        'Ropa Sans': GoogleFonts.ropaSans,
        'Rosario': GoogleFonts.rosario,
        'Rosarivo': GoogleFonts.rosarivo,
        'Rouge Script': GoogleFonts.rougeScript,
        'Rowdies': GoogleFonts.rowdies,
        'Rozha One': GoogleFonts.rozhaOne,
        'Rubik': GoogleFonts.rubik,
        'Rubik Beastly': GoogleFonts.rubikBeastly,
        'Rubik Mono One': GoogleFonts.rubikMonoOne,
        'Ruda': GoogleFonts.ruda,
        'Rufina': GoogleFonts.rufina,
        'Ruge Boogie': GoogleFonts.rugeBoogie,
        'Ruluko': GoogleFonts.ruluko,
        'Rum Raisin': GoogleFonts.rumRaisin,
        'Ruslan Display': GoogleFonts.ruslanDisplay,
        'Russo One': GoogleFonts.russoOne,
        'Ruthie': GoogleFonts.ruthie,
        'Rye': GoogleFonts.rye,
        'STIX Two Text': GoogleFonts.stixTwoText,
        'Sacramento': GoogleFonts.sacramento,
        'Sahitya': GoogleFonts.sahitya,
        'Sail': GoogleFonts.sail,
        'Saira': GoogleFonts.saira,
        'Saira Condensed': GoogleFonts.sairaCondensed,
        'Saira Extra Condensed': GoogleFonts.sairaExtraCondensed,
        'Saira Semi Condensed': GoogleFonts.sairaSemiCondensed,
        'Saira Stencil One': GoogleFonts.sairaStencilOne,
        'Salsa': GoogleFonts.salsa,
        'Sanchez': GoogleFonts.sanchez,
        'Sancreek': GoogleFonts.sancreek,
        'Sansita': GoogleFonts.sansita,
        'Sansita Swashed': GoogleFonts.sansitaSwashed,
        'Sarabun': GoogleFonts.sarabun,
        'Sarala': GoogleFonts.sarala,
        'Sarina': GoogleFonts.sarina,
        'Sarpanch': GoogleFonts.sarpanch,
        'Sassy Frass': GoogleFonts.sassyFrass,
        'Satisfy': GoogleFonts.satisfy,
        'Sawarabi Gothic': GoogleFonts.sawarabiGothic,
        'Sawarabi Mincho': GoogleFonts.sawarabiMincho,
        'Scada': GoogleFonts.scada,
        'Scheherazade': GoogleFonts.scheherazade,
        'Scheherazade New': GoogleFonts.scheherazadeNew,
        'Schoolbell': GoogleFonts.schoolbell,
        'Scope One': GoogleFonts.scopeOne,
        'Seaweed Script': GoogleFonts.seaweedScript,
        'Secular One': GoogleFonts.secularOne,
        'Sedgwick Ave': GoogleFonts.sedgwickAve,
        'Sedgwick Ave Display': GoogleFonts.sedgwickAveDisplay,
        'Sen': GoogleFonts.sen,
        'Sevillana': GoogleFonts.sevillana,
        'Seymour One': GoogleFonts.seymourOne,
        'Shadows Into Light': GoogleFonts.shadowsIntoLight,
        'Shadows Into Light Two': GoogleFonts.shadowsIntoLightTwo,
        'Shalimar': GoogleFonts.shalimar,
        'Shanti': GoogleFonts.shanti,
        'Share': GoogleFonts.share,
        'Share Tech': GoogleFonts.shareTech,
        'Share Tech Mono': GoogleFonts.shareTechMono,
        'Shippori Antique': GoogleFonts.shipporiAntique,
        'Shippori Antique B1': GoogleFonts.shipporiAntiqueB1,
        'Shippori Mincho': GoogleFonts.shipporiMincho,
        'Shippori Mincho B1': GoogleFonts.shipporiMinchoB1,
        'Shizuru': GoogleFonts.shizuru,
        'Shojumaru': GoogleFonts.shojumaru,
        'Short Stack': GoogleFonts.shortStack,
        'Shrikhand': GoogleFonts.shrikhand,
        'Sigmar One': GoogleFonts.sigmarOne,
        'Signika': GoogleFonts.signika,
        'Signika Negative': GoogleFonts.signikaNegative,
        'Simonetta': GoogleFonts.simonetta,
        'Single Day': GoogleFonts.singleDay,
        'Sintony': GoogleFonts.sintony,
        'Sirin Stencil': GoogleFonts.sirinStencil,
        'Six Caps': GoogleFonts.sixCaps,
        'Skranji': GoogleFonts.skranji,
        'Slabo 13px': GoogleFonts.slabo13px,
        'Slabo 27px': GoogleFonts.slabo27px,
        'Slackey': GoogleFonts.slackey,
        'Smokum': GoogleFonts.smokum,
        'Smooch': GoogleFonts.smooch,
        'Smythe': GoogleFonts.smythe,
        'Sniglet': GoogleFonts.sniglet,
        'Snippet': GoogleFonts.snippet,
        'Snowburst One': GoogleFonts.snowburstOne,
        'Sofadi One': GoogleFonts.sofadiOne,
        'Sofia': GoogleFonts.sofia,
        'Solway': GoogleFonts.solway,
        'Song Myung': GoogleFonts.songMyung,
        'Sonsie One': GoogleFonts.sonsieOne,
        'Sora': GoogleFonts.sora,
        'Sorts Mill Goudy': GoogleFonts.sortsMillGoudy,
        'Source Code Pro': GoogleFonts.sourceCodePro,
        'Source Sans 3': GoogleFonts.sourceSans3,
        'Source Sans Pro': GoogleFonts.sourceSansPro,
        'Source Serif Pro': GoogleFonts.sourceSerifPro,
        'Space Grotesk': GoogleFonts.spaceGrotesk,
        'Space Mono': GoogleFonts.spaceMono,
        'Spartan': GoogleFonts.spartan,
        'Special Elite': GoogleFonts.specialElite,
        'Spectral': GoogleFonts.spectral,
        'Spectral SC': GoogleFonts.spectralSc,
        'Spicy Rice': GoogleFonts.spicyRice,
        'Spinnaker': GoogleFonts.spinnaker,
        'Spirax': GoogleFonts.spirax,
        'Squada One': GoogleFonts.squadaOne,
        'Sree Krushnadevaraya': GoogleFonts.sreeKrushnadevaraya,
        'Sriracha': GoogleFonts.sriracha,
        'Srisakdi': GoogleFonts.srisakdi,
        'Staatliches': GoogleFonts.staatliches,
        'Stalemate': GoogleFonts.stalemate,
        'Stalinist One': GoogleFonts.stalinistOne,
        'Stardos Stencil': GoogleFonts.stardosStencil,
        'Stick': GoogleFonts.stick,
        'Stick No Bills': GoogleFonts.stickNoBills,
        'Stint Ultra Condensed': GoogleFonts.stintUltraCondensed,
        'Stint Ultra Expanded': GoogleFonts.stintUltraExpanded,
        'Stoke': GoogleFonts.stoke,
        'Strait': GoogleFonts.strait,
        'Style Script': GoogleFonts.styleScript,
        'Stylish': GoogleFonts.stylish,
        'Sue Ellen Francisco': GoogleFonts.sueEllenFrancisco,
        'Suez One': GoogleFonts.suezOne,
        'Sulphur Point': GoogleFonts.sulphurPoint,
        'Sumana': GoogleFonts.sumana,
        'Sunflower': GoogleFonts.sunflower,
        'Sunshiney': GoogleFonts.sunshiney,
        'Supermercado One': GoogleFonts.supermercadoOne,
        'Sura': GoogleFonts.sura,
        'Suranna': GoogleFonts.suranna,
        'Suravaram': GoogleFonts.suravaram,
        'Swanky and Moo Moo': GoogleFonts.swankyAndMooMoo,
        'Syncopate': GoogleFonts.syncopate,
        'Syne': GoogleFonts.syne,
        'Syne Mono': GoogleFonts.syneMono,
        'Syne Tactile': GoogleFonts.syneTactile,
        'Tajawal': GoogleFonts.tajawal,
        'Tangerine': GoogleFonts.tangerine,
        'Tauri': GoogleFonts.tauri,
        'Taviraj': GoogleFonts.taviraj,
        'Teko': GoogleFonts.teko,
        'Telex': GoogleFonts.telex,
        'Tenali Ramakrishna': GoogleFonts.tenaliRamakrishna,
        'Tenor Sans': GoogleFonts.tenorSans,
        'Text Me One': GoogleFonts.textMeOne,
        'Thasadith': GoogleFonts.thasadith,
        'The Girl Next Door': GoogleFonts.theGirlNextDoor,
        'Tienne': GoogleFonts.tienne,
        'Tillana': GoogleFonts.tillana,
        'Timmana': GoogleFonts.timmana,
        'Tinos': GoogleFonts.tinos,
        'Titan One': GoogleFonts.titanOne,
        'Titillium Web': GoogleFonts.titilliumWeb,
        'Tomorrow': GoogleFonts.tomorrow,
        'Tourney': GoogleFonts.tourney,
        'Trade Winds': GoogleFonts.tradeWinds,
        'Train One': GoogleFonts.trainOne,
        'Trirong': GoogleFonts.trirong,
        'Trispace': GoogleFonts.trispace,
        'Trocchi': GoogleFonts.trocchi,
        'Trochut': GoogleFonts.trochut,
        'Trykker': GoogleFonts.trykker,
        'Tulpen One': GoogleFonts.tulpenOne,
        'Turret Road': GoogleFonts.turretRoad,
        'Ubuntu': GoogleFonts.ubuntu,
        'Ubuntu Condensed': GoogleFonts.ubuntuCondensed,
        'Ubuntu Mono': GoogleFonts.ubuntuMono,
        'Uchen': GoogleFonts.uchen,
        'Ultra': GoogleFonts.ultra,
        'Uncial Antiqua': GoogleFonts.uncialAntiqua,
        'Underdog': GoogleFonts.underdog,
        'Unica One': GoogleFonts.unicaOne,
        'UnifrakturCook': GoogleFonts.unifrakturCook,
        'UnifrakturMaguntia': GoogleFonts.unifrakturMaguntia,
        'Unkempt': GoogleFonts.unkempt,
        'Unlock': GoogleFonts.unlock,
        'Unna': GoogleFonts.unna,
        'Urbanist': GoogleFonts.urbanist,
        'VT323': GoogleFonts.vt323,
        'Vampiro One': GoogleFonts.vampiroOne,
        'Varela': GoogleFonts.varela,
        'Varela Round': GoogleFonts.varelaRound,
        'Varta': GoogleFonts.varta,
        'Vast Shadow': GoogleFonts.vastShadow,
        'Vesper Libre': GoogleFonts.vesperLibre,
        'Viaoda Libre': GoogleFonts.viaodaLibre,
        'Vibes': GoogleFonts.vibes,
        'Vibur': GoogleFonts.vibur,
        'Vidaloka': GoogleFonts.vidaloka,
        'Viga': GoogleFonts.viga,
        'Voces': GoogleFonts.voces,
        'Volkhov': GoogleFonts.volkhov,
        'Vollkorn': GoogleFonts.vollkorn,
        'Vollkorn SC': GoogleFonts.vollkornSc,
        'Voltaire': GoogleFonts.voltaire,
        'Waiting for the Sunrise': GoogleFonts.waitingForTheSunrise,
        'Wallpoet': GoogleFonts.wallpoet,
        'Walter Turncoat': GoogleFonts.walterTurncoat,
        'Warnes': GoogleFonts.warnes,
        'Wellfleet': GoogleFonts.wellfleet,
        'Wendy One': GoogleFonts.wendyOne,
        'WindSong': GoogleFonts.windSong,
        'Wire One': GoogleFonts.wireOne,
        'Work Sans': GoogleFonts.workSans,
        'Xanh Mono': GoogleFonts.xanhMono,
        'Yaldevi': GoogleFonts.yaldevi,
        'Yanone Kaffeesatz': GoogleFonts.yanoneKaffeesatz,
        'Yantramanav': GoogleFonts.yantramanav,
        'Yatra One': GoogleFonts.yatraOne,
        'Yellowtail': GoogleFonts.yellowtail,
        'Yeon Sung': GoogleFonts.yeonSung,
        'Yeseva One': GoogleFonts.yesevaOne,
        'Yesteryear': GoogleFonts.yesteryear,
        'Yomogi': GoogleFonts.yomogi,
        'Yrsa': GoogleFonts.yrsa,
        'Yuji Boku': GoogleFonts.yujiBoku,
        'Yuji Hentaigana Akari': GoogleFonts.yujiHentaiganaAkari,
        'Yuji Hentaigana Akebono': GoogleFonts.yujiHentaiganaAkebono,
        'Yuji Mai': GoogleFonts.yujiMai,
        'Yuji Syuku': GoogleFonts.yujiSyuku,
        'Yusei Magic': GoogleFonts.yuseiMagic,
        'ZCOOL KuaiLe': GoogleFonts.zcoolKuaiLe,
        'ZCOOL QingKe HuangYou': GoogleFonts.zcoolQingKeHuangYou,
        'ZCOOL XiaoWei': GoogleFonts.zcoolXiaoWei,
        'Zen Antique': GoogleFonts.zenAntique,
        'Zen Antique Soft': GoogleFonts.zenAntiqueSoft,
        'Zen Kaku Gothic Antique': GoogleFonts.zenKakuGothicAntique,
        'Zen Kaku Gothic New': GoogleFonts.zenKakuGothicNew,
        'Zen Kurenaido': GoogleFonts.zenKurenaido,
        'Zen Loop': GoogleFonts.zenLoop,
        'Zen Maru Gothic': GoogleFonts.zenMaruGothic,
        'Zen Old Mincho': GoogleFonts.zenOldMincho,
        'Zen Tokyo Zoo': GoogleFonts.zenTokyoZoo,
        'Zeyada': GoogleFonts.zeyada,
        'Zhi Mang Xing': GoogleFonts.zhiMangXing,
        'Zilla Slab': GoogleFonts.zillaSlab,
        'Zilla Slab Highlight': GoogleFonts.zillaSlabHighlight,
      };

  /// Get a map of all available fonts and their associated text themes.
  ///
  /// Returns a map where the key is the name of the font family and the value
  /// is the corresponding [GoogleFonts] `TextTheme` method.
  static Map<String, TextTheme Function([TextTheme?])> _asMapOfTextThemes() =>
      const {
        'ABeeZee': GoogleFonts.aBeeZeeTextTheme,
        'Abel': GoogleFonts.abelTextTheme,
        'Abhaya Libre': GoogleFonts.abhayaLibreTextTheme,
        'Abril Fatface': GoogleFonts.abrilFatfaceTextTheme,
        'Aclonica': GoogleFonts.aclonicaTextTheme,
        'Acme': GoogleFonts.acmeTextTheme,
        'Actor': GoogleFonts.actorTextTheme,
        'Adamina': GoogleFonts.adaminaTextTheme,
        'Advent Pro': GoogleFonts.adventProTextTheme,
        'Aguafina Script': GoogleFonts.aguafinaScriptTextTheme,
        'Akaya Telivigala': GoogleFonts.akayaTelivigalaTextTheme,
        'Akronim': GoogleFonts.akronimTextTheme,
        'Aladin': GoogleFonts.aladinTextTheme,
        'Alata': GoogleFonts.alataTextTheme,
        'Alatsi': GoogleFonts.alatsiTextTheme,
        'Aldrich': GoogleFonts.aldrichTextTheme,
        'Alef': GoogleFonts.alefTextTheme,
        'Alegreya': GoogleFonts.alegreyaTextTheme,
        'Alegreya SC': GoogleFonts.alegreyaScTextTheme,
        'Alegreya Sans': GoogleFonts.alegreyaSansTextTheme,
        'Alegreya Sans SC': GoogleFonts.alegreyaSansScTextTheme,
        'Aleo': GoogleFonts.aleoTextTheme,
        'Alex Brush': GoogleFonts.alexBrushTextTheme,
        'Alfa Slab One': GoogleFonts.alfaSlabOneTextTheme,
        'Alice': GoogleFonts.aliceTextTheme,
        'Alike': GoogleFonts.alikeTextTheme,
        'Alike Angular': GoogleFonts.alikeAngularTextTheme,
        'Allan': GoogleFonts.allanTextTheme,
        'Allerta': GoogleFonts.allertaTextTheme,
        'Allerta Stencil': GoogleFonts.allertaStencilTextTheme,
        'Allison': GoogleFonts.allisonTextTheme,
        'Allura': GoogleFonts.alluraTextTheme,
        'Almarai': GoogleFonts.almaraiTextTheme,
        'Almendra': GoogleFonts.almendraTextTheme,
        'Almendra Display': GoogleFonts.almendraDisplayTextTheme,
        'Almendra SC': GoogleFonts.almendraScTextTheme,
        'Alumni Sans': GoogleFonts.alumniSansTextTheme,
        'Amarante': GoogleFonts.amaranteTextTheme,
        'Amaranth': GoogleFonts.amaranthTextTheme,
        'Amatic SC': GoogleFonts.amaticScTextTheme,
        'Amatica SC': GoogleFonts.amaticaScTextTheme,
        'Amethysta': GoogleFonts.amethystaTextTheme,
        'Amiko': GoogleFonts.amikoTextTheme,
        'Amiri': GoogleFonts.amiriTextTheme,
        'Amita': GoogleFonts.amitaTextTheme,
        'Anaheim': GoogleFonts.anaheimTextTheme,
        'Andada': GoogleFonts.andadaTextTheme,
        'Andada Pro': GoogleFonts.andadaProTextTheme,
        'Andika': GoogleFonts.andikaTextTheme,
        'Andika New Basic': GoogleFonts.andikaNewBasicTextTheme,
        'Annie Use Your Telescope': GoogleFonts.annieUseYourTelescopeTextTheme,
        'Anonymous Pro': GoogleFonts.anonymousProTextTheme,
        'Antic': GoogleFonts.anticTextTheme,
        'Antic Didone': GoogleFonts.anticDidoneTextTheme,
        'Antic Slab': GoogleFonts.anticSlabTextTheme,
        'Anton': GoogleFonts.antonTextTheme,
        'Arapey': GoogleFonts.arapeyTextTheme,
        'Arbutus': GoogleFonts.arbutusTextTheme,
        'Arbutus Slab': GoogleFonts.arbutusSlabTextTheme,
        'Architects Daughter': GoogleFonts.architectsDaughterTextTheme,
        'Archivo': GoogleFonts.archivoTextTheme,
        'Archivo Black': GoogleFonts.archivoBlackTextTheme,
        'Archivo Narrow': GoogleFonts.archivoNarrowTextTheme,
        'Are You Serious': GoogleFonts.areYouSeriousTextTheme,
        'Aref Ruqaa': GoogleFonts.arefRuqaaTextTheme,
        'Arima Madurai': GoogleFonts.arimaMaduraiTextTheme,
        'Arimo': GoogleFonts.arimoTextTheme,
        'Arizonia': GoogleFonts.arizoniaTextTheme,
        'Armata': GoogleFonts.armataTextTheme,
        'Arsenal': GoogleFonts.arsenalTextTheme,
        'Artifika': GoogleFonts.artifikaTextTheme,
        'Arvo': GoogleFonts.arvoTextTheme,
        'Arya': GoogleFonts.aryaTextTheme,
        'Asap': GoogleFonts.asapTextTheme,
        'Asar': GoogleFonts.asarTextTheme,
        'Asset': GoogleFonts.assetTextTheme,
        'Assistant': GoogleFonts.assistantTextTheme,
        'Astloch': GoogleFonts.astlochTextTheme,
        'Asul': GoogleFonts.asulTextTheme,
        'Athiti': GoogleFonts.athitiTextTheme,
        'Atkinson Hyperlegible': GoogleFonts.atkinsonHyperlegibleTextTheme,
        'Atma': GoogleFonts.atmaTextTheme,
        'Atomic Age': GoogleFonts.atomicAgeTextTheme,
        'Aubrey': GoogleFonts.aubreyTextTheme,
        'Audiowide': GoogleFonts.audiowideTextTheme,
        'Autour One': GoogleFonts.autourOneTextTheme,
        'Average': GoogleFonts.averageTextTheme,
        'Average Sans': GoogleFonts.averageSansTextTheme,
        'Averia Gruesa Libre': GoogleFonts.averiaGruesaLibreTextTheme,
        'Averia Libre': GoogleFonts.averiaLibreTextTheme,
        'Averia Sans Libre': GoogleFonts.averiaSansLibreTextTheme,
        'Averia Serif Libre': GoogleFonts.averiaSerifLibreTextTheme,
        'Azeret Mono': GoogleFonts.azeretMonoTextTheme,
        'B612': GoogleFonts.b612TextTheme,
        'B612 Mono': GoogleFonts.b612MonoTextTheme,
        'Bad Script': GoogleFonts.badScriptTextTheme,
        'Bahiana': GoogleFonts.bahianaTextTheme,
        'Bahianita': GoogleFonts.bahianitaTextTheme,
        'Bai Jamjuree': GoogleFonts.baiJamjureeTextTheme,
        'Bakbak One': GoogleFonts.bakbakOneTextTheme,
        'Baloo': GoogleFonts.balooTextTheme,
        'Baloo 2': GoogleFonts.baloo2TextTheme,
        'Baloo Bhai': GoogleFonts.balooBhaiTextTheme,
        'Baloo Bhai 2': GoogleFonts.balooBhai2TextTheme,
        'Baloo Bhaijaan': GoogleFonts.balooBhaijaanTextTheme,
        'Baloo Bhaijaan 2': GoogleFonts.balooBhaijaan2TextTheme,
        'Baloo Bhaina': GoogleFonts.balooBhainaTextTheme,
        'Baloo Bhaina 2': GoogleFonts.balooBhaina2TextTheme,
        'Baloo Chettan': GoogleFonts.balooChettanTextTheme,
        'Baloo Chettan 2': GoogleFonts.balooChettan2TextTheme,
        'Baloo Da': GoogleFonts.balooDaTextTheme,
        'Baloo Da 2': GoogleFonts.balooDa2TextTheme,
        'Baloo Paaji': GoogleFonts.balooPaajiTextTheme,
        'Baloo Paaji 2': GoogleFonts.balooPaaji2TextTheme,
        'Baloo Tamma': GoogleFonts.balooTammaTextTheme,
        'Baloo Tamma 2': GoogleFonts.balooTamma2TextTheme,
        'Baloo Tammudu': GoogleFonts.balooTammuduTextTheme,
        'Baloo Tammudu 2': GoogleFonts.balooTammudu2TextTheme,
        'Baloo Thambi': GoogleFonts.balooThambiTextTheme,
        'Baloo Thambi 2': GoogleFonts.balooThambi2TextTheme,
        'Balsamiq Sans': GoogleFonts.balsamiqSansTextTheme,
        'Balthazar': GoogleFonts.balthazarTextTheme,
        'Bangers': GoogleFonts.bangersTextTheme,
        'Barlow': GoogleFonts.barlowTextTheme,
        'Barlow Condensed': GoogleFonts.barlowCondensedTextTheme,
        'Barlow Semi Condensed': GoogleFonts.barlowSemiCondensedTextTheme,
        'Barriecito': GoogleFonts.barriecitoTextTheme,
        'Barrio': GoogleFonts.barrioTextTheme,
        'Basic': GoogleFonts.basicTextTheme,
        'Baskervville': GoogleFonts.baskervvilleTextTheme,
        'Baumans': GoogleFonts.baumansTextTheme,
        'Be Vietnam': GoogleFonts.beVietnamTextTheme,
        'Be Vietnam Pro': GoogleFonts.beVietnamProTextTheme,
        'Bebas Neue': GoogleFonts.bebasNeueTextTheme,
        'Belgrano': GoogleFonts.belgranoTextTheme,
        'Bellefair': GoogleFonts.bellefairTextTheme,
        'Belleza': GoogleFonts.bellezaTextTheme,
        'Bellota': GoogleFonts.bellotaTextTheme,
        'Bellota Text': GoogleFonts.bellotaTextTextTheme,
        'BenchNine': GoogleFonts.benchNineTextTheme,
        'Bentham': GoogleFonts.benthamTextTheme,
        'Berkshire Swash': GoogleFonts.berkshireSwashTextTheme,
        'Besley': GoogleFonts.besleyTextTheme,
        'Beth Ellen': GoogleFonts.bethEllenTextTheme,
        'Bevan': GoogleFonts.bevanTextTheme,
        'Big Shoulders Display': GoogleFonts.bigShouldersDisplayTextTheme,
        'Big Shoulders Inline Display':
            GoogleFonts.bigShouldersInlineDisplayTextTheme,
        'Big Shoulders Inline Text':
            GoogleFonts.bigShouldersInlineTextTextTheme,
        'Big Shoulders Stencil Display':
            GoogleFonts.bigShouldersStencilDisplayTextTheme,
        'Big Shoulders Stencil Text':
            GoogleFonts.bigShouldersStencilTextTextTheme,
        'Big Shoulders Text': GoogleFonts.bigShouldersTextTextTheme,
        'Bigelow Rules': GoogleFonts.bigelowRulesTextTheme,
        'Bigshot One': GoogleFonts.bigshotOneTextTheme,
        'Bilbo': GoogleFonts.bilboTextTheme,
        'Bilbo Swash Caps': GoogleFonts.bilboSwashCapsTextTheme,
        'BioRhyme': GoogleFonts.bioRhymeTextTheme,
        'BioRhyme Expanded': GoogleFonts.bioRhymeExpandedTextTheme,
        'Birthstone': GoogleFonts.birthstoneTextTheme,
        'Birthstone Bounce': GoogleFonts.birthstoneBounceTextTheme,
        'Biryani': GoogleFonts.biryaniTextTheme,
        'Bitter': GoogleFonts.bitterTextTheme,
        'Black And White Picture': GoogleFonts.blackAndWhitePictureTextTheme,
        'Black Han Sans': GoogleFonts.blackHanSansTextTheme,
        'Black Ops One': GoogleFonts.blackOpsOneTextTheme,
        'Blinker': GoogleFonts.blinkerTextTheme,
        'Bona Nova': GoogleFonts.bonaNovaTextTheme,
        'Bonbon': GoogleFonts.bonbonTextTheme,
        'Bonheur Royale': GoogleFonts.bonheurRoyaleTextTheme,
        'Boogaloo': GoogleFonts.boogalooTextTheme,
        'Bowlby One': GoogleFonts.bowlbyOneTextTheme,
        'Bowlby One SC': GoogleFonts.bowlbyOneScTextTheme,
        'Brawler': GoogleFonts.brawlerTextTheme,
        'Bree Serif': GoogleFonts.breeSerifTextTheme,
        'Brygada 1918': GoogleFonts.brygada1918TextTheme,
        'Bubblegum Sans': GoogleFonts.bubblegumSansTextTheme,
        'Bubbler One': GoogleFonts.bubblerOneTextTheme,
        'Buda': GoogleFonts.budaTextTheme,
        'Buenard': GoogleFonts.buenardTextTheme,
        'Bungee': GoogleFonts.bungeeTextTheme,
        'Bungee Hairline': GoogleFonts.bungeeHairlineTextTheme,
        'Bungee Inline': GoogleFonts.bungeeInlineTextTheme,
        'Bungee Outline': GoogleFonts.bungeeOutlineTextTheme,
        'Bungee Shade': GoogleFonts.bungeeShadeTextTheme,
        'Butcherman': GoogleFonts.butchermanTextTheme,
        'Butterfly Kids': GoogleFonts.butterflyKidsTextTheme,
        'Cabin': GoogleFonts.cabinTextTheme,
        'Cabin Condensed': GoogleFonts.cabinCondensedTextTheme,
        'Cabin Sketch': GoogleFonts.cabinSketchTextTheme,
        'Caesar Dressing': GoogleFonts.caesarDressingTextTheme,
        'Cagliostro': GoogleFonts.cagliostroTextTheme,
        'Cairo': GoogleFonts.cairoTextTheme,
        'Caladea': GoogleFonts.caladeaTextTheme,
        'Calistoga': GoogleFonts.calistogaTextTheme,
        'Calligraffitti': GoogleFonts.calligraffittiTextTheme,
        'Cambay': GoogleFonts.cambayTextTheme,
        'Cambo': GoogleFonts.camboTextTheme,
        'Candal': GoogleFonts.candalTextTheme,
        'Cantarell': GoogleFonts.cantarellTextTheme,
        'Cantata One': GoogleFonts.cantataOneTextTheme,
        'Cantora One': GoogleFonts.cantoraOneTextTheme,
        'Capriola': GoogleFonts.capriolaTextTheme,
        'Caramel': GoogleFonts.caramelTextTheme,
        'Carattere': GoogleFonts.carattereTextTheme,
        'Cardo': GoogleFonts.cardoTextTheme,
        'Carme': GoogleFonts.carmeTextTheme,
        'Carrois Gothic': GoogleFonts.carroisGothicTextTheme,
        'Carrois Gothic SC': GoogleFonts.carroisGothicScTextTheme,
        'Carter One': GoogleFonts.carterOneTextTheme,
        'Castoro': GoogleFonts.castoroTextTheme,
        'Catamaran': GoogleFonts.catamaranTextTheme,
        'Caudex': GoogleFonts.caudexTextTheme,
        'Caveat': GoogleFonts.caveatTextTheme,
        'Caveat Brush': GoogleFonts.caveatBrushTextTheme,
        'Cedarville Cursive': GoogleFonts.cedarvilleCursiveTextTheme,
        'Ceviche One': GoogleFonts.cevicheOneTextTheme,
        'Chakra Petch': GoogleFonts.chakraPetchTextTheme,
        'Changa': GoogleFonts.changaTextTheme,
        'Changa One': GoogleFonts.changaOneTextTheme,
        'Chango': GoogleFonts.changoTextTheme,
        'Charm': GoogleFonts.charmTextTheme,
        'Charmonman': GoogleFonts.charmonmanTextTheme,
        'Chathura': GoogleFonts.chathuraTextTheme,
        'Chau Philomene One': GoogleFonts.chauPhilomeneOneTextTheme,
        'Chela One': GoogleFonts.chelaOneTextTheme,
        'Chelsea Market': GoogleFonts.chelseaMarketTextTheme,
        'Cherish': GoogleFonts.cherishTextTheme,
        'Cherry Cream Soda': GoogleFonts.cherryCreamSodaTextTheme,
        'Cherry Swash': GoogleFonts.cherrySwashTextTheme,
        'Chewy': GoogleFonts.chewyTextTheme,
        'Chicle': GoogleFonts.chicleTextTheme,
        'Chilanka': GoogleFonts.chilankaTextTheme,
        'Chivo': GoogleFonts.chivoTextTheme,
        'Chonburi': GoogleFonts.chonburiTextTheme,
        'Cinzel': GoogleFonts.cinzelTextTheme,
        'Cinzel Decorative': GoogleFonts.cinzelDecorativeTextTheme,
        'Clicker Script': GoogleFonts.clickerScriptTextTheme,
        'Coda': GoogleFonts.codaTextTheme,
        'Coda Caption': GoogleFonts.codaCaptionTextTheme,
        'Codystar': GoogleFonts.codystarTextTheme,
        'Coiny': GoogleFonts.coinyTextTheme,
        'Combo': GoogleFonts.comboTextTheme,
        'Comfortaa': GoogleFonts.comfortaaTextTheme,
        'Comforter': GoogleFonts.comforterTextTheme,
        'Comforter Brush': GoogleFonts.comforterBrushTextTheme,
        'Comic Neue': GoogleFonts.comicNeueTextTheme,
        'Coming Soon': GoogleFonts.comingSoonTextTheme,
        'Commissioner': GoogleFonts.commissionerTextTheme,
        'Concert One': GoogleFonts.concertOneTextTheme,
        'Condiment': GoogleFonts.condimentTextTheme,
        'Contrail One': GoogleFonts.contrailOneTextTheme,
        'Convergence': GoogleFonts.convergenceTextTheme,
        'Cookie': GoogleFonts.cookieTextTheme,
        'Copse': GoogleFonts.copseTextTheme,
        'Corben': GoogleFonts.corbenTextTheme,
        'Corinthia': GoogleFonts.corinthiaTextTheme,
        'Cormorant': GoogleFonts.cormorantTextTheme,
        'Cormorant Garamond': GoogleFonts.cormorantGaramondTextTheme,
        'Cormorant Infant': GoogleFonts.cormorantInfantTextTheme,
        'Cormorant SC': GoogleFonts.cormorantScTextTheme,
        'Cormorant Unicase': GoogleFonts.cormorantUnicaseTextTheme,
        'Cormorant Upright': GoogleFonts.cormorantUprightTextTheme,
        'Courgette': GoogleFonts.courgetteTextTheme,
        'Courier Prime': GoogleFonts.courierPrimeTextTheme,
        'Cousine': GoogleFonts.cousineTextTheme,
        'Coustard': GoogleFonts.coustardTextTheme,
        'Covered By Your Grace': GoogleFonts.coveredByYourGraceTextTheme,
        'Crafty Girls': GoogleFonts.craftyGirlsTextTheme,
        'Creepster': GoogleFonts.creepsterTextTheme,
        'Crete Round': GoogleFonts.creteRoundTextTheme,
        'Crimson Pro': GoogleFonts.crimsonProTextTheme,
        'Crimson Text': GoogleFonts.crimsonTextTextTheme,
        'Croissant One': GoogleFonts.croissantOneTextTheme,
        'Crushed': GoogleFonts.crushedTextTheme,
        'Cuprum': GoogleFonts.cuprumTextTheme,
        'Cute Font': GoogleFonts.cuteFontTextTheme,
        'Cutive': GoogleFonts.cutiveTextTheme,
        'Cutive Mono': GoogleFonts.cutiveMonoTextTheme,
        'DM Mono': GoogleFonts.dmMonoTextTheme,
        'DM Sans': GoogleFonts.dmSansTextTheme,
        'DM Serif Display': GoogleFonts.dmSerifDisplayTextTheme,
        'DM Serif Text': GoogleFonts.dmSerifTextTextTheme,
        'Damion': GoogleFonts.damionTextTheme,
        'Dancing Script': GoogleFonts.dancingScriptTextTheme,
        'Darker Grotesque': GoogleFonts.darkerGrotesqueTextTheme,
        'David Libre': GoogleFonts.davidLibreTextTheme,
        'Dawning of a New Day': GoogleFonts.dawningOfANewDayTextTheme,
        'Days One': GoogleFonts.daysOneTextTheme,
        'Dekko': GoogleFonts.dekkoTextTheme,
        'Dela Gothic One': GoogleFonts.delaGothicOneTextTheme,
        'Delius': GoogleFonts.deliusTextTheme,
        'Delius Swash Caps': GoogleFonts.deliusSwashCapsTextTheme,
        'Delius Unicase': GoogleFonts.deliusUnicaseTextTheme,
        'Della Respira': GoogleFonts.dellaRespiraTextTheme,
        'Denk One': GoogleFonts.denkOneTextTheme,
        'Devonshire': GoogleFonts.devonshireTextTheme,
        'Dhurjati': GoogleFonts.dhurjatiTextTheme,
        'Didact Gothic': GoogleFonts.didactGothicTextTheme,
        'Diplomata': GoogleFonts.diplomataTextTheme,
        'Diplomata SC': GoogleFonts.diplomataScTextTheme,
        'Do Hyeon': GoogleFonts.doHyeonTextTheme,
        'Dokdo': GoogleFonts.dokdoTextTheme,
        'Domine': GoogleFonts.domineTextTheme,
        'Donegal One': GoogleFonts.donegalOneTextTheme,
        'Dongle': GoogleFonts.dongleTextTheme,
        'Doppio One': GoogleFonts.doppioOneTextTheme,
        'Dorsa': GoogleFonts.dorsaTextTheme,
        'Dosis': GoogleFonts.dosisTextTheme,
        'DotGothic16': GoogleFonts.dotGothic16TextTheme,
        'Dr Sugiyama': GoogleFonts.drSugiyamaTextTheme,
        'Droid Sans': GoogleFonts.droidSansTextTheme,
        'Droid Sans Mono': GoogleFonts.droidSansMonoTextTheme,
        'Droid Serif': GoogleFonts.droidSerifTextTheme,
        'Duru Sans': GoogleFonts.duruSansTextTheme,
        'Dynalight': GoogleFonts.dynalightTextTheme,
        'EB Garamond': GoogleFonts.ebGaramondTextTheme,
        'Eagle Lake': GoogleFonts.eagleLakeTextTheme,
        'East Sea Dokdo': GoogleFonts.eastSeaDokdoTextTheme,
        'Eater': GoogleFonts.eaterTextTheme,
        'Economica': GoogleFonts.economicaTextTheme,
        'Eczar': GoogleFonts.eczarTextTheme,
        'El Messiri': GoogleFonts.elMessiriTextTheme,
        'Electrolize': GoogleFonts.electrolizeTextTheme,
        'Elsie': GoogleFonts.elsieTextTheme,
        'Elsie Swash Caps': GoogleFonts.elsieSwashCapsTextTheme,
        'Emblema One': GoogleFonts.emblemaOneTextTheme,
        'Emilys Candy': GoogleFonts.emilysCandyTextTheme,
        'Encode Sans': GoogleFonts.encodeSansTextTheme,
        'Encode Sans Condensed': GoogleFonts.encodeSansCondensedTextTheme,
        'Encode Sans Expanded': GoogleFonts.encodeSansExpandedTextTheme,
        'Encode Sans SC': GoogleFonts.encodeSansScTextTheme,
        'Encode Sans Semi Condensed':
            GoogleFonts.encodeSansSemiCondensedTextTheme,
        'Encode Sans Semi Expanded':
            GoogleFonts.encodeSansSemiExpandedTextTheme,
        'Engagement': GoogleFonts.engagementTextTheme,
        'Englebert': GoogleFonts.englebertTextTheme,
        'Enriqueta': GoogleFonts.enriquetaTextTheme,
        'Ephesis': GoogleFonts.ephesisTextTheme,
        'Epilogue': GoogleFonts.epilogueTextTheme,
        'Erica One': GoogleFonts.ericaOneTextTheme,
        'Esteban': GoogleFonts.estebanTextTheme,
        'Estonia': GoogleFonts.estoniaTextTheme,
        'Euphoria Script': GoogleFonts.euphoriaScriptTextTheme,
        'Ewert': GoogleFonts.ewertTextTheme,
        'Exo': GoogleFonts.exoTextTheme,
        'Exo 2': GoogleFonts.exo2TextTheme,
        'Expletus Sans': GoogleFonts.expletusSansTextTheme,
        'Explora': GoogleFonts.exploraTextTheme,
        'Fahkwang': GoogleFonts.fahkwangTextTheme,
        'Fanwood Text': GoogleFonts.fanwoodTextTextTheme,
        'Farro': GoogleFonts.farroTextTheme,
        'Farsan': GoogleFonts.farsanTextTheme,
        'Fascinate': GoogleFonts.fascinateTextTheme,
        'Fascinate Inline': GoogleFonts.fascinateInlineTextTheme,
        'Faster One': GoogleFonts.fasterOneTextTheme,
        'Fauna One': GoogleFonts.faunaOneTextTheme,
        'Faustina': GoogleFonts.faustinaTextTheme,
        'Federant': GoogleFonts.federantTextTheme,
        'Federo': GoogleFonts.federoTextTheme,
        'Felipa': GoogleFonts.felipaTextTheme,
        'Fenix': GoogleFonts.fenixTextTheme,
        'Festive': GoogleFonts.festiveTextTheme,
        'Finger Paint': GoogleFonts.fingerPaintTextTheme,
        'Fira Code': GoogleFonts.firaCodeTextTheme,
        'Fira Mono': GoogleFonts.firaMonoTextTheme,
        'Fira Sans': GoogleFonts.firaSansTextTheme,
        'Fira Sans Condensed': GoogleFonts.firaSansCondensedTextTheme,
        'Fira Sans Extra Condensed':
            GoogleFonts.firaSansExtraCondensedTextTheme,
        'Fjalla One': GoogleFonts.fjallaOneTextTheme,
        'Fjord One': GoogleFonts.fjordOneTextTheme,
        'Flamenco': GoogleFonts.flamencoTextTheme,
        'Flavors': GoogleFonts.flavorsTextTheme,
        'Fleur De Leah': GoogleFonts.fleurDeLeahTextTheme,
        'Flow Block': GoogleFonts.flowBlockTextTheme,
        'Flow Circular': GoogleFonts.flowCircularTextTheme,
        'Flow Rounded': GoogleFonts.flowRoundedTextTheme,
        'Fondamento': GoogleFonts.fondamentoTextTheme,
        'Fontdiner Swanky': GoogleFonts.fontdinerSwankyTextTheme,
        'Forum': GoogleFonts.forumTextTheme,
        'Francois One': GoogleFonts.francoisOneTextTheme,
        'Frank Ruhl Libre': GoogleFonts.frankRuhlLibreTextTheme,
        'Fraunces': GoogleFonts.frauncesTextTheme,
        'Freckle Face': GoogleFonts.freckleFaceTextTheme,
        'Fredericka the Great': GoogleFonts.frederickaTheGreatTextTheme,
        'Fredoka One': GoogleFonts.fredokaOneTextTheme,
        'Fresca': GoogleFonts.frescaTextTheme,
        'Frijole': GoogleFonts.frijoleTextTheme,
        'Fruktur': GoogleFonts.frukturTextTheme,
        'Fugaz One': GoogleFonts.fugazOneTextTheme,
        'Fuggles': GoogleFonts.fugglesTextTheme,
        'Fuzzy Bubbles': GoogleFonts.fuzzyBubblesTextTheme,
        'GFS Didot': GoogleFonts.gfsDidotTextTheme,
        'GFS Neohellenic': GoogleFonts.gfsNeohellenicTextTheme,
        'Gabriela': GoogleFonts.gabrielaTextTheme,
        'Gaegu': GoogleFonts.gaeguTextTheme,
        'Gafata': GoogleFonts.gafataTextTheme,
        'Galada': GoogleFonts.galadaTextTheme,
        'Galdeano': GoogleFonts.galdeanoTextTheme,
        'Galindo': GoogleFonts.galindoTextTheme,
        'Gamja Flower': GoogleFonts.gamjaFlowerTextTheme,
        'Gayathri': GoogleFonts.gayathriTextTheme,
        'Gelasio': GoogleFonts.gelasioTextTheme,
        'Gemunu Libre': GoogleFonts.gemunuLibreTextTheme,
        'Genos': GoogleFonts.genosTextTheme,
        'Gentium Basic': GoogleFonts.gentiumBasicTextTheme,
        'Gentium Book Basic': GoogleFonts.gentiumBookBasicTextTheme,
        'Geo': GoogleFonts.geoTextTheme,
        'Georama': GoogleFonts.georamaTextTheme,
        'Geostar': GoogleFonts.geostarTextTheme,
        'Geostar Fill': GoogleFonts.geostarFillTextTheme,
        'Germania One': GoogleFonts.germaniaOneTextTheme,
        'Gideon Roman': GoogleFonts.gideonRomanTextTheme,
        'Gidugu': GoogleFonts.giduguTextTheme,
        'Gilda Display': GoogleFonts.gildaDisplayTextTheme,
        'Girassol': GoogleFonts.girassolTextTheme,
        'Give You Glory': GoogleFonts.giveYouGloryTextTheme,
        'Glass Antiqua': GoogleFonts.glassAntiquaTextTheme,
        'Glegoo': GoogleFonts.glegooTextTheme,
        'Gloria Hallelujah': GoogleFonts.gloriaHallelujahTextTheme,
        'Glory': GoogleFonts.gloryTextTheme,
        'Gluten': GoogleFonts.glutenTextTheme,
        'Goblin One': GoogleFonts.goblinOneTextTheme,
        'Gochi Hand': GoogleFonts.gochiHandTextTheme,
        'Goldman': GoogleFonts.goldmanTextTheme,
        'Gorditas': GoogleFonts.gorditasTextTheme,
        'Gothic A1': GoogleFonts.gothicA1TextTheme,
        'Gotu': GoogleFonts.gotuTextTheme,
        'Goudy Bookletter 1911': GoogleFonts.goudyBookletter1911TextTheme,
        'Gowun Batang': GoogleFonts.gowunBatangTextTheme,
        'Gowun Dodum': GoogleFonts.gowunDodumTextTheme,
        'Graduate': GoogleFonts.graduateTextTheme,
        'Grand Hotel': GoogleFonts.grandHotelTextTheme,
        'Grandstander': GoogleFonts.grandstanderTextTheme,
        'Gravitas One': GoogleFonts.gravitasOneTextTheme,
        'Great Vibes': GoogleFonts.greatVibesTextTheme,
        'Grechen Fuemen': GoogleFonts.grechenFuemenTextTheme,
        'Grenze': GoogleFonts.grenzeTextTheme,
        'Grenze Gotisch': GoogleFonts.grenzeGotischTextTheme,
        'Grey Qo': GoogleFonts.greyQoTextTheme,
        'Griffy': GoogleFonts.griffyTextTheme,
        'Gruppo': GoogleFonts.gruppoTextTheme,
        'Gudea': GoogleFonts.gudeaTextTheme,
        'Gugi': GoogleFonts.gugiTextTheme,
        'Gupter': GoogleFonts.gupterTextTheme,
        'Gurajada': GoogleFonts.gurajadaTextTheme,
        'Gwendolyn': GoogleFonts.gwendolynTextTheme,
        'Habibi': GoogleFonts.habibiTextTheme,
        'Hachi Maru Pop': GoogleFonts.hachiMaruPopTextTheme,
        'Hahmlet': GoogleFonts.hahmletTextTheme,
        'Halant': GoogleFonts.halantTextTheme,
        'Hammersmith One': GoogleFonts.hammersmithOneTextTheme,
        'Hanalei': GoogleFonts.hanaleiTextTheme,
        'Hanalei Fill': GoogleFonts.hanaleiFillTextTheme,
        'Handlee': GoogleFonts.handleeTextTheme,
        'Happy Monkey': GoogleFonts.happyMonkeyTextTheme,
        'Harmattan': GoogleFonts.harmattanTextTheme,
        'Headland One': GoogleFonts.headlandOneTextTheme,
        'Heebo': GoogleFonts.heeboTextTheme,
        'Henny Penny': GoogleFonts.hennyPennyTextTheme,
        'Hepta Slab': GoogleFonts.heptaSlabTextTheme,
        'Herr Von Muellerhoff': GoogleFonts.herrVonMuellerhoffTextTheme,
        'Hi Melody': GoogleFonts.hiMelodyTextTheme,
        'Hina Mincho': GoogleFonts.hinaMinchoTextTheme,
        'Hind': GoogleFonts.hindTextTheme,
        'Hind Guntur': GoogleFonts.hindGunturTextTheme,
        'Hind Madurai': GoogleFonts.hindMaduraiTextTheme,
        'Hind Siliguri': GoogleFonts.hindSiliguriTextTheme,
        'Hind Vadodara': GoogleFonts.hindVadodaraTextTheme,
        'Holtwood One SC': GoogleFonts.holtwoodOneScTextTheme,
        'Homemade Apple': GoogleFonts.homemadeAppleTextTheme,
        'Homenaje': GoogleFonts.homenajeTextTheme,
        'Hurricane': GoogleFonts.hurricaneTextTheme,
        'IBM Plex Mono': GoogleFonts.ibmPlexMonoTextTheme,
        'IBM Plex Sans': GoogleFonts.ibmPlexSansTextTheme,
        'IBM Plex Sans Arabic': GoogleFonts.ibmPlexSansArabicTextTheme,
        'IBM Plex Sans Condensed': GoogleFonts.ibmPlexSansCondensedTextTheme,
        'IBM Plex Sans Devanagari': GoogleFonts.ibmPlexSansDevanagariTextTheme,
        'IBM Plex Sans Hebrew': GoogleFonts.ibmPlexSansHebrewTextTheme,
        'IBM Plex Sans KR': GoogleFonts.ibmPlexSansKrTextTheme,
        'IBM Plex Sans Thai': GoogleFonts.ibmPlexSansThaiTextTheme,
        'IBM Plex Sans Thai Looped': GoogleFonts.ibmPlexSansThaiLoopedTextTheme,
        'IBM Plex Serif': GoogleFonts.ibmPlexSerifTextTheme,
        'IM Fell DW Pica': GoogleFonts.imFellDwPicaTextTheme,
        'IM Fell DW Pica SC': GoogleFonts.imFellDwPicaScTextTheme,
        'IM Fell Double Pica': GoogleFonts.imFellDoublePicaTextTheme,
        'IM Fell Double Pica SC': GoogleFonts.imFellDoublePicaScTextTheme,
        'IM Fell English': GoogleFonts.imFellEnglishTextTheme,
        'IM Fell English SC': GoogleFonts.imFellEnglishScTextTheme,
        'IM Fell French Canon': GoogleFonts.imFellFrenchCanonTextTheme,
        'IM Fell French Canon SC': GoogleFonts.imFellFrenchCanonScTextTheme,
        'IM Fell Great Primer': GoogleFonts.imFellGreatPrimerTextTheme,
        'IM Fell Great Primer SC': GoogleFonts.imFellGreatPrimerScTextTheme,
        'Ibarra Real Nova': GoogleFonts.ibarraRealNovaTextTheme,
        'Iceberg': GoogleFonts.icebergTextTheme,
        'Iceland': GoogleFonts.icelandTextTheme,
        'Imprima': GoogleFonts.imprimaTextTheme,
        'Inconsolata': GoogleFonts.inconsolataTextTheme,
        'Inder': GoogleFonts.inderTextTheme,
        'Indie Flower': GoogleFonts.indieFlowerTextTheme,
        'Inika': GoogleFonts.inikaTextTheme,
        'Inknut Antiqua': GoogleFonts.inknutAntiquaTextTheme,
        'Inria Sans': GoogleFonts.inriaSansTextTheme,
        'Inria Serif': GoogleFonts.inriaSerifTextTheme,
        'Inter': GoogleFonts.interTextTheme,
        'Irish Grover': GoogleFonts.irishGroverTextTheme,
        'Istok Web': GoogleFonts.istokWebTextTheme,
        'Italiana': GoogleFonts.italianaTextTheme,
        'Italianno': GoogleFonts.italiannoTextTheme,
        'Itim': GoogleFonts.itimTextTheme,
        'Jacques Francois': GoogleFonts.jacquesFrancoisTextTheme,
        'Jacques Francois Shadow': GoogleFonts.jacquesFrancoisShadowTextTheme,
        'Jaldi': GoogleFonts.jaldiTextTheme,
        'JetBrains Mono': GoogleFonts.jetBrainsMonoTextTheme,
        'Jim Nightshade': GoogleFonts.jimNightshadeTextTheme,
        'Jockey One': GoogleFonts.jockeyOneTextTheme,
        'Jolly Lodger': GoogleFonts.jollyLodgerTextTheme,
        'Jomhuria': GoogleFonts.jomhuriaTextTheme,
        'Jomolhari': GoogleFonts.jomolhariTextTheme,
        'Josefin Sans': GoogleFonts.josefinSansTextTheme,
        'Josefin Slab': GoogleFonts.josefinSlabTextTheme,
        'Jost': GoogleFonts.jostTextTheme,
        'Joti One': GoogleFonts.jotiOneTextTheme,
        'Jua': GoogleFonts.juaTextTheme,
        'Judson': GoogleFonts.judsonTextTheme,
        'Julee': GoogleFonts.juleeTextTheme,
        'Julius Sans One': GoogleFonts.juliusSansOneTextTheme,
        'Junge': GoogleFonts.jungeTextTheme,
        'Jura': GoogleFonts.juraTextTheme,
        'Just Another Hand': GoogleFonts.justAnotherHandTextTheme,
        'Just Me Again Down Here': GoogleFonts.justMeAgainDownHereTextTheme,
        'K2D': GoogleFonts.k2dTextTheme,
        'Kadwa': GoogleFonts.kadwaTextTheme,
        'Kaisei Decol': GoogleFonts.kaiseiDecolTextTheme,
        'Kaisei HarunoUmi': GoogleFonts.kaiseiHarunoUmiTextTheme,
        'Kaisei Opti': GoogleFonts.kaiseiOptiTextTheme,
        'Kaisei Tokumin': GoogleFonts.kaiseiTokuminTextTheme,
        'Kalam': GoogleFonts.kalamTextTheme,
        'Kameron': GoogleFonts.kameronTextTheme,
        'Kanit': GoogleFonts.kanitTextTheme,
        'Kantumruy': GoogleFonts.kantumruyTextTheme,
        'Karla': GoogleFonts.karlaTextTheme,
        'Karma': GoogleFonts.karmaTextTheme,
        'Katibeh': GoogleFonts.katibehTextTheme,
        'Kaushan Script': GoogleFonts.kaushanScriptTextTheme,
        'Kavivanar': GoogleFonts.kavivanarTextTheme,
        'Kavoon': GoogleFonts.kavoonTextTheme,
        'Kdam Thmor': GoogleFonts.kdamThmorTextTheme,
        'Keania One': GoogleFonts.keaniaOneTextTheme,
        'Kelly Slab': GoogleFonts.kellySlabTextTheme,
        'Kenia': GoogleFonts.keniaTextTheme,
        'Khand': GoogleFonts.khandTextTheme,
        'Khula': GoogleFonts.khulaTextTheme,
        'Kings': GoogleFonts.kingsTextTheme,
        'Kirang Haerang': GoogleFonts.kirangHaerangTextTheme,
        'Kite One': GoogleFonts.kiteOneTextTheme,
        'Klee One': GoogleFonts.kleeOneTextTheme,
        'Knewave': GoogleFonts.knewaveTextTheme,
        'KoHo': GoogleFonts.koHoTextTheme,
        'Kodchasan': GoogleFonts.kodchasanTextTheme,
        'Koh Santepheap': GoogleFonts.kohSantepheapTextTheme,
        'Kosugi': GoogleFonts.kosugiTextTheme,
        'Kosugi Maru': GoogleFonts.kosugiMaruTextTheme,
        'Kotta One': GoogleFonts.kottaOneTextTheme,
        'Kranky': GoogleFonts.krankyTextTheme,
        'Kreon': GoogleFonts.kreonTextTheme,
        'Kristi': GoogleFonts.kristiTextTheme,
        'Krona One': GoogleFonts.kronaOneTextTheme,
        'Krub': GoogleFonts.krubTextTheme,
        'Kufam': GoogleFonts.kufamTextTheme,
        'Kulim Park': GoogleFonts.kulimParkTextTheme,
        'Kumar One': GoogleFonts.kumarOneTextTheme,
        'Kumar One Outline': GoogleFonts.kumarOneOutlineTextTheme,
        'Kumbh Sans': GoogleFonts.kumbhSansTextTheme,
        'Kurale': GoogleFonts.kuraleTextTheme,
        'La Belle Aurore': GoogleFonts.laBelleAuroreTextTheme,
        'Lacquer': GoogleFonts.lacquerTextTheme,
        'Laila': GoogleFonts.lailaTextTheme,
        'Lakki Reddy': GoogleFonts.lakkiReddyTextTheme,
        'Lalezar': GoogleFonts.lalezarTextTheme,
        'Lancelot': GoogleFonts.lancelotTextTheme,
        'Langar': GoogleFonts.langarTextTheme,
        'Lateef': GoogleFonts.lateefTextTheme,
        'Lato': GoogleFonts.latoTextTheme,
        'League Script': GoogleFonts.leagueScriptTextTheme,
        'Leckerli One': GoogleFonts.leckerliOneTextTheme,
        'Ledger': GoogleFonts.ledgerTextTheme,
        'Lekton': GoogleFonts.lektonTextTheme,
        'Lemon': GoogleFonts.lemonTextTheme,
        'Lemonada': GoogleFonts.lemonadaTextTheme,
        'Lexend': GoogleFonts.lexendTextTheme,
        'Lexend Deca': GoogleFonts.lexendDecaTextTheme,
        'Lexend Exa': GoogleFonts.lexendExaTextTheme,
        'Lexend Giga': GoogleFonts.lexendGigaTextTheme,
        'Lexend Mega': GoogleFonts.lexendMegaTextTheme,
        'Lexend Peta': GoogleFonts.lexendPetaTextTheme,
        'Lexend Tera': GoogleFonts.lexendTeraTextTheme,
        'Lexend Zetta': GoogleFonts.lexendZettaTextTheme,
        'Libre Barcode 128': GoogleFonts.libreBarcode128TextTheme,
        'Libre Barcode 128 Text': GoogleFonts.libreBarcode128TextTextTheme,
        'Libre Barcode 39': GoogleFonts.libreBarcode39TextTheme,
        'Libre Barcode 39 Extended':
            GoogleFonts.libreBarcode39ExtendedTextTheme,
        'Libre Barcode 39 Extended Text':
            GoogleFonts.libreBarcode39ExtendedTextTextTheme,
        'Libre Barcode 39 Text': GoogleFonts.libreBarcode39TextTextTheme,
        'Libre Baskerville': GoogleFonts.libreBaskervilleTextTheme,
        'Libre Caslon Display': GoogleFonts.libreCaslonDisplayTextTheme,
        'Libre Caslon Text': GoogleFonts.libreCaslonTextTextTheme,
        'Libre Franklin': GoogleFonts.libreFranklinTextTheme,
        'Life Savers': GoogleFonts.lifeSaversTextTheme,
        'Lilita One': GoogleFonts.lilitaOneTextTheme,
        'Lily Script One': GoogleFonts.lilyScriptOneTextTheme,
        'Limelight': GoogleFonts.limelightTextTheme,
        'Linden Hill': GoogleFonts.lindenHillTextTheme,
        'Literata': GoogleFonts.literataTextTheme,
        'Liu Jian Mao Cao': GoogleFonts.liuJianMaoCaoTextTheme,
        'Livvic': GoogleFonts.livvicTextTheme,
        'Lobster': GoogleFonts.lobsterTextTheme,
        'Lobster Two': GoogleFonts.lobsterTwoTextTheme,
        'Londrina Outline': GoogleFonts.londrinaOutlineTextTheme,
        'Londrina Shadow': GoogleFonts.londrinaShadowTextTheme,
        'Londrina Sketch': GoogleFonts.londrinaSketchTextTheme,
        'Londrina Solid': GoogleFonts.londrinaSolidTextTheme,
        'Long Cang': GoogleFonts.longCangTextTheme,
        'Lora': GoogleFonts.loraTextTheme,
        'Love Ya Like A Sister': GoogleFonts.loveYaLikeASisterTextTheme,
        'Loved by the King': GoogleFonts.lovedByTheKingTextTheme,
        'Lovers Quarrel': GoogleFonts.loversQuarrelTextTheme,
        'Luckiest Guy': GoogleFonts.luckiestGuyTextTheme,
        'Lusitana': GoogleFonts.lusitanaTextTheme,
        'Lustria': GoogleFonts.lustriaTextTheme,
        'Luxurious Script': GoogleFonts.luxuriousScriptTextTheme,
        'M PLUS 1': GoogleFonts.mPlus1TextTheme,
        'M PLUS 1 Code': GoogleFonts.mPlus1CodeTextTheme,
        'M PLUS 1p': GoogleFonts.mPlus1pTextTheme,
        'M PLUS 2': GoogleFonts.mPlus2TextTheme,
        'M PLUS Code Latin': GoogleFonts.mPlusCodeLatinTextTheme,
        'M PLUS Rounded 1c': GoogleFonts.mPlusRounded1cTextTheme,
        'Ma Shan Zheng': GoogleFonts.maShanZhengTextTheme,
        'Macondo': GoogleFonts.macondoTextTheme,
        'Macondo Swash Caps': GoogleFonts.macondoSwashCapsTextTheme,
        'Mada': GoogleFonts.madaTextTheme,
        'Magra': GoogleFonts.magraTextTheme,
        'Maiden Orange': GoogleFonts.maidenOrangeTextTheme,
        'Maitree': GoogleFonts.maitreeTextTheme,
        'Major Mono Display': GoogleFonts.majorMonoDisplayTextTheme,
        'Mako': GoogleFonts.makoTextTheme,
        'Mali': GoogleFonts.maliTextTheme,
        'Mallanna': GoogleFonts.mallannaTextTheme,
        'Mandali': GoogleFonts.mandaliTextTheme,
        'Manjari': GoogleFonts.manjariTextTheme,
        'Manrope': GoogleFonts.manropeTextTheme,
        'Mansalva': GoogleFonts.mansalvaTextTheme,
        'Manuale': GoogleFonts.manualeTextTheme,
        'Marcellus': GoogleFonts.marcellusTextTheme,
        'Marcellus SC': GoogleFonts.marcellusScTextTheme,
        'Marck Script': GoogleFonts.marckScriptTextTheme,
        'Margarine': GoogleFonts.margarineTextTheme,
        'Markazi Text': GoogleFonts.markaziTextTextTheme,
        'Marko One': GoogleFonts.markoOneTextTheme,
        'Marmelad': GoogleFonts.marmeladTextTheme,
        'Martel': GoogleFonts.martelTextTheme,
        'Martel Sans': GoogleFonts.martelSansTextTheme,
        'Marvel': GoogleFonts.marvelTextTheme,
        'Mate': GoogleFonts.mateTextTheme,
        'Mate SC': GoogleFonts.mateScTextTheme,
        'Maven Pro': GoogleFonts.mavenProTextTheme,
        'McLaren': GoogleFonts.mcLarenTextTheme,
        'Meddon': GoogleFonts.meddonTextTheme,
        'MedievalSharp': GoogleFonts.medievalSharpTextTheme,
        'Medula One': GoogleFonts.medulaOneTextTheme,
        'Meera Inimai': GoogleFonts.meeraInimaiTextTheme,
        'Megrim': GoogleFonts.megrimTextTheme,
        'Meie Script': GoogleFonts.meieScriptTextTheme,
        'Meow Script': GoogleFonts.meowScriptTextTheme,
        'Merienda': GoogleFonts.meriendaTextTheme,
        'Merienda One': GoogleFonts.meriendaOneTextTheme,
        'Merriweather': GoogleFonts.merriweatherTextTheme,
        'Merriweather Sans': GoogleFonts.merriweatherSansTextTheme,
        'Metal Mania': GoogleFonts.metalManiaTextTheme,
        'Metamorphous': GoogleFonts.metamorphousTextTheme,
        'Metrophobic': GoogleFonts.metrophobicTextTheme,
        'Michroma': GoogleFonts.michromaTextTheme,
        'Milonga': GoogleFonts.milongaTextTheme,
        'Miltonian': GoogleFonts.miltonianTextTheme,
        'Miltonian Tattoo': GoogleFonts.miltonianTattooTextTheme,
        'Mina': GoogleFonts.minaTextTheme,
        'Miniver': GoogleFonts.miniverTextTheme,
        'Miriam Libre': GoogleFonts.miriamLibreTextTheme,
        'Mirza': GoogleFonts.mirzaTextTheme,
        'Miss Fajardose': GoogleFonts.missFajardoseTextTheme,
        'Mitr': GoogleFonts.mitrTextTheme,
        'Mochiy Pop One': GoogleFonts.mochiyPopOneTextTheme,
        'Mochiy Pop P One': GoogleFonts.mochiyPopPOneTextTheme,
        'Modak': GoogleFonts.modakTextTheme,
        'Modern Antiqua': GoogleFonts.modernAntiquaTextTheme,
        'Mogra': GoogleFonts.mograTextTheme,
        'Mohave': GoogleFonts.mohaveTextTheme,
        'Molengo': GoogleFonts.molengoTextTheme,
        'Molle': GoogleFonts.molleTextTheme,
        'Monda': GoogleFonts.mondaTextTheme,
        'Monofett': GoogleFonts.monofettTextTheme,
        'Monoton': GoogleFonts.monotonTextTheme,
        'Monsieur La Doulaise': GoogleFonts.monsieurLaDoulaiseTextTheme,
        'Montaga': GoogleFonts.montagaTextTheme,
        'Montagu Slab': GoogleFonts.montaguSlabTextTheme,
        'MonteCarlo': GoogleFonts.monteCarloTextTheme,
        'Montez': GoogleFonts.montezTextTheme,
        'Montserrat': GoogleFonts.montserratTextTheme,
        'Montserrat Alternates': GoogleFonts.montserratAlternatesTextTheme,
        'Montserrat Subrayada': GoogleFonts.montserratSubrayadaTextTheme,
        'Mountains of Christmas': GoogleFonts.mountainsOfChristmasTextTheme,
        'Mouse Memoirs': GoogleFonts.mouseMemoirsTextTheme,
        'Mr Bedfort': GoogleFonts.mrBedfortTextTheme,
        'Mr Dafoe': GoogleFonts.mrDafoeTextTheme,
        'Mr De Haviland': GoogleFonts.mrDeHavilandTextTheme,
        'Mrs Saint Delafield': GoogleFonts.mrsSaintDelafieldTextTheme,
        'Mrs Sheppards': GoogleFonts.mrsSheppardsTextTheme,
        'Mukta': GoogleFonts.muktaTextTheme,
        'Mukta Mahee': GoogleFonts.muktaMaheeTextTheme,
        'Mukta Malar': GoogleFonts.muktaMalarTextTheme,
        'Mukta Vaani': GoogleFonts.muktaVaaniTextTheme,
        'Muli': GoogleFonts.muliTextTheme,
        'Mulish': GoogleFonts.mulishTextTheme,
        'Murecho': GoogleFonts.murechoTextTheme,
        'MuseoModerno': GoogleFonts.museoModernoTextTheme,
        'Mystery Quest': GoogleFonts.mysteryQuestTextTheme,
        'NTR': GoogleFonts.ntrTextTheme,
        'Nanum Brush Script': GoogleFonts.nanumBrushScriptTextTheme,
        'Nanum Gothic': GoogleFonts.nanumGothicTextTheme,
        'Nanum Gothic Coding': GoogleFonts.nanumGothicCodingTextTheme,
        'Nanum Myeongjo': GoogleFonts.nanumMyeongjoTextTheme,
        'Nanum Pen Script': GoogleFonts.nanumPenScriptTextTheme,
        'Nerko One': GoogleFonts.nerkoOneTextTheme,
        'Neucha': GoogleFonts.neuchaTextTheme,
        'Neuton': GoogleFonts.neutonTextTheme,
        'New Rocker': GoogleFonts.newRockerTextTheme,
        'New Tegomin': GoogleFonts.newTegominTextTheme,
        'News Cycle': GoogleFonts.newsCycleTextTheme,
        'Niconne': GoogleFonts.niconneTextTheme,
        'Niramit': GoogleFonts.niramitTextTheme,
        'Nixie One': GoogleFonts.nixieOneTextTheme,
        'Nobile': GoogleFonts.nobileTextTheme,
        'Norican': GoogleFonts.noricanTextTheme,
        'Nosifer': GoogleFonts.nosiferTextTheme,
        'Notable': GoogleFonts.notableTextTheme,
        'Nothing You Could Do': GoogleFonts.nothingYouCouldDoTextTheme,
        'Noticia Text': GoogleFonts.noticiaTextTextTheme,
        'Noto Color Emoji Compat': GoogleFonts.notoColorEmojiCompatTextTheme,
        'Noto Kufi Arabic': GoogleFonts.notoKufiArabicTextTheme,
        'Noto Music': GoogleFonts.notoMusicTextTheme,
        'Noto Naskh Arabic': GoogleFonts.notoNaskhArabicTextTheme,
        'Noto Nastaliq Urdu': GoogleFonts.notoNastaliqUrduTextTheme,
        'Noto Rashi Hebrew': GoogleFonts.notoRashiHebrewTextTheme,
        'Noto Sans': GoogleFonts.notoSansTextTheme,
        'Noto Sans Adlam': GoogleFonts.notoSansAdlamTextTheme,
        'Noto Sans Adlam Unjoined': GoogleFonts.notoSansAdlamUnjoinedTextTheme,
        'Noto Sans Anatolian Hieroglyphs':
            GoogleFonts.notoSansAnatolianHieroglyphsTextTheme,
        'Noto Sans Arabic': GoogleFonts.notoSansArabicTextTheme,
        'Noto Sans Armenian': GoogleFonts.notoSansArmenianTextTheme,
        'Noto Sans Avestan': GoogleFonts.notoSansAvestanTextTheme,
        'Noto Sans Balinese': GoogleFonts.notoSansBalineseTextTheme,
        'Noto Sans Bamum': GoogleFonts.notoSansBamumTextTheme,
        'Noto Sans Bassa Vah': GoogleFonts.notoSansBassaVahTextTheme,
        'Noto Sans Batak': GoogleFonts.notoSansBatakTextTheme,
        'Noto Sans Bengali': GoogleFonts.notoSansBengaliTextTheme,
        'Noto Sans Bhaiksuki': GoogleFonts.notoSansBhaiksukiTextTheme,
        'Noto Sans Brahmi': GoogleFonts.notoSansBrahmiTextTheme,
        'Noto Sans Buginese': GoogleFonts.notoSansBugineseTextTheme,
        'Noto Sans Buhid': GoogleFonts.notoSansBuhidTextTheme,
        'Noto Sans Canadian Aboriginal':
            GoogleFonts.notoSansCanadianAboriginalTextTheme,
        'Noto Sans Carian': GoogleFonts.notoSansCarianTextTheme,
        'Noto Sans Caucasian Albanian':
            GoogleFonts.notoSansCaucasianAlbanianTextTheme,
        'Noto Sans Chakma': GoogleFonts.notoSansChakmaTextTheme,
        'Noto Sans Cham': GoogleFonts.notoSansChamTextTheme,
        'Noto Sans Cherokee': GoogleFonts.notoSansCherokeeTextTheme,
        'Noto Sans Coptic': GoogleFonts.notoSansCopticTextTheme,
        'Noto Sans Cuneiform': GoogleFonts.notoSansCuneiformTextTheme,
        'Noto Sans Cypriot': GoogleFonts.notoSansCypriotTextTheme,
        'Noto Sans Deseret': GoogleFonts.notoSansDeseretTextTheme,
        'Noto Sans Devanagari': GoogleFonts.notoSansDevanagariTextTheme,
        'Noto Sans Display': GoogleFonts.notoSansDisplayTextTheme,
        'Noto Sans Duployan': GoogleFonts.notoSansDuployanTextTheme,
        'Noto Sans Egyptian Hieroglyphs':
            GoogleFonts.notoSansEgyptianHieroglyphsTextTheme,
        'Noto Sans Elbasan': GoogleFonts.notoSansElbasanTextTheme,
        'Noto Sans Elymaic': GoogleFonts.notoSansElymaicTextTheme,
        'Noto Sans Georgian': GoogleFonts.notoSansGeorgianTextTheme,
        'Noto Sans Glagolitic': GoogleFonts.notoSansGlagoliticTextTheme,
        'Noto Sans Gothic': GoogleFonts.notoSansGothicTextTheme,
        'Noto Sans Grantha': GoogleFonts.notoSansGranthaTextTheme,
        'Noto Sans Gujarati': GoogleFonts.notoSansGujaratiTextTheme,
        'Noto Sans Gunjala Gondi': GoogleFonts.notoSansGunjalaGondiTextTheme,
        'Noto Sans Gurmukhi': GoogleFonts.notoSansGurmukhiTextTheme,
        'Noto Sans Hanifi Rohingya':
            GoogleFonts.notoSansHanifiRohingyaTextTheme,
        'Noto Sans Hanunoo': GoogleFonts.notoSansHanunooTextTheme,
        'Noto Sans Hatran': GoogleFonts.notoSansHatranTextTheme,
        'Noto Sans Hebrew': GoogleFonts.notoSansHebrewTextTheme,
        'Noto Sans Imperial Aramaic':
            GoogleFonts.notoSansImperialAramaicTextTheme,
        'Noto Sans Indic Siyaq Numbers':
            GoogleFonts.notoSansIndicSiyaqNumbersTextTheme,
        'Noto Sans Inscriptional Pahlavi':
            GoogleFonts.notoSansInscriptionalPahlaviTextTheme,
        'Noto Sans Inscriptional Parthian':
            GoogleFonts.notoSansInscriptionalParthianTextTheme,
        'Noto Sans Javanese': GoogleFonts.notoSansJavaneseTextTheme,
        'Noto Sans Kaithi': GoogleFonts.notoSansKaithiTextTheme,
        'Noto Sans Kannada': GoogleFonts.notoSansKannadaTextTheme,
        'Noto Sans Kayah Li': GoogleFonts.notoSansKayahLiTextTheme,
        'Noto Sans Kharoshthi': GoogleFonts.notoSansKharoshthiTextTheme,
        'Noto Sans Khmer': GoogleFonts.notoSansKhmerTextTheme,
        'Noto Sans Khojki': GoogleFonts.notoSansKhojkiTextTheme,
        'Noto Sans Khudawadi': GoogleFonts.notoSansKhudawadiTextTheme,
        'Noto Sans Lao': GoogleFonts.notoSansLaoTextTheme,
        'Noto Sans Lepcha': GoogleFonts.notoSansLepchaTextTheme,
        'Noto Sans Limbu': GoogleFonts.notoSansLimbuTextTheme,
        'Noto Sans Linear A': GoogleFonts.notoSansLinearATextTheme,
        'Noto Sans Linear B': GoogleFonts.notoSansLinearBTextTheme,
        'Noto Sans Lisu': GoogleFonts.notoSansLisuTextTheme,
        'Noto Sans Lycian': GoogleFonts.notoSansLycianTextTheme,
        'Noto Sans Lydian': GoogleFonts.notoSansLydianTextTheme,
        'Noto Sans Mahajani': GoogleFonts.notoSansMahajaniTextTheme,
        'Noto Sans Malayalam': GoogleFonts.notoSansMalayalamTextTheme,
        'Noto Sans Mandaic': GoogleFonts.notoSansMandaicTextTheme,
        'Noto Sans Manichaean': GoogleFonts.notoSansManichaeanTextTheme,
        'Noto Sans Marchen': GoogleFonts.notoSansMarchenTextTheme,
        'Noto Sans Masaram Gondi': GoogleFonts.notoSansMasaramGondiTextTheme,
        'Noto Sans Math': GoogleFonts.notoSansMathTextTheme,
        'Noto Sans Mayan Numerals': GoogleFonts.notoSansMayanNumeralsTextTheme,
        'Noto Sans Medefaidrin': GoogleFonts.notoSansMedefaidrinTextTheme,
        'Noto Sans Meetei Mayek': GoogleFonts.notoSansMeeteiMayekTextTheme,
        'Noto Sans Meroitic': GoogleFonts.notoSansMeroiticTextTheme,
        'Noto Sans Miao': GoogleFonts.notoSansMiaoTextTheme,
        'Noto Sans Modi': GoogleFonts.notoSansModiTextTheme,
        'Noto Sans Mongolian': GoogleFonts.notoSansMongolianTextTheme,
        'Noto Sans Mono': GoogleFonts.notoSansMonoTextTheme,
        'Noto Sans Mro': GoogleFonts.notoSansMroTextTheme,
        'Noto Sans Multani': GoogleFonts.notoSansMultaniTextTheme,
        'Noto Sans Myanmar': GoogleFonts.notoSansMyanmarTextTheme,
        'Noto Sans N Ko': GoogleFonts.notoSansNKoTextTheme,
        'Noto Sans Nabataean': GoogleFonts.notoSansNabataeanTextTheme,
        'Noto Sans New Tai Lue': GoogleFonts.notoSansNewTaiLueTextTheme,
        'Noto Sans Newa': GoogleFonts.notoSansNewaTextTheme,
        'Noto Sans Nushu': GoogleFonts.notoSansNushuTextTheme,
        'Noto Sans Ogham': GoogleFonts.notoSansOghamTextTheme,
        'Noto Sans Ol Chiki': GoogleFonts.notoSansOlChikiTextTheme,
        'Noto Sans Old Hungarian': GoogleFonts.notoSansOldHungarianTextTheme,
        'Noto Sans Old Italic': GoogleFonts.notoSansOldItalicTextTheme,
        'Noto Sans Old North Arabian':
            GoogleFonts.notoSansOldNorthArabianTextTheme,
        'Noto Sans Old Permic': GoogleFonts.notoSansOldPermicTextTheme,
        'Noto Sans Old Persian': GoogleFonts.notoSansOldPersianTextTheme,
        'Noto Sans Old Sogdian': GoogleFonts.notoSansOldSogdianTextTheme,
        'Noto Sans Old South Arabian':
            GoogleFonts.notoSansOldSouthArabianTextTheme,
        'Noto Sans Old Turkic': GoogleFonts.notoSansOldTurkicTextTheme,
        'Noto Sans Oriya': GoogleFonts.notoSansOriyaTextTheme,
        'Noto Sans Osage': GoogleFonts.notoSansOsageTextTheme,
        'Noto Sans Osmanya': GoogleFonts.notoSansOsmanyaTextTheme,
        'Noto Sans Pahawh Hmong': GoogleFonts.notoSansPahawhHmongTextTheme,
        'Noto Sans Palmyrene': GoogleFonts.notoSansPalmyreneTextTheme,
        'Noto Sans Pau Cin Hau': GoogleFonts.notoSansPauCinHauTextTheme,
        'Noto Sans Phags Pa': GoogleFonts.notoSansPhagsPaTextTheme,
        'Noto Sans Phoenician': GoogleFonts.notoSansPhoenicianTextTheme,
        'Noto Sans Psalter Pahlavi':
            GoogleFonts.notoSansPsalterPahlaviTextTheme,
        'Noto Sans Rejang': GoogleFonts.notoSansRejangTextTheme,
        'Noto Sans Runic': GoogleFonts.notoSansRunicTextTheme,
        'Noto Sans Samaritan': GoogleFonts.notoSansSamaritanTextTheme,
        'Noto Sans Saurashtra': GoogleFonts.notoSansSaurashtraTextTheme,
        'Noto Sans Sharada': GoogleFonts.notoSansSharadaTextTheme,
        'Noto Sans Shavian': GoogleFonts.notoSansShavianTextTheme,
        'Noto Sans Siddham': GoogleFonts.notoSansSiddhamTextTheme,
        'Noto Sans Sinhala': GoogleFonts.notoSansSinhalaTextTheme,
        'Noto Sans Sogdian': GoogleFonts.notoSansSogdianTextTheme,
        'Noto Sans Sora Sompeng': GoogleFonts.notoSansSoraSompengTextTheme,
        'Noto Sans Soyombo': GoogleFonts.notoSansSoyomboTextTheme,
        'Noto Sans Sundanese': GoogleFonts.notoSansSundaneseTextTheme,
        'Noto Sans Syloti Nagri': GoogleFonts.notoSansSylotiNagriTextTheme,
        'Noto Sans Symbols': GoogleFonts.notoSansSymbolsTextTheme,
        'Noto Sans Symbols 2': GoogleFonts.notoSansSymbols2TextTheme,
        'Noto Sans Syriac': GoogleFonts.notoSansSyriacTextTheme,
        'Noto Sans Tagalog': GoogleFonts.notoSansTagalogTextTheme,
        'Noto Sans Tagbanwa': GoogleFonts.notoSansTagbanwaTextTheme,
        'Noto Sans Tai Le': GoogleFonts.notoSansTaiLeTextTheme,
        'Noto Sans Tai Tham': GoogleFonts.notoSansTaiThamTextTheme,
        'Noto Sans Tai Viet': GoogleFonts.notoSansTaiVietTextTheme,
        'Noto Sans Takri': GoogleFonts.notoSansTakriTextTheme,
        'Noto Sans Tamil': GoogleFonts.notoSansTamilTextTheme,
        'Noto Sans Tamil Supplement':
            GoogleFonts.notoSansTamilSupplementTextTheme,
        'Noto Sans Telugu': GoogleFonts.notoSansTeluguTextTheme,
        'Noto Sans Thaana': GoogleFonts.notoSansThaanaTextTheme,
        'Noto Sans Thai': GoogleFonts.notoSansThaiTextTheme,
        'Noto Sans Thai Looped': GoogleFonts.notoSansThaiLoopedTextTheme,
        'Noto Sans Tifinagh': GoogleFonts.notoSansTifinaghTextTheme,
        'Noto Sans Tirhuta': GoogleFonts.notoSansTirhutaTextTheme,
        'Noto Sans Ugaritic': GoogleFonts.notoSansUgariticTextTheme,
        'Noto Sans Vai': GoogleFonts.notoSansVaiTextTheme,
        'Noto Sans Wancho': GoogleFonts.notoSansWanchoTextTheme,
        'Noto Sans Warang Citi': GoogleFonts.notoSansWarangCitiTextTheme,
        'Noto Sans Yi': GoogleFonts.notoSansYiTextTheme,
        'Noto Sans Zanabazar Square':
            GoogleFonts.notoSansZanabazarSquareTextTheme,
        'Noto Serif': GoogleFonts.notoSerifTextTheme,
        'Noto Serif Ahom': GoogleFonts.notoSerifAhomTextTheme,
        'Noto Serif Armenian': GoogleFonts.notoSerifArmenianTextTheme,
        'Noto Serif Balinese': GoogleFonts.notoSerifBalineseTextTheme,
        'Noto Serif Bengali': GoogleFonts.notoSerifBengaliTextTheme,
        'Noto Serif Devanagari': GoogleFonts.notoSerifDevanagariTextTheme,
        'Noto Serif Display': GoogleFonts.notoSerifDisplayTextTheme,
        'Noto Serif Dogra': GoogleFonts.notoSerifDograTextTheme,
        'Noto Serif Ethiopic': GoogleFonts.notoSerifEthiopicTextTheme,
        'Noto Serif Georgian': GoogleFonts.notoSerifGeorgianTextTheme,
        'Noto Serif Grantha': GoogleFonts.notoSerifGranthaTextTheme,
        'Noto Serif Gujarati': GoogleFonts.notoSerifGujaratiTextTheme,
        'Noto Serif Gurmukhi': GoogleFonts.notoSerifGurmukhiTextTheme,
        'Noto Serif Hebrew': GoogleFonts.notoSerifHebrewTextTheme,
        'Noto Serif Kannada': GoogleFonts.notoSerifKannadaTextTheme,
        'Noto Serif Khmer': GoogleFonts.notoSerifKhmerTextTheme,
        'Noto Serif Lao': GoogleFonts.notoSerifLaoTextTheme,
        'Noto Serif Malayalam': GoogleFonts.notoSerifMalayalamTextTheme,
        'Noto Serif Myanmar': GoogleFonts.notoSerifMyanmarTextTheme,
        'Noto Serif Nyiakeng Puachue Hmong':
            GoogleFonts.notoSerifNyiakengPuachueHmongTextTheme,
        'Noto Serif Sinhala': GoogleFonts.notoSerifSinhalaTextTheme,
        'Noto Serif Tamil': GoogleFonts.notoSerifTamilTextTheme,
        'Noto Serif Tangut': GoogleFonts.notoSerifTangutTextTheme,
        'Noto Serif Telugu': GoogleFonts.notoSerifTeluguTextTheme,
        'Noto Serif Thai': GoogleFonts.notoSerifThaiTextTheme,
        'Noto Serif Tibetan': GoogleFonts.notoSerifTibetanTextTheme,
        'Noto Serif Yezidi': GoogleFonts.notoSerifYezidiTextTheme,
        'Noto Traditional Nushu': GoogleFonts.notoTraditionalNushuTextTheme,
        'Nova Cut': GoogleFonts.novaCutTextTheme,
        'Nova Flat': GoogleFonts.novaFlatTextTheme,
        'Nova Mono': GoogleFonts.novaMonoTextTheme,
        'Nova Oval': GoogleFonts.novaOvalTextTheme,
        'Nova Round': GoogleFonts.novaRoundTextTheme,
        'Nova Script': GoogleFonts.novaScriptTextTheme,
        'Nova Slim': GoogleFonts.novaSlimTextTheme,
        'Nova Square': GoogleFonts.novaSquareTextTheme,
        'Numans': GoogleFonts.numansTextTheme,
        'Nunito': GoogleFonts.nunitoTextTheme,
        'Nunito Sans': GoogleFonts.nunitoSansTextTheme,
        'Odibee Sans': GoogleFonts.odibeeSansTextTheme,
        'Odor Mean Chey': GoogleFonts.odorMeanCheyTextTheme,
        'Offside': GoogleFonts.offsideTextTheme,
        'Oi': GoogleFonts.oiTextTheme,
        'Old Standard TT': GoogleFonts.oldStandardTtTextTheme,
        'Oldenburg': GoogleFonts.oldenburgTextTheme,
        'Oleo Script': GoogleFonts.oleoScriptTextTheme,
        'Oleo Script Swash Caps': GoogleFonts.oleoScriptSwashCapsTextTheme,
        'Open Sans': GoogleFonts.openSansTextTheme,
        'Open Sans Condensed': GoogleFonts.openSansCondensedTextTheme,
        'Oranienbaum': GoogleFonts.oranienbaumTextTheme,
        'Orbitron': GoogleFonts.orbitronTextTheme,
        'Oregano': GoogleFonts.oreganoTextTheme,
        'Orienta': GoogleFonts.orientaTextTheme,
        'Original Surfer': GoogleFonts.originalSurferTextTheme,
        'Oswald': GoogleFonts.oswaldTextTheme,
        'Otomanopee One': GoogleFonts.otomanopeeOneTextTheme,
        'Outfit': GoogleFonts.outfitTextTheme,
        'Over the Rainbow': GoogleFonts.overTheRainbowTextTheme,
        'Overlock': GoogleFonts.overlockTextTheme,
        'Overlock SC': GoogleFonts.overlockScTextTheme,
        'Overpass': GoogleFonts.overpassTextTheme,
        'Overpass Mono': GoogleFonts.overpassMonoTextTheme,
        'Ovo': GoogleFonts.ovoTextTheme,
        'Oxanium': GoogleFonts.oxaniumTextTheme,
        'Oxygen': GoogleFonts.oxygenTextTheme,
        'Oxygen Mono': GoogleFonts.oxygenMonoTextTheme,
        'PT Mono': GoogleFonts.ptMonoTextTheme,
        'PT Sans': GoogleFonts.ptSansTextTheme,
        'PT Sans Caption': GoogleFonts.ptSansCaptionTextTheme,
        'PT Sans Narrow': GoogleFonts.ptSansNarrowTextTheme,
        'PT Serif': GoogleFonts.ptSerifTextTheme,
        'PT Serif Caption': GoogleFonts.ptSerifCaptionTextTheme,
        'Pacifico': GoogleFonts.pacificoTextTheme,
        'Padauk': GoogleFonts.padaukTextTheme,
        'Palanquin': GoogleFonts.palanquinTextTheme,
        'Palanquin Dark': GoogleFonts.palanquinDarkTextTheme,
        'Palette Mosaic': GoogleFonts.paletteMosaicTextTheme,
        'Pangolin': GoogleFonts.pangolinTextTheme,
        'Paprika': GoogleFonts.paprikaTextTheme,
        'Parisienne': GoogleFonts.parisienneTextTheme,
        'Passero One': GoogleFonts.passeroOneTextTheme,
        'Passion One': GoogleFonts.passionOneTextTheme,
        'Passions Conflict': GoogleFonts.passionsConflictTextTheme,
        'Pathway Gothic One': GoogleFonts.pathwayGothicOneTextTheme,
        'Patrick Hand': GoogleFonts.patrickHandTextTheme,
        'Patrick Hand SC': GoogleFonts.patrickHandScTextTheme,
        'Pattaya': GoogleFonts.pattayaTextTheme,
        'Patua One': GoogleFonts.patuaOneTextTheme,
        'Pavanam': GoogleFonts.pavanamTextTheme,
        'Paytone One': GoogleFonts.paytoneOneTextTheme,
        'Peddana': GoogleFonts.peddanaTextTheme,
        'Peralta': GoogleFonts.peraltaTextTheme,
        'Permanent Marker': GoogleFonts.permanentMarkerTextTheme,
        'Petemoss': GoogleFonts.petemossTextTheme,
        'Petit Formal Script': GoogleFonts.petitFormalScriptTextTheme,
        'Petrona': GoogleFonts.petronaTextTheme,
        'Philosopher': GoogleFonts.philosopherTextTheme,
        'Piazzolla': GoogleFonts.piazzollaTextTheme,
        'Piedra': GoogleFonts.piedraTextTheme,
        'Pinyon Script': GoogleFonts.pinyonScriptTextTheme,
        'Pirata One': GoogleFonts.pirataOneTextTheme,
        'Plaster': GoogleFonts.plasterTextTheme,
        'Play': GoogleFonts.playTextTheme,
        'Playball': GoogleFonts.playballTextTheme,
        'Playfair Display': GoogleFonts.playfairDisplayTextTheme,
        'Playfair Display SC': GoogleFonts.playfairDisplayScTextTheme,
        'Podkova': GoogleFonts.podkovaTextTheme,
        'Poiret One': GoogleFonts.poiretOneTextTheme,
        'Poller One': GoogleFonts.pollerOneTextTheme,
        'Poly': GoogleFonts.polyTextTheme,
        'Pompiere': GoogleFonts.pompiereTextTheme,
        'Pontano Sans': GoogleFonts.pontanoSansTextTheme,
        'Poor Story': GoogleFonts.poorStoryTextTheme,
        'Poppins': GoogleFonts.poppinsTextTheme,
        'Port Lligat Sans': GoogleFonts.portLligatSansTextTheme,
        'Port Lligat Slab': GoogleFonts.portLligatSlabTextTheme,
        'Potta One': GoogleFonts.pottaOneTextTheme,
        'Pragati Narrow': GoogleFonts.pragatiNarrowTextTheme,
        'Praise': GoogleFonts.praiseTextTheme,
        'Prata': GoogleFonts.prataTextTheme,
        'Press Start 2P': GoogleFonts.pressStart2pTextTheme,
        'Pridi': GoogleFonts.pridiTextTheme,
        'Princess Sofia': GoogleFonts.princessSofiaTextTheme,
        'Prociono': GoogleFonts.procionoTextTheme,
        'Prompt': GoogleFonts.promptTextTheme,
        'Prosto One': GoogleFonts.prostoOneTextTheme,
        'Proza Libre': GoogleFonts.prozaLibreTextTheme,
        'Public Sans': GoogleFonts.publicSansTextTheme,
        'Puppies Play': GoogleFonts.puppiesPlayTextTheme,
        'Puritan': GoogleFonts.puritanTextTheme,
        'Purple Purse': GoogleFonts.purplePurseTextTheme,
        'Pushster': GoogleFonts.pushsterTextTheme,
        'Qahiri': GoogleFonts.qahiriTextTheme,
        'Quando': GoogleFonts.quandoTextTheme,
        'Quantico': GoogleFonts.quanticoTextTheme,
        'Quattrocento': GoogleFonts.quattrocentoTextTheme,
        'Quattrocento Sans': GoogleFonts.quattrocentoSansTextTheme,
        'Questrial': GoogleFonts.questrialTextTheme,
        'Quicksand': GoogleFonts.quicksandTextTheme,
        'Quintessential': GoogleFonts.quintessentialTextTheme,
        'Qwigley': GoogleFonts.qwigleyTextTheme,
        'Racing Sans One': GoogleFonts.racingSansOneTextTheme,
        'Radley': GoogleFonts.radleyTextTheme,
        'Rajdhani': GoogleFonts.rajdhaniTextTheme,
        'Rakkas': GoogleFonts.rakkasTextTheme,
        'Raleway': GoogleFonts.ralewayTextTheme,
        'Raleway Dots': GoogleFonts.ralewayDotsTextTheme,
        'Ramabhadra': GoogleFonts.ramabhadraTextTheme,
        'Ramaraja': GoogleFonts.ramarajaTextTheme,
        'Rambla': GoogleFonts.ramblaTextTheme,
        'Rammetto One': GoogleFonts.rammettoOneTextTheme,
        'Rampart One': GoogleFonts.rampartOneTextTheme,
        'Ranchers': GoogleFonts.ranchersTextTheme,
        'Rancho': GoogleFonts.ranchoTextTheme,
        'Ranga': GoogleFonts.rangaTextTheme,
        'Rasa': GoogleFonts.rasaTextTheme,
        'Rationale': GoogleFonts.rationaleTextTheme,
        'Ravi Prakash': GoogleFonts.raviPrakashTextTheme,
        'Readex Pro': GoogleFonts.readexProTextTheme,
        'Recursive': GoogleFonts.recursiveTextTheme,
        'Red Hat Display': GoogleFonts.redHatDisplayTextTheme,
        'Red Hat Mono': GoogleFonts.redHatMonoTextTheme,
        'Red Hat Text': GoogleFonts.redHatTextTextTheme,
        'Red Rose': GoogleFonts.redRoseTextTheme,
        'Redacted': GoogleFonts.redactedTextTheme,
        'Redacted Script': GoogleFonts.redactedScriptTextTheme,
        'Redressed': GoogleFonts.redressedTextTheme,
        'Reem Kufi': GoogleFonts.reemKufiTextTheme,
        'Reenie Beanie': GoogleFonts.reenieBeanieTextTheme,
        'Reggae One': GoogleFonts.reggaeOneTextTheme,
        'Revalia': GoogleFonts.revaliaTextTheme,
        'Rhodium Libre': GoogleFonts.rhodiumLibreTextTheme,
        'Ribeye': GoogleFonts.ribeyeTextTheme,
        'Ribeye Marrow': GoogleFonts.ribeyeMarrowTextTheme,
        'Righteous': GoogleFonts.righteousTextTheme,
        'Risque': GoogleFonts.risqueTextTheme,
        'Road Rage': GoogleFonts.roadRageTextTheme,
        'Roboto': GoogleFonts.robotoTextTheme,
        'Roboto Condensed': GoogleFonts.robotoCondensedTextTheme,
        'Roboto Mono': GoogleFonts.robotoMonoTextTheme,
        'Roboto Slab': GoogleFonts.robotoSlabTextTheme,
        'Rochester': GoogleFonts.rochesterTextTheme,
        'Rock 3D': GoogleFonts.rock3dTextTheme,
        'Rock Salt': GoogleFonts.rockSaltTextTheme,
        'RocknRoll One': GoogleFonts.rocknRollOneTextTheme,
        'Rokkitt': GoogleFonts.rokkittTextTheme,
        'Romanesco': GoogleFonts.romanescoTextTheme,
        'Ropa Sans': GoogleFonts.ropaSansTextTheme,
        'Rosario': GoogleFonts.rosarioTextTheme,
        'Rosarivo': GoogleFonts.rosarivoTextTheme,
        'Rouge Script': GoogleFonts.rougeScriptTextTheme,
        'Rowdies': GoogleFonts.rowdiesTextTheme,
        'Rozha One': GoogleFonts.rozhaOneTextTheme,
        'Rubik': GoogleFonts.rubikTextTheme,
        'Rubik Beastly': GoogleFonts.rubikBeastlyTextTheme,
        'Rubik Mono One': GoogleFonts.rubikMonoOneTextTheme,
        'Ruda': GoogleFonts.rudaTextTheme,
        'Rufina': GoogleFonts.rufinaTextTheme,
        'Ruge Boogie': GoogleFonts.rugeBoogieTextTheme,
        'Ruluko': GoogleFonts.rulukoTextTheme,
        'Rum Raisin': GoogleFonts.rumRaisinTextTheme,
        'Ruslan Display': GoogleFonts.ruslanDisplayTextTheme,
        'Russo One': GoogleFonts.russoOneTextTheme,
        'Ruthie': GoogleFonts.ruthieTextTheme,
        'Rye': GoogleFonts.ryeTextTheme,
        'STIX Two Text': GoogleFonts.stixTwoTextTextTheme,
        'Sacramento': GoogleFonts.sacramentoTextTheme,
        'Sahitya': GoogleFonts.sahityaTextTheme,
        'Sail': GoogleFonts.sailTextTheme,
        'Saira': GoogleFonts.sairaTextTheme,
        'Saira Condensed': GoogleFonts.sairaCondensedTextTheme,
        'Saira Extra Condensed': GoogleFonts.sairaExtraCondensedTextTheme,
        'Saira Semi Condensed': GoogleFonts.sairaSemiCondensedTextTheme,
        'Saira Stencil One': GoogleFonts.sairaStencilOneTextTheme,
        'Salsa': GoogleFonts.salsaTextTheme,
        'Sanchez': GoogleFonts.sanchezTextTheme,
        'Sancreek': GoogleFonts.sancreekTextTheme,
        'Sansita': GoogleFonts.sansitaTextTheme,
        'Sansita Swashed': GoogleFonts.sansitaSwashedTextTheme,
        'Sarabun': GoogleFonts.sarabunTextTheme,
        'Sarala': GoogleFonts.saralaTextTheme,
        'Sarina': GoogleFonts.sarinaTextTheme,
        'Sarpanch': GoogleFonts.sarpanchTextTheme,
        'Sassy Frass': GoogleFonts.sassyFrassTextTheme,
        'Satisfy': GoogleFonts.satisfyTextTheme,
        'Sawarabi Gothic': GoogleFonts.sawarabiGothicTextTheme,
        'Sawarabi Mincho': GoogleFonts.sawarabiMinchoTextTheme,
        'Scada': GoogleFonts.scadaTextTheme,
        'Scheherazade': GoogleFonts.scheherazadeTextTheme,
        'Scheherazade New': GoogleFonts.scheherazadeNewTextTheme,
        'Schoolbell': GoogleFonts.schoolbellTextTheme,
        'Scope One': GoogleFonts.scopeOneTextTheme,
        'Seaweed Script': GoogleFonts.seaweedScriptTextTheme,
        'Secular One': GoogleFonts.secularOneTextTheme,
        'Sedgwick Ave': GoogleFonts.sedgwickAveTextTheme,
        'Sedgwick Ave Display': GoogleFonts.sedgwickAveDisplayTextTheme,
        'Sen': GoogleFonts.senTextTheme,
        'Sevillana': GoogleFonts.sevillanaTextTheme,
        'Seymour One': GoogleFonts.seymourOneTextTheme,
        'Shadows Into Light': GoogleFonts.shadowsIntoLightTextTheme,
        'Shadows Into Light Two': GoogleFonts.shadowsIntoLightTwoTextTheme,
        'Shalimar': GoogleFonts.shalimarTextTheme,
        'Shanti': GoogleFonts.shantiTextTheme,
        'Share': GoogleFonts.shareTextTheme,
        'Share Tech': GoogleFonts.shareTechTextTheme,
        'Share Tech Mono': GoogleFonts.shareTechMonoTextTheme,
        'Shippori Antique': GoogleFonts.shipporiAntiqueTextTheme,
        'Shippori Antique B1': GoogleFonts.shipporiAntiqueB1TextTheme,
        'Shippori Mincho': GoogleFonts.shipporiMinchoTextTheme,
        'Shippori Mincho B1': GoogleFonts.shipporiMinchoB1TextTheme,
        'Shizuru': GoogleFonts.shizuruTextTheme,
        'Shojumaru': GoogleFonts.shojumaruTextTheme,
        'Short Stack': GoogleFonts.shortStackTextTheme,
        'Shrikhand': GoogleFonts.shrikhandTextTheme,
        'Sigmar One': GoogleFonts.sigmarOneTextTheme,
        'Signika': GoogleFonts.signikaTextTheme,
        'Signika Negative': GoogleFonts.signikaNegativeTextTheme,
        'Simonetta': GoogleFonts.simonettaTextTheme,
        'Single Day': GoogleFonts.singleDayTextTheme,
        'Sintony': GoogleFonts.sintonyTextTheme,
        'Sirin Stencil': GoogleFonts.sirinStencilTextTheme,
        'Six Caps': GoogleFonts.sixCapsTextTheme,
        'Skranji': GoogleFonts.skranjiTextTheme,
        'Slabo 13px': GoogleFonts.slabo13pxTextTheme,
        'Slabo 27px': GoogleFonts.slabo27pxTextTheme,
        'Slackey': GoogleFonts.slackeyTextTheme,
        'Smokum': GoogleFonts.smokumTextTheme,
        'Smooch': GoogleFonts.smoochTextTheme,
        'Smythe': GoogleFonts.smytheTextTheme,
        'Sniglet': GoogleFonts.snigletTextTheme,
        'Snippet': GoogleFonts.snippetTextTheme,
        'Snowburst One': GoogleFonts.snowburstOneTextTheme,
        'Sofadi One': GoogleFonts.sofadiOneTextTheme,
        'Sofia': GoogleFonts.sofiaTextTheme,
        'Solway': GoogleFonts.solwayTextTheme,
        'Song Myung': GoogleFonts.songMyungTextTheme,
        'Sonsie One': GoogleFonts.sonsieOneTextTheme,
        'Sora': GoogleFonts.soraTextTheme,
        'Sorts Mill Goudy': GoogleFonts.sortsMillGoudyTextTheme,
        'Source Code Pro': GoogleFonts.sourceCodeProTextTheme,
        'Source Sans 3': GoogleFonts.sourceSans3TextTheme,
        'Source Sans Pro': GoogleFonts.sourceSansProTextTheme,
        'Source Serif Pro': GoogleFonts.sourceSerifProTextTheme,
        'Space Grotesk': GoogleFonts.spaceGroteskTextTheme,
        'Space Mono': GoogleFonts.spaceMonoTextTheme,
        'Spartan': GoogleFonts.spartanTextTheme,
        'Special Elite': GoogleFonts.specialEliteTextTheme,
        'Spectral': GoogleFonts.spectralTextTheme,
        'Spectral SC': GoogleFonts.spectralScTextTheme,
        'Spicy Rice': GoogleFonts.spicyRiceTextTheme,
        'Spinnaker': GoogleFonts.spinnakerTextTheme,
        'Spirax': GoogleFonts.spiraxTextTheme,
        'Squada One': GoogleFonts.squadaOneTextTheme,
        'Sree Krushnadevaraya': GoogleFonts.sreeKrushnadevarayaTextTheme,
        'Sriracha': GoogleFonts.srirachaTextTheme,
        'Srisakdi': GoogleFonts.srisakdiTextTheme,
        'Staatliches': GoogleFonts.staatlichesTextTheme,
        'Stalemate': GoogleFonts.stalemateTextTheme,
        'Stalinist One': GoogleFonts.stalinistOneTextTheme,
        'Stardos Stencil': GoogleFonts.stardosStencilTextTheme,
        'Stick': GoogleFonts.stickTextTheme,
        'Stick No Bills': GoogleFonts.stickNoBillsTextTheme,
        'Stint Ultra Condensed': GoogleFonts.stintUltraCondensedTextTheme,
        'Stint Ultra Expanded': GoogleFonts.stintUltraExpandedTextTheme,
        'Stoke': GoogleFonts.stokeTextTheme,
        'Strait': GoogleFonts.straitTextTheme,
        'Style Script': GoogleFonts.styleScriptTextTheme,
        'Stylish': GoogleFonts.stylishTextTheme,
        'Sue Ellen Francisco': GoogleFonts.sueEllenFranciscoTextTheme,
        'Suez One': GoogleFonts.suezOneTextTheme,
        'Sulphur Point': GoogleFonts.sulphurPointTextTheme,
        'Sumana': GoogleFonts.sumanaTextTheme,
        'Sunflower': GoogleFonts.sunflowerTextTheme,
        'Sunshiney': GoogleFonts.sunshineyTextTheme,
        'Supermercado One': GoogleFonts.supermercadoOneTextTheme,
        'Sura': GoogleFonts.suraTextTheme,
        'Suranna': GoogleFonts.surannaTextTheme,
        'Suravaram': GoogleFonts.suravaramTextTheme,
        'Swanky and Moo Moo': GoogleFonts.swankyAndMooMooTextTheme,
        'Syncopate': GoogleFonts.syncopateTextTheme,
        'Syne': GoogleFonts.syneTextTheme,
        'Syne Mono': GoogleFonts.syneMonoTextTheme,
        'Syne Tactile': GoogleFonts.syneTactileTextTheme,
        'Tajawal': GoogleFonts.tajawalTextTheme,
        'Tangerine': GoogleFonts.tangerineTextTheme,
        'Tauri': GoogleFonts.tauriTextTheme,
        'Taviraj': GoogleFonts.tavirajTextTheme,
        'Teko': GoogleFonts.tekoTextTheme,
        'Telex': GoogleFonts.telexTextTheme,
        'Tenali Ramakrishna': GoogleFonts.tenaliRamakrishnaTextTheme,
        'Tenor Sans': GoogleFonts.tenorSansTextTheme,
        'Text Me One': GoogleFonts.textMeOneTextTheme,
        'Thasadith': GoogleFonts.thasadithTextTheme,
        'The Girl Next Door': GoogleFonts.theGirlNextDoorTextTheme,
        'Tienne': GoogleFonts.tienneTextTheme,
        'Tillana': GoogleFonts.tillanaTextTheme,
        'Timmana': GoogleFonts.timmanaTextTheme,
        'Tinos': GoogleFonts.tinosTextTheme,
        'Titan One': GoogleFonts.titanOneTextTheme,
        'Titillium Web': GoogleFonts.titilliumWebTextTheme,
        'Tomorrow': GoogleFonts.tomorrowTextTheme,
        'Tourney': GoogleFonts.tourneyTextTheme,
        'Trade Winds': GoogleFonts.tradeWindsTextTheme,
        'Train One': GoogleFonts.trainOneTextTheme,
        'Trirong': GoogleFonts.trirongTextTheme,
        'Trispace': GoogleFonts.trispaceTextTheme,
        'Trocchi': GoogleFonts.trocchiTextTheme,
        'Trochut': GoogleFonts.trochutTextTheme,
        'Trykker': GoogleFonts.trykkerTextTheme,
        'Tulpen One': GoogleFonts.tulpenOneTextTheme,
        'Turret Road': GoogleFonts.turretRoadTextTheme,
        'Ubuntu': GoogleFonts.ubuntuTextTheme,
        'Ubuntu Condensed': GoogleFonts.ubuntuCondensedTextTheme,
        'Ubuntu Mono': GoogleFonts.ubuntuMonoTextTheme,
        'Uchen': GoogleFonts.uchenTextTheme,
        'Ultra': GoogleFonts.ultraTextTheme,
        'Uncial Antiqua': GoogleFonts.uncialAntiquaTextTheme,
        'Underdog': GoogleFonts.underdogTextTheme,
        'Unica One': GoogleFonts.unicaOneTextTheme,
        'UnifrakturCook': GoogleFonts.unifrakturCookTextTheme,
        'UnifrakturMaguntia': GoogleFonts.unifrakturMaguntiaTextTheme,
        'Unkempt': GoogleFonts.unkemptTextTheme,
        'Unlock': GoogleFonts.unlockTextTheme,
        'Unna': GoogleFonts.unnaTextTheme,
        'Urbanist': GoogleFonts.urbanistTextTheme,
        'VT323': GoogleFonts.vt323TextTheme,
        'Vampiro One': GoogleFonts.vampiroOneTextTheme,
        'Varela': GoogleFonts.varelaTextTheme,
        'Varela Round': GoogleFonts.varelaRoundTextTheme,
        'Varta': GoogleFonts.vartaTextTheme,
        'Vast Shadow': GoogleFonts.vastShadowTextTheme,
        'Vesper Libre': GoogleFonts.vesperLibreTextTheme,
        'Viaoda Libre': GoogleFonts.viaodaLibreTextTheme,
        'Vibes': GoogleFonts.vibesTextTheme,
        'Vibur': GoogleFonts.viburTextTheme,
        'Vidaloka': GoogleFonts.vidalokaTextTheme,
        'Viga': GoogleFonts.vigaTextTheme,
        'Voces': GoogleFonts.vocesTextTheme,
        'Volkhov': GoogleFonts.volkhovTextTheme,
        'Vollkorn': GoogleFonts.vollkornTextTheme,
        'Vollkorn SC': GoogleFonts.vollkornScTextTheme,
        'Voltaire': GoogleFonts.voltaireTextTheme,
        'Waiting for the Sunrise': GoogleFonts.waitingForTheSunriseTextTheme,
        'Wallpoet': GoogleFonts.wallpoetTextTheme,
        'Walter Turncoat': GoogleFonts.walterTurncoatTextTheme,
        'Warnes': GoogleFonts.warnesTextTheme,
        'Wellfleet': GoogleFonts.wellfleetTextTheme,
        'Wendy One': GoogleFonts.wendyOneTextTheme,
        'WindSong': GoogleFonts.windSongTextTheme,
        'Wire One': GoogleFonts.wireOneTextTheme,
        'Work Sans': GoogleFonts.workSansTextTheme,
        'Xanh Mono': GoogleFonts.xanhMonoTextTheme,
        'Yaldevi': GoogleFonts.yaldeviTextTheme,
        'Yanone Kaffeesatz': GoogleFonts.yanoneKaffeesatzTextTheme,
        'Yantramanav': GoogleFonts.yantramanavTextTheme,
        'Yatra One': GoogleFonts.yatraOneTextTheme,
        'Yellowtail': GoogleFonts.yellowtailTextTheme,
        'Yeon Sung': GoogleFonts.yeonSungTextTheme,
        'Yeseva One': GoogleFonts.yesevaOneTextTheme,
        'Yesteryear': GoogleFonts.yesteryearTextTheme,
        'Yomogi': GoogleFonts.yomogiTextTheme,
        'Yrsa': GoogleFonts.yrsaTextTheme,
        'Yuji Boku': GoogleFonts.yujiBokuTextTheme,
        'Yuji Hentaigana Akari': GoogleFonts.yujiHentaiganaAkariTextTheme,
        'Yuji Hentaigana Akebono': GoogleFonts.yujiHentaiganaAkebonoTextTheme,
        'Yuji Mai': GoogleFonts.yujiMaiTextTheme,
        'Yuji Syuku': GoogleFonts.yujiSyukuTextTheme,
        'Yusei Magic': GoogleFonts.yuseiMagicTextTheme,
        'ZCOOL KuaiLe': GoogleFonts.zcoolKuaiLeTextTheme,
        'ZCOOL QingKe HuangYou': GoogleFonts.zcoolQingKeHuangYouTextTheme,
        'ZCOOL XiaoWei': GoogleFonts.zcoolXiaoWeiTextTheme,
        'Zen Antique': GoogleFonts.zenAntiqueTextTheme,
        'Zen Antique Soft': GoogleFonts.zenAntiqueSoftTextTheme,
        'Zen Kaku Gothic Antique': GoogleFonts.zenKakuGothicAntiqueTextTheme,
        'Zen Kaku Gothic New': GoogleFonts.zenKakuGothicNewTextTheme,
        'Zen Kurenaido': GoogleFonts.zenKurenaidoTextTheme,
        'Zen Loop': GoogleFonts.zenLoopTextTheme,
        'Zen Maru Gothic': GoogleFonts.zenMaruGothicTextTheme,
        'Zen Old Mincho': GoogleFonts.zenOldMinchoTextTheme,
        'Zen Tokyo Zoo': GoogleFonts.zenTokyoZooTextTheme,
        'Zeyada': GoogleFonts.zeyadaTextTheme,
        'Zhi Mang Xing': GoogleFonts.zhiMangXingTextTheme,
        'Zilla Slab': GoogleFonts.zillaSlabTextTheme,
        'Zilla Slab Highlight': GoogleFonts.zillaSlabHighlightTextTheme,
      };

  /// Retrieve a font by family name.
  ///
  /// Applies the given font family from Google Fonts to the given [textStyle]
  /// and returns the resulting [TextStyle].
  ///
  /// Note: [fontFamily] is case-sensitive.
  ///
  /// Parameter [fontFamily] must not be `null`. Throws if no font by name
  /// [fontFamily] exists.
  static TextStyle getFont(
    String fontFamily, {
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = GoogleFonts.asMap();
    if (!fonts.containsKey(fontFamily)) {
      throw Exception("No font family by name '$fontFamily' was found.");
    }
    return fonts[fontFamily]!(
      textStyle: textStyle,
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
    );
  }

  /// Retrieve a text theme by its font family name.
  ///
  /// Applies the given font family from Google Fonts to the given [textTheme]
  /// and returns the resulting [textTheme].
  ///
  /// Note: [fontFamily] is case-sensitive.
  ///
  /// Parameter [fontFamily] must not be `null`. Throws if no font by name
  /// [fontFamily] exists.
  static TextTheme getTextTheme(String fontFamily, [TextTheme? textTheme]) {
    final fonts = _asMapOfTextThemes();
    if (!fonts.containsKey(fontFamily)) {
      throw Exception("No font family by name '$fontFamily' was found.");
    }
    return fonts[fontFamily]!(textTheme);
  }

  /// Applies the ABeeZee font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ABeeZee
  static TextStyle aBeeZee({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ff99dd1bd594806e1b9f7423a75f1c1dfbbbcddb2698b3ab91f5709b1b90caf',
        29632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8654a417521bf7fa4ffd1a7f7b62648648c5415ff0f7e0d53474e4436d049b7a',
        30984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ABeeZee',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the ABeeZee font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ABeeZee
  static TextTheme aBeeZeeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.aBeeZee(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.aBeeZee(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.aBeeZee(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.aBeeZee(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.aBeeZee(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.aBeeZee(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aBeeZee(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aBeeZee(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aBeeZee(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aBeeZee(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aBeeZee(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aBeeZee(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aBeeZee(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aBeeZee(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aBeeZee(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Abel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abel
  static TextStyle abel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '37a44f872ce09b8a93244abfaf3741aa8e4da7cbf64de118635a7cf1c7bc1d5e',
        34924,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Abel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abel
  static TextTheme abelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.abel(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.abel(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.abel(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.abel(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.abel(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.abel(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.abel(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.abel(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.abel(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.abel(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.abel(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.abel(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.abel(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.abel(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.abel(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Abhaya Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abhaya+Libre
  static TextStyle abhayaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8e1a260e8a56f8cdb2e2401be9e3a6903026becbf134336b9c8f6b2e2490cd5',
        282252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff52a780878fd838b81f8c96e548f49d7bbd4f92cb0a3dc68eb3f852ca3f3fd4',
        282512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3be63e1c52229673f453da3c6abd79dc0011d02fd57da38489880434556aa77',
        281648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c7bdb109ab0e98ef91a41ec55825dcb97c2ea2e9274c67dde899104f5b59878',
        281252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9457be94f81fc73b59af3e850d0dcb91790d60078cbdc252da50881c615173aa',
        280484,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AbhayaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abhaya Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abhaya+Libre
  static TextTheme abhayaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.abhayaLibre(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.abhayaLibre(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.abhayaLibre(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.abhayaLibre(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.abhayaLibre(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.abhayaLibre(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.abhayaLibre(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.abhayaLibre(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.abhayaLibre(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.abhayaLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.abhayaLibre(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.abhayaLibre(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.abhayaLibre(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.abhayaLibre(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.abhayaLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Abril Fatface font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abril+Fatface
  static TextStyle abrilFatface({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2baf7b134013a2183457312f0d26115640d0171829d024dfb1466616a3ac789a',
        67316,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AbrilFatface',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abril Fatface font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abril+Fatface
  static TextTheme abrilFatfaceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.abrilFatface(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.abrilFatface(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.abrilFatface(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.abrilFatface(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.abrilFatface(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.abrilFatface(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.abrilFatface(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.abrilFatface(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.abrilFatface(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.abrilFatface(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.abrilFatface(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.abrilFatface(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.abrilFatface(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.abrilFatface(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.abrilFatface(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aclonica font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aclonica
  static TextStyle aclonica({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e26afc4582406a86fc1e1b81aad6e16a03f9276419fa76e91b98f9e42d868cc8',
        68136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aclonica',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aclonica font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aclonica
  static TextTheme aclonicaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.aclonica(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.aclonica(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.aclonica(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.aclonica(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.aclonica(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.aclonica(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aclonica(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aclonica(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aclonica(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aclonica(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aclonica(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aclonica(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aclonica(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aclonica(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aclonica(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Acme font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Acme
  static TextStyle acme({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7d0b4054bd37012deca722e47899589c1d35302b51b2fd21ea83e7f3410bccd',
        23028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Acme',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Acme font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Acme
  static TextTheme acmeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.acme(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.acme(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.acme(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.acme(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.acme(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.acme(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.acme(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.acme(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.acme(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.acme(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.acme(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.acme(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.acme(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.acme(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.acme(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Actor font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Actor
  static TextStyle actor({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '417b785d001974cb097e1f84b068ed6f47fa9c5317bf90801a55709954b59350',
        42356,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Actor',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Actor font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Actor
  static TextTheme actorTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.actor(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.actor(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.actor(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.actor(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.actor(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.actor(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.actor(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.actor(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.actor(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.actor(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.actor(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.actor(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.actor(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.actor(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.actor(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Adamina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Adamina
  static TextStyle adamina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c241502ff8869d44e310b4e1782d5ca6f53b2d1844593bb0a360e12af0ddfcb1',
        76672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Adamina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Adamina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Adamina
  static TextTheme adaminaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.adamina(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.adamina(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.adamina(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.adamina(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.adamina(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.adamina(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.adamina(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.adamina(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.adamina(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.adamina(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.adamina(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.adamina(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.adamina(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.adamina(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.adamina(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Advent Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Advent+Pro
  static TextStyle adventPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4041ce69b488624d0653057137ff69ead9c9496be2059ede6a5056fd48780850',
        46400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '20f54f798dd883fc2fab8294006f8201f1deed59b0abd0ad6c6864bb0062eb47',
        46424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '23462d311ba53dbeac614ad5c99742d75264652538c2aaaea50fa3f9a37c1111',
        46356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c7084224aa15f7d31683e67bc3107aa12f725f4d20a10e9b65bbcec912162191',
        46836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '21feddd6602a8e2daf17501cb32c4b27a26b6a357f3652ad357008c8a90f1646',
        51004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '908b9b388605933b6e469878f17c52da7e2cd9cd6c4ec72a3e12aa5a9c3b9b79',
        50772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '962b3ce8591b2ca225b23e65b3914233c576d21700e3f24c6b820230fe8424e0',
        55976,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AdventPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Advent Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Advent+Pro
  static TextTheme adventProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.adventPro(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.adventPro(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.adventPro(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.adventPro(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.adventPro(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.adventPro(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.adventPro(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.adventPro(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.adventPro(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.adventPro(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.adventPro(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.adventPro(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.adventPro(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.adventPro(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.adventPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aguafina Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aguafina+Script
  static TextStyle aguafinaScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '282b677fa945b70a3a5a57b8ffb8064638a07feb77edc68cf29591225bc7b5ce',
        47180,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AguafinaScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aguafina Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aguafina+Script
  static TextTheme aguafinaScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.aguafinaScript(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.aguafinaScript(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.aguafinaScript(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.aguafinaScript(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.aguafinaScript(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.aguafinaScript(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aguafinaScript(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aguafinaScript(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aguafinaScript(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aguafinaScript(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aguafinaScript(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aguafinaScript(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aguafinaScript(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aguafinaScript(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aguafinaScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Akaya Telivigala font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akaya+Telivigala
  static TextStyle akayaTelivigala({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fdfb2a47ec1652741ecd9f23c21e7407998e21b7ac68f5743ef8282f27241dc',
        319968,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AkayaTelivigala',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Akaya Telivigala font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akaya+Telivigala
  static TextTheme akayaTelivigalaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.akayaTelivigala(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.akayaTelivigala(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.akayaTelivigala(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.akayaTelivigala(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.akayaTelivigala(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.akayaTelivigala(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.akayaTelivigala(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Akronim font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akronim
  static TextStyle akronim({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb077a1601fc7353abf83d6f7e667b5c1ff47a853f2a90f466be1dd738f4e6a1',
        107340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Akronim',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Akronim font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akronim
  static TextTheme akronimTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.akronim(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.akronim(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.akronim(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.akronim(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.akronim(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.akronim(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.akronim(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.akronim(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.akronim(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.akronim(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.akronim(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.akronim(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.akronim(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.akronim(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.akronim(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aladin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aladin
  static TextStyle aladin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47e6aa68e0a6686d85005a8cd4e3c3055dc4828dc3b49d69fdf88f38491c8ae2',
        42112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aladin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aladin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aladin
  static TextTheme aladinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.aladin(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.aladin(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.aladin(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.aladin(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.aladin(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.aladin(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aladin(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aladin(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aladin(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aladin(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aladin(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aladin(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aladin(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aladin(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aladin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alata font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alata
  static TextStyle alata({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e69926cd849e08f0dfa58fa809a89d58262ec6a29e3dd4e2c59ea279301b12e',
        63264,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alata',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alata font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alata
  static TextTheme alataTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alata(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alata(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alata(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alata(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.alata(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alata(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alata(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alata(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alata(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alata(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alata(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alata(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alata(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alata(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alata(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alatsi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alatsi
  static TextStyle alatsi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7fa5a16b3bfdf1423bfccb98349fc2cee90ca48e42252467b9a36f5a3149622e',
        70056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alatsi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alatsi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alatsi
  static TextTheme alatsiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alatsi(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alatsi(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alatsi(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alatsi(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.alatsi(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alatsi(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alatsi(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alatsi(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alatsi(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alatsi(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alatsi(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alatsi(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alatsi(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alatsi(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alatsi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aldrich font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aldrich
  static TextStyle aldrich({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e288c81eacbaee70be6e11a25f4fb3bdaffcc0ea0449f285c94fc558e64335f4',
        27932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aldrich',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aldrich font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aldrich
  static TextTheme aldrichTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.aldrich(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.aldrich(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.aldrich(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.aldrich(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.aldrich(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.aldrich(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aldrich(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aldrich(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aldrich(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aldrich(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aldrich(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aldrich(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aldrich(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aldrich(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aldrich(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alef font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alef
  static TextStyle alef({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a50dedb5215d98f65036893675ded42762d4c7bdae624c71adb1ea584f5a1467',
        58300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'acbe7d381fcdbd3bca38351290cba306a1dde6549d74fbdef431ee9fcb60030d',
        59936,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alef',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alef font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alef
  static TextTheme alefTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alef(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alef(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alef(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alef(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.alef(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alef(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alef(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alef(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alef(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alef(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alef(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alef(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alef(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alef(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alef(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alegreya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya
  static TextStyle alegreya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '530d78cba23c5d8e261ae9447b431e1fa550f9dc6563540a0c400be3f7ee88ab',
        63708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'efba5f9b4495a2e911ec871cc4dfebb5dba60bc72d643c0dd346e8f90513f81a',
        61596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c00ad52d215d793be827a98a0661e13bbd3276c96c6aa5e6c8d71c9487a3da03',
        67268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bd912b8f7b092f81fc94ee9f3b769e57ecbb1a2443bfce7d405d2ad0c48c04b4',
        65700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f2d4a4c114f8e7ad762e764046f117bf954b1ba7797bbe6b6d754decc9bdbf99',
        62328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '01804c5bcb6aedbda393491d82c14328987c7fb66a6ef8c8313aed5d683d3dad',
        60620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alegreya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya
  static TextTheme alegreyaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alegreya(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alegreya(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alegreya(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alegreya(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.alegreya(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alegreya(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alegreya(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alegreya(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alegreya(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alegreya(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alegreya(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alegreya(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alegreya(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alegreya(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alegreya(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alegreya SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+SC
  static TextStyle alegreyaSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7449fd0507a0808ae452506eb8fb2fb46b4abe72f8f5d982b25c963ba93bc094',
        72748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6b36a9c6614f3cea8c2846f74b6823f8d3c5edd8a8b2319eccae142e3bb42738',
        73048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16e159f79c1929fa884f232e47d45cb0cc16a55a22b127359024868245f4a2d4',
        71836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6920f9042274d5d0b37753d233b86c7066a47d1cb94015d70ecbb9a76359faa7',
        72428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd591a36a0d78f0315b16c23983d84d6d8b4bbf8ea5b5879019cad423941d5990',
        70500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd312d023b86792b3a0f7cd9594498720cdb9feb7bec946d75a3f25f6580c19c7',
        71700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlegreyaSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+SC
  static TextTheme alegreyaScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alegreyaSc(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alegreyaSc(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alegreyaSc(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alegreyaSc(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alegreyaSc(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alegreyaSc(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alegreyaSc(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alegreyaSc(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alegreyaSc(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alegreyaSc(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alegreyaSc(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alegreyaSc(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alegreyaSc(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alegreyaSc(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alegreyaSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alegreya Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans
  static TextStyle alegreyaSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e4fc2370a575c44ada0a88565af306c9e5f6f863cd3e594f68fbecb64d6eb45',
        86800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dfad029fd95bc8e1e6f4aff5ca9a40f7ee01b7c42436068b1a609af1036de968',
        75952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f413bb7452d6c3127865026e765917685dde894f8130417ee32c5c22d3332a5a',
        88928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '53c675ca8ca26437bfdef9475e6be6a31d8f390904f2a25dc7f71ecacf749525',
        76244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5186af372dbc9306a0390c6a53c2b3ed7e398bf7e19390e4115779d9d4dcb9e0',
        90044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a1cf80b2ffea7f7a74c290c886e0853612aa20f2f2942a11b6221973a8b1125a',
        75740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b54080b02a55195adec0aed32ecb384095ddfef221504059e15682a59709d9a5',
        90304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '16b83ef0510db5d9b7adeb15a6bf505975df75012e3f04118c8384165bae4c4f',
        75644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'baf6cfdcdaeaff8ae1997ba5a87f7c43b4823b8e094097eb354fdaeb531c610e',
        90308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c3ea4ab25245b87d94c68e797ee68e472bf893023027f57d0dfb6aef204e650d',
        75464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2313ece3a1be01342c2f2b902904ce864b05c9ecf3a72e96580c84ed124b370c',
        90492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '296f24dc4713815e4ea5f25a60e938c00c6d94678ba90f140c4c4dcd5d3dae42',
        75552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1ae94a74aa4998c1ed777107095512b795dd19783a838e9eaffca2382405bf3',
        90324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '63fa7d406f209d33ac9020dc3209f61bda016b2e851b369e2475f6c77bd65111',
        75748,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlegreyaSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans
  static TextTheme alegreyaSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alegreyaSans(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.alegreyaSans(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alegreyaSans(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.alegreyaSans(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alegreyaSans(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.alegreyaSans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alegreyaSans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alegreyaSans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alegreyaSans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alegreyaSans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alegreyaSans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alegreyaSans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alegreyaSans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alegreyaSans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alegreyaSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alegreya Sans SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans+SC
  static TextStyle alegreyaSansSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f5b4f9e7531121c2163e92598f24222cdef538a04352553731f0c81f69c4227',
        77260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1a8c6b334dbb0663e1b509d268363d557f9d231f702c2fb6ffe0727c0bb374b5',
        67308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d94b7e8e30244280988269fbefbf776d08ff9ad0be6df4f620a6a5b7e0362f0',
        79488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ccd17db40859ba985ad048cea705168d600d36d89c00086787c0e0c4b3d82350',
        67492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2487f405a054a83c784021b2c8e860860b9243fb34fc64b7a5fd2250d68bf4f9',
        80884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b427017865c854fea91f74c2c65b73010299f090c4ce77e0854fac9a1de8bc0a',
        67168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'edb603dab26042252c435e746201e0f2f353dd09865130082f25072fb0969e0b',
        81296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'de77ecc3bedb1b421aebae8d44d23fc290cb7f252c8cd7eea6cc478ee69e13ec',
        67248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c46b10c450739d774b11b6e3d2f51e421d416b9a8174d249ad85973c5018894c',
        81476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '16e2233f43d03898a785024de868496150dfcba5754cec33d4e349b92c857453',
        67060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '356b90a20e5818313f51f03a05985f5c63745944a01aa92b78804caa0b7a4268',
        81900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '85eb333661be027f374e08a28cc4b0c394fa0052fc64197c5a96409168532e87',
        67216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '41a1bac96732155ce8415a0155d80de58383ab4223de540ad68c383f51b3cb5e',
        81560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7100fdd6d991e596021a3bc2578fd4eb74fb5bd5d7dfc6c30dcde981e6a27281',
        67304,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlegreyaSansSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya Sans SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans+SC
  static TextTheme alegreyaSansScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.alegreyaSansSc(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.alegreyaSansSc(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.alegreyaSansSc(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.alegreyaSansSc(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alegreyaSansSc(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.alegreyaSansSc(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alegreyaSansSc(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alegreyaSansSc(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alegreyaSansSc(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alegreyaSansSc(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alegreyaSansSc(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alegreyaSansSc(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alegreyaSansSc(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alegreyaSansSc(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alegreyaSansSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aleo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aleo
  static TextStyle aleo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8844034f7614859b836238cb530853c190b011335edbfc9fd9dbb15669134bcb',
        35800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9d41d1b8e554c18ef31b39cd96576f58048ab1dacd1e03dd349c3f471917ab43',
        45124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4124c4a19546d618079ccad928418735907b0eff5c68a0faf16b8fd3ec1d5bc2',
        65892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7662bf685a6bddd2908c8392229aac54817f3666c9915cec596880a13eef66c9',
        68788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd20df7d3bc69a847115b4c7f6de4db4d8aa878a8ad3ccc70a83b9beb9d29826c',
        60744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0277e97f9c04c3812b3987b151b56953251d09574f7f649b461074b2439a4026',
        64516,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aleo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aleo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aleo
  static TextTheme aleoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.aleo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.aleo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.aleo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.aleo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.aleo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.aleo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aleo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aleo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aleo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aleo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aleo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aleo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aleo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aleo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aleo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alex Brush font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alex+Brush
  static TextStyle alexBrush({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb8044f112b9878ec59f0825d91a9f011fc4925ce2272737c02ce2be161c3efd',
        48660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlexBrush',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alex Brush font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alex+Brush
  static TextTheme alexBrushTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alexBrush(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alexBrush(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alexBrush(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alexBrush(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alexBrush(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alexBrush(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alexBrush(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alexBrush(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alexBrush(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alexBrush(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alexBrush(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alexBrush(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alexBrush(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alexBrush(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alexBrush(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alfa Slab One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alfa+Slab+One
  static TextStyle alfaSlabOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7da478a94cb0f5cdf81dc70a08204fc3d9b097463f65a9108151851580dd9151',
        64824,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlfaSlabOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alfa Slab One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alfa+Slab+One
  static TextTheme alfaSlabOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alfaSlabOne(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.alfaSlabOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alfaSlabOne(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.alfaSlabOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alfaSlabOne(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.alfaSlabOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alfaSlabOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alfaSlabOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alfaSlabOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alfaSlabOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alfaSlabOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alfaSlabOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alfaSlabOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alfaSlabOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alfaSlabOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alice font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alice
  static TextStyle alice({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b09d7119f6ceba6b3b798683927d8bd51757498f4af762dc4509d1c76aafc6a3',
        95148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alice',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alice font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alice
  static TextTheme aliceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alice(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alice(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alice(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alice(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.alice(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alice(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alice(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alice(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alice(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alice(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alice(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alice(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alice(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alice(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alice(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alike font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike
  static TextStyle alike({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9683edf916072397bd15b9b312ff78533f85b4ac5598b5867733fb5670ed534',
        64584,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alike',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alike font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike
  static TextTheme alikeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alike(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alike(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alike(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alike(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.alike(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alike(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alike(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alike(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alike(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alike(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alike(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alike(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alike(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alike(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alike(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alike Angular font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike+Angular
  static TextStyle alikeAngular({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ae146a31a48840c579bbeefc31597a7c9b385c626ef8387ad461aeea8432452',
        97120,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlikeAngular',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alike Angular font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike+Angular
  static TextTheme alikeAngularTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alikeAngular(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.alikeAngular(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alikeAngular(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.alikeAngular(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alikeAngular(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.alikeAngular(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alikeAngular(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alikeAngular(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alikeAngular(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alikeAngular(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alikeAngular(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alikeAngular(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alikeAngular(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alikeAngular(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alikeAngular(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allan
  static TextStyle allan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83a268d06857cada4246725e7cc04eb4d7b87d19e6d4f44e745d33be739852fb',
        40992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b309341937b6f2a1893638c71f9877c70c658e6461e5b18011f9ab7f2782adc9',
        95644,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allan
  static TextTheme allanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.allan(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.allan(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.allan(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.allan(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.allan(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.allan(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.allan(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.allan(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.allan(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.allan(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.allan(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.allan(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.allan(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.allan(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.allan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allerta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta
  static TextStyle allerta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df4ce73d43a2a1eb976d66944a0555b8ab45b8848b9e9be9355d0f68a9373270',
        18844,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allerta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allerta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta
  static TextTheme allertaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.allerta(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.allerta(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.allerta(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.allerta(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.allerta(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.allerta(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.allerta(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.allerta(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.allerta(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.allerta(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.allerta(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.allerta(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.allerta(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.allerta(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.allerta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allerta Stencil font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta+Stencil
  static TextStyle allertaStencil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd43b315a156fb147d0bcd2dad6a682e5a23d388f0d12365c29c2d46fbf1e2c96',
        19512,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AllertaStencil',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allerta Stencil font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta+Stencil
  static TextTheme allertaStencilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.allertaStencil(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.allertaStencil(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.allertaStencil(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.allertaStencil(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.allertaStencil(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.allertaStencil(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.allertaStencil(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.allertaStencil(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.allertaStencil(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.allertaStencil(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.allertaStencil(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.allertaStencil(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.allertaStencil(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.allertaStencil(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.allertaStencil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allison font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allison
  static TextStyle allison({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd9a2afdaf9e19bae8275d7e758caa167d7378dd4def732cf707de5cb8da6c5c7',
        93716,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allison',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allison font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allison
  static TextTheme allisonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.allison(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.allison(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.allison(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.allison(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.allison(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.allison(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.allison(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.allison(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.allison(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.allison(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.allison(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.allison(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.allison(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.allison(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.allison(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allura font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allura
  static TextStyle allura({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '32adf6de6bc3ee14bedf4674a1020492d2c2e4a939883aa672ff9a31777f63ed',
        88036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allura',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allura font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allura
  static TextTheme alluraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.allura(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.allura(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.allura(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.allura(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.allura(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.allura(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.allura(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.allura(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.allura(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.allura(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.allura(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.allura(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.allura(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.allura(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.allura(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Almarai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almarai
  static TextStyle almarai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd65c40f0692b45d73302895b80e837f57f1b4e69a5d3255c3f186919eab23780',
        85828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b22529a81e051312110ae38c450d9b4f5474030f2275dc4574f26c8fcf5318e',
        85912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6cf3b7ecc9ac853f7071684fc5dfb22dd3a13f41901fee6aeb54cd9cc81d1126',
        85696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55d68f8e4adef1c44ed2dbc154537092c330112b9ac46a94338e58f08f02bcb6',
        86588,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Almarai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almarai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almarai
  static TextTheme almaraiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.almarai(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.almarai(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.almarai(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.almarai(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.almarai(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.almarai(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.almarai(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.almarai(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.almarai(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.almarai(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.almarai(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.almarai(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.almarai(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.almarai(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.almarai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Almendra font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra
  static TextStyle almendra({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '08fa6c15ee1bba267ec0f0f30bd11a5be545d922ebd057f450a702f87aa9aaa8',
        68696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd40d53b865a76778b1362d4e74f6c6294fbde5ae31f24f0173d9401c3fabcddc',
        35276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b0792b18907bbbe9c24855a75a53fc8ac926ae12e181ec5bbc70fae19df05bfa',
        36684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'eb34d628f80f6ab95c12f0ef6dd4138d2182b94042d615028af5353e58b9f1ee',
        35448,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Almendra',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almendra font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra
  static TextTheme almendraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.almendra(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.almendra(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.almendra(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.almendra(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.almendra(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.almendra(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.almendra(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.almendra(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.almendra(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.almendra(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.almendra(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.almendra(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.almendra(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.almendra(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.almendra(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Almendra Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+Display
  static TextStyle almendraDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a8aa056bca4ab7efab868e9b7a435eea1109abde7b232725b1e1b41cf482191a',
        39284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlmendraDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almendra Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+Display
  static TextTheme almendraDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.almendraDisplay(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.almendraDisplay(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.almendraDisplay(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.almendraDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.almendraDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.almendraDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.almendraDisplay(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.almendraDisplay(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.almendraDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.almendraDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.almendraDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.almendraDisplay(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.almendraDisplay(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.almendraDisplay(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.almendraDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Almendra SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+SC
  static TextStyle almendraSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '12f0d325f41e23a75aa0ddb706236e13487d31b43a77435817a684f239f324bd',
        36008,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlmendraSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almendra SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+SC
  static TextTheme almendraScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.almendraSc(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.almendraSc(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.almendraSc(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.almendraSc(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.almendraSc(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.almendraSc(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.almendraSc(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.almendraSc(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.almendraSc(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.almendraSc(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.almendraSc(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.almendraSc(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.almendraSc(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.almendraSc(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.almendraSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alumni Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans
  static TextStyle alumniSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '22cf960c3683bef122e824082ac2322f51a3f06b3ebe530f3f9c326b2a9ff3e4',
        52760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9731e3ddbd4f9e45d9617a086592b46e501e6d1d30f42f3ec01d7c8479ec678d',
        52972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6917c8b390c96e08dd157f34e19ded5de00d7a3d302d89e4ab24bcc8d3eb79b0',
        52868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aeb6dbddb889269b4be32a085aa1f941c2098c131fc7928b83b4462ac77d919d',
        52924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dec3c3a9504cb4cc1b40a04cf3048a3ac4ac2920eff49adb5e0304d3b707ffba',
        53000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '368d76d774dbc1c3bd50998aba4462ccd4955f23f70cdfff39d01506c942d94c',
        52960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c54a59e7e9ed93a1abf33c6a573b84241d18a5e41836c170188c77053854a47',
        52876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9757fb03803e2088f83b77057e81bdefd4e65fe24d598fd00d0b0749b27e431d',
        52916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '841b3a70970a9399aeba5c113e2c15a5019aef0d8adb47b61da246b71a6d17b2',
        52616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ab604215e1fd3bb22adf0da8f21da2c0d54fef3940478d5152a5b8d1d61f85ec',
        56016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd3b3329ab61d8a9183bacc96c0b1991bd8ce80ce629e974cb11480cea67e0940',
        56200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0e2ed145c87634271c6d911965a17f586ca494260b835ee621fd0797f1d300f9',
        56208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '75c92ba4f103c080ab9bfc3fe83320ef265b7c67ea563ad71dcb5b66026c03c7',
        56096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '34a9450ef14b5c993b45a81738389ca208157997d481676cc20f7d3cb65ad5fc',
        56192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0257441c61e8c7d6bb39f5b602c78b2f2e7491a06753b3908dd03de07c47d791',
        56152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd9675d29b154ca60b902d688e136c24736dd1b2daca568a8a8cf2347b6546b48',
        56020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '441ae442c960bc31d6c8476daa3fd44e390be09717b39b4bc73867eba21be70f',
        56012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3503c34b4b89a68ca685c984892e1334e7405ba4663084a6dba77f8c61227324',
        55920,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlumniSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alumni Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans
  static TextTheme alumniSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alumniSans(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alumniSans(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alumniSans(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alumniSans(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alumniSans(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alumniSans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alumniSans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alumniSans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alumniSans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alumniSans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alumniSans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alumniSans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alumniSans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alumniSans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alumniSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amarante font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amarante
  static TextStyle amarante({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f11a52c1a0f3e94f81dde8d9c60832c688c1d9b01c5bb1098c3ea30daac8ad29',
        74348,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amarante',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amarante font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amarante
  static TextTheme amaranteTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amarante(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amarante(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amarante(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amarante(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.amarante(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amarante(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amarante(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amarante(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amarante(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amarante(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amarante(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amarante(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amarante(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amarante(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amarante(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amaranth font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amaranth
  static TextStyle amaranth({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b8c69a7d5f0b230b1b010da8da3ad4ccb84f4dff4a1247a14af83392c9ecf64',
        66272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '359639014bf096771cbebb373f2d347f8e1b44a2ef2b48556e1a21289dbc7eb5',
        74196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b35625ebc301f471cd70df7575f4fc81597a8ab27dc321418707c40d8a99616',
        65892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '48c74968a6ddedd92d0c4d4e05959d24a1ae124fce3ab60c793c5a331dddee10',
        74616,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amaranth',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amaranth font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amaranth
  static TextTheme amaranthTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amaranth(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amaranth(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amaranth(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amaranth(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.amaranth(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amaranth(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amaranth(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amaranth(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amaranth(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amaranth(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amaranth(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amaranth(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amaranth(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amaranth(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amaranth(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amatic SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amatic+SC
  static TextStyle amaticSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9da6405b57357f309f00592371cf54bb3c1d57b8e7d9fc40fff6f364d6ca80fe',
        104904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81f4df2ecbc8d2fcae65290f5075ff98149f4f95ea00bb6bf3a0711e4e1afd75',
        99680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AmaticSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amatic SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amatic+SC
  static TextTheme amaticScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amaticSc(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amaticSc(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amaticSc(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amaticSc(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.amaticSc(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amaticSc(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amaticSc(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amaticSc(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amaticSc(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amaticSc(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amaticSc(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amaticSc(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amaticSc(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amaticSc(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amaticSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amatica SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amatica+SC
  static TextStyle amaticaSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '39a7e41edc371bdb0e8356c4e9f69ea62594cfd412fbb1f5c45a32c0a5e75516',
        140932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ead630d51d6f70a5e14a17fec1bffc04c9a13118b217101fd42eac20be2ae66',
        105524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AmaticaSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amatica SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amatica+SC
  static TextTheme amaticaScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amaticaSc(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amaticaSc(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amaticaSc(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amaticaSc(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.amaticaSc(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amaticaSc(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amaticaSc(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amaticaSc(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amaticaSc(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amaticaSc(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amaticaSc(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amaticaSc(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amaticaSc(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amaticaSc(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amaticaSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amethysta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amethysta
  static TextStyle amethysta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e4d26711903ae08c3bd10750f3b713928bdd3ee56d00372e37bd8606a3fe2d7a',
        36864,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amethysta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amethysta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amethysta
  static TextTheme amethystaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amethysta(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amethysta(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amethysta(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amethysta(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.amethysta(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amethysta(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amethysta(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amethysta(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amethysta(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amethysta(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amethysta(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amethysta(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amethysta(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amethysta(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amethysta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amiko font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiko
  static TextStyle amiko({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2e782cc6b503328a87e3b81b3ee6afa1acb6cd66bd04d9da2ba5d3ff4c43e3f',
        143076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd56799efb6c3d56b106cae38c558a3f2f9da3d0a90d0d1ea64449c693d3cadfc',
        142664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '037bbdff86b70266d62abc94be043671d3c04188f477dbb0ead70ee89df98ecb',
        142052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amiko',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amiko font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiko
  static TextTheme amikoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amiko(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amiko(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amiko(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amiko(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.amiko(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amiko(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amiko(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amiko(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amiko(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amiko(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amiko(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amiko(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amiko(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amiko(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amiko(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amiri font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiri
  static TextStyle amiri({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '15af380107efd8a082b372d1ba8027d5fd6d4720ccf7f7ce48345b845cfb83b6',
        370496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '03496500b8efdd151ca91912b003f23e04fcb45a8d39cee588e4ea47b61fc052',
        357340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1f6fcfa01fc6084132c66ff5b8da7b655fbf82dae7a9200c4471400281678bb',
        351752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9d9add54ab339fd5ca1f0b2fbda1117e04758800cefa39fa72d5f1e38b7a2e27',
        355324,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amiri',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amiri font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiri
  static TextTheme amiriTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amiri(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amiri(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amiri(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amiri(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.amiri(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amiri(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amiri(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amiri(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amiri(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amiri(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amiri(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amiri(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amiri(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amiri(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amiri(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amita font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amita
  static TextStyle amita({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8ab328073e1c729f0b4f38521b47bb39c63db396da1602f6b08a2a8775249f4',
        141504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e421cec126c6014995b96189e28c3c8b119e3e21dbe1c3dea8585ec31afa0679',
        141464,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amita',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amita font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amita
  static TextTheme amitaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amita(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amita(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amita(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amita(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.amita(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amita(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amita(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amita(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amita(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amita(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amita(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amita(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amita(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amita(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amita(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anaheim font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anaheim
  static TextStyle anaheim({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '738fa7ae0283744abbfcfd999eb71d255210a7ee0fa7e195a47482269b9e381e',
        27848,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Anaheim',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anaheim font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anaheim
  static TextTheme anaheimTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anaheim(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.anaheim(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anaheim(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.anaheim(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.anaheim(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.anaheim(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anaheim(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anaheim(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anaheim(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anaheim(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anaheim(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anaheim(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anaheim(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anaheim(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anaheim(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Andada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andada
  static TextStyle andada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c3fda3cdd2dcc60f34129cdd9c0a2f139b2a4bec16bcff6b27521d87d222f1e',
        108572,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Andada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Andada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andada
  static TextTheme andadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.andada(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.andada(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.andada(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.andada(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.andada(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.andada(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.andada(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.andada(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.andada(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.andada(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.andada(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.andada(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.andada(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.andada(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.andada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Andada Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andada+Pro
  static TextStyle andadaPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ed76387fc9d8338e38a60301b4eb45b6a0312aa0f0aea7f7dbb36af00ce93ec',
        91072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '59b2abc3156af3c0b9290b80215007e5361cedd91df77af007d181f189554e7a',
        91172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7df6a3c84c9d210af208960990461be21ab58ff81eece8153c7017e9040be2ee',
        91200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'baa2fb757366dafa8722259957a668f3d8dcd7f9da72efc64fe8740d6b6a60f7',
        91168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '97c10f4348eac46e4413e2a06cfd708f1e681ef0ab4ff58953df4d5f5eb7cc41',
        91236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '52fe324b4b0e03e8955414d84f932a2303cd8d4ed4e8dd4e634e95fedcd82067',
        89836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9a87f6de59cb013572282fa45df1ba695f7070fbdfc7eff33c6a85fd66b5ca5e',
        89908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3dad17cd3fa0d44dd7a7948f8d73739ee109cd70a505d9be31bfeef60d072d6e',
        89916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4e93af0d8bcc75c67660fbdf94f50eaeb7ff456488e3d4dd20469cc8697ee86f',
        89848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd8d922389d2631a5f89ec0fefde3f9bb68ed681a1e2d2341e7b4c4567bd11b35',
        89896,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AndadaPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Andada Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andada+Pro
  static TextTheme andadaProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.andadaPro(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.andadaPro(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.andadaPro(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.andadaPro(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.andadaPro(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.andadaPro(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.andadaPro(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.andadaPro(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.andadaPro(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.andadaPro(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.andadaPro(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.andadaPro(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.andadaPro(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.andadaPro(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.andadaPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Andika font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika
  static TextStyle andika({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c10763224ab91314d3fae862634f6bddf0aae60bd71668d68950102ca77b5d4',
        964524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Andika',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Andika font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika
  static TextTheme andikaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.andika(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.andika(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.andika(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.andika(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.andika(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.andika(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.andika(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.andika(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.andika(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.andika(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.andika(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.andika(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.andika(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.andika(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.andika(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Andika New Basic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika+New+Basic
  static TextStyle andikaNewBasic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48b18f488f9907c784ac7924a2d763257e1057f5ac3ee22c804ab0ba194253fb',
        71420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '65eed85f74c45790107ec98d6a3098e99d4f54a7580b53d536891a35385b16ba',
        75508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50bbb54d0ec04a720a330e87931ea2be85d5fc406fd2e171ce44ca67855f8a8d',
        72220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a2a105533f2063ef7f4a489f1d438cf7af064f1c5ed1c3ebc6ba7c1d46c8db40',
        76148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AndikaNewBasic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Andika New Basic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika+New+Basic
  static TextTheme andikaNewBasicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.andikaNewBasic(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.andikaNewBasic(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.andikaNewBasic(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.andikaNewBasic(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.andikaNewBasic(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.andikaNewBasic(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.andikaNewBasic(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.andikaNewBasic(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.andikaNewBasic(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.andikaNewBasic(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.andikaNewBasic(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.andikaNewBasic(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.andikaNewBasic(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.andikaNewBasic(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.andikaNewBasic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Annie Use Your Telescope font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Annie+Use+Your+Telescope
  static TextStyle annieUseYourTelescope({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '65c0cd06d1ec2528de45688966f2971cf95fed9f810f246e08b4efd9e717d850',
        50692,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnnieUseYourTelescope',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Annie Use Your Telescope font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Annie+Use+Your+Telescope
  static TextTheme annieUseYourTelescopeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.annieUseYourTelescope(
          textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anonymous Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anonymous+Pro
  static TextStyle anonymousPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ca7beef0b5eb5c9e72533cd45bc1e4f41c8272dc2335f22d3649e32a795995f',
        106796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '71ce3ee6476a91f9e89e9f8010d9ea13314306b645af3e8d7b7add697e6f0d3e',
        108996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd00937283f3b530bee6700e02cfabfbb96b833d42559d48fc5fdfcfde2ff5b39',
        106604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '60f1f3cae99bbc1323cdcdf9af6a0127d5b4684ef675e6836fa3034a297dc16a',
        108760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnonymousPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anonymous Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anonymous+Pro
  static TextTheme anonymousProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anonymousPro(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.anonymousPro(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anonymousPro(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.anonymousPro(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anonymousPro(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.anonymousPro(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anonymousPro(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anonymousPro(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anonymousPro(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anonymousPro(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anonymousPro(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anonymousPro(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anonymousPro(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anonymousPro(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anonymousPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Antic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic
  static TextStyle antic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6526fff8a94a5503810bc8805b716126e91295380d0e970f089e3e663a4440d5',
        39272,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Antic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic
  static TextTheme anticTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.antic(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.antic(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.antic(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.antic(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.antic(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.antic(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.antic(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.antic(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.antic(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.antic(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.antic(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.antic(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.antic(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.antic(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.antic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Antic Didone font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Didone
  static TextStyle anticDidone({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed8ca32ea2c34cc27f4a10cdf51c0ddb35d0cd580df90b19e68d8096a145ec35',
        39640,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnticDidone',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antic Didone font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Didone
  static TextTheme anticDidoneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anticDidone(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.anticDidone(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anticDidone(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.anticDidone(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anticDidone(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.anticDidone(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anticDidone(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anticDidone(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anticDidone(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anticDidone(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anticDidone(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anticDidone(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anticDidone(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anticDidone(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anticDidone(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Antic Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Slab
  static TextStyle anticSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1348202760ad87d67e74d3a921ad2be20b563b2cd2a8d6e99d54da029c7f2aad',
        36924,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnticSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antic Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Slab
  static TextTheme anticSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anticSlab(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.anticSlab(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anticSlab(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.anticSlab(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anticSlab(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.anticSlab(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anticSlab(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anticSlab(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anticSlab(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anticSlab(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anticSlab(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anticSlab(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anticSlab(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anticSlab(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anticSlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anton font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anton
  static TextStyle anton({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e0d29150a430129b0bfdaabaa46ba1e7967ccabc46440a5789bffe18b7dfcc2d',
        54896,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Anton',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anton font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anton
  static TextTheme antonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anton(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.anton(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anton(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.anton(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.anton(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.anton(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anton(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anton(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anton(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anton(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anton(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anton(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anton(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anton(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anton(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arapey font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arapey
  static TextStyle arapey({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d4786e233fac8fe0069ba6efaa828eb2fffef7b1d21a92a6d4f250ae9710415',
        26716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '10f469eeecd1cca95a1881d5fbd920abff25911a343caf957f7b2a0e3d4de390',
        29520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arapey',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arapey font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arapey
  static TextTheme arapeyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arapey(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arapey(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arapey(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arapey(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arapey(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arapey(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arapey(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arapey(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arapey(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arapey(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arapey(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arapey(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arapey(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arapey(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arapey(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arbutus font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus
  static TextStyle arbutus({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1484fe1dd2948c05f4d1ab7f6acbbc88d4acea2e32880263ec8f991cba4905f',
        81792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arbutus',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arbutus font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus
  static TextTheme arbutusTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arbutus(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arbutus(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arbutus(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arbutus(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arbutus(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arbutus(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arbutus(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arbutus(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arbutus(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arbutus(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arbutus(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arbutus(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arbutus(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arbutus(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arbutus(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arbutus Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus+Slab
  static TextStyle arbutusSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7c7bbc09f84fc70a8541195a960de7d282eeaee64c5b146253bd79fd209893d',
        39812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArbutusSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arbutus Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus+Slab
  static TextTheme arbutusSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arbutusSlab(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.arbutusSlab(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arbutusSlab(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.arbutusSlab(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.arbutusSlab(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.arbutusSlab(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arbutusSlab(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arbutusSlab(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arbutusSlab(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arbutusSlab(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arbutusSlab(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arbutusSlab(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arbutusSlab(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arbutusSlab(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arbutusSlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Architects Daughter font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Architects+Daughter
  static TextStyle architectsDaughter({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a4f5860f4b7aca9b95305b6c5a3b14e2f1c951eaddd28b5d1fffd374171ccdba',
        43356,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArchitectsDaughter',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Architects Daughter font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Architects+Daughter
  static TextTheme architectsDaughterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.architectsDaughter(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.architectsDaughter(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.architectsDaughter(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.architectsDaughter(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.architectsDaughter(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.architectsDaughter(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.architectsDaughter(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.architectsDaughter(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.architectsDaughter(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.architectsDaughter(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.architectsDaughter(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.architectsDaughter(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.architectsDaughter(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.architectsDaughter(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.architectsDaughter(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Archivo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo
  static TextStyle archivo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3992a886b3891c9b073cf3e46b1c578cb31ab065cf9b5e07f6fc2a0200a495f',
        58160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8af059c64838f116e4c8afda7a5c344815c3fe3c2111749d7281a046087dfb8a',
        60944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '455a61b80b447af7647cb7bbbef6de06c3c3031d0ecbb2619fa9cffa73871e76',
        59648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c266aeada4adba34caec3d404c7953743cf0327123506b66cde56cf556ad2ddf',
        62104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ad030ef4465b1be7229c5326d24955683bea533c9646e4ed2773cd30697d031',
        59960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '453878357ed380bea09e3661badd4636234be8794956428236bc3a166d84fc92',
        62300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c37a5634c5b7802983e322dcc187d5b4bc26e238dd61828a71f184592b9032f',
        59436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '12b65a3c8f63eb390f4acb0a6ade0ac245782113ddc2e397c216c3605fc245f8',
        62036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Archivo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Archivo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo
  static TextTheme archivoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.archivo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.archivo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.archivo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.archivo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.archivo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.archivo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.archivo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.archivo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.archivo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.archivo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.archivo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.archivo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.archivo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.archivo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.archivo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Archivo Black font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Black
  static TextStyle archivoBlack({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdd008fdde6eaf026762810841b23a803c1fd8f7691df010d250df61e584703b',
        59204,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArchivoBlack',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Archivo Black font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Black
  static TextTheme archivoBlackTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.archivoBlack(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.archivoBlack(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.archivoBlack(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.archivoBlack(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.archivoBlack(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.archivoBlack(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.archivoBlack(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.archivoBlack(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.archivoBlack(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.archivoBlack(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.archivoBlack(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.archivoBlack(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.archivoBlack(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.archivoBlack(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.archivoBlack(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Archivo Narrow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Narrow
  static TextStyle archivoNarrow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95b4094186b9443c74e987b6a5ad660b55c7dc1e548d66cc53ead05a10bf096f',
        57132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c5be034d89310f5e551f67507ef7bd0d5093e193d5e556598e1137cff7598ada',
        58796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '898e57eec4db5685859996bc7c9a87707d53ceca97c917edb0497302b7145fd5',
        55924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ff034a0073d594043d35a5058bf44df331be4b22576c8a753b210bcc55789e50',
        59204,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArchivoNarrow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Archivo Narrow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Narrow
  static TextTheme archivoNarrowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.archivoNarrow(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.archivoNarrow(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.archivoNarrow(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.archivoNarrow(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.archivoNarrow(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.archivoNarrow(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.archivoNarrow(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.archivoNarrow(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.archivoNarrow(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.archivoNarrow(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.archivoNarrow(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.archivoNarrow(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.archivoNarrow(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.archivoNarrow(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.archivoNarrow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Are You Serious font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Are+You+Serious
  static TextStyle areYouSerious({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f5c158df53c0056890d3850938a75e61af027316853dc7eaa83dc29d32341f4',
        149320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AreYouSerious',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Are You Serious font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Are+You+Serious
  static TextTheme areYouSeriousTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.areYouSerious(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.areYouSerious(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.areYouSerious(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.areYouSerious(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.areYouSerious(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.areYouSerious(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.areYouSerious(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.areYouSerious(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.areYouSerious(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.areYouSerious(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.areYouSerious(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.areYouSerious(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.areYouSerious(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.areYouSerious(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.areYouSerious(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aref Ruqaa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aref+Ruqaa
  static TextStyle arefRuqaa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '483d6ce42473c62a61b38dc4e30c6b1a5d9b02921ab5034c8eec4b8f0496127d',
        112872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ea198095e22fea5b0b08338b3b524a2ac489bd669154eab1927955f20124358',
        139992,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArefRuqaa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aref Ruqaa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aref+Ruqaa
  static TextTheme arefRuqaaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arefRuqaa(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arefRuqaa(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arefRuqaa(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arefRuqaa(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.arefRuqaa(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arefRuqaa(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arefRuqaa(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arefRuqaa(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arefRuqaa(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arefRuqaa(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arefRuqaa(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arefRuqaa(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arefRuqaa(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arefRuqaa(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arefRuqaa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arima Madurai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arima+Madurai
  static TextStyle arimaMadurai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '20fe984789a290b9c540b82d788511cf37e7dcb0c94a3f808ed8a9980ce92262',
        92064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ea122a5616110be9d6b0719ff9a8e5d87a5bb067671e53f60e9e2f34151a054',
        92944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9bb6dffdcb0e85ac571c284727a1ff484951f065ccff0e42668f232709bcfd0',
        93064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '72a8a5252b9293d6af843e90bdda0f995b86531cb25d7a2489b5b58e7c495575',
        93452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b608979162b4bce202e22f3cba5768ef3c5f96294c41e1d36229b02393a70cf7',
        93560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9809fc1ba075315f2526aba738bb8c4bfb8af33451d402a57eae3edbdbe45b6',
        93480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '030889c403dcab9b3a79394ed59d1d1da7d0dbafae26fc8c6d1b870d7732c997',
        93616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25561cbe875f9bad0c96c060f2a1f8108ba709366496e68ff510efdf5930429f',
        93604,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArimaMadurai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arima Madurai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arima+Madurai
  static TextTheme arimaMaduraiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arimaMadurai(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.arimaMadurai(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arimaMadurai(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.arimaMadurai(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.arimaMadurai(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.arimaMadurai(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arimaMadurai(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arimaMadurai(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arimaMadurai(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arimaMadurai(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arimaMadurai(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arimaMadurai(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arimaMadurai(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arimaMadurai(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arimaMadurai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arimo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arimo
  static TextStyle arimo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df255da5c656bbf01f4aa3012b4d4ba16f7bd17664a4e1fc011146a4eb95d436',
        242708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'eafe825bf96517b1ff3b8d8710254e225584de1489e4c3deaa6b1cb8549a027d',
        249396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a4f400fb6090e3938136ea6fd3ec2c02777fb674d13b9582f96d4515044df23',
        240652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e6b358f015564a1505c76b32db9b3f5c538a8f7d220dd04446697d286c820bf0',
        248528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arimo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arimo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arimo
  static TextTheme arimoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arimo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arimo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arimo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arimo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arimo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arimo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arimo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arimo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arimo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arimo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arimo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arimo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arimo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arimo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arimo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arizonia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arizonia
  static TextStyle arizonia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '603a1ae367969056ace1484bd5db4d882fabfa78008e6843d3ba07c08082c2c7',
        50688,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arizonia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arizonia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arizonia
  static TextTheme arizoniaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arizonia(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arizonia(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arizonia(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arizonia(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arizonia(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arizonia(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arizonia(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arizonia(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arizonia(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arizonia(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arizonia(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arizonia(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arizonia(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arizonia(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arizonia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Armata font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Armata
  static TextStyle armata({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7631b4ae2fae472da8b9d0b46acfec928c9c550e82dbee1685e72f389ab890d9',
        54772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Armata',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Armata font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Armata
  static TextTheme armataTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.armata(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.armata(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.armata(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.armata(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.armata(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.armata(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.armata(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.armata(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.armata(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.armata(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.armata(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.armata(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.armata(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.armata(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.armata(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arsenal font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arsenal
  static TextStyle arsenal({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7b13a735c3c27289a74f4e934b380f078f89568b2633c5d8386e97a97d46158c',
        140064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f687cc6b9b17ac45aaf3391fbe649c2e1607804ce3ab85daddf9669f796d0a79',
        138944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ac62eb1c6ee28d30c2dacea06acdbec9c72bcbfdca1f76a873b8a2c18ac8ae6',
        141180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '41b9ba2384a037e4ec361896e5868107cfa8535ab8befda2d9666584884aca80',
        139236,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arsenal',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arsenal font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arsenal
  static TextTheme arsenalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arsenal(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arsenal(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arsenal(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arsenal(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arsenal(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arsenal(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arsenal(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arsenal(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arsenal(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arsenal(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arsenal(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arsenal(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arsenal(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arsenal(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arsenal(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Artifika font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Artifika
  static TextStyle artifika({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0d399a0a07f993bcb6bdd075a4e0f6ae155d222d230710b94d48933e8470dbf',
        100216,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Artifika',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Artifika font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Artifika
  static TextTheme artifikaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.artifika(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.artifika(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.artifika(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.artifika(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.artifika(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.artifika(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.artifika(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.artifika(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.artifika(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.artifika(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.artifika(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.artifika(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.artifika(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.artifika(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.artifika(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arvo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arvo
  static TextStyle arvo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b816c4a4a7813e7daaa88e2f869b5c8acefbf8d52e00205c41d15dda95f1766c',
        22724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5250cf6a9f89eba5cb07686924135f2bce7a6f8775a569fac7276b5c83b03db7',
        22704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1126bb2afe7e919632493ca620fc94e998910794a9fd47d82092f6edc26f4368',
        22608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '43a330e1b8afd2c95f4f6b1c9c67ef7dfab28ed90bfb6a4551efe8480a060222',
        23288,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arvo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arvo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arvo
  static TextTheme arvoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arvo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arvo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arvo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arvo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arvo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arvo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arvo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arvo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arvo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arvo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arvo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arvo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arvo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arvo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arvo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arya
  static TextStyle arya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98cf640f609db3f8940fc4bc1566dda034961cb11d23f71a277f3ab268c8859a',
        120116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c168a53b559c7407d20692a42b94301046b15c4838d709b83992c32cab5732c',
        119776,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arya
  static TextTheme aryaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arya(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arya(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arya(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arya(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arya(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arya(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arya(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arya(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arya(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arya(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arya(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arya(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arya(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arya(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arya(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asap font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asap
  static TextStyle asap({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3424989c5e2512f04cbd78fd70665961847d7307eb5d795caadac8db451f74cc',
        67676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6286c24191501089796508556c20c3086610ae6aeb56d9aadceaaa0b7d825c51',
        69828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c7034a58c9a896f74c127472a7085dbd1d6bfb6fd2cafb4140dfde291f0bc399',
        67936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '13483b794adc9a08424049bbf8e6a03b399069e87c0c4d01777ae17c3328de81',
        69828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '835a74fedec5a1877e092c739d9f213a3e41860462c70437da2465b5f99ea073',
        67904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ce966470982f0031860428bc4a47e41d80471ac70ccc857fac1e948d6c964eb7',
        69648,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asap',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asap font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asap
  static TextTheme asapTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.asap(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.asap(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.asap(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.asap(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.asap(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.asap(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.asap(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.asap(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.asap(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.asap(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.asap(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.asap(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.asap(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.asap(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.asap(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asar
  static TextStyle asar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52cdc31a962e99a625bf96be5b06ab8118290c27e17701c4938182d9e56109af',
        410900,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asar
  static TextTheme asarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.asar(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.asar(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.asar(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.asar(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.asar(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.asar(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.asar(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.asar(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.asar(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.asar(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.asar(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.asar(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.asar(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.asar(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.asar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asset font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asset
  static TextStyle asset({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6423261d7b23d05ef705ee59a0151076feed8408f637b04693272b767ac6cfd5',
        52004,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asset',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asset font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asset
  static TextTheme assetTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.asset(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.asset(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.asset(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.asset(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.asset(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.asset(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.asset(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.asset(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.asset(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.asset(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.asset(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.asset(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.asset(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.asset(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.asset(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Assistant font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Assistant
  static TextStyle assistant({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f4c276bf1e4d52183015128074de4702a86fc31cce04f575a8ebef54a077c78',
        57240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad7ba792736448061fddf24806abe616e89d7a21a00d169ac4bf95db35ffe9cc',
        57400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ffb8d00a2bd6ab725bb34dc8eaf61737481f6b285988332e4f6a4b60279dbde',
        57088,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1dc8095e8dddae977007770ce433f8ed1e374d0a83d7330ecea3b335109a4985',
        56812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81008b85f8a91125a8efe85a353982fe1b825def9ef33eed881b709a6debf250',
        56752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7370c1c3e5649abcfa6f44475eed601eb070ab934a708081b87627827d5463a',
        56872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Assistant',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Assistant font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Assistant
  static TextTheme assistantTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.assistant(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.assistant(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.assistant(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.assistant(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.assistant(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.assistant(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.assistant(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.assistant(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.assistant(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.assistant(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.assistant(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.assistant(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.assistant(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.assistant(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.assistant(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Astloch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Astloch
  static TextStyle astloch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b51d807f9b0f818e44f8f40d4fbedacfff7df981efda85e7b722d62f6022a168',
        49860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b86a5f0e90945d44c5b629fde8c5a667dd7882ab201ccb397f96f482fd7e98bc',
        51544,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Astloch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Astloch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Astloch
  static TextTheme astlochTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.astloch(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.astloch(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.astloch(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.astloch(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.astloch(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.astloch(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.astloch(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.astloch(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.astloch(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.astloch(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.astloch(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.astloch(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.astloch(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.astloch(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.astloch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asul font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asul
  static TextStyle asul({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd38e526c102508df44df01ded7aefa955a61c999e42e91cbcb82103aa1269875',
        33468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1810c0e0a5199932d466db95d83fab54bd1b5f6fd5b91664ca7240078d2dd1f0',
        33500,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asul',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asul font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asul
  static TextTheme asulTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.asul(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.asul(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.asul(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.asul(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.asul(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.asul(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.asul(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.asul(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.asul(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.asul(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.asul(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.asul(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.asul(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.asul(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.asul(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Athiti font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Athiti
  static TextStyle athiti({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4abe61baf7f8762b4dcb6b88b0610de73f42b112a793e28b92da163ee7e441d7',
        112524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9c6df08ed329fa184304cf4bc64319e7812c62c2ae136dc89cb10a5d5c35018',
        111332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4559ae55fe1020c88dc144ae60afba5e282fcd3aa1c5107292df173d42135806',
        112320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e1f0a1706330d270d93ea13e88b35d9c6f4bf71d927e9468278c03b57986330',
        112508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '398a37b4c34df12c6ede4a85f215d56eaa5a8b515ea5e0bdad2ef676c2ae858a',
        112080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '63b6ab040d22bd64ce5d5400f352fac3ecefa83827b1862b8a216d5c729ea286',
        112932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Athiti',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Athiti font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Athiti
  static TextTheme athitiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.athiti(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.athiti(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.athiti(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.athiti(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.athiti(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.athiti(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.athiti(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.athiti(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.athiti(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.athiti(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.athiti(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.athiti(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.athiti(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.athiti(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.athiti(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Atkinson Hyperlegible font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atkinson+Hyperlegible
  static TextStyle atkinsonHyperlegible({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '34cbbb160a161e76615409702bd11d517714be485035c724a5b4823609e128f3',
        35240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'de702b1afd3d264aaff860cd5aa76e5a28a9d5d4194616f8ab58461aa732ac2e',
        35640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1d77f8ab92ba17799673d4b74349ec47450a40ec2e275ccfb1521e4b411808b',
        35432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6ae3af7b85ce5c0e45767b9ba419340fe3f91c78c181b9f09c5ebca7eb6505d0',
        35960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AtkinsonHyperlegible',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Atkinson Hyperlegible font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atkinson+Hyperlegible
  static TextTheme atkinsonHyperlegibleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Atma font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atma
  static TextStyle atma({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd691cbd1df6f6a53328f8d9d9514102c915be55e93a8c1f0cb0826a27a60e4f2',
        196364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '702ceed58c58203ab0c8ad4bbbbda56c77b89a29496d748322180acbed120201',
        198056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc558572cee6afca8a8d34b8cb8a2397d749e0c22f9d9977f39eb0e84d636967',
        197528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b569b84d6ee492ead3f4c73af6244137b0e4c604c9e98cc57627162221d498bb',
        196596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '127f716e96fc47aee7624acf9cebd859693a19f2fc1f7d832f33835e5bd3b834',
        193184,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Atma',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Atma font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atma
  static TextTheme atmaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.atma(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.atma(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.atma(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.atma(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.atma(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.atma(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.atma(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.atma(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.atma(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.atma(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.atma(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.atma(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.atma(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.atma(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.atma(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Atomic Age font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atomic+Age
  static TextStyle atomicAge({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fc59a494c6184d973d9d5db8ec698d8acb6283fc807bd1a13c30000b83b832c',
        44272,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AtomicAge',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Atomic Age font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atomic+Age
  static TextTheme atomicAgeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.atomicAge(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.atomicAge(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.atomicAge(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.atomicAge(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.atomicAge(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.atomicAge(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.atomicAge(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.atomicAge(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.atomicAge(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.atomicAge(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.atomicAge(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.atomicAge(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.atomicAge(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.atomicAge(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.atomicAge(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aubrey font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aubrey
  static TextStyle aubrey({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1464a409557010421785a4857a333c92eb6c4a28c0dbeeb0b1f8441f5e68ab96',
        96976,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aubrey',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aubrey font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aubrey
  static TextTheme aubreyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.aubrey(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.aubrey(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.aubrey(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.aubrey(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.aubrey(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.aubrey(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aubrey(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aubrey(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aubrey(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aubrey(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aubrey(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aubrey(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aubrey(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aubrey(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aubrey(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Audiowide font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Audiowide
  static TextStyle audiowide({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2054b5910bd5457176b1479122e09690d5afe73d3749e5ef89a3686e6f724c29',
        70472,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Audiowide',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Audiowide font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Audiowide
  static TextTheme audiowideTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.audiowide(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.audiowide(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.audiowide(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.audiowide(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.audiowide(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.audiowide(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.audiowide(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.audiowide(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.audiowide(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.audiowide(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.audiowide(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.audiowide(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.audiowide(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.audiowide(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.audiowide(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Autour One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Autour+One
  static TextStyle autourOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee63c9c20873c21ac935c1493e94bb24b9dc9782f63d01761b54dfedf4b3972c',
        59552,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AutourOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Autour One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Autour+One
  static TextTheme autourOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.autourOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.autourOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.autourOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.autourOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.autourOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.autourOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.autourOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.autourOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.autourOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.autourOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.autourOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.autourOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.autourOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.autourOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.autourOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Average font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average
  static TextStyle average({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce0697844aa3a978d483dfa380fbebd5bff8e7e6dc0897bf6c2c009fb9ae4ab2',
        37788,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Average',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Average font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average
  static TextTheme averageTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.average(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.average(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.average(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.average(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.average(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.average(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.average(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.average(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.average(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.average(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.average(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.average(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.average(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.average(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.average(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Average Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average+Sans
  static TextStyle averageSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'defa6f6e46057de37a3b075c74765ba7cd6a46e0ac756e83f454dfb8b1afa95c',
        43964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AverageSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Average Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average+Sans
  static TextTheme averageSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.averageSans(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.averageSans(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.averageSans(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.averageSans(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.averageSans(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.averageSans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.averageSans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.averageSans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.averageSans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.averageSans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.averageSans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.averageSans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.averageSans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.averageSans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.averageSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Averia Gruesa Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Gruesa+Libre
  static TextStyle averiaGruesaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3c60fda1756722c9f8d80009e0627d49eb2106d9eada7962d132e3ebef09c96a',
        111344,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaGruesaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Gruesa Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Gruesa+Libre
  static TextTheme averiaGruesaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Averia Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Libre
  static TextStyle averiaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '446105043cce1cc90406cda4c387ef2100b294d9d63b3946d4a395d3f2a9ce07',
        108192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c8a24e13d7d611dd8a4e15743ac34b163b1e96d1c9a9e82746f0bd9d3a878613',
        133544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b819eb7a1c11f4de65f3bfe1a8f658ea56fc62b2b7a24b2cf8688e9ced04c96',
        108468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '793d505e83fbdbef6ceeabd6897693fb515a4890b822623deb545b53e7ec68dd',
        128848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b157a260e6fd6b7cdd2d54fc4f46e1a72fbb33034b74a6929cbc4d0a7d83e3d',
        112228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '08c2c28ffffd04d884122fa538e0c615e52983959363269b543084794a60955f',
        135664,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Libre
  static TextTheme averiaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.averiaLibre(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.averiaLibre(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.averiaLibre(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.averiaLibre(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.averiaLibre(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.averiaLibre(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.averiaLibre(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.averiaLibre(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.averiaLibre(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.averiaLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.averiaLibre(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.averiaLibre(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.averiaLibre(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.averiaLibre(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.averiaLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Averia Sans Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Sans+Libre
  static TextStyle averiaSansLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '452436a08a43ba5da912a2ed71aa4e0c67ae680532317c5affb99278cedc4eb8',
        107752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '056589edb0d0f068b768b9b9f6361bb5c4a2d53a33006288c9d089b1e6421f66',
        134200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5f843350837023c845544f24fa59e8c71cbe7bc284c0ea4127aa872c4fcac41',
        108360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a79e7e7aecba032e6272d99a93c69868328db8d34091d1c70ccfd4a839f70489',
        128896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8af8ea3669721038ea729e975cadce19a0032e981378e23c8377e2faf979aca',
        113016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0509fc7d0b873424deb4340ab1bafca704241ecfda08cdafeab623999d12bdfd',
        135852,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaSansLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Sans Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Sans+Libre
  static TextTheme averiaSansLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.averiaSansLibre(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.averiaSansLibre(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.averiaSansLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.averiaSansLibre(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.averiaSansLibre(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.averiaSansLibre(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.averiaSansLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Averia Serif Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Serif+Libre
  static TextStyle averiaSerifLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '605722d0534e8b2a7a4ce36ebc7ecfa14868d5aeae52ba3419e14a19e67c92ba',
        109972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4b675f9e2f2962fb69b7145f35ea9df241cdc9b91744abeac3cdfbf7aca1740b',
        135976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1939fc59e6192c78872b151f71d328c64c84552c1f8f7548f3278d3db023959f',
        109988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '383c63d8878e96726e26c44d5a631030fcf28d4abdcb9bdadd86dbb01a623de9',
        130956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19af7d57b5ea32ff5df3f2405e0d51759fdbab503fa4cfd420a5eb4943805fcc',
        113956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '164c3a01088756eebd948641705d6759b2fc7dabfd77d6e36490aa39befa0028',
        138208,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaSerifLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Serif Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Serif+Libre
  static TextTheme averiaSerifLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.averiaSerifLibre(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.averiaSerifLibre(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.averiaSerifLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.averiaSerifLibre(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.averiaSerifLibre(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.averiaSerifLibre(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.averiaSerifLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Azeret Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Azeret+Mono
  static TextStyle azeretMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17eadd900e8697179e86daa8727665092ebec16832f9ee199de8b8e54fda5aa7',
        36332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3fbb2b6e56d74da49cd1b04d6ed9cfc80aaa81561b455427db77b7b1a12759b4',
        36372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a3d65bcd9f306acf8c3744450b92f85380524a8dfa9b586dcccf56eb1c400c1d',
        36288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '966e02b75e7454d55d4b1a2974a330c2b76779ccba8f6d684d848de14dce93ce',
        36248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03fda14a0ebe8a246f3f9521b14c6a9a91dc70f72072d4b746308def23eec808',
        36312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd729517045d72ae5a8787d73efb2290c35d850c6729525a10d485421cc057889',
        36188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd04e67b0254378c3a21eb212f76251a059f22b5e23d47f38c4e1d1187fe8919a',
        36100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '54e96a6c30b11221465bf0071fbd2d431b9053cd1aceae988b3ab0edf7f5bcaa',
        36272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8067b9c0891f914b2e18396d78759a447a7f05e9e9962bfcced62c5ac17451f6',
        36320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bb9d34f997abe93294bac0aeb7f3a3a0890ddc714764ec04efacb5dd4d3ad804',
        37464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ae97ba631af094633e309222572eac2797a918e9b915b16b00fb951079f2e88b',
        37556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8f8e6637fa70bd1135e9a8a8e948df66e815acbaa4bb7276e7d11b299ec8070f',
        37448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '296c839ed98ffa90d3501f16cbda77bbfc970812fd973684ca4e9d810d96935e',
        37344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1617eb8b69ff5da2019ed9928aa01fe94ecd8772c4c74142f5cdffbd85113482',
        37496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '91ddb90e7301d3c70287c8c2e8aa1e78e0abe3a98885fe318d7a64c4cbf4be5d',
        37464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '00eb258d2de95fbe13fb792f6489d0ca99bf660874bde4af33b6fe4c225bfb41',
        37236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd6f6f39f052a155a9dcf80659f3740a1477100fa486592f4bd51d70079cbd3fb',
        37412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6836a6e60b3516ec45ba9a8ccb68f827c2ec3880feaaa71d6258aa021eaf63ae',
        37468,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AzeretMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Azeret Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Azeret+Mono
  static TextTheme azeretMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.azeretMono(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.azeretMono(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.azeretMono(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.azeretMono(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.azeretMono(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.azeretMono(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.azeretMono(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.azeretMono(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.azeretMono(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.azeretMono(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.azeretMono(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.azeretMono(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.azeretMono(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.azeretMono(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.azeretMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the B612 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612
  static TextStyle b612({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b11c6d50f8a4ef2abd6df134192e3770a9b392c814caf916bcf0efa87e6743d2',
        89048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4250a2e42f4ceda476c771828532dfb8cb2e9170ceb541e8aecc34ecea7977b4',
        92732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd3f9b01c62cb7bf3bc87cbc07452bc98a3058af8a40db93b64528fb711a429ea',
        88700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f930926cd0cbbde94c51659420d91fb464c93fa3109c6bdf553a706985e307e2',
        91740,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'B612',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the B612 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612
  static TextTheme b612TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.b612(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.b612(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.b612(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.b612(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.b612(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.b612(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.b612(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.b612(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.b612(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.b612(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.b612(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.b612(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.b612(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.b612(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.b612(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the B612 Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612+Mono
  static TextStyle b612Mono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ffa9cacfa6fcd1a7a413d3b87f6f5ac6e2b201649b64695d976e0af5a46d512',
        86196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '55c1dcdfe00e2848cd4e1946617c601f62a0828e6ba3c73924b8b4f4e705785c',
        88684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '515c42e5f2790fd973f2ee9685301efa0110bc2dfb33df69b57875318ad1e100',
        85172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a4a6d28684fe7467e89b15c82070e98ed4c0623a5df5a9a05d347f757cda41e6',
        87488,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'B612Mono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the B612 Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612+Mono
  static TextTheme b612MonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.b612Mono(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.b612Mono(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.b612Mono(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.b612Mono(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.b612Mono(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.b612Mono(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.b612Mono(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.b612Mono(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.b612Mono(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.b612Mono(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.b612Mono(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.b612Mono(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.b612Mono(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.b612Mono(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.b612Mono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bad Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bad+Script
  static TextStyle badScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85388546eb146e3e3bf5803d4a47f053ad2a9491ee3470c23912777bfbfbc111',
        54372,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BadScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bad Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bad+Script
  static TextTheme badScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.badScript(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.badScript(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.badScript(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.badScript(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.badScript(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.badScript(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.badScript(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.badScript(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.badScript(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.badScript(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.badScript(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.badScript(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.badScript(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.badScript(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.badScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bahiana font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahiana
  static TextStyle bahiana({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1134edff7d2708933a16883c07c5223938a3500e9880b289c754c2602b9181f7',
        51296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bahiana',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bahiana font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahiana
  static TextTheme bahianaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bahiana(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bahiana(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bahiana(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bahiana(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bahiana(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bahiana(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bahiana(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bahiana(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bahiana(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bahiana(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bahiana(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bahiana(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bahiana(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bahiana(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bahiana(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bahianita font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahianita
  static TextStyle bahianita({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8eae7d3828ad86d4af376a41fb9bd577433f7b9acf6f561f8c3383bf8f37224b',
        91540,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bahianita',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bahianita font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahianita
  static TextTheme bahianitaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bahianita(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bahianita(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bahianita(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bahianita(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bahianita(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bahianita(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bahianita(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bahianita(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bahianita(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bahianita(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bahianita(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bahianita(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bahianita(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bahianita(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bahianita(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bai Jamjuree font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bai+Jamjuree
  static TextStyle baiJamjuree({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdb9acd5c9a309240a161cc16a0a5e3a1f3bf9258d1f2cf14fdfdf6f79d83c8e',
        78044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fff587a7a746a3d84947c3982968551180877152f29ac4e6b58a5d060e741ee3',
        83600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '253ea5a1c8d0d3dacbf5b9f0db496617c2af6b95a5e0680df9c9c62b989b1799',
        78384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c31f0c72862a5db7605a1625ddf34cc3c20c1c8a756b7d8848bf7f57a2707e0c',
        83780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1dad5e37560fcacf02277fc359aecaab78b734f4a4839c6cf910296b20101fa',
        78416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e8939d2176c550b12487aed8e2fbc3b25917494c1174787534ed05c61be397f2',
        83856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f9c01d94ba412108985bed479c74ca19d6b1b8c6982ee1fc113a970d5d323ea',
        78428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '01569d323f908485836ed8c94772695fc05a4b02812f4f29a62ec257f911b55b',
        83944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a2ef2b81cbfb6b9a14a4bb8931a87a0887e676e237a098c40aa9e61d601dcbd2',
        78412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7db95e5673e505c331643e67b6172b4465e72300e3642242b55e75a28d7f5883',
        83776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e456eaafee629c1aa6ffda2fbc121b9b76b54ab7f4b6dcaac6a4a523263b2237',
        78104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3445df11af52dc901fce718f3b68b4df5dc14a6c7b2ae6399dcf47c7fa7dd34b',
        83360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BaiJamjuree',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bai Jamjuree font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bai+Jamjuree
  static TextTheme baiJamjureeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.baiJamjuree(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.baiJamjuree(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.baiJamjuree(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.baiJamjuree(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.baiJamjuree(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.baiJamjuree(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.baiJamjuree(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.baiJamjuree(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.baiJamjuree(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.baiJamjuree(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.baiJamjuree(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.baiJamjuree(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.baiJamjuree(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.baiJamjuree(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.baiJamjuree(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bakbak One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bakbak+One
  static TextStyle bakbakOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad261ccadac3c182a1a7fe97f1a4451e76fe99ddcfdf24cc848ca6e14fb22b90',
        146024,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BakbakOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bakbak One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bakbak+One
  static TextTheme bakbakOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bakbakOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bakbakOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bakbakOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bakbakOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bakbakOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bakbakOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bakbakOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bakbakOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bakbakOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bakbakOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bakbakOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bakbakOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bakbakOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bakbakOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bakbakOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo
  static TextStyle baloo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2466b115f1d612b5be7c3c51aa118d952041ad4c9ebc6b790d3659c11ae3681d',
        386736,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baloo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo
  static TextTheme balooTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.baloo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.baloo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.baloo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.baloo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.baloo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.baloo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.baloo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.baloo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.baloo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.baloo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.baloo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.baloo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.baloo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.baloo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.baloo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+2
  static TextStyle baloo2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50f1fa75576179db905615b5082a9cc002d428b28978b665b2104c7bb66dc734',
        418540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a75bd421ee450e7d822122c1a1a14bc950175c2ffacf755fae53c2a69081e5a8',
        418852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '29ae9534de2fdb12104bd01aed59e45714043b2385ae9e27260c70f3d313df1a',
        418760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19b747c63cb3dfb634894e1724013a5013b9913f344e4db2d926bc8ad66b0d11',
        418628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3e109e93272c4824337c012dd567915c1a7a0cf9542c54f46fca29cfec233d8',
        418236,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baloo2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+2
  static TextTheme baloo2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.baloo2(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.baloo2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.baloo2(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.baloo2(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.baloo2(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.baloo2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.baloo2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.baloo2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.baloo2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.baloo2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.baloo2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.baloo2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.baloo2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.baloo2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.baloo2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Bhai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhai
  static TextStyle balooBhai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '678bfe33602fe168ee8732abcdc1ea3a454798cd99cb4f81f7e9d16581a7e2ed',
        277392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhai
  static TextTheme balooBhaiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooBhai(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.balooBhai(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooBhai(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.balooBhai(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooBhai(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.balooBhai(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooBhai(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooBhai(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooBhai(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooBhai(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooBhai(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooBhai(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooBhai(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooBhai(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooBhai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Bhai 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhai+2
  static TextStyle balooBhai2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f77231e378c1e0f35889351005528d442b76a08b428547f8681a58d8a25018d',
        539732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8256fc1059c0c31c79bf1055af14dfbf465482649e9aaf7b46ae7037a1ee46d',
        539852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '543bb68e0d2faeab4410e4bbb6304a4e64cbf1ea00eff0afc875fb5476f3d64d',
        540084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ddd339d75d662fd3a7e3df7a3ecb9f7b63b9f644edbdf30f10d5cd30f4269608',
        539956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2c5414d8fbd676015be0628b947eba4b4ca682a2e13e759d308a53a56b6d3ae1',
        539476,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhai2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhai 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhai+2
  static TextTheme balooBhai2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooBhai2(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.balooBhai2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooBhai2(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.balooBhai2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooBhai2(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.balooBhai2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooBhai2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooBhai2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooBhai2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooBhai2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooBhai2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooBhai2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooBhai2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooBhai2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooBhai2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Bhaijaan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaijaan
  static TextStyle balooBhaijaan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52b00fb70a18a89da089a7492d3d97836ec7bd211288d3ec4ad6a60914db3dd3',
        171132,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhaijaan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhaijaan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaijaan
  static TextTheme balooBhaijaanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.balooBhaijaan(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooBhaijaan(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.balooBhaijaan(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooBhaijaan(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooBhaijaan(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooBhaijaan(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooBhaijaan(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooBhaijaan(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooBhaijaan(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooBhaijaan(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooBhaijaan(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooBhaijaan(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooBhaijaan(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooBhaijaan(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooBhaijaan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Bhaijaan 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaijaan+2
  static TextStyle balooBhaijaan2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bdf9cf4da53391e4964ce53fa661740d80743524fc9c63410fa46975b1c6bb9',
        167644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '015ae39bc2f2da3e78cba0e127c7d2a12354e09a5347cf3b1399840ed12ebeb4',
        167880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5458f762cd4c6c4bd759c1040c9768a3f4dd6a7192fd8c7ec53c6ae3d3c24707',
        167896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd0a76003e8d5c7207e0b2c47761dc720f2a641c917788860e7668e03583c5333',
        167880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a93ab0920d84c5e00dc61f4c359999f8a1e5a5d05c7997b8b86a50fe3ee07d73',
        167716,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhaijaan2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhaijaan 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaijaan+2
  static TextTheme balooBhaijaan2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.balooBhaijaan2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooBhaijaan2(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.balooBhaijaan2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooBhaijaan2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooBhaijaan2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooBhaijaan2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooBhaijaan2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooBhaijaan2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooBhaijaan2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooBhaijaan2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooBhaijaan2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooBhaijaan2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooBhaijaan2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooBhaijaan2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooBhaijaan2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Bhaina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaina
  static TextStyle balooBhaina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '86bbf2a9f2b3936c4b1907de7136a4ca0f71efacfe22b7a6fa1b8a8a81f86282',
        262212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhaina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhaina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaina
  static TextTheme balooBhainaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooBhaina(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooBhaina(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooBhaina(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooBhaina(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooBhaina(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooBhaina(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooBhaina(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooBhaina(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooBhaina(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooBhaina(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooBhaina(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooBhaina(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooBhaina(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooBhaina(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooBhaina(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Bhaina 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaina+2
  static TextStyle balooBhaina2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5b9208ff3dd1e0390cef097fa5e5d7d6ec9812dbf9e21b0d6a6fb65dc1af33b4',
        273820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0573a15884d1a9ff4d1c8c6f73f9ba9ed56be4eb55bc274f1bcd50711fd29f52',
        274868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a439bf203f075c1959d34a6980c5a25f43c792eba25ca64383b84ea525e2904',
        274900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e6b18bc5ebd33d0a8665cc890dfd74ed52496b7ba6df8dd3d2c857d29e195f3',
        274736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81f55e89e694069e05eab12c0d4b4cf1c4b3d76aba366df382d04cab2d710b07',
        273220,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhaina2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhaina 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaina+2
  static TextTheme balooBhaina2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooBhaina2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooBhaina2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooBhaina2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooBhaina2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooBhaina2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooBhaina2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooBhaina2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooBhaina2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooBhaina2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooBhaina2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooBhaina2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooBhaina2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooBhaina2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooBhaina2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooBhaina2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Chettan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Chettan
  static TextStyle balooChettan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5e430d6e47dbe9220996407624585cda368b6ce19a23c3f46844a06db3c0a679',
        217796,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooChettan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Chettan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Chettan
  static TextTheme balooChettanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooChettan(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooChettan(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooChettan(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooChettan(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooChettan(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooChettan(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooChettan(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooChettan(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooChettan(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooChettan(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooChettan(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooChettan(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooChettan(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooChettan(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooChettan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Chettan 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Chettan+2
  static TextStyle balooChettan2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af187faa14f0b4d90d4b7fe397e38be6fd453e3aa17a729b517c0ef726922ad4',
        191080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '96aea35a01a609c9b9684550058fb7bf16b63c3f66fd6e90179350f0f9495a05',
        191676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05698cf8974676fc630d827c82d2d9c3551cc40539fcd5cd5bc139b320445ab0',
        191668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a3cdaa152c3ac6d72497123ce30e38cd5e698598db3ae1b9a29f374e2528c8d',
        191576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee8f98eeeaae014a51bcc36d2f594d850842e4eeeb155b7edb6404c9d567593e',
        191428,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooChettan2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Chettan 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Chettan+2
  static TextTheme balooChettan2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.balooChettan2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooChettan2(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.balooChettan2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooChettan2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooChettan2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooChettan2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooChettan2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooChettan2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooChettan2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooChettan2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooChettan2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooChettan2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooChettan2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooChettan2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooChettan2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Da font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Da
  static TextStyle balooDa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88a331b2ae3e4db09605af2b1076b22c3734e2ecfd1b4ef1f4ca57446672e6cf',
        288676,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooDa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Da font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Da
  static TextTheme balooDaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooDa(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.balooDa(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooDa(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.balooDa(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.balooDa(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.balooDa(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooDa(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooDa(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooDa(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooDa(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooDa(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooDa(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooDa(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooDa(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooDa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Da 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Da+2
  static TextStyle balooDa2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a4320e8c2c249a46f3d46e23da2f071abe081b23cf282495ba93a3d6f79d52c3',
        269952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db6079f2c759d759c23845143ca2279d4a7dcc4750d38092979d3a97e53be87c',
        270480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ab5d23427bc5a4390f10308d0ebf872aad08181af3d50b23a1c2b1bfd7847dd',
        270608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'efbd830048983225f35b73d86f55eb1ccc8a6fb89967ac8187570c946f4275ad',
        270288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd8d1033cf085ab33c1c97619c67bdc6f46d6656a955227f30a7cc79390327a52',
        269412,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooDa2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Da 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Da+2
  static TextTheme balooDa2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooDa2(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.balooDa2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooDa2(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.balooDa2(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.balooDa2(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.balooDa2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooDa2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooDa2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooDa2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooDa2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooDa2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooDa2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooDa2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooDa2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooDa2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Paaji font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Paaji
  static TextStyle balooPaaji({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95ba9f62ad854dc07958f311af18c674ca943fa7450fa4f6640d18e8eccdfe3f',
        185064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooPaaji',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Paaji font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Paaji
  static TextTheme balooPaajiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooPaaji(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.balooPaaji(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooPaaji(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.balooPaaji(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooPaaji(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.balooPaaji(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooPaaji(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooPaaji(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooPaaji(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooPaaji(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooPaaji(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooPaaji(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooPaaji(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooPaaji(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooPaaji(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Paaji 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Paaji+2
  static TextStyle balooPaaji2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a99cd8c935313e394111a744d82a8f539a54d43b38cf43797f1ffe788b157b2',
        148084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd686d10ca6d4b9ecfe632d22b6cfaa345cd6ce5ff327f65fd0de3b083b8481e1',
        148324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf268c63ba37c47821e4e9322f3e865d0921f0de24cdd5c1f59e63a61da79db2',
        148316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c54e7da8c2ced370202fb07d7d8136c0e739f5eaa321585db788716f48801d04',
        148188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '664ee4d64437ca980964284054825a3241c268749e439537f993ff69025bacba',
        148120,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooPaaji2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Paaji 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Paaji+2
  static TextTheme balooPaaji2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooPaaji2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooPaaji2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooPaaji2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooPaaji2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooPaaji2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooPaaji2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooPaaji2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooPaaji2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooPaaji2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooPaaji2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooPaaji2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooPaaji2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooPaaji2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooPaaji2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooPaaji2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Tamma font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tamma
  static TextStyle balooTamma({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8005871563cf3cfadf580fba66361b46649b342e9e1765d65405765af6e92c4',
        389440,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooTamma',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Tamma font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tamma
  static TextTheme balooTammaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooTamma(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.balooTamma(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooTamma(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.balooTamma(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooTamma(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.balooTamma(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooTamma(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooTamma(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooTamma(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooTamma(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooTamma(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooTamma(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooTamma(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooTamma(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooTamma(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Tamma 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tamma+2
  static TextStyle balooTamma2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f92657afb4b2f15e8fac2d4691d62acee86045cca51a987f8f4f04873bf38e1',
        280440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a73e821f0858fd50d0cce6b298e3d40d04548f464385f283118dde9aeccc0ac',
        281528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de3910900e7a20797c8ea9ccad5c24ec1593ce226f1c7258bb39e08e900a2386',
        281668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ebe046951e426194621fe77ed17a6f500e804a1016d550c34817e4010e87d505',
        281592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '224e88a3618a2dd207255fb20e5981bc75d28fff2efe84200280bbac80a42a26',
        280984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooTamma2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Tamma 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tamma+2
  static TextTheme balooTamma2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooTamma2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooTamma2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooTamma2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooTamma2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooTamma2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooTamma2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooTamma2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooTamma2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooTamma2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooTamma2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooTamma2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooTamma2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooTamma2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooTamma2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooTamma2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Tammudu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tammudu
  static TextStyle balooTammudu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7bc7db26ac47d3561769f8cb3dfb93afd2767965efbd2770a77f8ffb33c5a013',
        406812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooTammudu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Tammudu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tammudu
  static TextTheme balooTammuduTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooTammudu(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooTammudu(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooTammudu(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooTammudu(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooTammudu(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooTammudu(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooTammudu(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooTammudu(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooTammudu(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooTammudu(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooTammudu(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooTammudu(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooTammudu(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooTammudu(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooTammudu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Tammudu 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tammudu+2
  static TextStyle balooTammudu2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '26d89904983b89ec9d35c3ff0926caddbd573d1819c9cc5e075076e32fae1e2e',
        388492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '450e924c9b1553fb6a2dac936b4969a3c17e945106eda976bc3a9430495bb944',
        389948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5240982376f483e2f466392812aaf742861add0608c00f1a0e4fd75c39537fdd',
        389924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '127c1d082ab229aa23f6cbe6d8bf4896cca953566fdd2ac230cbac1c93d2cf09',
        389872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a68cd6a9804defcaa7cab652a50f1ca88488833995452234d85f82222ba0a33e',
        388168,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooTammudu2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Tammudu 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tammudu+2
  static TextTheme balooTammudu2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.balooTammudu2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooTammudu2(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.balooTammudu2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooTammudu2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooTammudu2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooTammudu2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooTammudu2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooTammudu2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooTammudu2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooTammudu2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooTammudu2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooTammudu2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooTammudu2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooTammudu2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooTammudu2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Thambi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Thambi
  static TextStyle balooThambi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5eb4d30c776f864b83a43cfbbcf1d05dda4a119a042f5a735adb014fdb4707e3',
        200468,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooThambi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Thambi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Thambi
  static TextTheme balooThambiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooThambi(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooThambi(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooThambi(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooThambi(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooThambi(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooThambi(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooThambi(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooThambi(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooThambi(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooThambi(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooThambi(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooThambi(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooThambi(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooThambi(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooThambi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Thambi 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Thambi+2
  static TextStyle balooThambi2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0832b1721d4a2eaacea1a3ea56da049a7ac7bc37e948ba4ea6a7055aac3233cf',
        171208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bf994fbad7fcb711fc55e9a3873edbef46b1ac4f147c0922c0c3f13831057f7',
        171444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '74c3fee0953424c375ad7dd24c84125a3ad2b582171e7d5aa4fafd74493cd3ac',
        171516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a983a3ba859b623947f3e05e74976932e533aa647a5a992bedc19bc034b0fb8d',
        171152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f02c70eca53d0c0e93cd1aa4811516f597efc42ca65f6f3830a55958e855ce54',
        171152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooThambi2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Thambi 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Thambi+2
  static TextTheme balooThambi2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooThambi2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooThambi2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooThambi2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooThambi2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooThambi2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooThambi2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooThambi2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooThambi2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooThambi2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooThambi2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooThambi2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooThambi2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooThambi2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooThambi2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooThambi2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Balsamiq Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balsamiq+Sans
  static TextStyle balsamiqSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e06cc657444119a9850424b46ff940639699d52e1c3031047cb7fc3691a6c33e',
        303084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '029988fdbc0ec2b09771bb360c222d7c13d7247fd1c37c3e82858febc4f78349',
        283788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de004fda1323e24a4c16a3f11bb31263cbef6c1ed531a72ff49866f47c488fa1',
        275832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f7734baad3cbcee8aea5640e4c79b22fe23e57a1a619020095e4e4d2d723f98b',
        257140,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalsamiqSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Balsamiq Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balsamiq+Sans
  static TextTheme balsamiqSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balsamiqSans(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balsamiqSans(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balsamiqSans(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balsamiqSans(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balsamiqSans(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balsamiqSans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balsamiqSans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balsamiqSans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balsamiqSans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balsamiqSans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balsamiqSans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balsamiqSans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balsamiqSans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balsamiqSans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balsamiqSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Balthazar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balthazar
  static TextStyle balthazar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f532266accd2179da995d74ed36fa8bf3095162e9404d68381594561a335b66',
        28176,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Balthazar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Balthazar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balthazar
  static TextTheme balthazarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balthazar(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.balthazar(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balthazar(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.balthazar(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balthazar(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.balthazar(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balthazar(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balthazar(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balthazar(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balthazar(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balthazar(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balthazar(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balthazar(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balthazar(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balthazar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bangers font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bangers
  static TextStyle bangers({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '42a6646ed15dc91b9430f7e69e6259203235b48fa12c9cc10b6b72afab348de0',
        75700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bangers',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bangers font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bangers
  static TextTheme bangersTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bangers(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bangers(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bangers(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bangers(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bangers(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bangers(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bangers(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bangers(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bangers(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bangers(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bangers(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bangers(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bangers(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bangers(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bangers(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barlow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow
  static TextStyle barlow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cbc7c82fdee3fa8b92bb23c3b9a2e8030733dbbc7322cd0c547b7c1889e7ecc0',
        61884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f69e0bff8f7ab1739bd00636f1efa74a5937c7d34ae95b4ce353b4baad0eae33',
        65692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6759b2d507f1549918b6b4a394efcca8982958de5ac4134d359b7162e12701ba',
        62392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f750383a2bd7ca69e5e24c2f3fcf974a67a9e98818703c12d9fd2600d62b49cf',
        66844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f582c8c58e673f459c2daf36fb9e1d3522dd5a7c50e0b8ee02d5a95089fff221',
        64984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5ccb6cff74b4b842a4da09f1543e6f2ab54f86a0e75b997b7ef375159d0f9bca',
        68556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1e3cf893b74f13d898b529820f0e01dd59c5c3f6f69635604600893cc99c914',
        62316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '512de0e21c7303a0b6718ff5cf57c376345786cc521ce3851053764f55398e53',
        66936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ed898f9a3aa42d3615c69b731f57305ce7006e87e29042e8467203889f0ff3a',
        64904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b84f9e4475585d31451021e3e9d27e8336f00eac47c6753193de4033f15ea30d',
        68204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88497110ef5b50e3903b3c97ee671e01497a9a6d49f64218c9a70fd5042c3b49',
        62368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '53cad3b96c2a07c4af9d7111e1b6eaf07718e6510b0ccf65140b1ee7040da9b3',
        67272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7513399e0a26a50c0f81fab7a114c8f40337b1d2edd0f28abed3f23ff5232c1',
        62356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '274e649f86e4323b0b8553520d855c49523b84eb9269b8e0cf9f41d201e76068',
        65900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6063124468c1350716105b1b52edec1c02bbbea85a0d675477016f425f457c9a',
        64856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a4cbccba78e5ea3a5c9560b15ff91d04b88b7a8cadb3c81b64ceb9ebd5fc266f',
        68012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb60a33ebebe512faae572e414c6865041ea47c278458a28cdcadc762958bd4b',
        61268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cabd84f11a9c742e6116cea169752a0f8c03073eeb60dc0ab4532987bd853878',
        66736,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Barlow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barlow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow
  static TextTheme barlowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.barlow(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.barlow(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.barlow(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.barlow(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.barlow(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.barlow(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.barlow(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.barlow(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.barlow(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.barlow(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.barlow(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.barlow(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.barlow(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.barlow(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.barlow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barlow Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Condensed
  static TextStyle barlowCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6f3686935062113e7b09390ffc3c690c608aa440f3e30db068b64420664ec5d',
        60532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ea5455d6f97ca5ea27d76f30e87b842dc23d6a9fdd9566ccffb6415a3a56bcb0',
        65992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '410b2efcf0b449d214182287f404b669840f4cc0a3c2f04940cee2d94b6eed4e',
        60752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bba549e676526ff4957a986006a9290f70d407fc1fd00d34135a1291ce6138d4',
        65952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9bcf33e336ef2238ede09a908f8b86c6cca1586df6b1fbe0d59e462e3149b8ba',
        60544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '49c62182eb883aeeab13fa2dbfcde072f2aac31e8bf77a232696bebc3b14e856',
        65664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e5dff25ad8b2553decdba77625dc57cdcba97555b53612a9c9bfa40f43f953c',
        60524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '65d8e8aa8d380e24c33fe4d2da62c7f9ec3de8e3429671ef5ff32782d21d649a',
        65840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8014ab571e1d04db59a24744420219343b4d1806c983ac73e808a9e96c638306',
        60404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dc26bbeb004e7e2084d0662973c4742fa65fd15b7eda3cb74826a27d686f44b0',
        65284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36127289f54d9e42dd6bba46b0f52ce7e1839e79ce1b4d8fc5b22a54ee7c30f3',
        63120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '70e3edc6f039c1a69acb610d298d522d5b46330458810ec9647e08c87b476dbb',
        66768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec8d231a02a1e88872bef49e1099c712e93f3a723722a3d3ddc0fe2bfbe40962',
        63072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'edbf575a42819a83bc5539e63b01efa4299d750d2f679579ef7673c972e3211e',
        66532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e17df55a2cb70a97d869d33d55b38a29d60d31ae75c0bcaf61aca5f1215702cd',
        62876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '34b5cbd8a9497c32949bcad7e8bd3f63019f7d28e693401b3ac39a69b5cd778d',
        66084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5db2f838d3b4d86fe437bcaef0fb569cf99cfda6377a230687348897a816eeb5',
        61360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'de353be0369b799b090de4e2e272ebe13c6fd496973ff92b9e391656334ad1f2',
        64724,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BarlowCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barlow Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Condensed
  static TextTheme barlowCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.barlowCondensed(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.barlowCondensed(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.barlowCondensed(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.barlowCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.barlowCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.barlowCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.barlowCondensed(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.barlowCondensed(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.barlowCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.barlowCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.barlowCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.barlowCondensed(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.barlowCondensed(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.barlowCondensed(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.barlowCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barlow Semi Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Semi+Condensed
  static TextStyle barlowSemiCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '429d1fa72c7702c9b3dcb38d750756505166e563306daaf1b66cb753a68f9e2d',
        62376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '39a411a6e0b959d02638199381cb91af60eb4da3e34ac231c61bea08043966e1',
        67272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd4d4a161e4199c955202ca92d228838efee2dfa3cf68a0cf388085e19395aa5f',
        62680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '79508f19bd17b1cdbf0b5b6f486c964d65c4a893a7f8f739a63cb71d206bb157',
        67540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b2c8175065ed2235c4db66650397fad918d8f97db3f1b3991125f2df604b76c',
        62680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b1eca79a9e101dd60e1836afb98fee66886d6042c2870f88b7ec822a7b97877b',
        67388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a9dca109aaa256a5afb98477989b87e0e102269f948949e5573b65b45779d4e',
        62588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '97fff70c506e46d82a769311aa3efd01c86a10161c92dee921fb6c75da5ba39c',
        67012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '73e602f9d74684f25a9d352cc61a0cfefc4ab505dfecb50b843492b1b5a87c3e',
        62528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f1b5d4427848534739c734c5af7bdae1967a666e5c68e04156f0c5a60c1a1c78',
        66868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b98dce5b8a6c1c5c2804cd26be37b203c56aee083840f4bad5d1907c4bf0b295',
        65064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '82e1d9e57f5b1c3fba390bb1e428d9b26538ead3342f04c40e60ded6325cc06e',
        68404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'acfd284673d183fe78a563ebf695ce70f7800151495260debfa9532d93289a55',
        65208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e07191b9549a6c8c553608c75269487bb83c555c9e2fd9c08cfe704a5416e750',
        68320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b42194ff2e3637db2ee27a0720eed118d756d564014725a948bcdc8964d25901',
        65240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '36f4cee581975816949c810a10be068d6131acdc211a99acb3a2ce6c9586174f',
        68236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2305373351846fd5f75bfb35b24697021e9bd4ea4fac80bb25bfe62c9afcb604',
        63764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '29476cff7567544f2a04e61c90254033e0eb160089bfae4dea9871e8f6fbe2f9',
        67124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BarlowSemiCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barlow Semi Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Semi+Condensed
  static TextTheme barlowSemiCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barriecito font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barriecito
  static TextStyle barriecito({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cbd439bbca5ece3347c1497394d9cdfd488742cc10ccd2413cdba4e819f236bb',
        167636,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Barriecito',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barriecito font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barriecito
  static TextTheme barriecitoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.barriecito(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.barriecito(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.barriecito(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.barriecito(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.barriecito(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.barriecito(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.barriecito(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.barriecito(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.barriecito(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.barriecito(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.barriecito(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.barriecito(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.barriecito(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.barriecito(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.barriecito(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barrio font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barrio
  static TextStyle barrio({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e1745250902305ccc432fd4ac10b9b248159dddd57634c31c70b8b4f3e3983f1',
        146692,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Barrio',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barrio font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barrio
  static TextTheme barrioTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.barrio(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.barrio(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.barrio(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.barrio(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.barrio(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.barrio(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.barrio(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.barrio(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.barrio(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.barrio(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.barrio(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.barrio(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.barrio(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.barrio(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.barrio(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Basic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Basic
  static TextStyle basic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '29cf0f576451b712f706b5f33a2e8e1b6e2be41ed145ebce30bcf8828ec37960',
        45400,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Basic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Basic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Basic
  static TextTheme basicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.basic(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.basic(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.basic(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.basic(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.basic(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.basic(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.basic(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.basic(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.basic(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.basic(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.basic(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.basic(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.basic(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.basic(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.basic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baskervville font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baskervville
  static TextStyle baskervville({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f83292ed3ada742c822e6b55c57b05a68a0d27b136b872ed2cb3edaf2dd778c',
        46788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fdcacb6cacae51af7ce0b4bc57b4400feedcf38a9e21898b144205607cd15185',
        48936,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baskervville',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baskervville font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baskervville
  static TextTheme baskervvilleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.baskervville(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.baskervville(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.baskervville(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.baskervville(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.baskervville(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.baskervville(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.baskervville(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.baskervville(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.baskervville(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.baskervville(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.baskervville(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.baskervville(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.baskervville(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.baskervville(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.baskervville(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baumans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baumans
  static TextStyle baumans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f9e8b94de7e96a118ae0165a927ffde8127bb9105f38bc5c39359622c7c40f4',
        38752,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baumans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baumans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baumans
  static TextTheme baumansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.baumans(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.baumans(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.baumans(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.baumans(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.baumans(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.baumans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.baumans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.baumans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.baumans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.baumans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.baumans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.baumans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.baumans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.baumans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.baumans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Be Vietnam font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Be+Vietnam
  static TextStyle beVietnam({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0cc0f5cd392e42154ccdcf1ffc6987159ee0807caf89c6ac0796a273c9c80cd4',
        43452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '11b1d7f41abb8a24b4ba203416df07809dbaf7de51619a1d167ab9af0361b6b7',
        44588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03d32b9f1d2ddaa56a41075b22ab477cbc078409bda7fe7f7e030491bf70988a',
        43992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a46d7c089e1fe8c124bc2de7b2cdf8a7f23fc0e9724766f3029c5c528b88b2cf',
        45400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '79220c67d8f8488a5dc457833419e884bef66e01eae43ec9c9b7e2944c5d88f0',
        43896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e2928c1924824c824cac4ddaa74885a1fb9f3723429fa145c579cde5e79eeba5',
        45368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d504a978c86a628884d737bacc817b24a74963f8e36e6cab5e9b81b9977b1f4',
        43948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a2af11a383bfb3ee1ef8731946b78f349dce66a9151e6724f9428a29af43faac',
        45316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '94efd29230ff40c08cd89d8ae44d0e847ad17d53088280868a4bfbe29bc9afe0',
        43864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2e18bd0f37b3e15856f513a8bd6b5d019948460f502359bf06716759b5b07664',
        45424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f6fdb78c7c80b7871c787918369b6f9908cb55d29a6f68602b90d557a0ef839',
        43720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c54104de856f3762629b69585ceb0eed536f7f7a19d2a2e1cdb44c1b1398e6b8',
        45380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '920f1f8cbfb2d9b94b66296e1f4ddf430a02ce638be482c79c598832645fda13',
        43640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2140e6025b6df417db0a543e64c090a9a5aa119d7523fd43a5f806a1550bdb37',
        45296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BeVietnam',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Be Vietnam font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Be+Vietnam
  static TextTheme beVietnamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.beVietnam(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.beVietnam(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.beVietnam(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.beVietnam(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.beVietnam(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.beVietnam(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.beVietnam(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.beVietnam(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.beVietnam(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.beVietnam(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.beVietnam(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.beVietnam(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.beVietnam(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.beVietnam(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.beVietnam(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Be Vietnam Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Be+Vietnam+Pro
  static TextStyle beVietnamPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '031b377b332f95da1996500fb97fca5a8cd5f95522e852083d196c0bcefca6b2',
        72348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '623f374adea67c8f650c9c6e5d90b30602e7e5eccfb92bdbd59f607381e3d685',
        73916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6d33c91e88361e46ef97084811ce5943e715f130e6c5eb655c509cb61e56cd6',
        72252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'beca4da968f8fd5d2ff57f072c08b3ef5b719a6177c0cdaf5af411352ccac3ee',
        74416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '640424e70dcdaa495bf299facdf0bd803ea0492bd99642ff227a3f7a57b8ebdd',
        72484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c5a100db64d132fccebb61d4bd41cdbe878baba40f6d4969a091b3e9c5835fab',
        74252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0bec39a3895ccc7eec7131ac011754fa70315afed0061ec49d08dd587215174b',
        72288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'efcd7cebb01e08925565bf7304c7721c3846ab9ad36fe89f9dc79c49cdd4379a',
        74040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb68c949987e445999e4f0474fb0224289c6bc8fb00e56d7d9dfcc3006114598',
        72424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '377d647aa2a9f0f0220ca01557c18d98375005eb4e971aef8bee1a048bf2c90c',
        73976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2966316c8748b3e3167941ae9b48ee38c4af7e5c110202875d7cc0567a0169e9',
        72268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f243bdb9ef0545663215bfdfa72ddc42fa004725b443b4670fb52adb61480284',
        73448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d6b7608799789c3f8e5c896afc5f11d07402482092f341a4224e4d362f58b68',
        72172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a18cf3c2a37908a0d2bfbfd37376f4029e5709763df1e4df858ec281407afe8c',
        73308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '77e480c26df369171a0dcddf6eef76082774637010ae0bacefbae59159e34224',
        71864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0ffebfacff73e9d3225844e5efde238061ea50ac72c7eed5536f0334c1efae2b',
        73248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '632cec316b2bd7f440c0c647b9d1e95ef6e55338d4cc8c1979d642f0178ce981',
        70768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fd41536742311aacb3cada2492ea78f67ff700057c9af14f8fcb2cb05b45c37e',
        72052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BeVietnamPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Be Vietnam Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Be+Vietnam+Pro
  static TextTheme beVietnamProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.beVietnamPro(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.beVietnamPro(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.beVietnamPro(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.beVietnamPro(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.beVietnamPro(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.beVietnamPro(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.beVietnamPro(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.beVietnamPro(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.beVietnamPro(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.beVietnamPro(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.beVietnamPro(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.beVietnamPro(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.beVietnamPro(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.beVietnamPro(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.beVietnamPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bebas Neue font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bebas+Neue
  static TextStyle bebasNeue({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd16210fc689a14930beb51e89f3890e3167bdb105c0e7618abb62d6c4a2cc5d',
        37392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BebasNeue',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bebas Neue font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bebas+Neue
  static TextTheme bebasNeueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bebasNeue(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bebasNeue(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bebasNeue(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bebasNeue(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bebasNeue(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bebasNeue(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bebasNeue(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bebasNeue(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bebasNeue(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bebasNeue(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bebasNeue(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bebasNeue(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bebasNeue(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bebasNeue(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bebasNeue(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Belgrano font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belgrano
  static TextStyle belgrano({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b66b889e699bfe12ea9cc04621e48eed308f79ef2955cd4f20d0e7ddbcbaeab',
        29028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Belgrano',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Belgrano font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belgrano
  static TextTheme belgranoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.belgrano(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.belgrano(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.belgrano(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.belgrano(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.belgrano(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.belgrano(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.belgrano(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.belgrano(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.belgrano(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.belgrano(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.belgrano(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.belgrano(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.belgrano(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.belgrano(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.belgrano(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bellefair font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellefair
  static TextStyle bellefair({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '581fd752c6fe9933425b7868917fe51b6d222b42336b931e58385cea219007a0',
        46492,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bellefair',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bellefair font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellefair
  static TextTheme bellefairTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bellefair(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bellefair(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bellefair(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bellefair(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bellefair(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bellefair(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bellefair(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bellefair(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bellefair(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bellefair(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bellefair(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bellefair(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bellefair(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bellefair(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bellefair(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Belleza font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belleza
  static TextStyle belleza({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '916c38d3ec21ba4e080cbb7c82b60f62b023224acf789357a9338460a610def2',
        27772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Belleza',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Belleza font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belleza
  static TextTheme bellezaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.belleza(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.belleza(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.belleza(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.belleza(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.belleza(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.belleza(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.belleza(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.belleza(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.belleza(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.belleza(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.belleza(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.belleza(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.belleza(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.belleza(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.belleza(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bellota font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota
  static TextStyle bellota({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '29b1164370f0eca544e3c2cb64f06324bd098c99c35f5ecdd5527d6642e5a78f',
        87324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2876a1892bc886d0df661eef1cc4fd3273dc8bce9563d1a7fba2c72987e340c5',
        90184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ae1ca7fd73a6c369b6bf3b7326788cb2a360b467fa83a298140dac4166b8efa',
        86996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd628b046cfc942ee35db112226b78f9ac3973ccaf005074bbbe867656201b8ec',
        89836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac23e7ab6ffb89ee1593424695c867b8150bd97cd85fdbe2a3d7f89bf32a0973',
        87220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e876bb51e7fba1f8fadcef59f4b68e3020a0909557cef70a98c84253c9e32f2f',
        90052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bellota',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bellota font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota
  static TextTheme bellotaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bellota(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bellota(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bellota(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bellota(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bellota(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bellota(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bellota(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bellota(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bellota(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bellota(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bellota(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bellota(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bellota(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bellota(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bellota(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bellota Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota+Text
  static TextStyle bellotaText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0643b4ed7b9e5fe0a6023e98e3c731ac5ed3dd6a93688e6d319415902455806',
        85396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e0b3916debc6fdfc7a7fd3129785215a68039360ca58fff2137a5855ee962138',
        88396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd71701b5f03e11645c6c76521346bb0658b950d8e568f92dbad4c0f832775eb',
        85276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cab1408381b8c09a1322d14913d773a9ecd2af835363efced81df2db8aa5107b',
        88112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c08136cdca5423cf6e4f79255b1d8968b3ce107c396b03445f6c49c286dd349',
        85352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ec9c1edafbe6c75409ba2200628821ee1f0dbad581d6f79db100aeb366b12ee4',
        88192,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BellotaText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bellota Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota+Text
  static TextTheme bellotaTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bellotaText(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bellotaText(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bellotaText(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bellotaText(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bellotaText(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bellotaText(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bellotaText(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bellotaText(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bellotaText(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bellotaText(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bellotaText(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bellotaText(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bellotaText(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bellotaText(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bellotaText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BenchNine font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BenchNine
  static TextStyle benchNine({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '819e7479fd3310e52e9754666e7a85aae97b6ea92363f425c93d1763341c5720',
        38056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ff13f62cc4e1011ea688bc0bdad0ec34826a3c14cbc1b9ec0ed2b768a756be1',
        38812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad7761d772dd04c7cf6c3ea55ea6f5bc9ca1540a2961a12251b37aee5d067022',
        38748,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BenchNine',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BenchNine font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BenchNine
  static TextTheme benchNineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.benchNine(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.benchNine(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.benchNine(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.benchNine(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.benchNine(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.benchNine(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.benchNine(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.benchNine(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.benchNine(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.benchNine(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.benchNine(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.benchNine(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.benchNine(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.benchNine(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.benchNine(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bentham font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bentham
  static TextStyle bentham({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36b9c399aae73bd09e01d76e51e8697f80e9e34f14e954b929a08d6cfbc5f697',
        40176,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bentham',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bentham font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bentham
  static TextTheme benthamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bentham(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bentham(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bentham(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bentham(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bentham(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bentham(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bentham(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bentham(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bentham(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bentham(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bentham(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bentham(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bentham(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bentham(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bentham(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Berkshire Swash font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Berkshire+Swash
  static TextStyle berkshireSwash({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e73eb938ce44215938a21b199bc0a7eba8e1805d0d2528c3300ad7a1813d5e0',
        57948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BerkshireSwash',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Berkshire Swash font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Berkshire+Swash
  static TextTheme berkshireSwashTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.berkshireSwash(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.berkshireSwash(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.berkshireSwash(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.berkshireSwash(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.berkshireSwash(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.berkshireSwash(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.berkshireSwash(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.berkshireSwash(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.berkshireSwash(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.berkshireSwash(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.berkshireSwash(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.berkshireSwash(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.berkshireSwash(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.berkshireSwash(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.berkshireSwash(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Besley font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Besley
  static TextStyle besley({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '996fc0a7ae5a8dd33cf37073dc2ce08b220591215bcca76fe67834abc8962810',
        55960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f9bbdb98ffb8273aa66a11445e812d98e8e11542cc38b1def0ec270814a042a',
        56036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c3a17ae1149f3cdb1158266bb4b5c22ae62ce044e951124fe273d065f8fda1b',
        56044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f37839fc3286096ea12deb215849f68765998f3f2a4854d9c631f0183317bf87',
        55988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51a4fdf8f05eed2b6fb62479e644dcfcac56c8bb7fcc26fae2192486e0c5b5e8',
        56048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '62dfbeb5cf9e9f58e47c752855ac2890cf1ae580028e5e93bf916a8bbad416e7',
        56008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '56678de811af0d473572cc095f2cd93e18e10a82207b54ec581a6ad4b4375d81',
        56532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ff33ded3060192d7714b5bd91a5d7df7dc6d3393150f7a3df190f6a0e6b83e81',
        56728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '13401ce4349820156fcec4b0e53b29a81820897114e081a0e8f35ddd1ecd96c3',
        56764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7ce81f5bd7d1a13df8b7f99836d01b64d645545ec261172a638b3d31f176a436',
        56684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'abff22f994971a0ca872d74e8a52b95d4c77955822766b5633eed8789b70dd1e',
        56784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '18a9e8ab8c41769a85ac8bdf65517815fb36c31c37238b5f8063337073577b9a',
        56728,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Besley',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Besley font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Besley
  static TextTheme besleyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.besley(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.besley(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.besley(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.besley(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.besley(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.besley(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.besley(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.besley(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.besley(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.besley(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.besley(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.besley(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.besley(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.besley(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.besley(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Beth Ellen font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beth+Ellen
  static TextStyle bethEllen({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33f7d9b097ad741e56ef314b447fa4e0d310aab981ba6aea5db368053b65bc56',
        115600,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BethEllen',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Beth Ellen font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beth+Ellen
  static TextTheme bethEllenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bethEllen(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bethEllen(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bethEllen(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bethEllen(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bethEllen(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bethEllen(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bethEllen(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bethEllen(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bethEllen(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bethEllen(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bethEllen(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bethEllen(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bethEllen(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bethEllen(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bethEllen(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bevan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bevan
  static TextStyle bevan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95fb9ca931c31e79c8312fb66d76a2239472f842f9aeed9c261367a55723370f',
        55536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bevan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bevan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bevan
  static TextTheme bevanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bevan(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bevan(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bevan(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bevan(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bevan(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bevan(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bevan(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bevan(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bevan(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bevan(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bevan(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bevan(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bevan(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bevan(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bevan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Display
  static TextStyle bigShouldersDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '243bc59e9459b35c35fa0bc5cc49219e1cbf248be840664569ca730a8a7a7e5e',
        60384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9d601dd24fc0f4bb73ca5a9bc3fb23c2d744597df0f10a2894d566903ba1154',
        64044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d1c3a1a7aca284022f6d11318ac148fe815d11c400a02d20e25768bbcf17f16',
        63888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '782f7156f414a376945013c065917553e525e9f55dc801588c0f2f47406a51a3',
        63824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'abf50d14f1c83beca50dbf4875c46279d06f2120f997bd0b3670236cf24bf1aa',
        63924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '908c135c2591d12f000c0af1d59e56e72fb77beb39c1ba091505f250575b4ea6',
        63876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19b8e205eb51647a9245e28993f1aa99df1cdc107cab1e823db05dce048363ca',
        63916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71c2e1ad1b8e3abbf78e31165b5b054095b45b80cdd32410b9df8abaa45a631f',
        65188,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Display
  static TextTheme bigShouldersDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Inline Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Display
  static TextStyle bigShouldersInlineDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cecd28ac71e6d26fe426d809a967ca89fd34ebf00666daf5e72be698043690f8',
        98144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3710b6162121414170f4ee83003c9a801a07d3a8b78f6abbab39e670edc08a0b',
        99972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45fd384c9df07fc26138ac660041a108fad83e7e900169cd69ff9e1ff683c79e',
        100792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4485432c8a8581e0b3f3b507691b848e4673ba5d3606ccc8c51d573b9950d995',
        101060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8429a118926e0997b6894777f001d3c63d792b7b82f9bbd3ee909b393e049c73',
        101340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80e5e506aebe63f25614ef4b8b1a69935d750ff148abb1ed248d7c94b23cfb19',
        101752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e1b12519d38230d280f84445cb7e50edb127c715cdd6fb9e7697e29f7f77a0bf',
        102272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d986bf2e9666f76e4a791c20a4aa9255ec6f92d62eac8c45365f456e9b64bc1',
        102192,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersInlineDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Inline Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Display
  static TextTheme bigShouldersInlineDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Inline Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Text
  static TextStyle bigShouldersInlineText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '914a99a3f7a36509645da4d56298db3eaf53f8fe091adc6f511305a5b5415d94',
        98832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a4e1ca3362feca7026abcdc3f6cd27be00d437bdca4963451e70f627fc47285e',
        100608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8171ef16c4d2ccf81271d6bb77a9a25723b54e3033e75e930b47738e9f8f738c',
        101584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '07dddac8ecdf608d7eecb9031c91626e78dc9e0721d6e3861ce58cd5b205d8a7',
        101584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b3e3a0152deb77bbf594da21360ad2cd1012e94424ef6fb664f876cbeec5ee45',
        101692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0a7d5ffddfee40b18b44e3f89aac2801f82ed5cabcc11e6707b05525a55d3bb',
        102024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '26b8f325b1bcca1f6b88728184699789e3bf7ec260804d04421b5db694ae4157',
        102752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0169fdfd36818b76f6f2182152276acbf8129be7a3e4d0ad77755b6d069acb71',
        102380,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersInlineText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Inline Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Text
  static TextTheme bigShouldersInlineTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bigShouldersInlineText(
          textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bigShouldersInlineText(
          textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bigShouldersInlineText(
          textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bigShouldersInlineText(
          textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Stencil Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Display
  static TextStyle bigShouldersStencilDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e745115111f02d5a11cdf1328f3eecff1bb5f775cb0f2b06b4d8f24b196ac32e',
        57612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0f312a4998a7fdb735ce3e5c2cebb4c88987d6b221039c3ec51117af72a7a92d',
        59556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b8e0ce085bdd03707db89704d38ea6f6523ee0a6dc14dbe5e41ca65b3266958',
        59596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d0ca21a6f86141b1d824eecc8a4b221e2f9b0a2d99c35b4b8da6132324a2431',
        59536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c5b5b3228b0893035ab61f43b1666de4e2ac70346c6b5a0af6212dc881b2895',
        59488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f18fa1842c04a9bb7b65cd8865d8db3ad6129de5aba757f7dac332de21e2e557',
        59548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '999379e5037b63a0d57539a9aa7b10a200910a43531557a752265827a074c079',
        59848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6055fdd83b00cf395678263ba7a8d07c043046f85db67776ca586dfd72ced1a5',
        59592,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersStencilDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Stencil Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Display
  static TextTheme bigShouldersStencilDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Stencil Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Text
  static TextStyle bigShouldersStencilText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce5239dead961193d7ed14ae8ad117d8ac7c38b3004ce5268f79858cb05dff20',
        58792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b72cc9791d7c353499dd3cdd8cb057f1b737306474a92e64d32b94e60e63300a',
        60148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c3218546f3f3c56203170cf14894c6b0f93024f0759022205174bd64fe18b52',
        60140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b32127d757a06294d75c04041ebf65257d3b861075010b125b52b1872f0164a',
        60000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f502e0a1bfb3a7c94c8bd1d80fce760f9dbc080b53d928803846e0705859c342',
        59900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3e82a1e08ebbaaabd1a452bd3461bc4174ec94b641c99774dd41a1d552de12a7',
        59980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '814371b884bf588132731087f41533e3852bfa4953739fca42c71fcba588f073',
        59980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b6e75385f85cfb30647c3935bf4ed6f0dfad6012a0a38bad71cf46c32d2d9ce',
        59508,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersStencilText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Stencil Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Text
  static TextTheme bigShouldersStencilTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bigShouldersStencilText(
          textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bigShouldersStencilText(
          textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bigShouldersStencilText(
          textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bigShouldersStencilText(
          textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bigShouldersStencilText(
          textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bigShouldersStencilText(
          textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Text
  static TextStyle bigShouldersText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '627d92b7b60e71b44920b0badb4fab35e76dc999346110b16b5503642b274d9c',
        60972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8aef88ac2024c3940f399eee0642162cf1880de4b3072c385da26169385aaff9',
        64304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b28c250237404079c092e1f0bbe96a9877935f854758b23d0c596474d2dc0a9',
        64348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ceadafc7d9e2a44c734bb0219be7688bb6f03e1d0788f1a6fdaff25989c7c821',
        64240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '891fff63a87492e0329b1ad1261d5d60e1e276099f63a26b28497f66fddb1e58',
        64288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '089e74d0e80e3f820d20c2dadb61e35e88025df110b9bfdf6878dd0c88300f35',
        64144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c3090bbff39b913daac1ce49ed0afcd52cba93db2e114faba5840a983ff222f0',
        64208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a6e0bec5c1e7d0a62882e4f6be1b781665211f69d499f61aa439ad6bb097e60',
        65320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Text
  static TextTheme bigShouldersTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bigShouldersText(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bigShouldersText(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bigShouldersText(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bigShouldersText(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bigShouldersText(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bigShouldersText(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bigShouldersText(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.bigShouldersText(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bigShouldersText(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bigShouldersText(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bigShouldersText(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bigShouldersText(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bigShouldersText(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.bigShouldersText(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bigShouldersText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bigelow Rules font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigelow+Rules
  static TextStyle bigelowRules({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b86229b1bc741bc11ef0517467d96769485504f74278c1011120697a17d74d26',
        59028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigelowRules',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bigelow Rules font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigelow+Rules
  static TextTheme bigelowRulesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bigelowRules(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bigelowRules(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bigelowRules(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bigelowRules(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bigelowRules(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bigelowRules(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bigelowRules(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bigelowRules(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bigelowRules(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bigelowRules(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bigelowRules(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bigelowRules(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bigelowRules(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bigelowRules(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bigelowRules(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bigshot One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigshot+One
  static TextStyle bigshotOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd6b11ed5794f665b3e412e676ae624b63b086b93992d6c0b00c9afd26180c79',
        36972,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigshotOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bigshot One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigshot+One
  static TextTheme bigshotOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bigshotOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bigshotOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bigshotOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bigshotOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bigshotOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bigshotOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bigshotOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bigshotOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bigshotOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bigshotOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bigshotOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bigshotOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bigshotOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bigshotOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bigshotOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bilbo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo
  static TextStyle bilbo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55d2e6fb7257d5ade5d2419927eebf1f0c78ba65154b64d0cb737b6c8fa6a7df',
        42864,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bilbo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bilbo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo
  static TextTheme bilboTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bilbo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bilbo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bilbo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bilbo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bilbo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bilbo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bilbo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bilbo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bilbo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bilbo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bilbo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bilbo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bilbo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bilbo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bilbo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bilbo Swash Caps font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo+Swash+Caps
  static TextStyle bilboSwashCaps({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e55126acc93a6cae98b3736d06e24e1301a26f9aa4ac2173998ab1fa142b1736',
        58124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BilboSwashCaps',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bilbo Swash Caps font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo+Swash+Caps
  static TextTheme bilboSwashCapsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bilboSwashCaps(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bilboSwashCaps(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bilboSwashCaps(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bilboSwashCaps(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bilboSwashCaps(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bilboSwashCaps(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bilboSwashCaps(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bilboSwashCaps(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bilboSwashCaps(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bilboSwashCaps(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bilboSwashCaps(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bilboSwashCaps(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bilboSwashCaps(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bilboSwashCaps(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bilboSwashCaps(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BioRhyme font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme
  static TextStyle bioRhyme({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c7047e02059b7ea10893cf7bcfe3dc06e450dd3fb6000e05171462fedc43f7e',
        69848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9ee5307ca507a88bed949ef452d4b6c835e503ef09b30cbb1ace6d65030e873',
        72476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bfe90585ffc1c3fc0d661d75c86187e9b6176836b56026b7882465f43a328616',
        71764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd56fec3e00f732e0ff393a16cd304a5b4818b7b5bc437e4f418142a976284e6',
        71756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43c38cd7da3c0c61638db3dbfd450b28e4abcacc9a48011176274140cf681c2b',
        68792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BioRhyme',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BioRhyme font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme
  static TextTheme bioRhymeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bioRhyme(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bioRhyme(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bioRhyme(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bioRhyme(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bioRhyme(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bioRhyme(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bioRhyme(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bioRhyme(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bioRhyme(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bioRhyme(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bioRhyme(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bioRhyme(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bioRhyme(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bioRhyme(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bioRhyme(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BioRhyme Expanded font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme+Expanded
  static TextStyle bioRhymeExpanded({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7770459b3448470de7eebc842dd6d1b27857480f955caa6fda9114f30f9c487a',
        69024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '564af9bc89e9baac8c99c4a2b2bb1262ed16deaec1971840ab3e348ed0dc8e22',
        72648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1fa6003a77f1c41cfe89fc6db7c98358f0e6fa62b61c965e0e1a04ed960601b9',
        72028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '89375361cdabf9dbf2e57378fa40cc8c19512e518617d5e8502c9db8aa4ee2a1',
        71960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '586a8d74b8042767a173971c026734fb6cb75934497b3c9d2ebd80ad9e60c31d',
        71188,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BioRhymeExpanded',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BioRhyme Expanded font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme+Expanded
  static TextTheme bioRhymeExpandedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Birthstone font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Birthstone
  static TextStyle birthstone({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f3d248062a495d35e1234712de6d4e67724c5ebe2436f5597a457129950a850c',
        97112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Birthstone',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Birthstone font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Birthstone
  static TextTheme birthstoneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.birthstone(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.birthstone(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.birthstone(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.birthstone(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.birthstone(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.birthstone(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.birthstone(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.birthstone(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.birthstone(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.birthstone(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.birthstone(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.birthstone(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.birthstone(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.birthstone(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.birthstone(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Birthstone Bounce font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Birthstone+Bounce
  static TextStyle birthstoneBounce({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db4a20734f94b167a8b7b97639a8c07289d1f25c41afec846ea4d0fa0863fcf0',
        131944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87c3ba7dc30ec3cc8a7538a0a49d8a2b382dadbee3bd9b366843510f7a6f6357',
        129296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BirthstoneBounce',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Birthstone Bounce font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Birthstone+Bounce
  static TextTheme birthstoneBounceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.birthstoneBounce(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.birthstoneBounce(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.birthstoneBounce(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.birthstoneBounce(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.birthstoneBounce(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.birthstoneBounce(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.birthstoneBounce(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Biryani font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Biryani
  static TextStyle biryani({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f65303a20787e99a61c757c6e4cbc9ee68af544a375dac932049def734163642',
        123500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '842f2d86cd486de76ca080714383fb99a105dfb85b3bae4360d00e8ac8db8c9f',
        124924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16e70205340aba8294e2da2cc8581ec3c5fb3f2af846d51a3de360f447d6f254',
        124200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80169a7f1fadd79859c89b0e9a066fd8dbbc460f13a4e5df8389cd853dc67be9',
        124224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8834894534eb39412acdbc906f20b8d4addd5339d6777eaf647ee1ecbd44538c',
        123988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba9bcb5882f72d4ac114689fb32db356c2be660bc64a16c88ac2457bdbefd777',
        124032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5bad25e5e05861d1da7ddd858aefac18d200688fc997bf2760059fcc2c2ad30d',
        123080,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Biryani',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Biryani font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Biryani
  static TextTheme biryaniTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.biryani(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.biryani(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.biryani(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.biryani(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.biryani(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.biryani(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.biryani(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.biryani(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.biryani(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.biryani(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.biryani(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.biryani(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.biryani(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.biryani(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.biryani(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bitter font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bitter
  static TextStyle bitter({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '937e0cb8bbc92b1b89eafc86f73c06dec677f4e8d2c39de72208ae4fffedc7fa',
        24208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7a9ae7d2a6428de7df36662a7014e91b880c5d09663ae9c66abb8a928c0ad371',
        39064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c41cd10ef080e4d415bc6da6d86b29b73fe87ba84afe455423476109ed6addbd',
        25616,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bitter',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bitter font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bitter
  static TextTheme bitterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bitter(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bitter(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bitter(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bitter(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bitter(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bitter(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bitter(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bitter(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bitter(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bitter(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bitter(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bitter(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bitter(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bitter(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bitter(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Black And White Picture font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+And+White+Picture
  static TextStyle blackAndWhitePicture({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c951e047e8f1e152232363c35791b975f78ae96c97bfa6f14634c7a2551970c',
        9586680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlackAndWhitePicture',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Black And White Picture font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+And+White+Picture
  static TextTheme blackAndWhitePictureTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Black Han Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Han+Sans
  static TextStyle blackHanSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ea3e07623642e89ce9ae84a698b9557dd6361db9bc40b993b7715531404db088',
        382952,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlackHanSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Black Han Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Han+Sans
  static TextTheme blackHanSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.blackHanSans(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.blackHanSans(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.blackHanSans(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.blackHanSans(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.blackHanSans(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.blackHanSans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.blackHanSans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.blackHanSans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.blackHanSans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.blackHanSans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.blackHanSans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.blackHanSans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.blackHanSans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.blackHanSans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.blackHanSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Black Ops One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Ops+One
  static TextStyle blackOpsOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a9eebffdb4d3c168c63bfcd5d0ec80a1571160a66e46ef698786f9c56922256',
        41404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlackOpsOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Black Ops One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Ops+One
  static TextTheme blackOpsOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.blackOpsOne(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.blackOpsOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.blackOpsOne(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.blackOpsOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.blackOpsOne(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.blackOpsOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.blackOpsOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.blackOpsOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.blackOpsOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.blackOpsOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.blackOpsOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.blackOpsOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.blackOpsOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.blackOpsOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.blackOpsOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Blinker font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blinker
  static TextStyle blinker({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c240948a3fc8d5d8689c3a63f7f8ebc6306f7c85e807823569843f0f54195f9',
        47168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a79a8324609cc2b3bcdaec6541902337b886042ed55c471dbb6f257c65b280f',
        48596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3dd96a764325a06a02dcd84be7a03f3a2f2b6808e40d63328015690bf81f6c96',
        48440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51b0da89566f911a7458b35be7b50dd97cb0ac23dff1eeb067b4d64a79911f3c',
        47676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a51856bff19a13b746d4d2d4b3ebb07157b40df14a94c526837c9e5586337f01',
        53416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6eba9015f99f6f510f713d65f3f324ba543c2e9d3bc5eac9cbdd446b738eda1f',
        48892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd898f7f6b1fb3ed914d6dfaa20bc29b0f94d293822df46b2a78b5759f2637549',
        53068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d02003dcc4ca64b3de96560fffcdd9e05125270589caabebc0da78d05d0f61e',
        52352,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Blinker',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Blinker font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blinker
  static TextTheme blinkerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.blinker(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.blinker(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.blinker(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.blinker(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.blinker(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.blinker(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.blinker(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.blinker(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.blinker(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.blinker(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.blinker(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.blinker(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.blinker(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.blinker(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.blinker(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bona Nova font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bona+Nova
  static TextStyle bonaNova({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '078d2bfcfc80d682132d953545812db70e0f9f0b98ae0cac142ea71b158d1318',
        198112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f09688cecf4b8ba9818a169e25b836f04679a229109cb520cc95adef6e6ad81d',
        215808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43adb619f6b73f11f25abeeb80e1afc75285c402742402228abf38595b558505',
        196232,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BonaNova',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bona Nova font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bona+Nova
  static TextTheme bonaNovaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bonaNova(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bonaNova(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bonaNova(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bonaNova(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bonaNova(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bonaNova(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bonaNova(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bonaNova(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bonaNova(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bonaNova(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bonaNova(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bonaNova(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bonaNova(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bonaNova(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bonaNova(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bonbon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonbon
  static TextStyle bonbon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7c2ebdfc96584f15448c9196a29a7983cad1097756e748e6d3d89db0cab6796',
        38740,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bonbon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bonbon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonbon
  static TextTheme bonbonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bonbon(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bonbon(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bonbon(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bonbon(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bonbon(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bonbon(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bonbon(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bonbon(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bonbon(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bonbon(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bonbon(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bonbon(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bonbon(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bonbon(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bonbon(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bonheur Royale font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonheur+Royale
  static TextStyle bonheurRoyale({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '962bd9c44fd65031a838196c18c0b1056fa2a0e51177c9bfa257707464c1cd34',
        87220,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BonheurRoyale',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bonheur Royale font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonheur+Royale
  static TextTheme bonheurRoyaleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bonheurRoyale(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bonheurRoyale(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bonheurRoyale(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bonheurRoyale(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bonheurRoyale(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bonheurRoyale(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bonheurRoyale(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bonheurRoyale(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bonheurRoyale(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bonheurRoyale(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bonheurRoyale(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bonheurRoyale(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bonheurRoyale(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bonheurRoyale(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bonheurRoyale(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Boogaloo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Boogaloo
  static TextStyle boogaloo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ecd8d89eafeb4669ce51f02cef4e529aa97180ed7c2a9cfcbad4714ed9ede46f',
        33880,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Boogaloo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Boogaloo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Boogaloo
  static TextTheme boogalooTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.boogaloo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.boogaloo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.boogaloo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.boogaloo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.boogaloo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.boogaloo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.boogaloo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.boogaloo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.boogaloo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.boogaloo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.boogaloo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.boogaloo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.boogaloo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.boogaloo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.boogaloo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bowlby One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One
  static TextStyle bowlbyOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d04430262e4d8e8e549ffcc4c97a27cb31ad26f9d2d85b2ba224381697b1a8d',
        61596,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BowlbyOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bowlby One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One
  static TextTheme bowlbyOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bowlbyOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bowlbyOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bowlbyOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bowlbyOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bowlbyOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bowlbyOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bowlbyOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bowlbyOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bowlbyOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bowlbyOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bowlbyOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bowlbyOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bowlbyOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bowlbyOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bowlbyOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bowlby One SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One+SC
  static TextStyle bowlbyOneSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2826dfb2cc015f4d1a83c121524eff701bea716ad41719d21b0baaf0462abae',
        45072,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BowlbyOneSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bowlby One SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One+SC
  static TextTheme bowlbyOneScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bowlbyOneSc(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bowlbyOneSc(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bowlbyOneSc(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bowlbyOneSc(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bowlbyOneSc(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bowlbyOneSc(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bowlbyOneSc(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bowlbyOneSc(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bowlbyOneSc(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bowlbyOneSc(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bowlbyOneSc(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bowlbyOneSc(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bowlbyOneSc(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bowlbyOneSc(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bowlbyOneSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Brawler font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brawler
  static TextStyle brawler({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '58683ec3f93abe0d96615faa1fc7fce9f3297205572a4c8c6265d0be27219279',
        64320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Brawler',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Brawler font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brawler
  static TextTheme brawlerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.brawler(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.brawler(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.brawler(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.brawler(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.brawler(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.brawler(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.brawler(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.brawler(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.brawler(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.brawler(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.brawler(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.brawler(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.brawler(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.brawler(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.brawler(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bree Serif font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bree+Serif
  static TextStyle breeSerif({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a7248ed16d47821a8836aa345a8297f6c44d86162fdbc6475497bc799db0e9f',
        46612,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BreeSerif',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bree Serif font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bree+Serif
  static TextTheme breeSerifTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.breeSerif(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.breeSerif(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.breeSerif(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.breeSerif(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.breeSerif(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.breeSerif(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.breeSerif(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.breeSerif(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.breeSerif(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.breeSerif(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.breeSerif(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.breeSerif(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.breeSerif(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.breeSerif(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.breeSerif(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Brygada 1918 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brygada+1918
  static TextStyle brygada1918({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e7fcc3f4acfcaa3d245edff8d0218d3330b35bbaa5a62c069edd37caa13c764e',
        121484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '087e581b96d490f120e58844c91fffb13af8934bfc433bb8e34ee28838d9b989',
        122024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed5884598cf23102d8295885a8e4ff3e48a0b978407ff2374331c2efb8f84bbd',
        121992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '76749402ad6df348c5ed7d152476f687e8bcff08e6686495979d6624036f2102',
        121920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '81286c6a2d8405995a5c5b45e325a5e281a816bc60f7f912596c468032408045',
        120804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1d3d91639e7be0623deaffe68fb0a69c19a1e3af86cfb94b9741d53a90cc1bd4',
        121000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5944de849b60ea9ce63de8e400e74bdb6a5e988ad1d32ec474f98316ac2a2b86',
        121124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c024f6b3f3ca23a435568420b6d9ee12cc4c6c325b844775af731595bc8da8cd',
        121028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Brygada1918',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Brygada 1918 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brygada+1918
  static TextTheme brygada1918TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.brygada1918(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.brygada1918(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.brygada1918(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.brygada1918(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.brygada1918(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.brygada1918(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.brygada1918(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.brygada1918(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.brygada1918(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.brygada1918(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.brygada1918(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.brygada1918(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.brygada1918(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.brygada1918(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.brygada1918(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bubblegum Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubblegum+Sans
  static TextStyle bubblegumSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53e2f591d5b22787b4fd506e06145d2652da6014e1707f782a92395533188726',
        38772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BubblegumSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bubblegum Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubblegum+Sans
  static TextTheme bubblegumSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bubblegumSans(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bubblegumSans(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bubblegumSans(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bubblegumSans(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bubblegumSans(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bubblegumSans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bubblegumSans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bubblegumSans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bubblegumSans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bubblegumSans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bubblegumSans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bubblegumSans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bubblegumSans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bubblegumSans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bubblegumSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bubbler One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubbler+One
  static TextStyle bubblerOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd7ed8791a88cc19effc14df166be456cef77a85b707501822da21df19386254',
        30944,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BubblerOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bubbler One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubbler+One
  static TextTheme bubblerOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bubblerOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bubblerOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bubblerOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bubblerOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bubblerOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bubblerOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bubblerOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bubblerOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bubblerOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bubblerOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bubblerOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bubblerOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bubblerOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bubblerOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bubblerOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Buda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buda
  static TextStyle buda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '385d4247a0218281950ea513488d597434ce1d22bafe1b9e0b0853fce9304338',
        90392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Buda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Buda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buda
  static TextTheme budaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.buda(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.buda(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.buda(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.buda(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.buda(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.buda(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.buda(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.buda(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.buda(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.buda(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.buda(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.buda(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.buda(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.buda(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.buda(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Buenard font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buenard
  static TextStyle buenard({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98e52931f613305f11ff078f1cb569682195e516554178bf3c4127f644df907a',
        59764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b680cec9af406d125f721b89472951a526fcf17393adea7449be902ffb7f5cd',
        58608,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Buenard',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Buenard font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buenard
  static TextTheme buenardTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.buenard(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.buenard(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.buenard(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.buenard(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.buenard(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.buenard(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.buenard(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.buenard(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.buenard(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.buenard(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.buenard(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.buenard(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.buenard(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.buenard(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.buenard(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee
  static TextStyle bungee({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee34fb3fe185999f9942b2b39a37688866c1a4e25eab17c7a67765e7f47f6dbe',
        110116,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bungee',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee
  static TextTheme bungeeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bungee(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bungee(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bungee(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bungee(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bungee(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bungee(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bungee(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bungee(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bungee(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bungee(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bungee(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bungee(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bungee(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bungee(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bungee(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Hairline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Hairline
  static TextStyle bungeeHairline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7082ad6f58a7ae0bdd49f1c56b50fdd5f19c8e5a7a760de15f353ff47bf2c391',
        97300,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeHairline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Hairline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Hairline
  static TextTheme bungeeHairlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bungeeHairline(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bungeeHairline(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bungeeHairline(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bungeeHairline(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bungeeHairline(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bungeeHairline(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bungeeHairline(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bungeeHairline(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bungeeHairline(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bungeeHairline(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bungeeHairline(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bungeeHairline(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bungeeHairline(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bungeeHairline(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bungeeHairline(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Inline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Inline
  static TextStyle bungeeInline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c34108c66136e4485dbe7f75f62e6d782066911952901a3b1657b8d37d5bf414',
        147660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeInline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Inline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Inline
  static TextTheme bungeeInlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bungeeInline(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bungeeInline(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bungeeInline(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bungeeInline(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bungeeInline(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bungeeInline(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bungeeInline(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bungeeInline(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bungeeInline(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bungeeInline(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bungeeInline(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bungeeInline(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bungeeInline(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bungeeInline(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bungeeInline(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Outline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Outline
  static TextStyle bungeeOutline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53bb5dbad57c06403c9f7c9503b0397f17f001d2a0881305c5bee9de3c610f78',
        200136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeOutline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Outline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Outline
  static TextTheme bungeeOutlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bungeeOutline(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bungeeOutline(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bungeeOutline(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bungeeOutline(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bungeeOutline(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bungeeOutline(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bungeeOutline(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bungeeOutline(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bungeeOutline(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bungeeOutline(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bungeeOutline(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bungeeOutline(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bungeeOutline(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bungeeOutline(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bungeeOutline(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Shade font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Shade
  static TextStyle bungeeShade({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd736a1fd1e9468b036a7df272341d90fa2864fa1a985cfef42c164898cadd99',
        330628,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeShade',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Shade font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Shade
  static TextTheme bungeeShadeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bungeeShade(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bungeeShade(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bungeeShade(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bungeeShade(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bungeeShade(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bungeeShade(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bungeeShade(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bungeeShade(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bungeeShade(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bungeeShade(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bungeeShade(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bungeeShade(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bungeeShade(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bungeeShade(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bungeeShade(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Butcherman font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butcherman
  static TextStyle butcherman({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5bcf1ab19e7b312ef6a3f23116fef277d7af2240e6ee5719e5a8688f36f00e23',
        66300,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Butcherman',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Butcherman font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butcherman
  static TextTheme butchermanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.butcherman(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.butcherman(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.butcherman(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.butcherman(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.butcherman(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.butcherman(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.butcherman(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.butcherman(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.butcherman(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.butcherman(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.butcherman(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.butcherman(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.butcherman(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.butcherman(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.butcherman(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Butterfly Kids font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butterfly+Kids
  static TextStyle butterflyKids({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3e78c92335db0b2820b46df2d4a84c41e8690af1bac099b4a552e36736643b61',
        202408,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ButterflyKids',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Butterfly Kids font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butterfly+Kids
  static TextTheme butterflyKidsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.butterflyKids(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.butterflyKids(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.butterflyKids(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.butterflyKids(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.butterflyKids(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.butterflyKids(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.butterflyKids(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.butterflyKids(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.butterflyKids(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.butterflyKids(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.butterflyKids(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.butterflyKids(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.butterflyKids(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.butterflyKids(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.butterflyKids(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cabin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin
  static TextStyle cabin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ff30e9e9a66cf6a4e65d444d6bf8afdea7d574b27589397657972c2f9b2194f',
        81084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'db35751de9b88dfbea004784c70c96bca9d813b5521cf320e5cb30adfd7384a2',
        80436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4851465297f9c9aa19d41a969b28272f070f43271c7f279eb6daf3f291a47609',
        81516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2f1dff32a90462507aca783f85d6b2ed780858dd81a2a13bf217afbbfe5cce77',
        81408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b7e9674a2fca64e9eddd32df2987e72643c1fbadb5cc8158e4a429f8a99ea39a',
        81656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'da97f68bcdcff651e97b599499a784fc828a6e26feb94f391324076d060e3f7f',
        81548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9adb3df669ae368a467dbe74951a83ec476b74739063459b95b664e6ea2bf36a',
        78196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e4a3605f6b618e79e1d2bc2e4890babb2828cca85fee80608cb7d4a810b06eab',
        80320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cabin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cabin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin
  static TextTheme cabinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cabin(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cabin(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cabin(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cabin(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.cabin(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cabin(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cabin(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cabin(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cabin(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cabin(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cabin(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cabin(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cabin(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cabin(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cabin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cabin Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Condensed
  static TextStyle cabinCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8864cf658e1904654fb267649af1a35b07c0f9e7b2df523910efcfa047857270',
        75132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19d7c8b72085fd1898042b6adfa002bee67aa85565ea042e3383c6d9718262f3',
        74864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '204e4e214a76e3cc970598f75636fbe098a6541146bb02dd3d1ec67c8e155e5b',
        74872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b3d243ed807d45b1666f9a3866bc69260a7d81fe656a1d0fc9335302b4d82fa',
        74732,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CabinCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cabin Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Condensed
  static TextTheme cabinCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.cabinCondensed(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.cabinCondensed(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.cabinCondensed(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.cabinCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cabinCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.cabinCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cabinCondensed(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cabinCondensed(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cabinCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cabinCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cabinCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cabinCondensed(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cabinCondensed(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cabinCondensed(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cabinCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cabin Sketch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Sketch
  static TextStyle cabinSketch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c56ec3d2c6227ce0f5959e906b36dda6fbf2ea830ed4edeb9000ee53197c122e',
        155128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6dab969699fde26ddd2636960d9e77e5178036db4b98b1f3761df0e74e17ca88',
        269912,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CabinSketch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cabin Sketch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Sketch
  static TextTheme cabinSketchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cabinSketch(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.cabinSketch(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cabinSketch(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.cabinSketch(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cabinSketch(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.cabinSketch(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cabinSketch(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cabinSketch(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cabinSketch(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cabinSketch(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cabinSketch(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cabinSketch(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cabinSketch(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cabinSketch(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cabinSketch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caesar Dressing font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caesar+Dressing
  static TextStyle caesarDressing({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee89ad88164ca8c3eeb747410087b9deecb5d306172af188f53bd267ec033f9c',
        89212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CaesarDressing',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caesar Dressing font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caesar+Dressing
  static TextTheme caesarDressingTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.caesarDressing(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.caesarDressing(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.caesarDressing(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.caesarDressing(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.caesarDressing(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.caesarDressing(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.caesarDressing(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.caesarDressing(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.caesarDressing(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.caesarDressing(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.caesarDressing(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.caesarDressing(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.caesarDressing(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.caesarDressing(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.caesarDressing(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cagliostro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cagliostro
  static TextStyle cagliostro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f57e12bc813bf3381233056c5544a970ea10f321f64dc63eef3ae1e650b2b93',
        37772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cagliostro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cagliostro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cagliostro
  static TextTheme cagliostroTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cagliostro(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cagliostro(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cagliostro(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cagliostro(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cagliostro(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cagliostro(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cagliostro(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cagliostro(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cagliostro(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cagliostro(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cagliostro(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cagliostro(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cagliostro(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cagliostro(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cagliostro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cairo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cairo
  static TextStyle cairo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f4138b4fc3c1369eee1151ad813f76e1b371364feb318c2dfed606c6c7a98dc',
        105268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '22d57a326952ad111119348fad278153f66b456e3f1e1b3eba074a4dc167f96e',
        104816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1537c4e5a58de46dea37716791ce13157250bce598772e19adbf07abdaa2f5c0',
        103204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f5b7f284695e2fd50ce750d2a479bcbdc7f701be3c33893f0773866193c8fba',
        104040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56f0547834a0a361e7216604988268770c085dcbd6f3241778f613b02d6db926',
        98368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cf0e64d282c925bd689d2224fc9f34075e4586dbbebdbfa585ebab25a42059c',
        105544,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cairo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cairo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cairo
  static TextTheme cairoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cairo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cairo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cairo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cairo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.cairo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cairo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cairo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cairo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cairo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cairo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cairo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cairo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cairo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cairo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cairo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caladea font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caladea
  static TextStyle caladea({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60f1d4e3a572497f3530ac2ae1478709e606b3bdaaa56f97fd7efbc48e01de08',
        51516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a200599eb491ec914c9ce2fe7b2cdda1f14b4d082af53d054932993d3db7e7bb',
        50840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb25a8c8d05e937b9c5c3a001d1801276ba670641e4332a5f5d83cdc357cc5c3',
        52576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0d6a8296a9489017c434820f994212d73ffe43b80bc9b3913f0eec7a4b3d4ed5',
        50968,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caladea',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caladea font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caladea
  static TextTheme caladeaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.caladea(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.caladea(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.caladea(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.caladea(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.caladea(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.caladea(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.caladea(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.caladea(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.caladea(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.caladea(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.caladea(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.caladea(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.caladea(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.caladea(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.caladea(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Calistoga font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calistoga
  static TextStyle calistoga({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bbcc8c6618b098df3f7de4ee7afbe7a4ebe1832e5d8cca3579199c4e73ef5e8f',
        77552,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Calistoga',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Calistoga font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calistoga
  static TextTheme calistogaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.calistoga(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.calistoga(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.calistoga(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.calistoga(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.calistoga(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.calistoga(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.calistoga(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.calistoga(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.calistoga(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.calistoga(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.calistoga(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.calistoga(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.calistoga(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.calistoga(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.calistoga(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Calligraffitti font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calligraffitti
  static TextStyle calligraffitti({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '580e522ce80a61e980096a261015c86696213b70822d677e4de3902787578e63',
        46940,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Calligraffitti',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Calligraffitti font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calligraffitti
  static TextTheme calligraffittiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.calligraffitti(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.calligraffitti(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.calligraffitti(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.calligraffitti(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.calligraffitti(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.calligraffitti(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.calligraffitti(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.calligraffitti(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.calligraffitti(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.calligraffitti(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.calligraffitti(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.calligraffitti(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.calligraffitti(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.calligraffitti(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.calligraffitti(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cambay font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambay
  static TextStyle cambay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7bad4e2ac4cc5bdeef53e890b4b3d52b065fdae8ebe5f754f263384995f7c73',
        140024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e821a1eb24db547646223e8b5065d6feeed373e25daf722bd4c3499785d3b6aa',
        155856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ece04d3d10726b39914e7a3c3ebbef7ccadcf7a26272fc090c83d3bf7690eea4',
        139576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd17daa8d61f0a8bdd69696d0da7fc566e3a13141eb0ae45e512b48dcafb92565',
        151048,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cambay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cambay font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambay
  static TextTheme cambayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cambay(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cambay(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cambay(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cambay(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.cambay(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cambay(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cambay(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cambay(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cambay(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cambay(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cambay(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cambay(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cambay(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cambay(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cambay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cambo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambo
  static TextStyle cambo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d8d683131ae5168d1210d9676808b76b985ad2a151d3a7514ec02f7b8a776b9',
        29056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cambo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cambo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambo
  static TextTheme camboTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cambo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cambo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cambo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cambo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.cambo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cambo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cambo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cambo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cambo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cambo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cambo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cambo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cambo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cambo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cambo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Candal font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Candal
  static TextStyle candal({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e16795a5489340834dda623038868a2e7f48f4bc0f154f98c1a1962894a2598',
        32200,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Candal',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Candal font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Candal
  static TextTheme candalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.candal(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.candal(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.candal(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.candal(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.candal(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.candal(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.candal(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.candal(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.candal(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.candal(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.candal(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.candal(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.candal(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.candal(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.candal(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cantarell font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantarell
  static TextStyle cantarell({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1e62d82800c92f72ed501733b5d52d7b8a5d88d1c6315bfdaf7f8ce781108c00',
        47436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6d9559dd0df30daed7da97dc8ef05e7f39b72205fb9bd7a055ddaa5242afd36f',
        50000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db0c34021061680135f973a2cb5565811527ea91f2fa07d023f4e105eb6f45d3',
        49208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bb2c0f469972ec2016c3b8b8254ea0077f46207efb249afb3c4d356cf2c5418e',
        52132,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cantarell',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cantarell font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantarell
  static TextTheme cantarellTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cantarell(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cantarell(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cantarell(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cantarell(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cantarell(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cantarell(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cantarell(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cantarell(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cantarell(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cantarell(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cantarell(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cantarell(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cantarell(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cantarell(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cantarell(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cantata One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantata+One
  static TextStyle cantataOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b58597daf95866fac678391238aefbae4bc3e31e826a3b85a2c749c3844a4dfe',
        57144,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CantataOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cantata One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantata+One
  static TextTheme cantataOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cantataOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cantataOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cantataOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cantataOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cantataOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cantataOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cantataOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cantataOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cantataOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cantataOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cantataOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cantataOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cantataOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cantataOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cantataOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cantora One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantora+One
  static TextStyle cantoraOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '242d2167789079107cbe59c3e9ccd0339ca51419245296a4659c6b3ad73cc41c',
        109236,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CantoraOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cantora One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantora+One
  static TextTheme cantoraOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cantoraOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cantoraOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cantoraOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cantoraOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cantoraOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cantoraOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cantoraOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cantoraOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cantoraOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cantoraOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cantoraOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cantoraOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cantoraOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cantoraOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cantoraOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Capriola font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Capriola
  static TextStyle capriola({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '938d0b1c7f521513ee9bb1114d92827718670e0e5a495ccd564d70b0ddc59594',
        78168,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Capriola',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Capriola font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Capriola
  static TextTheme capriolaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.capriola(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.capriola(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.capriola(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.capriola(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.capriola(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.capriola(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.capriola(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.capriola(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.capriola(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.capriola(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.capriola(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.capriola(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.capriola(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.capriola(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.capriola(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caramel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caramel
  static TextStyle caramel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a80d114cb9fa5025551733589efa28c9b6f18d17fa1d0a64a019760e66369bac',
        77520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caramel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caramel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caramel
  static TextTheme caramelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.caramel(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.caramel(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.caramel(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.caramel(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.caramel(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.caramel(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.caramel(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.caramel(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.caramel(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.caramel(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.caramel(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.caramel(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.caramel(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.caramel(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.caramel(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Carattere font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carattere
  static TextStyle carattere({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ac879fd9028443388930525ff30f4a8a05587cdc1c63f8cfac7b8efd056b6a4',
        78436,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Carattere',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carattere font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carattere
  static TextTheme carattereTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.carattere(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.carattere(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.carattere(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.carattere(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.carattere(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.carattere(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.carattere(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.carattere(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.carattere(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.carattere(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.carattere(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.carattere(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.carattere(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.carattere(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.carattere(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cardo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cardo
  static TextStyle cardo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '286e6a4bde92ea6087b503978338898808df924a3cdd8144741fa780d11603a2',
        400420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '43bee56e6bb3d2ad574558a859227592f0b0ac881a70fd8f2cf74b808bb9be00',
        262820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10c0bab22a674656a3d5e94e05e64f9c6c6ea25acce0d0fc846f964985b142ce',
        348296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cardo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cardo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cardo
  static TextTheme cardoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cardo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cardo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cardo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cardo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.cardo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cardo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cardo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cardo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cardo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cardo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cardo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cardo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cardo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cardo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cardo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Carme font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carme
  static TextStyle carme({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '79973fb109b078d0e49d90287e9f6527dc8829c6076c878ed07743d78cfb988b',
        60852,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Carme',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carme font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carme
  static TextTheme carmeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.carme(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.carme(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.carme(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.carme(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.carme(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.carme(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.carme(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.carme(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.carme(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.carme(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.carme(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.carme(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.carme(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.carme(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.carme(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Carrois Gothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carrois+Gothic
  static TextStyle carroisGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd013d780a3d17a244794f0d2649a6214a1946f102ddf0a02fe366fa7bb8bb6ec',
        26212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CarroisGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carrois Gothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carrois+Gothic
  static TextTheme carroisGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.carroisGothic(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.carroisGothic(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.carroisGothic(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.carroisGothic(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.carroisGothic(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.carroisGothic(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.carroisGothic(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.carroisGothic(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.carroisGothic(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.carroisGothic(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.carroisGothic(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.carroisGothic(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.carroisGothic(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.carroisGothic(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.carroisGothic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Carrois Gothic SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carrois+Gothic+SC
  static TextStyle carroisGothicSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b50b78ae9eb35706d3d9923b420465d6c6245e9469dcbe4a96c30d118338edf',
        26084,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CarroisGothicSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carrois Gothic SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carrois+Gothic+SC
  static TextTheme carroisGothicScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.carroisGothicSc(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.carroisGothicSc(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.carroisGothicSc(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.carroisGothicSc(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.carroisGothicSc(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.carroisGothicSc(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.carroisGothicSc(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.carroisGothicSc(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.carroisGothicSc(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.carroisGothicSc(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.carroisGothicSc(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.carroisGothicSc(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.carroisGothicSc(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.carroisGothicSc(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.carroisGothicSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Carter One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carter+One
  static TextStyle carterOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '64cdbf0babf6eb9e23f0a780f283a930636589b4b8d9a5d0cdf24888a7719292',
        63872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CarterOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carter One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carter+One
  static TextTheme carterOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.carterOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.carterOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.carterOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.carterOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.carterOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.carterOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.carterOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.carterOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.carterOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.carterOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.carterOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.carterOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.carterOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.carterOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.carterOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Castoro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Castoro
  static TextStyle castoro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1c0fdc4bf42e6acc4514d8e123a56bfa4101a0bf4d339c2f0a71bfcb0f6d02e',
        70892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '14b88401404e0d4111e8147bff13b3e811ece5feb299cd9259f3571ceb0de230',
        72080,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Castoro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Castoro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Castoro
  static TextTheme castoroTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.castoro(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.castoro(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.castoro(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.castoro(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.castoro(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.castoro(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.castoro(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.castoro(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.castoro(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.castoro(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.castoro(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.castoro(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.castoro(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.castoro(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.castoro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Catamaran font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Catamaran
  static TextStyle catamaran({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8e9d704be93826d9781f133277934bb6184afd9522b149f005c78f5d89e62ac',
        51516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f24bc068d63c199fab01e5c0690d6e034f485057c3c19571b656e705a78756b',
        51520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '853537ef3cef46cebdd3f2ee0f94b33861095d50b2584d6f96a47725f6f4b79d',
        51428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6af095039ae2cc21b9f8e147b290dc6fae99dd4f45843dd262a9e30557dd4e65',
        51200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b80fad7d7ef99a42af9235090775e879520d07fb7b3deda4986a64c81be4a96',
        51172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd77e1072b0d92cfa66cc458ff7e053b1e33cfa9dd663fb52f75062ba9a134122',
        51028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47d32e32345049db4c0f41c0ffba707afcf0ac18cb7000817fd26ae811255728',
        50828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '342bd0052b9b81ca6df68a9cdda635ad6f77c796e37045545bfa1d0a071c0bc8',
        50464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa466db090fa897764fa413a006d0c4f7a975a118db3de634988a14f674446cb',
        50220,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Catamaran',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Catamaran font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Catamaran
  static TextTheme catamaranTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.catamaran(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.catamaran(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.catamaran(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.catamaran(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.catamaran(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.catamaran(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.catamaran(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.catamaran(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.catamaran(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.catamaran(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.catamaran(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.catamaran(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.catamaran(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.catamaran(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.catamaran(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caudex font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caudex
  static TextStyle caudex({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e0c195632ea06158f87e86ee898119dd8a7f59788999552ed79be77c33c6a726',
        466276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '53374860983e21bb358d83d1162c824903649ae49f873a963c665b066514bb9d',
        559392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09a6db433fd45eb3e1423e9947afe5b766008cc358cb482b42103970fc840676',
        471660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '45c118976f77e53a2a5122e22cace7fb846373a14892fbb7e0ff61e1a46de1d4',
        555108,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caudex',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caudex font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caudex
  static TextTheme caudexTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.caudex(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.caudex(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.caudex(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.caudex(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.caudex(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.caudex(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.caudex(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.caudex(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.caudex(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.caudex(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.caudex(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.caudex(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.caudex(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.caudex(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.caudex(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caveat font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caveat
  static TextStyle caveat({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ffe3acdd9c8d91838d7ba021d1c4e9111151e34a104318a8aafe0efeda5755f',
        165376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6993da01fa90c359d45a03be9927b46be80d261978de6f5805f43d75ed2d172f',
        166236,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caveat',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caveat font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caveat
  static TextTheme caveatTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.caveat(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.caveat(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.caveat(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.caveat(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.caveat(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.caveat(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.caveat(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.caveat(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.caveat(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.caveat(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.caveat(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.caveat(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.caveat(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.caveat(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.caveat(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caveat Brush font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caveat+Brush
  static TextStyle caveatBrush({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70de81a815f44819880ddba3c93eda87ab6bd1a4b21db15e5ba29c9271cba521',
        232640,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CaveatBrush',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caveat Brush font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caveat+Brush
  static TextTheme caveatBrushTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.caveatBrush(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.caveatBrush(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.caveatBrush(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.caveatBrush(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.caveatBrush(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.caveatBrush(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.caveatBrush(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.caveatBrush(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.caveatBrush(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.caveatBrush(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.caveatBrush(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.caveatBrush(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.caveatBrush(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.caveatBrush(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.caveatBrush(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cedarville Cursive font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cedarville+Cursive
  static TextStyle cedarvilleCursive({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1296a081a20bf4a1936ace5eac4d05fa6702cdfaab5f94a5088af4c0aa46c3d',
        68704,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CedarvilleCursive',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cedarville Cursive font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cedarville+Cursive
  static TextTheme cedarvilleCursiveTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cedarvilleCursive(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cedarvilleCursive(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.cedarvilleCursive(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ceviche One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ceviche+One
  static TextStyle cevicheOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ed3cdc36bf356dbe366b2198c633acbf26815fc96c14ba05a7847b274043909',
        36688,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CevicheOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ceviche One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ceviche+One
  static TextTheme cevicheOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cevicheOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cevicheOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cevicheOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cevicheOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cevicheOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cevicheOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cevicheOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cevicheOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cevicheOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cevicheOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cevicheOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cevicheOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cevicheOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cevicheOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cevicheOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chakra Petch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chakra+Petch
  static TextStyle chakraPetch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ecaf4ae2d67c61e2a3fa8df13a271ccea00d43000ba74107e7bfda439f60b1d2',
        70452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '020376f9083d9c7e6f32ecb879dee72b6fadef64ea9a3df0bd01d4952a06f1aa',
        72720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6854c9992a9a1345525235ab8e75582a0f6f3f828c37e4720a78aad1de6c0aa5',
        70160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '114572d34834d0022111a2a7a0eaf1d6bb7e3b70537f2c52e283219fa86ccd02',
        72412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '179d4e7774a67d1c01789bcf1bf48e72fbc37fa173f3373470769b54a505ad17',
        70152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f7172b64774efd15a32d833b00836c9e30c0ee766c096a08de2a427c904f5c2d',
        72504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6b54f7d68496d966460fe300af5b72cc91ca631822110de9fbc976ceabb2591',
        70164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a7a04e1ebef703c41253da2ca8a90c83a63649e471590d939c69828a0e0e591f',
        72524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e409c139ac42c535be29bfb904109788499a4b3971f95c0853dce713da259ea9',
        70068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '86042cd1693573443cb56c465a3f44172486eb888d707fcc03eb3dc8600008cb',
        72408,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChakraPetch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chakra Petch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chakra+Petch
  static TextTheme chakraPetchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.chakraPetch(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.chakraPetch(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.chakraPetch(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.chakraPetch(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.chakraPetch(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.chakraPetch(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.chakraPetch(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.chakraPetch(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.chakraPetch(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.chakraPetch(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.chakraPetch(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.chakraPetch(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.chakraPetch(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.chakraPetch(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.chakraPetch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Changa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Changa
  static TextStyle changa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e248c51b3bc1f8fd1d6b980400670c54bf2cdf89f4c5e075bca29f09ecdb936b',
        81252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f083dc8e9965f9e9b8c6c977bcfac5a504f4ef820e8c8237f1217d4edf3bdd9a',
        80888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '01d71ec0cc7235bb908cc0c3ae45d1e10a2f87e4a61ad5ef855af157f39e8a80',
        80184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb1d544301460f01712f06d94a05af7420497d1b5791bdf43b542c0351227242',
        80588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c22f4b8d7a97aaa32759b9336354bdcf999861dac5d589a4e02e7e5bb9504f98',
        80472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a274e0c0a7aa46f455bf65caff8b972998ce8fc975bf677ae154d5765ac4c0f',
        79956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5d419cee41ca204d194f089cfd5d8d35ea6bc706a8f606ecaa69132df9854893',
        79556,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Changa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Changa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Changa
  static TextTheme changaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.changa(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.changa(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.changa(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.changa(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.changa(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.changa(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.changa(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.changa(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.changa(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.changa(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.changa(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.changa(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.changa(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.changa(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.changa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Changa One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Changa+One
  static TextStyle changaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55a043f0a2eb34269cfb137a6203fdc338019e9bdaabee1e685c6b37495cb962',
        22668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '241077b802e7b6209a41ea93aae98aa81d9f09e6f78fce924c863af6ca96b529',
        26680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChangaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Changa One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Changa+One
  static TextTheme changaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.changaOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.changaOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.changaOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.changaOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.changaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.changaOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.changaOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.changaOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.changaOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.changaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.changaOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.changaOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.changaOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.changaOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.changaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chango font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chango
  static TextStyle chango({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '66d5dcae03b7a0d59f38640d05bb920cc6d3b4e2a1cdb176628330e20ab9a6ca',
        40684,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chango',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chango font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chango
  static TextTheme changoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.chango(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.chango(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.chango(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.chango(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.chango(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.chango(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.chango(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.chango(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.chango(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.chango(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.chango(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.chango(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.chango(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.chango(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.chango(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Charm font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charm
  static TextStyle charm({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b2803aafd875584dcb262e1eddd8dc7542342f4d2d76ac5f9b06c6b5e2bae18f',
        121276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40f34767fa59a87e641da20236b9966135321cb03c1ed68d88a6234d432d2604',
        122112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Charm',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Charm font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charm
  static TextTheme charmTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.charm(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.charm(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.charm(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.charm(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.charm(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.charm(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.charm(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.charm(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.charm(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.charm(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.charm(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.charm(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.charm(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.charm(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.charm(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Charmonman font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charmonman
  static TextStyle charmonman({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c4d7f973e9f5d882d38668d863ec90889ddc79cd302e832da538621ac970513',
        100884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1492915dc59b590610a5b5bcf4d1b9aca380c377b870a0a9de187fc05146908',
        100612,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Charmonman',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Charmonman font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charmonman
  static TextTheme charmonmanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.charmonman(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.charmonman(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.charmonman(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.charmonman(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.charmonman(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.charmonman(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.charmonman(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.charmonman(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.charmonman(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.charmonman(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.charmonman(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.charmonman(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.charmonman(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.charmonman(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.charmonman(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chathura font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chathura
  static TextStyle chathura({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '78a5a2532fd10bcf3317ec8440d1e758a309bd152369607ccea764abddbcb168',
        345716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7b8357f2b60bfe270ca77801978a0bd5e729870ffad8b19d54ff69cded800a1f',
        340972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8abdba026fb7a58e3f5b2cbe302ab4d9e817e69dfd7c6fce0ffbf22fe9600f5',
        330780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '129573e675c52db3364e6d6ac3d517a6cb8113531a3bc2b54276e1d28d28c11a',
        329608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6190f40f502b8b950146bbe4ba7b7b02eea38047766ba5b56895059e3b6c655',
        328760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chathura',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chathura font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chathura
  static TextTheme chathuraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.chathura(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.chathura(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.chathura(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.chathura(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.chathura(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.chathura(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.chathura(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.chathura(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.chathura(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.chathura(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.chathura(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.chathura(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.chathura(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.chathura(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.chathura(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chau Philomene One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chau+Philomene+One
  static TextStyle chauPhilomeneOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c44d00d1e4d0cfcf8ae3458b12571cdd000ce9df7849a29afa3dd3aadfdb6224',
        39692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5be1fbfb8c59a78422d618850745eeabe8bebc7aef35518a599c765168ad124a',
        43992,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChauPhilomeneOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chau Philomene One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chau+Philomene+One
  static TextTheme chauPhilomeneOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.chauPhilomeneOne(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.chauPhilomeneOne(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.chauPhilomeneOne(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.chauPhilomeneOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.chauPhilomeneOne(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.chauPhilomeneOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.chauPhilomeneOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.chauPhilomeneOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chela One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chela+One
  static TextStyle chelaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3efd79a48f37981dfb1dd9c73243093c103f990459d6cc0e0918ed692c2beef0',
        35492,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChelaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chela One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chela+One
  static TextTheme chelaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.chelaOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.chelaOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.chelaOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.chelaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.chelaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.chelaOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.chelaOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.chelaOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.chelaOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.chelaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.chelaOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.chelaOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.chelaOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.chelaOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.chelaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chelsea Market font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chelsea+Market
  static TextStyle chelseaMarket({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7841b0525f53772efeff1353b0297e9faa176874f84319d11057dfa3d129147b',
        172508,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChelseaMarket',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chelsea Market font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chelsea+Market
  static TextTheme chelseaMarketTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.chelseaMarket(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.chelseaMarket(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.chelseaMarket(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.chelseaMarket(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.chelseaMarket(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.chelseaMarket(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.chelseaMarket(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.chelseaMarket(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.chelseaMarket(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.chelseaMarket(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.chelseaMarket(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.chelseaMarket(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.chelseaMarket(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.chelseaMarket(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.chelseaMarket(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cherish font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherish
  static TextStyle cherish({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c27293defe6805cbe5d44a9ef638bc71b43a7df0ed9e38511d64c4f2c0be74d',
        195668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cherish',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cherish font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherish
  static TextTheme cherishTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cherish(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cherish(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cherish(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cherish(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.cherish(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cherish(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cherish(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cherish(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cherish(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cherish(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cherish(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cherish(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cherish(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cherish(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cherish(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cherry Cream Soda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Cream+Soda
  static TextStyle cherryCreamSoda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47e79c87ca78a16fd9c841454bdf7ea5a7485a08a7f78baddcc83bbc2f510729',
        40208,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CherryCreamSoda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cherry Cream Soda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Cream+Soda
  static TextTheme cherryCreamSodaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.cherryCreamSoda(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.cherryCreamSoda(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.cherryCreamSoda(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.cherryCreamSoda(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cherryCreamSoda(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.cherryCreamSoda(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cherryCreamSoda(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.cherryCreamSoda(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cherryCreamSoda(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cherryCreamSoda(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cherryCreamSoda(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cherryCreamSoda(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cherryCreamSoda(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.cherryCreamSoda(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cherryCreamSoda(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cherry Swash font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Swash
  static TextStyle cherrySwash({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c16f18e4a0ef56672f00dcd810fae50a7468eccc6174968c6890ca1ed1eb4dc0',
        30548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46fc53776950e3047f5b647b1819e4ec28a5521b733a7e614aa9d97562cb5371',
        29984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CherrySwash',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cherry Swash font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Swash
  static TextTheme cherrySwashTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cherrySwash(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.cherrySwash(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cherrySwash(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.cherrySwash(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cherrySwash(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.cherrySwash(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cherrySwash(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cherrySwash(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cherrySwash(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cherrySwash(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cherrySwash(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cherrySwash(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cherrySwash(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cherrySwash(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cherrySwash(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chewy font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chewy
  static TextStyle chewy({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd88ead910c7aca7ef7e4aec8e38bc7bd8ea2f85b93181a960e2747192d839469',
        36096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chewy',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chewy font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chewy
  static TextTheme chewyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.chewy(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.chewy(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.chewy(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.chewy(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.chewy(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.chewy(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.chewy(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.chewy(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.chewy(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.chewy(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.chewy(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.chewy(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.chewy(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.chewy(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.chewy(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chicle font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chicle
  static TextStyle chicle({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '463fc42349dcac85fa8e161556aa92b7ae3f8d9cd174ef7b134ac072382d6069',
        40964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chicle',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chicle font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chicle
  static TextTheme chicleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.chicle(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.chicle(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.chicle(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.chicle(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.chicle(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.chicle(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.chicle(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.chicle(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.chicle(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.chicle(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.chicle(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.chicle(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.chicle(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.chicle(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.chicle(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chilanka font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chilanka
  static TextStyle chilanka({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c0b4dcbe94cf228d02f67f71242fed2881a691a3b3516a791881a3428605d6dc',
        338888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chilanka',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chilanka font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chilanka
  static TextTheme chilankaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.chilanka(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.chilanka(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.chilanka(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.chilanka(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.chilanka(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.chilanka(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.chilanka(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.chilanka(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.chilanka(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.chilanka(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.chilanka(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.chilanka(textStyle: textThe