/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.embedding.android.FlutterImageView;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.android.MotionEventTracker;
import io.flutter.embedding.engine.FlutterOverlaySurface;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorView;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorsStack;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.systemchannels.PlatformViewsChannel;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.plugin.platform.AccessibilityEventsDelegate;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugin.platform.PlatformViewRegistry;
import io.flutter.plugin.platform.PlatformViewRegistryImpl;
import io.flutter.plugin.platform.PlatformViewWrapper;
import io.flutter.plugin.platform.PlatformViewsAccessibilityDelegate;
import io.flutter.view.AccessibilityBridge;
import io.flutter.view.TextureRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PlatformViewsController
implements PlatformViewsAccessibilityDelegate {
    private static final String TAG = "PlatformViewsController";
    private final PlatformViewRegistryImpl registry;
    private AndroidTouchProcessor androidTouchProcessor;
    private Context context;
    private FlutterView flutterView;
    @Nullable
    private TextureRegistry textureRegistry;
    @Nullable
    private TextInputPlugin textInputPlugin;
    private PlatformViewsChannel platformViewsChannel;
    private final AccessibilityEventsDelegate accessibilityEventsDelegate;
    private final SparseArray<PlatformView> platformViews;
    private final SparseArray<FlutterMutatorView> platformViewParent;
    private final SparseArray<FlutterImageView> overlayLayerViews;
    private final SparseArray<PlatformViewWrapper> viewWrappers;
    private int nextOverlayLayerId = 0;
    private boolean flutterViewConvertedToImageView = false;
    private boolean synchronizeToNativeViewHierarchy = true;
    private final HashSet<Integer> currentFrameUsedOverlayLayerIds;
    private final HashSet<Integer> currentFrameUsedPlatformViewIds;
    private final MotionEventTracker motionEventTracker;
    private boolean usesSoftwareRendering = false;
    private final PlatformViewsChannel.PlatformViewsHandler channelHandler = new PlatformViewsChannel.PlatformViewsHandler(){

        @Override
        @TargetApi(value=19)
        public void createForPlatformViewLayer(@NonNull PlatformViewsChannel.PlatformViewCreationRequest request) {
            this.ensureValidAndroidVersion(19);
            if (!PlatformViewsController.validateDirection(request.direction)) {
                throw new IllegalStateException("Trying to create a view with unknown direction value: " + request.direction + "(view id: " + request.viewId + ")");
            }
            PlatformViewFactory factory = PlatformViewsController.this.registry.getFactory(request.viewType);
            if (factory == null) {
                throw new IllegalStateException("Trying to create a platform view of unregistered type: " + request.viewType);
            }
            Object createParams = null;
            if (request.params != null) {
                createParams = factory.getCreateArgsCodec().decodeMessage(request.params);
            }
            PlatformView platformView = factory.create(PlatformViewsController.this.context, request.viewId, createParams);
            platformView.getView().setLayoutDirection(request.direction);
            PlatformViewsController.this.platformViews.put(request.viewId, (Object)platformView);
        }

        @Override
        @TargetApi(value=23)
        public long createForTextureLayer(@NonNull PlatformViewsChannel.PlatformViewCreationRequest request) {
            long txId;
            PlatformViewWrapper wrapperView;
            int viewId = request.viewId;
            if (PlatformViewsController.this.viewWrappers.get(viewId) != null) {
                throw new IllegalStateException("Trying to create an already created platform view, view id: " + viewId);
            }
            if (!PlatformViewsController.validateDirection(request.direction)) {
                throw new IllegalStateException("Trying to create a view with unknown direction value: " + request.direction + "(view id: " + viewId + ")");
            }
            if (PlatformViewsController.this.textureRegistry == null) {
                throw new IllegalStateException("Texture registry is null. This means that platform views controller was detached, view id: " + viewId);
            }
            if (PlatformViewsController.this.flutterView == null) {
                throw new IllegalStateException("Flutter view is null. This means the platform views controller doesn't have an attached view, view id: " + viewId);
            }
            PlatformViewFactory viewFactory = PlatformViewsController.this.registry.getFactory(request.viewType);
            if (viewFactory == null) {
                throw new IllegalStateException("Trying to create a platform view of unregistered type: " + request.viewType);
            }
            Object createParams = null;
            if (request.params != null) {
                createParams = viewFactory.getCreateArgsCodec().decodeMessage(request.params);
            }
            PlatformView platformView = viewFactory.create(PlatformViewsController.this.context, viewId, createParams);
            PlatformViewsController.this.platformViews.put(viewId, (Object)platformView);
            if (PlatformViewsController.this.usesSoftwareRendering) {
                wrapperView = new PlatformViewWrapper(PlatformViewsController.this.context);
                txId = -1L;
            } else {
                TextureRegistry.SurfaceTextureEntry textureEntry = PlatformViewsController.this.textureRegistry.createSurfaceTexture();
                wrapperView = new PlatformViewWrapper(PlatformViewsController.this.context, textureEntry);
                txId = textureEntry.id();
            }
            wrapperView.setTouchProcessor(PlatformViewsController.this.androidTouchProcessor);
            int physicalWidth = PlatformViewsController.this.toPhysicalPixels(request.logicalWidth);
            int physicalHeight = PlatformViewsController.this.toPhysicalPixels(request.logicalHeight);
            wrapperView.setBufferSize(physicalWidth, physicalHeight);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(physicalWidth, physicalHeight);
            int physicalTop = PlatformViewsController.this.toPhysicalPixels(request.logicalTop);
            int physicalLeft = PlatformViewsController.this.toPhysicalPixels(request.logicalLeft);
            layoutParams.topMargin = physicalTop;
            layoutParams.leftMargin = physicalLeft;
            wrapperView.setLayoutParams(layoutParams);
            wrapperView.setLayoutDirection(request.direction);
            View view = platformView.getView();
            if (view == null) {
                throw new IllegalStateException("PlatformView#getView() returned null, but an Android view reference was expected.");
            }
            if (view.getParent() != null) {
                throw new IllegalStateException("The Android view returned from PlatformView#getView() was already added to a parent view.");
            }
            wrapperView.addView(view);
            wrapperView.setOnDescendantFocusChangeListener((v, hasFocus) -> {
                if (hasFocus) {
                    PlatformViewsController.this.platformViewsChannel.invokeViewFocused(viewId);
                } else if (PlatformViewsController.this.textInputPlugin != null) {
                    PlatformViewsController.this.textInputPlugin.clearPlatformViewClient(viewId);
                }
            });
            PlatformViewsController.this.flutterView.addView((View)wrapperView);
            PlatformViewsController.this.viewWrappers.append(viewId, (Object)wrapperView);
            return txId;
        }

        @Override
        public void dispose(int viewId) {
            PlatformViewWrapper viewWrapper;
            PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
            if (platformView != null) {
                PlatformViewsController.this.platformViews.remove(viewId);
                platformView.dispose();
            }
            if ((viewWrapper = (PlatformViewWrapper)((Object)PlatformViewsController.this.viewWrappers.get(viewId))) != null) {
                viewWrapper.removeAllViews();
                viewWrapper.release();
                viewWrapper.unsetOnDescendantFocusChangeListener();
                ViewGroup wrapperParent = (ViewGroup)viewWrapper.getParent();
                if (wrapperParent != null) {
                    wrapperParent.removeView((View)viewWrapper);
                }
                PlatformViewsController.this.viewWrappers.remove(viewId);
                return;
            }
            FlutterMutatorView parentView = (FlutterMutatorView)((Object)PlatformViewsController.this.platformViewParent.get(viewId));
            if (parentView != null) {
                parentView.removeAllViews();
                parentView.unsetOnDescendantFocusChangeListener();
                ViewGroup mutatorViewParent = (ViewGroup)parentView.getParent();
                if (mutatorViewParent != null) {
                    mutatorViewParent.removeView((View)parentView);
                }
                PlatformViewsController.this.platformViewParent.remove(viewId);
            }
        }

        @Override
        public void offset(int viewId, double top, double left) {
            PlatformViewWrapper wrapper = (PlatformViewWrapper)((Object)PlatformViewsController.this.viewWrappers.get(viewId));
            if (wrapper == null) {
                Log.e(PlatformViewsController.TAG, "Setting offset for unknown platform view with id: " + viewId);
                return;
            }
            int physicalTop = PlatformViewsController.this.toPhysicalPixels(top);
            int physicalLeft = PlatformViewsController.this.toPhysicalPixels(left);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)wrapper.getLayoutParams();
            layoutParams.topMargin = physicalTop;
            layoutParams.leftMargin = physicalLeft;
            wrapper.setLayoutParams(layoutParams);
        }

        @Override
        public PlatformViewsChannel.PlatformViewBufferSize resize(@NonNull PlatformViewsChannel.PlatformViewResizeRequest request) {
            int viewId = request.viewId;
            PlatformViewWrapper view = (PlatformViewWrapper)((Object)PlatformViewsController.this.viewWrappers.get(viewId));
            if (view == null) {
                Log.e(PlatformViewsController.TAG, "Resizing unknown platform view with id: " + viewId);
                return null;
            }
            int newWidth = PlatformViewsController.this.toPhysicalPixels(request.newLogicalWidth);
            int newHeight = PlatformViewsController.this.toPhysicalPixels(request.newLogicalHeight);
            if (newWidth > view.getBufferWidth() || newHeight > view.getBufferHeight()) {
                view.setBufferSize(newWidth, newHeight);
            }
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
            layoutParams.width = newWidth;
            layoutParams.height = newHeight;
            view.setLayoutParams(layoutParams);
            return new PlatformViewsChannel.PlatformViewBufferSize(PlatformViewsController.this.toLogicalPixels(view.getBufferWidth()), PlatformViewsController.this.toLogicalPixels(view.getBufferHeight()));
        }

        @Override
        public void onTouch(@NonNull PlatformViewsChannel.PlatformViewTouch touch) {
            int viewId = touch.viewId;
            PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
            if (platformView == null) {
                Log.e(PlatformViewsController.TAG, "Sending touch to an unknown view with id: " + viewId);
                return;
            }
            this.ensureValidAndroidVersion(20);
            float density = ((PlatformViewsController)PlatformViewsController.this).context.getResources().getDisplayMetrics().density;
            MotionEvent event = PlatformViewsController.this.toMotionEvent(density, touch);
            View view = platformView.getView();
            if (view == null) {
                Log.e(PlatformViewsController.TAG, "Sending touch to a null view with id: " + viewId);
                return;
            }
            view.dispatchTouchEvent(event);
        }

        @Override
        @TargetApi(value=17)
        public void setDirection(int viewId, int direction) {
            if (!PlatformViewsController.validateDirection(direction)) {
                throw new IllegalStateException("Trying to set unknown direction value: " + direction + "(view id: " + viewId + ")");
            }
            PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
            if (platformView == null) {
                Log.e(PlatformViewsController.TAG, "Setting direction to an unknown view with id: " + viewId);
                return;
            }
            this.ensureValidAndroidVersion(20);
            View view = platformView.getView();
            if (view == null) {
                Log.e(PlatformViewsController.TAG, "Setting direction to a null view with id: " + viewId);
                return;
            }
            view.setLayoutDirection(direction);
        }

        @Override
        public void clearFocus(int viewId) {
            PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
            if (platformView == null) {
                Log.e(PlatformViewsController.TAG, "Clearing focus on an unknown view with id: " + viewId);
                return;
            }
            View view = platformView.getView();
            if (view == null) {
                Log.e(PlatformViewsController.TAG, "Clearing focus on a null view with id: " + viewId);
                return;
            }
            view.clearFocus();
        }

        private void ensureValidAndroidVersion(int minSdkVersion) {
            if (Build.VERSION.SDK_INT < minSdkVersion) {
                throw new IllegalStateException("Trying to use platform views with API " + Build.VERSION.SDK_INT + ", required API level is: " + minSdkVersion);
            }
        }

        @Override
        public void synchronizeToNativeViewHierarchy(boolean yes) {
            PlatformViewsController.this.synchronizeToNativeViewHierarchy = yes;
        }
    };

    @VisibleForTesting
    public MotionEvent toMotionEvent(float density, PlatformViewsChannel.PlatformViewTouch touch) {
        MotionEventTracker.MotionEventId motionEventId = MotionEventTracker.MotionEventId.from(touch.motionEventId);
        MotionEvent trackedEvent = this.motionEventTracker.pop(motionEventId);
        MotionEvent.PointerProperties[] pointerProperties = PlatformViewsController.parsePointerPropertiesList(touch.rawPointerPropertiesList).toArray(new MotionEvent.PointerProperties[touch.pointerCount]);
        MotionEvent.PointerCoords[] pointerCoords = PlatformViewsController.parsePointerCoordsList(touch.rawPointerCoords, density).toArray(new MotionEvent.PointerCoords[touch.pointerCount]);
        if (trackedEvent != null) {
            return MotionEvent.obtain((long)trackedEvent.getDownTime(), (long)trackedEvent.getEventTime(), (int)trackedEvent.getAction(), (int)touch.pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)trackedEvent.getMetaState(), (int)trackedEvent.getButtonState(), (float)trackedEvent.getXPrecision(), (float)trackedEvent.getYPrecision(), (int)trackedEvent.getDeviceId(), (int)trackedEvent.getEdgeFlags(), (int)trackedEvent.getSource(), (int)trackedEvent.getFlags());
        }
        return MotionEvent.obtain((long)touch.downTime.longValue(), (long)touch.eventTime.longValue(), (int)touch.action, (int)touch.pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)touch.metaState, (int)touch.buttonState, (float)touch.xPrecision, (float)touch.yPrecision, (int)touch.deviceId, (int)touch.edgeFlags, (int)touch.source, (int)touch.flags);
    }

    public PlatformViewsController() {
        this.registry = new PlatformViewRegistryImpl();
        this.accessibilityEventsDelegate = new AccessibilityEventsDelegate();
        this.overlayLayerViews = new SparseArray();
        this.currentFrameUsedOverlayLayerIds = new HashSet();
        this.currentFrameUsedPlatformViewIds = new HashSet();
        this.viewWrappers = new SparseArray();
        this.platformViews = new SparseArray();
        this.platformViewParent = new SparseArray();
        this.motionEventTracker = MotionEventTracker.getInstance();
    }

    public void attach(@Nullable Context context, @NonNull TextureRegistry textureRegistry, @NonNull DartExecutor dartExecutor) {
        if (this.context != null) {
            throw new AssertionError((Object)"A PlatformViewsController can only be attached to a single output target.\nattach was called while the PlatformViewsController was already attached.");
        }
        this.context = context;
        this.textureRegistry = textureRegistry;
        this.platformViewsChannel = new PlatformViewsChannel(dartExecutor);
        this.platformViewsChannel.setPlatformViewsHandler(this.channelHandler);
    }

    public void setSoftwareRendering(boolean useSoftwareRendering) {
        this.usesSoftwareRendering = useSoftwareRendering;
    }

    @UiThread
    public void detach() {
        if (this.platformViewsChannel != null) {
            this.platformViewsChannel.setPlatformViewsHandler(null);
        }
        this.destroyOverlaySurfaces();
        this.platformViewsChannel = null;
        this.context = null;
        this.textureRegistry = null;
    }

    public void attachToView(@NonNull FlutterView newFlutterView) {
        int viewId;
        this.flutterView = newFlutterView;
        for (viewId = 0; viewId < this.viewWrappers.size(); ++viewId) {
            this.flutterView.addView((View)this.viewWrappers.get(viewId));
        }
        for (viewId = 0; viewId < this.platformViewParent.size(); ++viewId) {
            this.flutterView.addView((View)this.platformViewParent.get(viewId));
        }
        for (int platformViewId = 0; platformViewId < this.platformViews.size(); ++platformViewId) {
            PlatformView view = (PlatformView)this.platformViews.valueAt(platformViewId);
            view.onFlutterViewAttached((View)this.flutterView);
        }
    }

    public void detachFromView() {
        int viewId;
        for (viewId = 0; viewId < this.viewWrappers.size(); ++viewId) {
            this.flutterView.removeView((View)this.viewWrappers.get(viewId));
        }
        for (viewId = 0; viewId < this.platformViewParent.size(); ++viewId) {
            this.flutterView.removeView((View)this.platformViewParent.get(viewId));
        }
        this.destroyOverlaySurfaces();
        this.removeOverlaySurfaces();
        this.flutterView = null;
        this.flutterViewConvertedToImageView = false;
        for (int platformViewId = 0; platformViewId < this.platformViews.size(); ++platformViewId) {
            PlatformView view = (PlatformView)this.platformViews.valueAt(platformViewId);
            view.onFlutterViewDetached();
        }
    }

    @Override
    public void attachAccessibilityBridge(@NonNull AccessibilityBridge accessibilityBridge) {
        this.accessibilityEventsDelegate.setAccessibilityBridge(accessibilityBridge);
    }

    @Override
    public void detachAccessibilityBridge() {
        this.accessibilityEventsDelegate.setAccessibilityBridge(null);
    }

    public void attachTextInputPlugin(@NonNull TextInputPlugin textInputPlugin) {
        this.textInputPlugin = textInputPlugin;
    }

    public void detachTextInputPlugin() {
        this.textInputPlugin = null;
    }

    public PlatformViewRegistry getRegistry() {
        return this.registry;
    }

    public void onAttachedToJNI() {
    }

    public void onDetachedFromJNI() {
        this.flushAllViews();
    }

    public void onPreEngineRestart() {
        this.flushAllViews();
    }

    @Override
    @Nullable
    public View getPlatformViewById(int viewId) {
        PlatformView platformView = (PlatformView)this.platformViews.get(viewId);
        if (platformView == null) {
            return null;
        }
        return platformView.getView();
    }

    private static boolean validateDirection(int direction) {
        return direction == 0 || direction == 1;
    }

    private static List<MotionEvent.PointerProperties> parsePointerPropertiesList(Object rawPropertiesList) {
        List rawProperties = (List)rawPropertiesList;
        ArrayList<MotionEvent.PointerProperties> pointerProperties = new ArrayList<MotionEvent.PointerProperties>();
        for (Object o : rawProperties) {
            pointerProperties.add(PlatformViewsController.parsePointerProperties(o));
        }
        return pointerProperties;
    }

    private static MotionEvent.PointerProperties parsePointerProperties(Object rawProperties) {
        List propertiesList = (List)rawProperties;
        MotionEvent.PointerProperties properties = new MotionEvent.PointerProperties();
        properties.id = (Integer)propertiesList.get(0);
        properties.toolType = (Integer)propertiesList.get(1);
        return properties;
    }

    private static List<MotionEvent.PointerCoords> parsePointerCoordsList(Object rawCoordsList, float density) {
        List rawCoords = (List)rawCoordsList;
        ArrayList<MotionEvent.PointerCoords> pointerCoords = new ArrayList<MotionEvent.PointerCoords>();
        for (Object o : rawCoords) {
            pointerCoords.add(PlatformViewsController.parsePointerCoords(o, density));
        }
        return pointerCoords;
    }

    private static MotionEvent.PointerCoords parsePointerCoords(Object rawCoords, float density) {
        List coordsList = (List)rawCoords;
        MotionEvent.PointerCoords coords = new MotionEvent.PointerCoords();
        coords.orientation = (float)((Double)coordsList.get(0)).doubleValue();
        coords.pressure = (float)((Double)coordsList.get(1)).doubleValue();
        coords.size = (float)((Double)coordsList.get(2)).doubleValue();
        coords.toolMajor = (float)((Double)coordsList.get(3)).doubleValue() * density;
        coords.toolMinor = (float)((Double)coordsList.get(4)).doubleValue() * density;
        coords.touchMajor = (float)((Double)coordsList.get(5)).doubleValue() * density;
        coords.touchMinor = (float)((Double)coordsList.get(6)).doubleValue() * density;
        coords.x = (float)((Double)coordsList.get(7)).doubleValue() * density;
        coords.y = (float)((Double)coordsList.get(8)).doubleValue() * density;
        return coords;
    }

    private float getDisplayDensity() {
        return this.context.getResources().getDisplayMetrics().density;
    }

    private int toPhysicalPixels(double logicalPixels) {
        return (int)Math.round(logicalPixels * (double)this.getDisplayDensity());
    }

    private int toLogicalPixels(double physicalPixels) {
        return (int)Math.round(physicalPixels / (double)this.getDisplayDensity());
    }

    private void flushAllViews() {
        while (this.platformViews.size() > 0) {
            this.channelHandler.dispose(this.platformViews.keyAt(0));
        }
    }

    private void initializeRootImageViewIfNeeded() {
        if (this.synchronizeToNativeViewHierarchy && !this.flutterViewConvertedToImageView) {
            this.flutterView.convertToImageView();
            this.flutterViewConvertedToImageView = true;
        }
    }

    @VisibleForTesting
    void initializePlatformViewIfNeeded(int viewId) {
        PlatformView platformView = (PlatformView)this.platformViews.get(viewId);
        if (platformView == null) {
            throw new IllegalStateException("Platform view hasn't been initialized from the platform view channel.");
        }
        if (this.platformViewParent.get(viewId) != null) {
            return;
        }
        if (platformView.getView() == null) {
            throw new IllegalStateException("PlatformView#getView() returned null, but an Android view reference was expected.");
        }
        if (platformView.getView().getParent() != null) {
            throw new IllegalStateException("The Android view returned from PlatformView#getView() was already added to a parent view.");
        }
        FlutterMutatorView parentView = new FlutterMutatorView(this.context, this.context.getResources().getDisplayMetrics().density, this.androidTouchProcessor);
        parentView.setOnDescendantFocusChangeListener((view, hasFocus) -> {
            if (hasFocus) {
                this.platformViewsChannel.invokeViewFocused(viewId);
            } else if (this.textInputPlugin != null) {
                this.textInputPlugin.clearPlatformViewClient(viewId);
            }
        });
        this.platformViewParent.put(viewId, (Object)parentView);
        parentView.addView(platformView.getView());
        this.flutterView.addView((View)parentView);
    }

    public void attachToFlutterRenderer(@NonNull FlutterRenderer flutterRenderer) {
        this.androidTouchProcessor = new AndroidTouchProcessor(flutterRenderer, true);
    }

    public void onDisplayPlatformView(int viewId, int x, int y, int width, int height, int viewWidth, int viewHeight, @NonNull FlutterMutatorsStack mutatorsStack) {
        this.initializeRootImageViewIfNeeded();
        this.initializePlatformViewIfNeeded(viewId);
        FlutterMutatorView parentView = (FlutterMutatorView)((Object)this.platformViewParent.get(viewId));
        parentView.readyToDisplay(mutatorsStack, x, y, width, height);
        parentView.setVisibility(0);
        parentView.bringToFront();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(viewWidth, viewHeight);
        View view = ((PlatformView)this.platformViews.get(viewId)).getView();
        if (view != null) {
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            view.bringToFront();
        }
        this.currentFrameUsedPlatformViewIds.add(viewId);
    }

    public void onDisplayOverlaySurface(int id2, int x, int y, int width, int height) {
        if (this.overlayLayerViews.get(id2) == null) {
            throw new IllegalStateException("The overlay surface (id:" + id2 + ") doesn't exist");
        }
        this.initializeRootImageViewIfNeeded();
        FlutterImageView overlayView = (FlutterImageView)this.overlayLayerViews.get(id2);
        if (overlayView.getParent() == null) {
            this.flutterView.addView(overlayView);
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
        layoutParams.leftMargin = x;
        layoutParams.topMargin = y;
        overlayView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        overlayView.setVisibility(0);
        overlayView.bringToFront();
        this.currentFrameUsedOverlayLayerIds.add(id2);
    }

    public void onBeginFrame() {
        this.currentFrameUsedOverlayLayerIds.clear();
        this.currentFrameUsedPlatformViewIds.clear();
    }

    public void onEndFrame() {
        if (this.flutterViewConvertedToImageView && this.currentFrameUsedPlatformViewIds.isEmpty()) {
            this.flutterViewConvertedToImageView = false;
            this.flutterView.revertImageView(() -> this.finishFrame(false));
            return;
        }
        boolean isFrameRenderedUsingImageReaders = this.flutterViewConvertedToImageView && this.flutterView.acquireLatestImageViewFrame();
        this.finishFrame(isFrameRenderedUsingImageReaders);
    }

    private void finishFrame(boolean isFrameRenderedUsingImageReaders) {
        int i;
        for (i = 0; i < this.overlayLayerViews.size(); ++i) {
            int overlayId = this.overlayLayerViews.keyAt(i);
            FlutterImageView overlayView = (FlutterImageView)this.overlayLayerViews.valueAt(i);
            if (this.currentFrameUsedOverlayLayerIds.contains(overlayId)) {
                this.flutterView.attachOverlaySurfaceToRender(overlayView);
                boolean didAcquireOverlaySurfaceImage = overlayView.acquireLatestImage();
                isFrameRenderedUsingImageReaders &= didAcquireOverlaySurfaceImage;
                continue;
            }
            if (!this.flutterViewConvertedToImageView) {
                overlayView.detachFromRenderer();
            }
            overlayView.setVisibility(8);
        }
        for (i = 0; i < this.platformViewParent.size(); ++i) {
            int viewId = this.platformViewParent.keyAt(i);
            View parentView = (View)this.platformViewParent.get(viewId);
            if (this.currentFrameUsedPlatformViewIds.contains(viewId) && (isFrameRenderedUsingImageReaders || !this.synchronizeToNativeViewHierarchy)) {
                parentView.setVisibility(0);
                continue;
            }
            parentView.setVisibility(8);
        }
    }

    @VisibleForTesting
    @TargetApi(value=19)
    @NonNull
    public FlutterOverlaySurface createOverlaySurface(@NonNull FlutterImageView imageView) {
        int id2 = this.nextOverlayLayerId++;
        this.overlayLayerViews.put(id2, (Object)imageView);
        return new FlutterOverlaySurface(id2, imageView.getSurface());
    }

    @TargetApi(value=19)
    @NonNull
    public FlutterOverlaySurface createOverlaySurface() {
        return this.createOverlaySurface(new FlutterImageView(this.flutterView.getContext(), this.flutterView.getWidth(), this.flutterView.getHeight(), FlutterImageView.SurfaceKind.overlay));
    }

    public void destroyOverlaySurfaces() {
        for (int viewId = 0; viewId < this.overlayLayerViews.size(); ++viewId) {
            FlutterImageView overlayView = (FlutterImageView)this.overlayLayerViews.valueAt(viewId);
            overlayView.detachFromRenderer();
            overlayView.closeImageReader();
        }
    }

    private void removeOverlaySurfaces() {
        if (this.flutterView == null) {
            Log.e(TAG, "removeOverlaySurfaces called while flutter view is null");
            return;
        }
        for (int viewId = 0; viewId < this.overlayLayerViews.size(); ++viewId) {
            this.flutterView.removeView((View)this.overlayLayerViews.valueAt(viewId));
        }
        this.overlayLayerViews.clear();
    }
}

