/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.util;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;

public final class ViewUtils {
    @Nullable
    public static Activity getActivity(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return ViewUtils.getActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    public static int generateViewId(int fallbackId) {
        if (Build.VERSION.SDK_INT >= 17) {
            return View.generateViewId();
        }
        return fallbackId;
    }

    public static boolean childHasFocus(@Nullable View root) {
        if (root == null) {
            return false;
        }
        if (root.hasFocus()) {
            return true;
        }
        if (root instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)root;
            for (int idx = 0; idx < viewGroup.getChildCount(); ++idx) {
                if (!ViewUtils.childHasFocus(viewGroup.getChildAt(idx))) continue;
                return true;
            }
        }
        return false;
    }
}

