Iostreams, part of collection of the [Boost C++ Libraries](http://github.com/boostorg), provides:

* Tools to make it easy to create standard C++ streams and stream buffers for accessing new Sources and Sinks.
* A framework for defining filters and attaching them to standard streams and stream buffers.
* A collection of ready-to-use Filters, Sources and Sinks.
* Utilities to save and restore stream state.

### License

Distributed under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).

### Properties

* C++03
* Requires a Link Library

### Build Status

Branch          | Travis | Appveyor | Coverity Scan | codecov.io | Deps | Docs | Tests |
:-------------: | ------ | -------- | ------------- | ---------- | ---- | ---- | ----- |
[`master`](https://github.com/boostorg/iostreams/tree/master) | [![Build Status](https://travis-ci.org/boostorg/iostreams.svg?branch=master)](https://travis-ci.org/boostorg/iostreams) | [![Build status](https://ci.appveyor.com/api/projects/status/github/boostorg/iostreams?branch=master&svg=true)](https://ci.appveyor.com/project/eldiener/iostreams/branch/master) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/16463/badge.svg)](https://scan.coverity.com/projects/boostorg-iostreams) | [![codecov](https://codecov.io/gh/boostorg/iostreams/branch/master/graph/badge.svg)](https://codecov.io/gh/boostorg/iostreams/branch/master)| [![Deps](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/iostreams.html) | [![Documentation](https://img.shields.io/badge/docs-master-brightgreen.svg)](http://www.boost.org/doc/libs/master/doc/html/iostreams.html) | [![Enter the Matrix](https://img.shields.io/badge/matrix-master-brightgreen.svg)](http://www.boost.org/development/tests/master/developer/iostreams.html)
[`develop`](https://github.com/boostorg/iostreams/tree/develop) | [![Build Status](https://travis-ci.org/boostorg/iostreams.svg?branch=develop)](https://travis-ci.org/boostorg/iostreams) | [![Build status](https://ci.appveyor.com/api/projects/status/github/boostorg/iostreams?branch=develop&svg=true)](https://ci.appveyor.com/project/eldiener/iostreams/branch/develop) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/16463/badge.svg)](https://scan.coverity.com/projects/boostorg-iostreams) | [![codecov](https://codecov.io/gh/boostorg/iostreams/branch/develop/graph/badge.svg)](https://codecov.io/gh/boostorg/iostreams/branch/develop) | [![Deps](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/iostreams.html) | [![Documentation](https://img.shields.io/badge/docs-develop-brightgreen.svg)](http://www.boost.org/doc/libs/develop/doc/html/iostreams.html) | [![Enter the Matrix](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](http://www.boost.org/development/tests/develop/developer/iostreams.html)

### Directories

| Name        | Purpose                        |
| ----------- | ------------------------------ |
| `doc`       | documentation                  |
| `example`   | examples                       |
| `include`   | headers                        |
| `test`      | unit tests                     |

### More information

* [Ask questions](http://stackoverflow.com/questions/ask?tags=c%2B%2B,boost,boost-iostreams)
* [Report bugs](https://github.com/boostorg/iostreams/issues): Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as pull requests against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).
* Discussions about the library are held on the [Boost developers mailing list](http://www.boost.org/community/groups.html#main). Be sure to read the [discussion policy](http://www.boost.org/community/policy.html) before posting and add the `[iostreams]` tag at the beginning of the subject line.

