.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.ny0
.TH XSetCommand __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetCommand, XGetCommand \- set or read a window's WM_COMMAND property
.SH SYNTAX
.HP
int XSetCommand\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, char
**\fIargv\fP\^, int \fIargc\fP\^); 
.HP
Status XGetCommand\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, char
***\fIargv_return\fP\^, int *\fIargc_return\fP\^); 
.SH ARGUMENTS
.IP \fIargc\fP 1i
Specifies the number of arguments.
.IP \fIargc_return\fP 1i
Returns the number of arguments returned.
.IP \fIargv\fP 1i
Specifies the application's argument list.
.IP \fIargv_return\fP 1i
Returns the application's argument list.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIw\fP 1i
Specifies the window.
.SH DESCRIPTION
The
.ZN XSetCommand
function sets the command and arguments used to invoke the
application.
(Typically, argv is the argv array of your main program.)
If the strings are not in the Host Portable Character Encoding,
the result is implementation-dependent.
.LP
.ZN XSetCommand
can generate
.ZN BadAlloc
and
.ZN BadWindow 
errors.
.LP
The 
.ZN XGetCommand 
function reads the WM_COMMAND property from the specified window 
and returns a string list.
If the WM_COMMAND property exists, 
it is of type STRING and format 8.
If sufficient memory can be allocated to contain the string list, 
.ZN XGetCommand
fills in the argv_return and argc_return arguments
and returns a nonzero status.
Otherwise, or if any other error is encountered, it returns a zero status.
If the data returned by the server is in the Latin Portable Character Encoding,
then the returned strings are in the Host Portable Character Encoding.
Otherwise, the result is implementation-dependent.
To free the memory allocated to the string list, use
.ZN XFreeStringList .
.SH PROPERTIES
.TP 1i
\s-1WM_COMMAND\s+1
The command and arguments, null-separated, used to invoke the
application.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllocClassHint(__libmansuffix__),
XAllocIconSize(__libmansuffix__),
XAllocSizeHints(__libmansuffix__),
XAllocWMHints(__libmansuffix__),
XSetTransientForHint(__libmansuffix__),
XSetTextProperty(__libmansuffix__),
XSetWMClientMachine(__libmansuffix__),
XSetWMColormapWindows(__libmansuffix__),
XSetWMIconName(__libmansuffix__),
XSetWMName(__libmansuffix__),
XSetWMProperties(__libmansuffix__),
XSetWMProtocols(__libmansuffix__),
XStringListToTextProperty(__libmansuffix__)
.br
\fI\*(xL\fP
