
SUMMARY = "An abstract syntax tree for Python with inference support."
DESCRIPTION = "The aim of this module is to provide a common base \
representation of python source code. It is currently the library powering \
pylint’s capabilities.\
\
It provides a compatible representation which comes from the _ast module. It \
rebuilds the tree generated by the builtin _ast module by recursively walking \
down the AST and building an extended ast. The new node classes have \
additional methods and attributes for different usages. They include some \
support for static inference and local name scopes. Furthermore, astroid can \
also build partial trees by inspecting living objects."
HOMEPAGE = "https://pypi.python.org/pypi/astroid"
SECTION = "devel/python"

LICENSE = "LGPL-2.1-only"
LIC_FILES_CHKSUM = "file://COPYING;md5=751419260aa954499f7abaabaa882bbe"

SRC_URI[md5sum] = "5f3d73d82d1753b59bb49a6bc6046dee"
SRC_URI[sha256sum] = "71ea07f44df9568a75d0f354c49143a4575d90645e9fead6dfb52c26a85ed13a"

DEPENDS += "${PYTHON_PN}-pytest-runner-native"

PACKAGES =+ "${PN}-tests"

inherit pypi setuptools

FILES:${PN}-tests += " \
    ${PYTHON_SITEPACKAGES_DIR}/astroid/test* \
    ${PYTHON_SITEPACKAGES_DIR}/astroid/__pycache__/test* \
"

RDEPENDS:${PN}:class-target += "\
    ${PYTHON_PN}-backports-functools-lru-cache \
    ${PYTHON_PN}-distutils \
    ${PYTHON_PN}-enum34 \
    ${PYTHON_PN}-lazy-object-proxy \
    ${PYTHON_PN}-logging \
    ${PYTHON_PN}-re \
    ${PYTHON_PN}-setuptools \
    ${PYTHON_PN}-singledispatch \
    ${PYTHON_PN}-six \
    ${PYTHON_PN}-subprocess \
    ${PYTHON_PN}-wrapt \
"

RDEPENDS:${PN}-tests:class-target += "\
    ${PYTHON_PN}-unittest \
    ${PYTHON_PN}-xml \
"

SKIP_RECIPE[python-astroid] ?= "${@bb.utils.contains('I_SWEAR_TO_MIGRATE_TO_PYTHON3', 'yes', '', 'python2 is out of support for long time, read https://www.python.org/doc/sunset-python-2/ https://python3statement.org/ and if you really have to temporarily use this, then set I_SWEAR_TO_MIGRATE_TO_PYTHON3 to "yes"', d)}"
