# This file contains a list of CVE's where resolution has proven to be impractical
# or there is no reasonable action the Yocto Project can take to resolve the issue.
# It contains all the information we are aware of about an issue and analysis about
# why we believe it can't be fixed/handled. Additional information is welcome through
# patches to the file.
#
# Include this file in your local.conf or distro.conf to exclude these CVE's
# from the cve-check results or add to the bitbake command with:
#     -R conf/distro/include/cve-extra-exclusions.inc
#
# The file is not included by default since users should review this data to ensure
# it matches their expectations and usage of the project.
#
# We may also include "in-flight" information about current/ongoing CVE work with
# the aim of sharing that work and ensuring we don't duplicate it.
#


# strace https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2000-0006
# CVE is more than 20 years old with no resolution evident
# broken links in CVE database references make resolution impractical
CVE_CHECK_IGNORE += "CVE-2000-0006"

# epiphany https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2005-0238
# The issue here is spoofing of domain names using characters from other character sets.
# There has been much discussion amongst the epiphany and webkit developers and
# whilst there are improvements about how domains are handled and displayed to the user
# there is unlikely ever to be a single fix to webkit or epiphany which addresses this
# problem. Ignore this CVE as there isn't any mitigation or fix or way to progress this further
# we can seem to take.
CVE_CHECK_IGNORE += "CVE-2005-0238"

# glibc https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2010-4756
# Issue is memory exhaustion via glob() calls, e.g. from within an ftp server
# Best discussion in https://bugzilla.redhat.com/show_bug.cgi?id=681681
# Upstream don't see it as a security issue, ftp servers shouldn't be passing
# this to libc glob. Exclude as upstream have no plans to add BSD's GLOB_LIMIT or similar
CVE_CHECK_IGNORE += "CVE-2010-4756"

# go https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2020-29509
# go https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2020-29511
# The encoding/xml package in go can potentially be used for security exploits if not used correctly
# CVE applies to a netapp product as well as flagging a general issue. We don't ship anything
# exposing this interface in an exploitable way
CVE_CHECK_IGNORE += "CVE-2020-29509 CVE-2020-29511"

# db
# Since Oracle relicensed bdb, the open source community is slowly but surely replacing bdb with
# supported and open source friendly alternatives. As a result these CVEs are unlikely to ever be fixed.
CVE_CHECK_IGNORE += "CVE-2015-2583 CVE-2015-2624 CVE-2015-2626 CVE-2015-2640 CVE-2015-2654 \
CVE-2015-2656 CVE-2015-4754 CVE-2015-4764 CVE-2015-4774 CVE-2015-4775 CVE-2015-4776 CVE-2015-4777 \
CVE-2015-4778 CVE-2015-4779 CVE-2015-4780 CVE-2015-4781 CVE-2015-4782 CVE-2015-4783 CVE-2015-4784 \
CVE-2015-4785 CVE-2015-4786 CVE-2015-4787 CVE-2015-4788 CVE-2015-4789 CVE-2015-4790 CVE-2016-0682 \
CVE-2016-0689 CVE-2016-0692 CVE-2016-0694 CVE-2016-3418 CVE-2020-2981"


#
# Kernel CVEs, e.g. linux-yocto*
#
# For OE-Core our policy is to stay as close to the kernel stable releases as we can. This should
# ensure the bulk of the major kernel CVEs are fixed and we don't dive into each individual issue
# as the stable maintainers are much more able to do that.
#
# Rather than just ignore all kernel CVEs, list the ones we ignore on this basis here, allowing new
# issues to be visible. If anyone wishes to clean up CPE entries with NIST for these, we'd
# welcome than and then entries can likely be removed from here.
#
# 1999-2010
CVE_CHECK_IGNORE += "CVE-1999-0524 CVE-1999-0656 CVE-2006-2932 CVE-2007-2764 CVE-2007-4998 CVE-2008-2544 \
                     CVE-2008-4609 CVE-2010-0298 CVE-2010-4563"
# 2011-2017
CVE_CHECK_IGNORE += "CVE-2011-0640 CVE-2014-2648 CVE-2014-8171 CVE-2016-0774 CVE-2016-3695 CVE-2016-3699 \
                     CVE-2017-1000255 CVE-2017-1000377 CVE-2017-5897 CVE-2017-6264"
# 2018
CVE_CHECK_IGNORE += "CVE-2018-1000026 CVE-2018-10840 CVE-2018-10876 CVE-2018-10882 CVE-2018-10901 CVE-2018-10902 \
                     CVE-2018-14625 CVE-2018-16880 CVE-2018-16884 CVE-2018-5873 CVE-2018-6559"
# 2019
CVE_CHECK_IGNORE += "CVE-2019-10126 CVE-2019-14899 CVE-2019-18910 CVE-2019-3016 CVE-2019-3819 CVE-2019-3846 CVE-2019-3887"
# 2020
CVE_CHECK_IGNORE += "CVE-2020-10732 CVE-2020-10742 CVE-2020-16119 CVE-2020-1749 CVE-2020-25672 CVE-2020-27820 CVE-2020-35501 CVE-2020-8834"
# 2021
CVE_CHECK_IGNORE += "CVE-2021-20194 CVE-2021-20226 CVE-2021-20265 CVE-2021-3564 CVE-2021-3743 CVE-2021-3847 CVE-2021-4002 \
                     CVE-2021-4090 CVE-2021-4095 CVE-2021-4197 CVE-2021-4202 CVE-2021-44879 CVE-2021-45402"
# 2022
CVE_CHECK_IGNORE += "CVE-2022-0185 CVE-2022-0264 CVE-2022-0286 CVE-2022-0330 CVE-2022-0382 CVE-2022-0433 CVE-2022-0435 \
                     CVE-2022-0492 CVE-2022-0494 CVE-2022-0500 CVE-2022-0516 CVE-2022-0617 CVE-2022-0742 CVE-2022-0854 \
                     CVE-2022-0995 CVE-2022-0998 CVE-2022-1011 CVE-2022-1015 CVE-2022-1048 CVE-2022-1055 CVE-2022-1195 \
                     CVE-2022-1353 CVE-2022-24122 CVE-2022-24448 CVE-2022-24958 CVE-2022-24959 CVE-2022-25258 CVE-2022-25265 \
                     CVE-2022-25375 CVE-2022-26490 CVE-2022-26878 CVE-2022-26966 CVE-2022-27223 CVE-2022-27666 CVE-2022-27950 \
                     CVE-2022-28356 CVE-2022-28388 CVE-2022-28389 CVE-2022-28390 CVE-2022-28796 CVE-2022-28893 CVE-2022-29156 \
                     CVE-2022-29582 CVE-2022-29968"

#### CPE update pending ####

# groff:groff-native https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2000-0803
# Appears it was fixed in https://git.savannah.gnu.org/cgit/groff.git/commit/?id=07f95f1674217275ed4612f1dcaa95a88435c6a7
# so from 1.17 onwards. Reported to the database for update by RP 2021/5/9. Update accepted 2021/5/10.
#CVE_CHECK_IGNORE += "CVE-2000-0803"



#### Upstream still working on ####

# qemu:qemu-native:qemu-system-native https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2021-20255
# There was a proposed patch https://lists.gnu.org/archive/html/qemu-devel/2021-02/msg06098.html
# however qemu maintainers are sure the patch is incorrect and should not be applied.

# wget https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2021-31879
# https://mail.gnu.org/archive/html/bug-wget/2021-02/msg00002.html
# No response upstream as of 2021/5/12



