/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.dart;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import io.flutter.FlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.PlatformMessageHandler;
import io.flutter.embedding.engine.dart.PlatformTaskQueue;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.util.TraceSection;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

class DartMessenger
implements BinaryMessenger,
PlatformMessageHandler {
    private static final String TAG = "DartMessenger";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final Map<String, HandlerInfo> messageHandlers = new HashMap<String, HandlerInfo>();
    @NonNull
    private Map<String, List<BufferedMessageInfo>> bufferedMessages = new HashMap<String, List<BufferedMessageInfo>>();
    @NonNull
    private final Object handlersLock = new Object();
    @NonNull
    private final AtomicBoolean enableBufferingIncomingMessages = new AtomicBoolean(false);
    @NonNull
    private final Map<Integer, BinaryMessenger.BinaryReply> pendingReplies = new HashMap<Integer, BinaryMessenger.BinaryReply>();
    private int nextReplyId = 1;
    @NonNull
    private final DartMessengerTaskQueue platformTaskQueue = new PlatformTaskQueue();
    @NonNull
    private WeakHashMap<BinaryMessenger.TaskQueue, DartMessengerTaskQueue> createdTaskQueues = new WeakHashMap();
    @NonNull
    private TaskQueueFactory taskQueueFactory;

    DartMessenger(@NonNull FlutterJNI flutterJNI, @NonNull TaskQueueFactory taskQueueFactory) {
        this.flutterJNI = flutterJNI;
        this.taskQueueFactory = taskQueueFactory;
    }

    DartMessenger(@NonNull FlutterJNI flutterJNI) {
        this(flutterJNI, new DefaultTaskQueueFactory());
    }

    @Override
    public BinaryMessenger.TaskQueue makeBackgroundTaskQueue(BinaryMessenger.TaskQueueOptions options) {
        DartMessengerTaskQueue taskQueue = this.taskQueueFactory.makeBackgroundTaskQueue(options);
        TaskQueueToken token = new TaskQueueToken();
        this.createdTaskQueues.put(token, taskQueue);
        return token;
    }

    @Override
    public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessenger.BinaryMessageHandler handler) {
        this.setMessageHandler(channel, handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessenger.BinaryMessageHandler handler, @Nullable BinaryMessenger.TaskQueue taskQueue) {
        List<BufferedMessageInfo> list;
        if (handler == null) {
            Log.v(TAG, "Removing handler for channel '" + channel + "'");
            Object object = this.handlersLock;
            synchronized (object) {
                this.messageHandlers.remove(channel);
            }
            return;
        }
        DartMessengerTaskQueue dartMessengerTaskQueue = null;
        if (taskQueue != null && (dartMessengerTaskQueue = this.createdTaskQueues.get(taskQueue)) == null) {
            throw new IllegalArgumentException("Unrecognized TaskQueue, use BinaryMessenger to create your TaskQueue (ex makeBackgroundTaskQueue).");
        }
        Log.v(TAG, "Setting handler for channel '" + channel + "'");
        Iterator<BufferedMessageInfo> iterator = this.handlersLock;
        synchronized (iterator) {
            this.messageHandlers.put(channel, new HandlerInfo(handler, dartMessengerTaskQueue));
            list = this.bufferedMessages.remove(channel);
            if (list == null) {
                return;
            }
        }
        for (BufferedMessageInfo info : list) {
            this.dispatchMessageToQueue(channel, this.messageHandlers.get(channel), info.message, info.replyId, info.messageData);
        }
    }

    @Override
    public void enableBufferingIncomingMessages() {
        this.enableBufferingIncomingMessages.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableBufferingIncomingMessages() {
        Map<String, List<BufferedMessageInfo>> pendingMessages;
        Iterator<Map.Entry<String, List<BufferedMessageInfo>>> iterator = this.handlersLock;
        synchronized (iterator) {
            this.enableBufferingIncomingMessages.set(false);
            pendingMessages = this.bufferedMessages;
            this.bufferedMessages = new HashMap<String, List<BufferedMessageInfo>>();
        }
        for (Map.Entry<String, List<BufferedMessageInfo>> channel : pendingMessages.entrySet()) {
            for (BufferedMessageInfo info : channel.getValue()) {
                this.dispatchMessageToQueue(channel.getKey(), null, info.message, info.replyId, info.messageData);
            }
        }
    }

    @Override
    @UiThread
    public void send(@NonNull String channel, @NonNull ByteBuffer message) {
        Log.v(TAG, "Sending message over channel '" + channel + "'");
        this.send(channel, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(@NonNull String channel, @Nullable ByteBuffer message, @Nullable BinaryMessenger.BinaryReply callback) {
        TraceSection.begin("DartMessenger#send on " + channel);
        try {
            Log.v(TAG, "Sending message with callback over channel '" + channel + "'");
            int replyId = this.nextReplyId++;
            if (callback != null) {
                this.pendingReplies.put(replyId, callback);
            }
            if (message == null) {
                this.flutterJNI.dispatchEmptyPlatformMessage(channel, replyId);
            } else {
                this.flutterJNI.dispatchPlatformMessage(channel, message, message.position(), replyId);
            }
        }
        finally {
            TraceSection.end();
        }
    }

    private void invokeHandler(@Nullable HandlerInfo handlerInfo, @Nullable ByteBuffer message, int replyId) {
        if (handlerInfo != null) {
            try {
                Log.v(TAG, "Deferring to registered handler to process message.");
                handlerInfo.handler.onMessage(message, new Reply(this.flutterJNI, replyId));
            }
            catch (Exception ex) {
                Log.e(TAG, "Uncaught exception in binary message listener", ex);
                this.flutterJNI.invokePlatformMessageEmptyResponseCallback(replyId);
            }
            catch (Error err) {
                DartMessenger.handleError(err);
            }
        } else {
            Log.v(TAG, "No registered handler for message. Responding to Dart with empty reply message.");
            this.flutterJNI.invokePlatformMessageEmptyResponseCallback(replyId);
        }
    }

    private void dispatchMessageToQueue(@NonNull String channel, @Nullable HandlerInfo handlerInfo, @Nullable ByteBuffer message, int replyId, long messageData) {
        DartMessengerTaskQueue taskQueue = handlerInfo != null ? handlerInfo.taskQueue : null;
        Runnable myRunnable = () -> {
            TraceSection.begin("DartMessenger#handleMessageFromDart on " + channel);
            try {
                this.invokeHandler(handlerInfo, message, replyId);
                if (message != null && message.isDirect()) {
                    message.limit(0);
                }
            }
            finally {
                this.flutterJNI.cleanupMessageData(messageData);
                TraceSection.end();
            }
        };
        DartMessengerTaskQueue nonnullTaskQueue = taskQueue == null ? this.platformTaskQueue : taskQueue;
        nonnullTaskQueue.dispatch(myRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessageFromDart(@NonNull String channel, @Nullable ByteBuffer message, int replyId, long messageData) {
        boolean messageDeferred;
        HandlerInfo handlerInfo;
        Log.v(TAG, "Received message from Dart over channel '" + channel + "'");
        Object object = this.handlersLock;
        synchronized (object) {
            handlerInfo = this.messageHandlers.get(channel);
            boolean bl = messageDeferred = this.enableBufferingIncomingMessages.get() && handlerInfo == null;
            if (messageDeferred) {
                if (!this.bufferedMessages.containsKey(channel)) {
                    this.bufferedMessages.put(channel, new LinkedList());
                }
                List<BufferedMessageInfo> buffer = this.bufferedMessages.get(channel);
                buffer.add(new BufferedMessageInfo(message, replyId, messageData));
            }
        }
        if (!messageDeferred) {
            this.dispatchMessageToQueue(channel, handlerInfo, message, replyId, messageData);
        }
    }

    @Override
    public void handlePlatformMessageResponse(int replyId, @Nullable ByteBuffer reply) {
        Log.v(TAG, "Received message reply from Dart.");
        BinaryMessenger.BinaryReply callback = this.pendingReplies.remove(replyId);
        if (callback != null) {
            try {
                Log.v(TAG, "Invoking registered callback for reply from Dart.");
                callback.reply(reply);
                if (reply != null && reply.isDirect()) {
                    reply.limit(0);
                }
            }
            catch (Exception ex) {
                Log.e(TAG, "Uncaught exception in binary message reply handler", ex);
            }
            catch (Error err) {
                DartMessenger.handleError(err);
            }
        }
    }

    @UiThread
    public int getPendingChannelResponseCount() {
        return this.pendingReplies.size();
    }

    private static void handleError(Error err) {
        Thread currentThread = Thread.currentThread();
        if (currentThread.getUncaughtExceptionHandler() == null) {
            throw err;
        }
        currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, err);
    }

    static class Reply
    implements BinaryMessenger.BinaryReply {
        @NonNull
        private final FlutterJNI flutterJNI;
        private final int replyId;
        private final AtomicBoolean done = new AtomicBoolean(false);

        Reply(@NonNull FlutterJNI flutterJNI, int replyId) {
            this.flutterJNI = flutterJNI;
            this.replyId = replyId;
        }

        @Override
        public void reply(@Nullable ByteBuffer reply) {
            if (this.done.getAndSet(true)) {
                throw new IllegalStateException("Reply already submitted");
            }
            if (reply == null) {
                this.flutterJNI.invokePlatformMessageEmptyResponseCallback(this.replyId);
            } else {
                this.flutterJNI.invokePlatformMessageResponseCallback(this.replyId, reply, reply.position());
            }
        }
    }

    static class SerialTaskQueue
    implements DartMessengerTaskQueue {
        @NonNull
        private final ExecutorService executor;
        @NonNull
        private final ConcurrentLinkedQueue<Runnable> queue;
        @NonNull
        private final AtomicBoolean isRunning;

        SerialTaskQueue(ExecutorService executor) {
            this.executor = executor;
            this.queue = new ConcurrentLinkedQueue();
            this.isRunning = new AtomicBoolean(false);
        }

        @Override
        public void dispatch(@NonNull Runnable runnable) {
            this.queue.add(runnable);
            this.executor.execute(() -> this.flush());
        }

        private void flush() {
            if (this.isRunning.compareAndSet(false, true)) {
                try {
                    Runnable runnable = this.queue.poll();
                    if (runnable != null) {
                        runnable.run();
                    }
                }
                finally {
                    this.isRunning.set(false);
                    if (!this.queue.isEmpty()) {
                        this.executor.execute(() -> this.flush());
                    }
                }
            }
        }
    }

    static class ConcurrentTaskQueue
    implements DartMessengerTaskQueue {
        @NonNull
        private final ExecutorService executor;

        ConcurrentTaskQueue(ExecutorService executor) {
            this.executor = executor;
        }

        @Override
        public void dispatch(@NonNull Runnable runnable) {
            this.executor.execute(runnable);
        }
    }

    private static class BufferedMessageInfo {
        @NonNull
        public final ByteBuffer message;
        int replyId;
        long messageData;

        BufferedMessageInfo(@NonNull ByteBuffer message, int replyId, long messageData) {
            this.message = message;
            this.replyId = replyId;
            this.messageData = messageData;
        }
    }

    private static class HandlerInfo {
        @NonNull
        public final BinaryMessenger.BinaryMessageHandler handler;
        @Nullable
        public final DartMessengerTaskQueue taskQueue;

        HandlerInfo(@NonNull BinaryMessenger.BinaryMessageHandler handler, @Nullable DartMessengerTaskQueue taskQueue) {
            this.handler = handler;
            this.taskQueue = taskQueue;
        }
    }

    private static class DefaultTaskQueueFactory
    implements TaskQueueFactory {
        ExecutorService executorService = FlutterInjector.instance().executorService();

        DefaultTaskQueueFactory() {
        }

        @Override
        public DartMessengerTaskQueue makeBackgroundTaskQueue(BinaryMessenger.TaskQueueOptions options) {
            if (options.getIsSerial()) {
                return new SerialTaskQueue(this.executorService);
            }
            return new ConcurrentTaskQueue(this.executorService);
        }
    }

    static interface TaskQueueFactory {
        public DartMessengerTaskQueue makeBackgroundTaskQueue(BinaryMessenger.TaskQueueOptions var1);
    }

    static interface DartMessengerTaskQueue {
        public void dispatch(@NonNull Runnable var1);
    }

    private static class TaskQueueToken
    implements BinaryMessenger.TaskQueue {
        private TaskQueueToken() {
        }
    }
}

