A lower range wasn't less than the upper range.

Erroneous code example:

```compile_fail,E0579
#![feature(exclusive_range_pattern)]

fn main() {
    match 5u32 {
        // This range is ok, albeit pointless.
        1..2 => {}
        // This range is empty, and the compiler can tell.
        5..5 => {} // error!
    }
}
```

When matching against an exclusive range, the compiler verifies that the range
is non-empty. Exclusive range patterns include the start point but not the end
point, so this is equivalent to requiring the start of the range to be less
than the end of the range.
