/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.renderer.RenderSurface;

public class FlutterTextureView
extends TextureView
implements RenderSurface {
    private static final String TAG = "FlutterTextureView";
    private boolean isSurfaceAvailableForRendering = false;
    private boolean isAttachedToFlutterRenderer = false;
    private boolean isPaused = false;
    @Nullable
    private FlutterRenderer flutterRenderer;
    @Nullable
    private Surface renderSurface;
    private final TextureView.SurfaceTextureListener surfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            Log.v(FlutterTextureView.TAG, "SurfaceTextureListener.onSurfaceTextureAvailable()");
            FlutterTextureView.this.isSurfaceAvailableForRendering = true;
            if (FlutterTextureView.this.isAttachedToFlutterRenderer) {
                FlutterTextureView.this.connectSurfaceToRenderer();
            }
        }

        public void onSurfaceTextureSizeChanged(@NonNull SurfaceTexture surface, int width, int height) {
            Log.v(FlutterTextureView.TAG, "SurfaceTextureListener.onSurfaceTextureSizeChanged()");
            if (FlutterTextureView.this.isAttachedToFlutterRenderer) {
                FlutterTextureView.this.changeSurfaceSize(width, height);
            }
        }

        public void onSurfaceTextureUpdated(@NonNull SurfaceTexture surface) {
        }

        public boolean onSurfaceTextureDestroyed(@NonNull SurfaceTexture surface) {
            Log.v(FlutterTextureView.TAG, "SurfaceTextureListener.onSurfaceTextureDestroyed()");
            FlutterTextureView.this.isSurfaceAvailableForRendering = false;
            if (FlutterTextureView.this.isAttachedToFlutterRenderer) {
                FlutterTextureView.this.disconnectSurfaceFromRenderer();
            }
            if (FlutterTextureView.this.renderSurface != null) {
                FlutterTextureView.this.renderSurface.release();
                FlutterTextureView.this.renderSurface = null;
            }
            return true;
        }
    };

    public FlutterTextureView(@NonNull Context context) {
        this(context, null);
    }

    public FlutterTextureView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setSurfaceTextureListener(this.surfaceTextureListener);
    }

    @Override
    @Nullable
    public FlutterRenderer getAttachedRenderer() {
        return this.flutterRenderer;
    }

    @Override
    public void attachToRenderer(@NonNull FlutterRenderer flutterRenderer) {
        Log.v(TAG, "Attaching to FlutterRenderer.");
        if (this.flutterRenderer != null) {
            Log.v(TAG, "Already connected to a FlutterRenderer. Detaching from old one and attaching to new one.");
            this.flutterRenderer.stopRenderingToSurface();
        }
        this.flutterRenderer = flutterRenderer;
        this.isAttachedToFlutterRenderer = true;
        if (this.isSurfaceAvailableForRendering) {
            Log.v(TAG, "Surface is available for rendering. Connecting FlutterRenderer to Android surface.");
            this.connectSurfaceToRenderer();
        }
    }

    @Override
    public void detachFromRenderer() {
        if (this.flutterRenderer != null) {
            if (this.getWindowToken() != null) {
                Log.v(TAG, "Disconnecting FlutterRenderer from Android surface.");
                this.disconnectSurfaceFromRenderer();
            }
            this.flutterRenderer = null;
            this.isAttachedToFlutterRenderer = false;
        } else {
            Log.w(TAG, "detachFromRenderer() invoked when no FlutterRenderer was attached.");
        }
    }

    @Override
    public void pause() {
        if (this.flutterRenderer != null) {
            this.flutterRenderer = null;
            this.isPaused = true;
            this.isAttachedToFlutterRenderer = false;
        } else {
            Log.w(TAG, "pause() invoked when no FlutterRenderer was attached.");
        }
    }

    @VisibleForTesting
    public void setRenderSurface(Surface renderSurface) {
        this.renderSurface = renderSurface;
    }

    private void connectSurfaceToRenderer() {
        if (this.flutterRenderer == null || this.getSurfaceTexture() == null) {
            throw new IllegalStateException("connectSurfaceToRenderer() should only be called when flutterRenderer and getSurfaceTexture() are non-null.");
        }
        if (this.renderSurface != null) {
            this.renderSurface.release();
            this.renderSurface = null;
        }
        this.renderSurface = new Surface(this.getSurfaceTexture());
        this.flutterRenderer.startRenderingToSurface(this.renderSurface, this.isPaused);
        this.isPaused = false;
    }

    private void changeSurfaceSize(int width, int height) {
        if (this.flutterRenderer == null) {
            throw new IllegalStateException("changeSurfaceSize() should only be called when flutterRenderer is non-null.");
        }
        Log.v(TAG, "Notifying FlutterRenderer that Android surface size has changed to " + width + " x " + height);
        this.flutterRenderer.surfaceChanged(width, height);
    }

    private void disconnectSurfaceFromRenderer() {
        if (this.flutterRenderer == null) {
            throw new IllegalStateException("disconnectSurfaceFromRenderer() should only be called when flutterRenderer is non-null.");
        }
        this.flutterRenderer.stopRenderingToSurface();
        if (this.renderSurface != null) {
            this.renderSurface.release();
            this.renderSurface = null;
        }
    }
}

