/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.content.Context;
import android.graphics.Region;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.embedding.engine.renderer.RenderSurface;

public class FlutterSurfaceView
extends SurfaceView
implements RenderSurface {
    private static final String TAG = "FlutterSurfaceView";
    private final boolean renderTransparently;
    private boolean isSurfaceAvailableForRendering = false;
    private boolean isPaused = false;
    @Nullable
    private FlutterRenderer flutterRenderer;
    private final SurfaceHolder.Callback surfaceCallback = new SurfaceHolder.Callback(){

        public void surfaceCreated(@NonNull SurfaceHolder holder) {
            Log.v(FlutterSurfaceView.TAG, "SurfaceHolder.Callback.startRenderingToSurface()");
            FlutterSurfaceView.this.isSurfaceAvailableForRendering = true;
            if (FlutterSurfaceView.this.shouldNotify()) {
                FlutterSurfaceView.this.connectSurfaceToRenderer();
            }
        }

        public void surfaceChanged(@NonNull SurfaceHolder holder, int format, int width, int height) {
            Log.v(FlutterSurfaceView.TAG, "SurfaceHolder.Callback.surfaceChanged()");
            if (FlutterSurfaceView.this.shouldNotify()) {
                FlutterSurfaceView.this.changeSurfaceSize(width, height);
            }
        }

        public void surfaceDestroyed(@NonNull SurfaceHolder holder) {
            Log.v(FlutterSurfaceView.TAG, "SurfaceHolder.Callback.stopRenderingToSurface()");
            FlutterSurfaceView.this.isSurfaceAvailableForRendering = false;
            if (FlutterSurfaceView.this.shouldNotify()) {
                FlutterSurfaceView.this.disconnectSurfaceFromRenderer();
            }
        }
    };
    private final FlutterUiDisplayListener flutterUiDisplayListener = new FlutterUiDisplayListener(){

        @Override
        public void onFlutterUiDisplayed() {
            Log.v(FlutterSurfaceView.TAG, "onFlutterUiDisplayed()");
            FlutterSurfaceView.this.setAlpha(1.0f);
            if (FlutterSurfaceView.this.flutterRenderer != null) {
                FlutterSurfaceView.this.flutterRenderer.removeIsDisplayingFlutterUiListener(this);
            }
        }

        @Override
        public void onFlutterUiNoLongerDisplayed() {
        }
    };

    private boolean shouldNotify() {
        return this.flutterRenderer != null && !this.isPaused;
    }

    public FlutterSurfaceView(@NonNull Context context) {
        this(context, null, false);
    }

    public FlutterSurfaceView(@NonNull Context context, boolean renderTransparently) {
        this(context, null, renderTransparently);
    }

    public FlutterSurfaceView(@NonNull Context context, @NonNull AttributeSet attrs) {
        this(context, attrs, false);
    }

    private FlutterSurfaceView(@NonNull Context context, @Nullable AttributeSet attrs, boolean renderTransparently) {
        super(context, attrs);
        this.renderTransparently = renderTransparently;
        this.init();
    }

    private void init() {
        if (this.renderTransparently) {
            this.getHolder().setFormat(-2);
            this.setZOrderOnTop(true);
        }
        this.getHolder().addCallback(this.surfaceCallback);
        this.setAlpha(0.0f);
    }

    public boolean gatherTransparentRegion(Region region) {
        if (this.getAlpha() < 1.0f) {
            return false;
        }
        int[] location = new int[2];
        this.getLocationInWindow(location);
        region.op(location[0], location[1], location[0] + this.getRight() - this.getLeft(), location[1] + this.getBottom() - this.getTop(), Region.Op.DIFFERENCE);
        return true;
    }

    @Override
    @Nullable
    public FlutterRenderer getAttachedRenderer() {
        return this.flutterRenderer;
    }

    @Override
    public void attachToRenderer(@NonNull FlutterRenderer flutterRenderer) {
        Log.v(TAG, "Attaching to FlutterRenderer.");
        if (this.flutterRenderer != null) {
            Log.v(TAG, "Already connected to a FlutterRenderer. Detaching from old one and attaching to new one.");
            this.flutterRenderer.stopRenderingToSurface();
            this.flutterRenderer.removeIsDisplayingFlutterUiListener(this.flutterUiDisplayListener);
        }
        this.flutterRenderer = flutterRenderer;
        this.resume();
    }

    @Override
    public void detachFromRenderer() {
        if (this.flutterRenderer != null) {
            if (this.getWindowToken() != null) {
                Log.v(TAG, "Disconnecting FlutterRenderer from Android surface.");
                this.disconnectSurfaceFromRenderer();
            }
            this.pause();
            this.setAlpha(0.0f);
            this.flutterRenderer.removeIsDisplayingFlutterUiListener(this.flutterUiDisplayListener);
            this.flutterRenderer = null;
        } else {
            Log.w(TAG, "detachFromRenderer() invoked when no FlutterRenderer was attached.");
        }
    }

    @Override
    public void pause() {
        if (this.flutterRenderer == null) {
            Log.w(TAG, "pause() invoked when no FlutterRenderer was attached.");
            return;
        }
        this.isPaused = true;
    }

    @Override
    public void resume() {
        if (this.flutterRenderer == null) {
            Log.w(TAG, "resume() invoked when no FlutterRenderer was attached.");
            return;
        }
        this.flutterRenderer.addIsDisplayingFlutterUiListener(this.flutterUiDisplayListener);
        if (this.isSurfaceAvailableForRendering) {
            Log.v(TAG, "Surface is available for rendering. Connecting FlutterRenderer to Android surface.");
            this.connectSurfaceToRenderer();
        }
        this.isPaused = false;
    }

    private void connectSurfaceToRenderer() {
        if (this.flutterRenderer == null || this.getHolder() == null) {
            throw new IllegalStateException("connectSurfaceToRenderer() should only be called when flutterRenderer and getHolder() are non-null.");
        }
        this.flutterRenderer.startRenderingToSurface(this.getHolder().getSurface(), this.isPaused);
    }

    private void changeSurfaceSize(int width, int height) {
        if (this.flutterRenderer == null) {
            throw new IllegalStateException("changeSurfaceSize() should only be called when flutterRenderer is non-null.");
        }
        Log.v(TAG, "Notifying FlutterRenderer that Android surface size has changed to " + width + " x " + height);
        this.flutterRenderer.surfaceChanged(width, height);
    }

    private void disconnectSurfaceFromRenderer() {
        if (this.flutterRenderer == null) {
            throw new IllegalStateException("disconnectSurfaceFromRenderer() should only be called when flutterRenderer is non-null.");
        }
        this.flutterRenderer.stopRenderingToSurface();
    }
}

