/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.content.Context;
import android.graphics.Rect;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;

class SingleViewFakeWindowViewGroup
extends ViewGroup {
    private final Rect viewBounds = new Rect();
    private final Rect childRect = new Rect();

    public SingleViewFakeWindowViewGroup(Context context) {
        super(context);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            WindowManager.LayoutParams params = (WindowManager.LayoutParams)child.getLayoutParams();
            this.viewBounds.set(l, t, r, b);
            Gravity.apply((int)params.gravity, (int)child.getMeasuredWidth(), (int)child.getMeasuredHeight(), (Rect)this.viewBounds, (int)params.x, (int)params.y, (Rect)this.childRect);
            child.layout(this.childRect.left, this.childRect.top, this.childRect.right, this.childRect.bottom);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            child.measure(SingleViewFakeWindowViewGroup.atMost(widthMeasureSpec), SingleViewFakeWindowViewGroup.atMost(heightMeasureSpec));
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private static int atMost(int measureSpec) {
        return View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)measureSpec), (int)Integer.MIN_VALUE);
    }
}

