// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
//
// VMOptions=--verbose_debug

// See: https://github.com/dart-lang/sdk/issues/45673

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 26;
const LINE_B = 36;
const LINE_C = 46;
// AUTOGENERATED END

@pragma('vm:notify-debugger-on-exception')
Future<void> throwFromAsync() async {
  try {
    throw 'Throw from throwFromAsync'; // LINE_A
  } catch (e) {
    // Ignore. Internals will notify debugger.
  }
  return Future.value();
}

@pragma('vm:notify-debugger-on-exception')
Stream<int> throwFromAsyncStar() async* {
  try {
    throw 'Throw from throwFromAsyncStar'; // LINE_B
  } catch (e) {
    // Ignore. Internals will notify debugger.
  }
  yield 13;
}

@pragma('vm:notify-debugger-on-exception')
Iterable<int> throwFromSyncStar() sync* {
  try {
    throw 'Throw from throwFromSyncStar'; // LINE_C
  } catch (e) {
    // Ignore. Internals will notify debugger.
  }
  yield 7;
}

Future<void> testMain() async {
  await throwFromAsync();
  await for (var _ in throwFromAsyncStar()) {/*ignore*/}
  for (var _ in throwFromSyncStar()) {/*ignore*/}
}

final tests = <IsolateTest>[
  hasStoppedWithUnhandledException,
  stoppedAtLine(LINE_A),
  resumeIsolate,
  hasStoppedWithUnhandledException,
  stoppedAtLine(LINE_B),
  resumeIsolate,
  hasStoppedWithUnhandledException,
  stoppedAtLine(LINE_C),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'notify_debugger_on_exception_yielding_test.dart',
      testeeConcurrent: testMain,
      pauseOnUnhandledExceptions: true,
    );
