// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:async';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 23;
// AUTOGENERATED END

const file = 'step_through_await_for_test.dart';

Future<void> code() async {
  // ignore: unused_local_variable
  int count = 0; // LINE_A
  await for (var num in naturalsTo(2)) {
    print(num);
    count++;
  }
}

Stream<int> naturalsTo(int n) async* {
  int k = 0;
  while (k < n) {
    k++;
    yield k;
  }
  yield 42;
}

List<String> stops = [];
const expected = <String>[
  '$file:${LINE_A + 0}:13', // on '='
  '$file:${LINE_A + 1}:25', // on 'naturalsTo'

  // Iteration #1
  '$file:${LINE_A + 1}:3', // on 'await'
  '$file:${LINE_A + 1}:40', // on '{'
  '$file:${LINE_A + 2}:5', // on 'print'
  '$file:${LINE_A + 3}:10', // on '++'

  // Iteration #2
  '$file:${LINE_A + 1}:3', // on 'await'
  '$file:${LINE_A + 1}:40', // on '{'
  '$file:${LINE_A + 2}:5', // on 'print'
  '$file:${LINE_A + 3}:10', // on '++'

  // Iteration #3
  '$file:${LINE_A + 1}:3', // on 'await'
  '$file:${LINE_A + 1}:40', // on '{'
  '$file:${LINE_A + 2}:5', // on 'print'
  '$file:${LINE_A + 3}:10', // on '++'

  // Done
  '$file:${LINE_A + 1}:3', // on 'await'
  '$file:${LINE_A + 5}:1',
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepThroughProgramRecordingStops(stops),
  checkRecordedStops(
    stops,
    expected,
    debugPrint: true,
    debugPrintFile: file,
    debugPrintLine: LINE_A,
  ),
];

void main([args = const <String>[]]) => runIsolateTestsSynchronous(
      args,
      tests,
      'step_through_await_for_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
