// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 31;
// AUTOGENERATED END

const file = 'step_through_operator_bracket_on_super_test.dart';

class Class2 {
  int operator [](int index) => index;

  int code() {
    this[42];
    return this[42];
  }
}

class Class3 extends Class2 {
  @override
  int code() {
    super[42]; // LINE_A
    return super[42];
  }
}

void code() {
  final c = Class3();
  c[42];
  c.code();
}

final stops = <String>[];
const expected = <String>[
  '$file:${LINE_A + 0}:10', // on '['
  '$file:${LINE_A + 1}:17', // on '['
  '$file:${LINE_A + 1}:5', // on 'return'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepThroughProgramRecordingStops(stops),
  checkRecordedStops(stops, expected),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'step_through_operator_bracket_on_super_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
