The coerced type does not outlive the value being coerced to.

Example of erroneous code:

```compile_fail,E0476
#![feature(coerce_unsized)]
#![feature(unsize)]

use std::marker::Unsize;
use std::ops::CoerceUnsized;

// error: lifetime of the source pointer does not outlive lifetime bound of the
//        object type
impl<'a, 'b, T, S> CoerceUnsized<&'a T> for &'b S where S: Unsize<T> {}
```

During a coercion, the "source pointer" (the coerced type) did not outlive the
"object type" (value being coerced to). In the above example, `'b` is not a
subtype of `'a`. This error can currently only be encountered with the unstable
`CoerceUnsized` trait which allows custom coercions of unsized types behind a
smart pointer to be implemented.
