// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 19;
// AUTOGENERATED END

const file = 'step_through_switch_test.dart';

void code() /* LINE_A */ {
  code2('a');
  code2('b');
  code2('c');
  code2('d');
}

void code2(String key) {
  switch (key) {
    case 'a':
      print('a!');
      break;
    case 'b':
    case 'c':
      print('b or c!');
      break;
    default:
      print('neither a, b or c...');
  }
}

final stops = <String>[];
const expected = <String>[
  '$file:${LINE_A + 0}:10', // after 'code'

  '$file:${LINE_A + 1}:3', // on 'code2'
  '$file:${LINE_A + 7}:19', // on 'key'
  '$file:${LINE_A + 9}:10', // on first ''' on 'case 'a'' line
  '$file:${LINE_A + 10}:7', // on 'print'
  '$file:${LINE_A + 11}:7', // on 'break'
  '$file:${LINE_A + 19}:1', // on '}'

  '$file:${LINE_A + 2}:3', // on 'code2'
  '$file:${LINE_A + 7}:19', // on 'key'
  '$file:${LINE_A + 9}:10', // on first ''' on 'case 'a'' line
  '$file:${LINE_A + 12}:10', // on first ''' on 'case 'b'' line
  '$file:${LINE_A + 14}:7', // on 'print'
  '$file:${LINE_A + 15}:7', // on 'break'
  '$file:${LINE_A + 19}:1', // on '}'

  '$file:${LINE_A + 3}:3', // on 'code2'
  '$file:${LINE_A + 7}:19', // on 'key'
  '$file:${LINE_A + 9}:10', // on first ''' on 'case 'a'' line
  '$file:${LINE_A + 12}:10', // on first ''' on 'case 'b'' line
  '$file:${LINE_A + 13}:10', // on first ''' on 'case 'c'' line
  '$file:${LINE_A + 14}:7', // on 'print'
  '$file:${LINE_A + 15}:7', // on 'break'
  '$file:${LINE_A + 19}:1', // on '}'

  '$file:${LINE_A + 4}:3', // on 'code2'
  '$file:${LINE_A + 7}:19', // on 'key'
  '$file:${LINE_A + 9}:10', // on first ''' on 'case 'a'' line
  '$file:${LINE_A + 12}:10', // on first ''' on 'case 'b'' line
  '$file:${LINE_A + 13}:10', // on first ''' on 'case 'c'' line
  '$file:${LINE_A + 17}:7', // on 'print'
  '$file:${LINE_A + 19}:1', // on '}'

  '$file:${LINE_A + 5}:1', // on ending '}'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepIntoThroughProgramRecordingStops(stops),
  checkRecordedStops(
    stops,
    expected,
    debugPrint: true,
    debugPrintFile: file,
    debugPrintLine: LINE_A,
  ),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'step_through_switch_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
